# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008, 2009, 2010, 2011, 2012, 2013 Ralph Amissah, All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.sisudoc.org/sisu/en/SiSU/download.html>

 * Git
   <http://sources.sisudoc.org/gitweb/?p=code/sisu.git;a=summary>
   <http://sources.sisudoc.org/?p=code/sisu.git;a=blob;f=lib/sisu/v3/author_format.rb;hb=HEAD>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: system environment, resource control and configuration details

=end
module SiSU_FormatAuthor
  class Author
    def initialize(author_param)
      @author_param=author_param
    end
    def author_details
      @authors,@author_array=[],[]
      authors=@author_param.scan(/[^;]+/)
      authors.each do |a|
        a=a.strip
        if a =~/"(.+?)"/
          @authors << { the: $1 }
          @author_array << $1.upcase
        else #if a =~/,/
          x=a.scan(/[^,]+/)
          x[0]=x[0].strip
          x[1]=x[1].strip if x[1]
          if x.length==1
            @authors << { the: x[0] }
            @author_array << x[0].upcase
          elsif x.length==2
            @authors << { the: x[0], others: x[1] }
            @author_array << "#{x[0].upcase}, #{x[1]}"
          else #p x.length
          end
        end
      end
      l = @authors.length
      authors_string=''
      @authors.each_with_index do |a,i|
        authors_string += if a[:others]
          if (l - i) > 1
            "#{a[:others]} #{a[:the]}, "
          else
            "#{a[:others]} #{a[:the]}"
          end
        else
          if (l - i) > 2
            "#{a[:the]}, "
          else
            "#{a[:the]}"
          end
        end
      end
      {
        last_first_a: authors,
        last_first_format_a: @author_array,
        authors_h: @authors,
        authors_s: authors_string,
        authors_param: @author_param
      }
    end
  end
end
__END__
