# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997 - 2012, Ralph Amissah, All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.jus.uio.no/sisu/gpl.fsf/toc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/doc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/plain.txt>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: SiSU information Structuring Universe, command line options
    parsing

=end
module SiSU_Commandline
  require "pathname"
  require_relative 'sysenv'                             # sysenv.rb
  @@base_path=nil
  class Options
    attr_accessor :cmd,:mod,:act,:dir_structure_by,:f_pths,:files,:files_mod,:base_path,:base_stub,:sub_location,:paths,:lngs,:f_pth,:pth,:fno,:fns,:fnb,:fnc,:fncb,:lng,:lng_base,:what
    def initialize(a)
      @cmd,@f_pth,@pth,@fno,@fns,@fnb,@fnc,@fncb,@what,@lng,@lng_base,@base_path,@base_stub,@sub_location='','','','','','','','','','','','','',''
      @f_pths,@files,@files_mod,@paths,@mod,@act=Array.new(5){[]}
      @env=SiSU_Env::InfoEnv.new
      @lng_base=@env.language_default_set
      @dir_structure_by=SiSU_Env::EnvCall.new.output_dir_structure.by?
      @@base_path ||=Dir.pwd
      @base_path=@@base_path
      r=Px[:lng_lst].join('|')
      u=/.+?\/([^\/]+)(?:\/(?:#{r})$|$)/
      @base_stub=@base_path.gsub(u,'\1')
      @a=sisu_glob_rules(a)
      @a.freeze
      init
    end
    def find_all(find_flag,opt)
      if find_flag
        pwd_set=Dir.pwd
        x=Dir.glob('*.ss[tm]')
        Px[:lng_lst].each do |d|
          if FileTest.directory?(d)
            x << Dir.glob("#{d}/*.ss[tm]")
          end
        end
        x=x.flatten
        opt + x
      end
    end
    def find_select(find_flag,opt)
      if find_flag
        pwd_set=Dir.pwd
        x=[]
        if opt.inspect =~/"[a-zA-Z][a-zA-Z0-9._-]+?"/
          opt.each do |g|
            x <<=if g =~/.ss[tm]/
              Dir.glob("*#{g}")
            else
              Dir.glob("*#{g}*.ss[tm]")
            end
            Px[:lng_lst].each do |d|
              if FileTest.directory?(d)
                x <<=if g =~/.ss[tm]/
                  Dir.glob("#{d}/*#{g}")
                else
                  Dir.glob("#{d}/*#{g}*.ss[tm]")
                end
              end
            end
          end
        end
        x.flatten
      end
    end
    def sisu_glob_rules(a)
      a=if a.inspect =~/"-[A-Za-z0-9]*[fG]/ \
      or a.inspect =~/"--find"|"--glob"/
        b,f=[],[]
        find_flag=false
        a.each do |y|
          if y =~ /^-/
            if y =~/^-/ \
            && y =~/[fG]|--find|--glob/
              find_flag=true
            end
            b << y
          end
          if find_flag \
          && y !~ /^-/ \
          && y =~ /\S+/
            if y !~/\//
              f << y
            else
              find_flag=false
              puts %{sub-directories "#{y}" cannot be provided for --find or --glob at this time}
            end
          end
        end
        r=Px[:lng_lst].join('|')
        r=r.gsub(/\|#{@lng_base}\|/,'|')
        @lang_regx=%r{(?:#{r})}
        z=if find_flag
          (f.length > 0) \
          ? (b + find_select(find_flag,f))
          : find_all(find_flag,b)
        elsif a.inspect =~/"(?:-\S+?|--\S+?)"/ \
        && a.inspect =~/"#{@lang_regx}\/?"/ \
        && a.inspect =~/"#{@lng_base}\/\S+?\.ss[tm]"/
          init_selected_lang_dirs(a)
        else b
        end
      else a
      end
    end
    def init_selected_lang_dirs(a)
      @z=[]
      a.each do |y|
        if y =~/^#{@lng_base}\/(\S+?\.ss[tm])$/
          @fn=$1
          @z << y
        elsif y =~/^#{@lang_regx}\/?$/
          @z << "#{y}/#{@fn}"
        else @z << y
        end
      end
      @z
    end
    def init
      a=@a
      if a.length > 0
        s=expand_numeric_shortcuts(a)
        q=set_files_and_paths_and_general_extract(s)
        @cmd,@mod=opt_cmd_and_mod_adjust(q[:cmd],q[:mod])
        @what=q[:what] unless q[:what].empty?
        @paths = q[:paths]
        @files = q[:files]
        @f_pths = q[:f_pths]
        @lngs = q[:lngs]
        if @files.length > 0 \
        and @cmd.empty? \
        and @mod.length==0 #% if no other action called on filename given, default is sisu --v3 -0 [filename(s)] configured as flag default
          shortcut=SiSU_Env::InfoProcessingFlag.new
          @mod=['--v3']
          @cmd=shortcut.cf_0 + 'm'
        end
        SiSU_Screen::Ansi.new(@cmd,"\tsisu " + @cmd +  ' ' + @mod.join(' ') + ' ' + @files.join(' ') + "\n").print_brown if @cmd =~/[vVM]/
      end
#     @files=@files.uniq
      @act=opt_act
      @files
      self
    end
    def set_files_and_paths_and_general_extract(s)
      c,w='',''
      m,f,pth,z,lng,lngs=[],[],[],[],[],[]
      a=s.split(/\s+/)
      r_l=Px[:lng_lst].join('|')
      a.uniq.each do |x|
        if x =~/^-[a-z0-5]+/i \
        or x =~/^--\S+/
          if x =~/^-([a-z0-5]+)/i
            c << $1
          end
          if x =~/^--\S+/
            m << x
          end
        elsif x =~ /(?:\.(?:(?:-|ssm\.)?sst(?:\.xml)?|ssm|ssi|sx[sdn]\.xml|s[1-3]|kdi|ssp)|\S+?\.ss[mt]\.(?:txz|zip)|sisupod\.(?:txz|zip))$/
          if x =~/^(?:https?|file):\/\/\S+/ \
          and x =~/\S+?\.ss[mt]$/
            r_url=/(http:\/\/\S+?\/\S+?\/src(?:\/(?:#{r_l}))?)\//
            url_base = (x[r_url,1])
            url = x
            y=x.gsub(/http:\/\/\S+?\/\S+?\/src\//,'')
            t=/(#{r_l})\/[^\/]+?\.ss[tm]$/
            l_p = (y[t,1]) \
              ? y[t,1]
              : nil
            lng << l_p
            lngs << if l_p
              l_p
            elsif x =~/~(#{r_l})\.ss[tm]/
              $1
            else lng_base
            end
            r_f=/(?:#{r_l})\/([^\/]+?\.ss[tm])$/
            fn = (y[r_f,1]) \
              ? y[r_f,1]
              : y
            fn=fn.gsub(/\.((?:ssm\.)?sst)/,'.-\1')
            fullname=Dir.pwd + '/' + fn
            pt=Pathname.new(fullname)
            pth << Dir.pwd
            r_u=/.+?\/([^\/]+)(?:\/(?:#{r_l})$|$)/
            lng_is =if l_p
              l_p
            elsif x =~/~(#{r_l})\.ss[tm]/
              $1
            else lng_base
            end
            f_pths << {
              pth: pt.split[0].realpath.to_s,
              f: pt.split[1].to_s,
              pth_stub: pt.split[0].realpath.to_s[r_u,1],
              lng: (pt.split[0].realpath.to_s[t,1]) \
                ? pt.split[0].realpath.to_s[t,1]
                : nil,
              lng_is: lng_is,
              url_base: url_base,
              url: url
            }
            f << fn
          elsif x =~/^(?:https?|file):\/\/\S+/ \
          and x =~/\S+?\.ss[mt]\.(?:txz|zip)|sisupod\.(?:txz|zip)/
            x=x.gsub(/^file:\/\//,'')
            f << x
          elsif FileTest.file?(x)
### FIX
            pt=Pathname.new(x)
            pth << pt.split[0].realpath.to_s     #remove?
            f << pt.split[1].to_s                #remove?
            r_u=/.+?\/([^\/]+)(?:\/(?:#{r_l})$|$)/
            t=/.+\/(#{r_l})$/
            l_p = (pt.split[0].realpath.to_s[t,1]) \
              ? pt.split[0].realpath.to_s[t,1]
              : nil
            lng << l_p
            lngs << if l_p
              l_p
            elsif x =~/~(#{r_l})\.ss[tm]/
              $1
            else lng_base
            end
            lng_is =if l_p
              l_p
            elsif x =~/~(#{r_l})\.ss[tm]/
              $1
            else lng_base
            end
            f_pths << {
              pth: pt.split[0].realpath.to_s,
              f: pt.split[1].to_s,
              pth_stub: pt.split[0].realpath.to_s[r_u,1],
              lng: (pt.split[0].realpath.to_s[t,1]) \
                ? pt.split[0].realpath.to_s[t,1]
                : nil,
              lng_is: lng_is,
              url_base: nil,
              url: nil
            }
#           Dir.chdir(pt.split[0].realpath)
          else  puts "file not found: #{x}"
          end
        elsif x =~ /\.termsheet\.rb$/
          if FileTest.file?(x); f << x
          else  puts "file not found: #{x}"
          end
        else w=x
          puts "#{x} in #{a.join(' ')}?"
        end
      end
      { cmd: c, mod: m, what: w, paths: pth, files: f, f_pths: f_pths, lng: lng, lngs: lngs }
    end
    def expand_numeric_shortcuts(a)
      shortcut=SiSU_Env::InfoProcessingFlag.new
      s=''
      a.each do |x|
        y=case x
        when /0/
          (x=~/^-1\S+/) \
          ? x.gsub(/^-0(\S+)/,shortcut.cf_0 + ' -\1')
          : x.gsub(/^-0/,shortcut.cf_0 + ' ')
        when /1/
          (x=~/^-1\S+/) \
          ? x.gsub(/^-1(\S+)/,shortcut.cf_1 + ' -\1')
          : x.gsub(/^-1/,shortcut.cf_1 + ' ')
        when /2/
          (x=~/^-2\S+/) \
          ? x.gsub(/^-2(\S+)/,shortcut.cf_2 + ' -\1')
          : x.gsub(/^-2/,shortcut.cf_2 + ' ')
        when /3/
          (x=~/^-3\S+/) \
          ? x.gsub(/^-3(\S+)/,shortcut.cf_3 + ' -\1')
          : x.gsub(/^-3/,shortcut.cf_3 + ' ')
        when /4/
          (x=~/^-4\S+/) \
          ? x.gsub(/^-4(\S+)/,shortcut.cf_4 + ' -\1')
          : x.gsub(/^-4/,shortcut.cf_4 + ' ')
        when /5/
          (x=~/^-5\S+/) \
          ? x.gsub(/^-5(\S+)/,shortcut.cf_5 + ' -\1')
          : x.gsub(/^-5/,shortcut.cf_5 + ' ')
        when /6/
          (x=~/^-6\S+/) \
          ? x.gsub(/^-6(\S+)/,shortcut.cf_5 + ' -\1')
          : x.gsub(/^-6/,shortcut.cf_5 + ' ')
        else x
        end
        s << " #{y}" unless y.empty?
      end
      s.strip!
    end
    def opt_cmd_and_mod_adjust(c,m)
      cmd,mod,files=@cmd,@mod,@files
      unless m.empty?
        m.each do |m|
          case m
          when /^--(?:color-toggle)$/;                       c=c+'c'
          when /^--(?:configure)$/;                          c=c+'CC'
          when /^--(?:dal?|machine|abstraction|abs)$/;       c=c+'m'
          when /^--(?:txt|text|plaintext)$/;                 c=c+'t'
          when /^--(?:html)$/;                               c=c+'h'
          when /^--(?:epub)$/;                               c=c+'e'
          when /^--(?:od[ft])$/;                             c=c+'o'
          when /^--(?:pdf)$/;                                c=c+'p'
          when /^--(?:concordance|wordmap)$/;                c=c+'w'
          when /^--(?:manpage|man)$/;                        c=c+'i'
          when /^--(?:texinfo)$/;                            c=c+'I'
          when /^--(?:xhtml)$/;                              c=c+'b'
          when /^--(?:xml-sax)$/;                            c=c+'x'
          when /^--(?:xml-dom)$/;                            c=c+'X'
          when /^--(?:images)$/;                             c=c+'j'
          when /^--(?:hash-digests)$/;                       c=c+'N'
          when /^--(?:po4a|pot?)$/;                          c=c+'P'
          when /^--(?:termsheet)$/;                          c=c+'T'
          when /^--(?:manifest)$/;                           c=c+'y'
          when /^--(?:qrcode)$/;                             c=c+'Q'
          when /^--(?:sqlite)$/;                             c=c+'d'
          when /^--(?:pg|pg?sql|postgresql)$/;               c=c+'D'
          when /^--(?:remote|rsync)$/;                       c=c+'R'
          when /^--(?:scp)$/;                                c=c+'r'
          when /^--(?:source)$/;                             c=c+'s'
          when /^--(?:sisupod|pod)$/;                        c=c+'S'
          when /^--(?:git)$/;                                c=c+'g'
          when /^--(?:urls)$/;                               c=c+'U'
          when /^--(?:zap|delete)$/;                         c=c+'Z'
          when /^--(?:sample-search-form)$/;                 c=c+'F'
          when /^--(?:webserv|webrick)$/;                    c=c+'W'
          when /^--(?:profile)$/;                            c=c+'E'
          when /^--(?:maintenance|keep-processing-files)$/;  c=c+'M'
          when /^--(?:verbose[=-]3)$/;                       c=c+'VM'
          when /^--(?:verbose[=-]2|Verbose|VERBOSE)$/;       c=c+'V'
          when /^--(?:verbose(?:[=-]1)?)$/;                  c=c+'v'
          when /^--(?:verbose[=-]0|quiet|silent)$/;          c=c+'q'
          else mod << m                                     #mod only contains command modifiers; commands converted to character
          end
        end
      end
      ca=[]
      unless c.empty?
        c=c.gsub(/-/,'')
        c.scan(/CC|\S/) {|x| ca << x}
        cmd= '-' + ca.uniq.join
      end
      extra=''
      if cmd !~/[mn]/
        extra+=if cmd =~/[abegHhIiNOoPpQTtwXxyz]/ \
        and cmd !~/[mn]/
          'm'                        #% add dal
        elsif ((cmd =~/[Dd]/ \
        or (mod.inspect =~/--(?:(?:sq)?lite|pg(?:sql)?)/)) \
        and mod.inspect !~/(?:remove|(?:(?:re)?create(?:all)?|dropall|drop)$)/) \
        and cmd !~/[mn]/
          'm'                        #% add dal
        else ''
        end
      end
      if cmd !~/j/
        extra+=if cmd =~/[bHhwXxyz]/ \
        and cmd !~/[j]/
          'j'                        #% copy images
        else ''
        end
      end
      if cmd !~/y/
        extra+=if cmd =~/[abeHhIiNopQsSstwXxz]/ \
        and cmd !~/y/
          'ym'                       #% add manifest
        elsif (cmd =~/[Dd]/ \
        or mod.inspect =~/--(?:(?:sq)?lite|pg(?:sql)?)/) \
        and files[0] !~/^remove$/ \
        and cmd !~/y/
          'ym'                       #% add manifest
        else ''
        end
      end
      if cmd !~/u/                   #% add urls
        extra+='u'
      end
      cmd=cmd + extra
      cmds=cmd.scan(/CC|\S/)
      [cmds.uniq.join,mod]
    end
    def opt_act #note mod line commands have already been converted to command characters, cmd
      cmd,mod=@cmd,@mod
      act={}
      act[:license]=(cmd =~/L/ \
      || mod.inspect =~/"--license/) \
      ? { bool: true, set: :on }
      : { bool: false, set: :na }
      act[:site_init]=(cmd =~/C/ \
      || mod.inspect =~/"--init-site/) \
      ? { bool: true, set: :on  }
      : { bool: false, set: :na }
      act[:rc]=if mod.inspect =~/"--rc=/
        x=Dir.pwd + '/' + mod.join.gsub(/--rc=/,'')
        { bool: true, set: :on, inst: x }
      else
        { bool: false, set: :na, inst: '' }
      end
      act[:processing_path]=if mod.inspect =~/"--processing-path=/
        base_pth=mod.join(';').gsub(/^.*--processing-path=['"]?(.+?)(?:['"]?;.+)?$/,'\1')
        { bool: true, set: :on, inst: base_pth }
      elsif mod.inspect =~/"--processing-path/
        { bool: true, set: :on, inst: @base_path }
      else
        { bool: false, set: :na, inst: nil }
      end
      act[:dump]=if mod.inspect =~/"--dump=/
        base_pth=mod.join(';').gsub(/^.*--dump=['"]?(.+?)(?:['"]?;.+)?$/,'\1')
        { bool: true, set: :on, inst: base_pth }
      elsif mod.inspect =~/"--dump/
        { bool: true, set: :on, inst: @base_path }
      else
        { bool: false, set: :na, inst: nil }
      end
      act[:redirect]=if mod.inspect =~/"--redirect=/
        base_pth=mod.join(';').gsub(/^.*--redirect=['"]?(.+?)(?:['"]?;.+)?$/,'\1')
        { bool: true, set: :on, inst: base_pth }
      elsif mod.inspect =~/"--redirect/
        { bool: true, set: :on, inst: @base_path }
      else
        { bool: false, set: :na, inst: nil }
      end
      act[:verbose]=(cmd =~/v/ \
      || mod.inspect =~/"--verbose"/) \
      ? { bool: true, set: :on }
      : { bool: false, set: :na }
      act[:quiet]=(cmd =~/q/ \
      || mod.inspect =~/"--quiet"/) \
      ? { bool: true, set: :on }
      : { bool: false, set: :na }
      act[:color_state]=if mod.inspect =~/"--color-on"|"--color"/
        { bool: true, set: :on }
      elsif mod.inspect =~/"--color-off"/
        { bool: false, set: :off }
      else { bool: true, set: :na } #fix default color
      end
#     act[:color_toggle]=if cmd =~/c/ \
#     or mod.inspect =~/"--color-toggle"/
#       true
#     else false
#     end
      act[:maintenance]=(cmd =~/M/ \
      || mod.inspect =~/"--maintenance|--keep-processing-files"/) \
      ? { bool: true, set: :on }
      : { bool: false, set: :na }
      act[:profile]=(cmd =~/E/ \
      || mod.inspect =~/"--profile"/) \
      ? { bool: true, set: :on }
      : { bool: false, set: :na }
      act[:switch]=if mod.inspect =~/"--switch-off=/
        off_list=mod.join(';').gsub(/^.*--switch-off=['"]?(.+?)(?:['"];.+)?$/,'\1')
        off_list=off_list.scan(/[^,;\s]+/)
        { bool: false, set: :off, off: off_list}
      else { bool: true, set: :na, off: [] }
      end
      act[:ocn]=
      if mod.inspect =~/"--inc-ocn"/
        { bool: true, set: :on }
      elsif mod.inspect =~/"--(?:exc|no)-ocn"/ \
      || act[:switch][:off].inspect =~/"ocn"/
        { bool: false, set: :off }
      else { bool: true, set: :na }
      end
      act[:toc]=if mod.inspect =~/"--inc-toc"/
        { bool: true, set: :on }
      elsif mod.inspect =~/"--(?:exc|no)-toc"/ \
      || act[:switch][:off].inspect =~/"toc"/
        { bool: false, set: :off }
      else { bool: true, set: :na }
      end
      act[:minitoc]=if mod.inspect =~/"--inc-minitoc"/
        { bool: true, set: :on }
      elsif mod.inspect =~/"--(?:exc|no)-minitoc"/ \
      || act[:switch][:off].inspect =~/"minitoc"/
        { bool: false, set: :off }
      else { bool: true, set: :na }
      end
      act[:manifest]=if mod.inspect =~/"--inc-manifest"/
        { bool: true, set: :on }
      elsif mod.inspect =~/"--(?:exc|no)-manifest"/ \
      || act[:switch][:off].inspect =~/"manifest"/
        { bool: false, set: :off }
      elsif act[:manifest]=(cmd =~/y/ \
      || mod.inspect =~/"--manifest"/)
        { bool: true, set: :on }
      else { bool: true, set: :na }
      end
      act[:links_to_manifest]=if mod.inspect =~/"--inc-links-to-manifest"|"--inc-manifest-links"/
        { bool: true, set: :on }
      elsif mod.inspect =~/"--(?:exc|no)-links-to-manifest"|"--(?:exc|no)-manifest-links"/ \
      || act[:switch][:off].inspect =~/"links_to_manifest"|"manifest_links"|"--(?:exc|no)-manifest"/ \
      || mod.inspect =~/"--(?:redirect|dump)/
        { bool: false, set: :off }
      else { bool: true, set: :na }
      end
      act[:manifest_minitoc]=if mod.inspect =~/"--inc-manifest-minitoc"|"--inc-minitoc"/
        { bool: true, set: :on }
      elsif mod.inspect =~/"--(?:exc|no)-manifest-minitoc"|"--(?:exc|no)-minitoc"/ \
      || act[:switch][:off].inspect =~/"manifest_minitoc"|"minitoc"/
      #|| mod.inspect =~/"--(?:redirect|dump)/
        { bool: false, set: :off }
      else { bool: true, set: :na }
      end
      act[:metadata]=if mod.inspect =~/"--inc-metadata"/
        { bool: true, set: :on }
      elsif mod.inspect =~/"--(?:exc|no)-metadata"/ \
      || act[:switch][:off].inspect =~/"metadata"/
        { bool: false, set: :off }
      else { bool: true, set: :na }
      end
      act[:html_minitoc]=if mod.inspect =~/"--inc-html-minitoc"|"--inc-minitoc"/
        { bool: true, set: :on }
      elsif mod.inspect =~/"--(?:exc|no)-html-minitoc"|"--(?:exc|no)-minitoc"/ \
      || act[:switch][:off].inspect =~/"html_minitoc"|"minitoc"/
        { bool: false, set: :off }
      else { bool: true, set: :na }
      end
      act[:html_navigation]=if mod.inspect =~/"--inc-html-navigation"|"--inc-navigation"/
        { bool: true, set: :on }
      elsif mod.inspect =~/"--(?:exc|no)-html-navigation"|"--(?:exc|no)-navigation"/ \
      || act[:switch][:off].inspect =~/"html_navigation"|"nav"/
        { bool: false, set: :off }
      else { bool: true, set: :na }
      end
      act[:html_navigation_bar]=if mod.inspect =~/"--inc-html-navigation-bar"|"--inc-navigation-bar"/
        { bool: true, set: :on }
      elsif mod.inspect =~/"--(?:exc|no)-html-navigation-bar"|"--(?:exc|no)-navigation-bar"/ \
      || act[:switch][:off].inspect =~/"html_navigation_bar"|"navbar"/
        { bool: false, set: :off }
      else { bool: true, set: :na }
      end
      act[:segsubtoc]=if mod.inspect =~/"--inc-segsubtoc"/
        { bool: true, set: :on }
      elsif mod.inspect =~/"--(?:exc|no)-segsubtoc"/ \
      || act[:switch][:off].inspect =~/"segsubtoc"/
        { bool: false, set: :off }
      else { bool: true, set: :na }
      end
      act[:search_form]=if mod.inspect =~/"--inc-search-form"/
        { bool: true, set: :on }
      elsif mod.inspect =~/"--(?:exc|no)-search-form"/ \
      || act[:switch][:off].inspect =~/"search_form"|"search"/
        { bool: false, set: :off }
      else { bool: true, set: :na }
      end
      act[:html_search_form]=if mod.inspect =~/"--inc-html-search-form"|"--inc-search-form"/
        { bool: true, set: :on }
      elsif mod.inspect =~/"--(?:exc|no)-html-search-form"|"--(?:exc|no)-search-form"/ \
      || act[:switch][:off].inspect =~/"html_search_form"|"search_form"|"search"/
        { bool: false, set: :off }
      else { bool: true, set: :na }
      end
      act[:html_right_pane]=if mod.inspect =~/"--inc-html-right-pane"|"--inc-right-pane"|"--inc-html-right-column"|"--inc-right-column"/
        { bool: true, set: :on }
      elsif mod.inspect =~/"--(?:exc|no)-html-right-pane"|"--(?:exc|no)-right-pane"|"--(?:exc|no)-html-right-column"|"--(?:exc|no)-right-column"/ \
      || act[:switch][:off].inspect =~/"html_right_pane"|"html_right_column"|"promo"/
        { bool: false, set: :off }
      else { bool: true, set: :na }
      end
      act[:html_top_band]=if mod.inspect =~/"--inc-html-top-band"|"--inc-top-band"/
        { bool: true, set: :on }
      elsif mod.inspect =~/"--(?:exc|no)-html-top-band"|"--(?:exc|no)-top-band"/ \
      || act[:switch][:off].inspect =~/"html-top-band"|"top-band"/
        { bool: false, set: :off }
      else { bool: true, set: :na }
      end
      act[:dal]=(cmd =~/m/ \
      || mod.inspect =~/"--dal"/) \
      ? { bool: true, set: :on }
      : { bool: false, set: :na }
      act[:html]=(cmd =~/h/ \
      || mod.inspect =~/"--html"/) \
      ? { bool: true, set: :on }
      : { bool: false, set: :na }
      act[:concordance]=(cmd =~/w/ \
      || mod.inspect =~/"--concordance"/) \
      ? { bool: true, set: :on }
      : { bool: false, set: :na }
      act[:images]=(cmd =~/j/ \
      || mod.inspect =~/"--images"/) \
      ? { bool: true, set: :on }
      : { bool: false, set: :na }
      act[:pdf]=(cmd =~/p/ \
      || mod.inspect =~/"--pdf"/) \
      ? { bool: true, set: :on }
      : { bool: false, set: :na }
      act[:epub]=(cmd =~/e/ \
      || mod.inspect =~/"--epub"/) \
      ? { bool: true, set: :on }
      : { bool: false, set: :na }
      act[:odt]=(cmd =~/o/ \
      || mod.inspect =~/"--odt"|"--odf"/) \
      ? { bool: true, set: :on }
      : { bool: false, set: :na }
      act[:xml_sax]=(cmd =~/x/ \
      || mod.inspect =~/"--xml-sax"/) \
      ? { bool: true, set: :on }
      : { bool: false, set: :na }
      act[:xml_dom]=(cmd =~/X/ \
      || mod.inspect =~/"--xml-dom"/) \
      ? { bool: true, set: :on }
      : { bool: false, set: :na }
      act[:xhtml]=(cmd =~/b/ \
      || mod.inspect =~/"--xhtml"/) \
      ? { bool: true, set: :on }
      : { bool: false, set: :na }
      act[:txt]=(cmd =~/[at]/ \
      || mod.inspect =~/"--txt"/) \
      ? { bool: true, set: :on }
      : { bool: false, set: :na }
      act[:manpage]=(cmd =~/i/ \
      || mod.inspect =~/"--manpage"|"--man"/) \
      ? { bool: true, set: :on }
      : { bool: false, set: :na }
      act[:texinfo]=(cmd =~/I/ \
      || mod.inspect =~/"--texinfo"/) \
      ? { bool: true, set: :on }
      : { bool: false, set: :na }
      act[:fictionbook]=(cmd =~/f/ \
      || mod.inspect =~/"--fictionbook"/) \
      ? { bool: true, set: :on }
      : { bool: false, set: :na }
      act[:psql]=(cmd =~/D/ \
      || mod.inspect =~/"--pg"|"--pgsql"/) \
      ? { bool: true, set: :on }
      : { bool: false, set: :na }
      act[:sqlite]=(cmd =~/d/ \
      || mod.inspect =~/"--sqlite"/) \
      && (mod.inspect =~/"--createdb"|"--create(?:all)?"|"--dropall"|"--recreate(?:all)?"|"--import"|"--update"|"--remove"/) \
      ? { bool: true, set: :on }
      : { bool: false, set: :na }
      act[:sqlite_discreet]=(cmd =~/d/ \
      || mod.inspect =~/"--sql"|"--sqlite"/) \
      && (mod.inspect =~/"--both"/ \
      || mod.inspect !~/"--createdb"|"--create(?:all)?"|"--dropall"|"--recreate(?:all)?"|"--import"|"--update"|"--remove"/) \
      ? { bool: true, set: :on }
      : { bool: false, set: :na }
      act[:harvest]=(mod.inspect =~/"--harvest"/) \
      ? { bool: true, set: :on }
      : { bool: false, set: :na }
      act[:po4a]=(cmd =~/P/ \
      || mod.inspect =~/"--po4a"|"--pot?"/) \
      ? { bool: true, set: :on }
      : { bool: false, set: :na }
      act[:git]=(cmd =~/g/ \
      || mod.inspect =~/"--git"/) \
      ? { bool: true, set: :on }
      : { bool: false, set: :na }
      act[:zap]=(cmd =~/Z/ \
      || mod.inspect =~/"--zap"|"--delete"/) \
      ? { bool: true, set: :on }
      : { bool: false, set: :na }
      act[:hash_digests]=(cmd =~/N/ \
      || mod.inspect =~/"--hash-digests"/) \
      ? { bool: true, set: :on }
      : { bool: false, set: :na }
      act[:sample_search_form]=(cmd =~/F/ \
      || mod.inspect =~/"--sample-search-form"/) \
      ? { bool: true, set: :on }
      : { bool: false, set: :na }
      act[:webrick]=(cmd =~/W/ \
      || mod.inspect =~/"--webrick"/) \
      ? { bool: true, set: :on }
      : { bool: false, set: :na }
      act[:share_source]=(cmd =~/s/ \
      || mod.inspect =~/"--source"/) \
      ? { bool: true, set: :on }
      : { bool: false, set: :na }
      act[:sisupod]=(cmd =~/S/ \
      || mod.inspect =~/"--sisupod"/) \
      ? { bool: true, set: :on }
      : { bool: false, set: :na }
      act[:scp]=(cmd =~/r/ \
      || mod.inspect =~/"--scp"/) \
      ? { bool: true, set: :on }
      : { bool: false, set: :na }
      act[:rsync]=(cmd =~/R/ \
      || mod.inspect =~/"--rsync"/) \
      ? { bool: true, set: :on }
      : { bool: false, set: :na }
      act[:delete_output]=(cmd =~/z/ \
      || mod.inspect =~/"--delete"|"--zap"/) \
      ? { bool: true, set: :on }
      : { bool: false, set: :na }
      act[:urls_all]=(cmd =~/U/ \
      || mod.inspect =~/"--urls-all"/) \
      ? { bool: true, set: :on }
      : { bool: false, set: :na }
      act[:urls_selected]=(cmd =~/u/ \
      || mod.inspect =~/"--urls"/) \
      ? { bool: true, set: :on }
      : { bool: false, set: :na }
      act[:sitemap]=(cmd =~/Y/ \
      || mod.inspect =~/"--sitemap"/) \
      ? { bool: true, set: :on }
      : { bool: false, set: :na }
      act[:qrcode]=(cmd =~/Q/ \
      || mod.inspect =~/"--qrcode"/) \
      ? { bool: true, set: :on }
      : { bool: false, set: :na }
      act[:help]=(mod.inspect =~/"--help/) \
      ? { bool: true, set: :on }
      : { bool: false, set: :na }
      @act=act
    end
    def cmd
      @cmd
    end
    def mod
      @mod
    end
    def act
      @act
    end
    def files_mod
      files_mod=files
      @files_mod=files_mod
      @files_mod
    end
    def f_pth
      @f_pth
    end
    def pth
      @pth
    end
    def sub_location
      pth.gsub(/#{base_path}/,'')
    end
    def lng
      @lng
    end
    def lng_base
      @lng_base
    end
    def fno
      @fno=if @fno and not @fno.empty?
        @fno
      else
        fns[/(.+?(?:sst|ssm))(?:\.sst)?/,1]
      end
    end
    def fns
      @fns
    end
    def what
      @what
    end
    def fnb
      unless fns.empty?
        fns[/(.+?)\.(?:(?:-|ssm\.)?sst|ssm)$/,1]
      end
    end
    def fnc
      @fnc=if @fns =~/\.(?:ssm\.sst|ssm)$/
        fnb + '.ssm.sst'
      else @fns
      end
    end
    def fncb
      @fncb=if @fns =~/(?:\~\S{2,3})?\.(?:ssm\.sst|ssm)$/
        fnb + '.ssm.sst'
      else @fns.gsub(/(?:\~\S{2,3})?(\.sst)$/,'\1')
      end
    end
  end
end
__END__
note usually named @opt
is carried in Param usually as @md
@opt is a subset of @md
where @md is passed, contents of @opt are available
passing @opt as well is duplication
check for fns & fnb
