# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997 - 2012, Ralph Amissah, All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.jus.uio.no/sisu/gpl.fsf/toc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/doc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/plain.txt>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: SiSU information Structuring Universe, text structuring,
    processing, publishing, search

=end
module SiSU
  require_relative 'constants'                          # constants.rb
  require_relative 'sysenv'                             # sysenv.rb
    include SiSU_Screen
  @@pwd_the=Dir.pwd
  class OptionLoopFiles
    def initialize(opt)
      @opt=opt
    end
    def loop_files_on_given_option
      @opt.files.each_with_index do |fns,i|
        @opt.fns=fns
        @opt.f_pth=@opt.f_pths[i]
        if fns !~/\.-sst$/
          @opt.pth=@opt.paths[i]
          @opt.lng=@opt.lngs[i]
        else
          @opt.pth=Dir.pwd
          @opt.lng='en'
        end
        @@pwd=@opt.pth
        Dir.chdir(@opt.pth) #watch
        @env=SiSU_Env::InfoEnv.new(fns)
        yield
      end
    end
    def manifest_on_files_translated
      r=Px[:lng_lst].join('|')
      number_of_files={}
      @opt.files.each_with_index do |fns,i|
        fn=fns.gsub(/(?:\.#{r})?\.ss[tm]$/,'')
        if number_of_files[fn].class == Array
          number_of_files[fn] << i
        else
          number_of_files = { fn => [i] }
        end
      end
      files_translated_idx=[]
      number_of_files.each do |x|
        if x[1].length > 1
          files_translated_idx << x[1]
        end
      end
      if files_translated_idx.flatten.length > 1
      SiSU_Screen::Ansi.new(@opt.cmd,'Manifest re-run on (currently generated) tranlated files',"").grey_title_hi unless @opt.act[:quiet][:set] ==:on
        files_translated_idx.flatten.each do |i|
          @opt.fns=@opt.files[i]
          @opt.f_pth=@opt.f_pths[i]
          if @opt.fns =~/\.-sst$/
            @opt.pth=Dir.pwd
            @opt.lng='en'
          elsif @opt.fno =~/\.txz$/
          else
            @opt.pth=@opt.paths[i]
            @opt.lng=@opt.lngs[i]
          end
          @@pwd=@opt.pth
          Dir.chdir(@opt.pth) #watch
          @env=SiSU_Env::InfoEnv.new(@opt.fns)
          yield
        end
      end
    end
  end
  class Operations
    @@n_do=0
    def initialize(opt='')
      @opt=opt
      @cX=SiSU_Screen::Ansi.new(@opt).cX
    end
    def counter
      @@n_do=0
    end
    def remote_put_base_site_rsync                         # -CR
p "#{__LINE__}:#{__FILE__}" if @opt.act[:maintenance][:set] ==:on
      require_relative 'remote'                         # remote.rb
      SiSU_Remote::Put.new(@opt).rsync_base
    end
    def remote_put_base_site_rsync_match                   # -CCRZ
p "#{__LINE__}:#{__FILE__}" if @opt.act[:maintenance][:set] ==:on
      require_relative 'remote'                         # remote.rb
      SiSU_Remote::Put.new(@opt).rsync_base_sync
    end
    def remote_put_base_site                               # -Cr
p "#{__LINE__}:#{__FILE__}" if @opt.act[:maintenance][:set] ==:on
      require_relative 'remote'                         # remote.rb
      SiSU_Remote::Put.new(@opt).scp_base
    end
    def remote_put_base_site_all                           # -CCr
p "#{__LINE__}:#{__FILE__}" if @opt.act[:maintenance][:set] ==:on
      require_relative 'remote'                         # remote.rb
      SiSU_Remote::Put.new(@opt).scp_base_all
    end
    def cgi                                                # -F
      require_relative 'cgi'                            # cgi.rb
      SiSU_CGI::SearchSQL.new(@opt).read
    end
    def encoding                                           # -K build character encoding db (uses KirbyBase)
      require_relative 'character_encoding'             # character_encoding.rb
      SiSU_CharacterEncode::Create.new.db
    end
    def termsheet                                          # -t
      system("sisu_termsheet #{@opt.cmd} #{@opt.fns}\n")
      @@n_do=@@n_do+1
      SiSU_Screen::Ansi.new(@opt.cmd,@@n_do,'Termsheet(s) processed').term_sheet_title unless @opt.act[:quiet][:set] ==:on
    end
    def webrick                                            # -W
      port=prt=@fns
      prt=if prt !~/\d+/
        'webrick default (sysenv)'
      else "webrick port set to #{prt}"
      end
      puts %{#{@cX.blue}<<#{@cX.off}#{@cX.green}Start Webrick web server on port: #{prt}#{@cX.off}#{@cX.blue}>> #{@cX.off*2} }
      system("sisu_webrick #{port}&\n")
    end
    def not_found
      puts "\n#{@cX.fuschia}FILE NOT FOUND:#{@cX.off} << #{@opt.fns} >> - requested #{@opt.cmd} processing skipped\n"
    end
    def convert_name_message(fns,type,i,o,rune)
      %{\nIn filename: "#{@cX.fuschia}#{fns}#{@cX.off}" << #{type} >> #{@cX.fuschia}is apre 0.36 markup filename.#{@cX.off} #{@cX.brown}Please rename your file.#{@cX.off}\n\tAs of sisu-0.37, SiSU markup files with #{@cX.brown}the extensions #{i} should be re-named #{o}#{@cX.off}\n\tif you have the program called 'rename' installed, the following rune should do the trick:\n\t\t#{rune}\n\talternatively try:\n\t\tsisu --convert --36to37 #{fns}\n\trequested #{@opt.cmd} processing skipped\n}
    end
    def not_recognised
      case @opt.fns
      when /(\.s[123])$/
        type=@opt.fns.gsub(/\S+?(#{$1})/,'\1')
        rune=%q{rename 's/\.s[123]$/\.sst/' *.s{1,2,3}}
        puts convert_name_message(@opt.fns,type,'.s1 .s2 and .s3','.sst',rune)
      when /(\.r[123])$/
        type=@opt.fns.gsub(/\S+?(#{$1})/,'\1')
        rune=%q{rename 's/\.r[123]$/\.ssm/' *.r{1,2,3}}
        puts convert_name_message(@opt.fns,type,'.r1 .r2 and .r3','.sst',rune)
        puts %{\n\tNote also that you will need to change the names of the files called/required\n\twithin the document text to build the composite document\n\t\t.s1 .s2 .s3 should be .sst \n\t\t.si should be .ssi\n\trequested #{@opt.cmd} processing skipped\n}
      when /(\.ssi)$/
        puts "\n#{@cX.fuschia}component filetype:#{@cX.off} << #{@opt.fns} >> - is not a processed filetype, (it may be used as a component of a .ssm markup file)\n\trequested #{@opt.cmd} processing skipped\n"
      else
        puts "\n#{@cX.fuschia}FILETYPE NOT RECOGNISED:#{@cX.off} << #{@opt.fns} >> - is not a recognized filetype,\n\trequested #{@opt.cmd} processing skipped\n"
      end
    end
  end
  class Processing
    require 'fileutils'
      include FileUtils
    @@env=SiSU_Env::InfoEnv.new
    attr_accessor :op
    def initialize(opt)
      @opt=opt
      @msg,@msgs='',nil
      @tell=lambda { SiSU_Screen::Ansi.new(@opt.cmd,@msg,"#{@msgs.inspect if @msgs}") }
    end
    def actions
      if @opt.act[:profile][:set]==:on
        require 'profile'
      end
      if @opt.act[:harvest][:set]==:on
        require_relative 'harvest'                         # harvest.rb
        SiSU_Harvest::Source.new(@opt).read                # -h -H  html.rb
      elsif @opt.mod.inspect =~/--convert|--to|--from/
        require_relative 'sst_convert_markup'              # sst_convert_markup.rb
      elsif @opt.cmd =~/([abCcDdeFGgHhIjikLMmNnoPpQqRrSsTtUuVvWwXxYyZ_0-9])/ \
      and @opt.cmd =~/^-/ \
      and @opt.mod.inspect !~/--(?:sitemaps|query|identify)/ \
      or @opt.mod.inspect =~/--(?:(?:sq)?lite|pg(?:sql)?)/
        @cX=SiSU_Screen::Ansi.new(@opt.cmd).cX
        flag=SiSU_Env::InfoProcessingFlag.new
        if @opt.cmd =~/[vVM]/                              #% version information
          unless @opt.files.empty?
            SiSU_Help::Help.new('env',@opt).sisu_version
          end
        end
        if @opt.act[:license][:set]==:on                   #% license information
          SiSU_Help::Help.new('license',@opt).help_request
        end
        if @opt.act[:dal][:set]==:on \
        or @opt.act[:maintenance][:set]==:on               #% --maintenance, -m for -C
          path={}
          path[:css]=@@env.path.output + '/_sisu/css'
          path[:xml]=@@env.path.output + '/_sisu/xml'
          path[:xsd]=path[:xml] + '/xsd'
          path[:xsd]=path[:xml] + '/rnc'
          path[:xsd]=path[:xml] + '/rng'
          re_p3=/(sisupod(?:\.txz)?|\S+?\.ss[mt]\.txz|[^\/]+?\.ssp)$/
          unless @opt.files.join(',') =~ re_p3 #do not mix pods with source markup files in command line
          # unless ( FileTest.directory?(path[:css]) \
          # and FileTest.directory?(path[:xsd]) )
          #   @opt.cmd=@opt.cmd +='C' unless @opt.cmd =~/C/ #FIX
          # end
            if @opt.act[:maintenance][:set] ==:on
              $VERBOSE=false                               #debug $VERBOSE=true
            end
          end
          re_p2=/(sisupod(?:\.zip)?|\S+?\.ss[mt]\.zip)$/
          unless @opt.files.join(',') =~ re_p2 #do not mix pods with source markup files in command line
          # unless ( FileTest.directory?(path[:css]) \
          # and FileTest.directory?(path[:xsd]) )
          #   @opt.cmd=@opt.cmd +='C' unless @opt.cmd =~/C/ #FIX
          # end
            if @opt.act[:maintenance][:set] ==:on
              $VERBOSE=false                               #debug $VERBOSE=true
            end
          end
        end
        if @opt.act[:site_init][:set]==:on                 #% --init-site, -C initialize/configure
          requires('conf')                                 #% --init-site, -C initialize/configure
          SiSU_Initialize::Source.new(@opt).read
          if @opt.act[:rsync][:set]==:on
            if @opt.mod.inspect =~/--init(?:ialize)?=site/ \
            and @opt.cmd =~/RZ/
              SiSU::Operations.new(@opt).remote_put_base_site_rsync_match
            else SiSU::Operations.new(@opt).remote_put_base_site_rsync
            end
          elsif @opt.act[:scp][:set]==:on
            if @opt.mod.inspect =~/--init(?:ialize)?=site/ \
            and @opt.cmd =~/CCr/
              SiSU::Operations.new(@opt).remote_put_base_site_all
            else SiSU::Operations.new(@opt).remote_put_base_site
            end
          end
        end
        if @opt.act[:sample_search_form][:set]==:on        #% --sample-search-form, -F cgi sample search form
          SiSU::Operations.new(@opt).cgi
        end
        if @opt.act[:webrick][:set]==:on                   #% --webrick, -W webrick
          SiSU::Operations.new(@opt).webrick
        end
        if @opt.act[:zap][:set]==:on                       #% --zap -Z wipe previous output clean DUPLICATE
          #requires('zap')
          #SiSU_Zap::Source.new(@opt).read              # -Z     zap.rb
        end
        if @opt.act[:dal][:set]==:on
          @retry_count= -1
          begin
            path_image='./_sisu/processing/external_document/image'
            path_skin='./_sisu/processing/external_document/skin/doc'
            @get_s,@get_p,@get_pl=[],[],[]
            re_s=/(\S+?\.-sst)$/
            re_p3=/((?:https?|file):\/\/\S+?(?:\/\S+?\.ss[mt]\.txz|sisupod(?:\.txz)?|\.ssp))/
            re_pl3=/^(\/\S+?\.ss[mt]\.txz)/
            @opt.files.each do |fns|
              if fns =~re_s
                @get_s << @opt.f_pths[0][:url]
              end
              if fns =~re_p3
                @get_p << re_p3.match(fns)[1] if re_p3
              end
              if fns =~re_pl3
                @get_pl << re_pl3.match(fns)[1] if re_p3
              end
            end
            if @get_s.length > 0                           #% remote markup file .sst
              require_relative 'remote'                    # remote.rb
              SiSU_Remote::Get.new(@opt,@get_s).fns
              SiSU::Operations.new.counter
            end
            if @get_p.length > 0                           #% remote sisupod
              require_relative 'remote'                    # remote.rb
              SiSU_Remote::Get.new(@opt,@get_p).sisupod
            end
          rescue
            SiSU_Errors::InfoError.new($!,$@,@opt,@fns).error do
              __LINE__.to_s + ':' + __FILE__
            end
            @retry_count +=1
            retry unless @retry_count > 1
          ensure
          end
         end
        def requires(req)
          require_relative req
        end
        def each_file_loop_options
          @opt.files.each_with_index do |fno,i|
            @opt.fno=fno
            @opt.fns=fno.gsub(/(?:https?|file):\/\/\S+\/(\S+)\.sst$/,'\1.-sst').
              gsub(/\.ssm$/,'.ssm.sst')
            @opt.f_pth=@opt.f_pths[i]
            if @opt.fns !~/\.-sst$/
              @opt.pth=@opt.paths[i]
              @opt.lng=@opt.lngs[i]
            else
              @opt.pth=Dir.pwd
              @opt.lng='en'
            end
            unless @opt.pth.nil?
              @@pwd=@opt.pth
              Dir.chdir(@opt.pth) #watch
            end
            @env=SiSU_Env::InfoEnv.new(@opt.fns)
            if @opt.act[:dal][:set]==:on                   #% --dal, -m
              unless @opt.act[:po4a][:set]==:on            # --po4a, -P
                if @opt.fno =~ /\.ssm$/
                  require_relative 'composite'               # composite.rb #pre-processing
                  SiSU_Assemble::Composite.new(@opt).read
                end
                requires('dal')                              # -m     dal.rb
                SiSU_DAL::Source.new(@opt).read
              end
            end
            if @opt.act[:share_source][:set]==:on
              requires('share_src')                        # -s     share_src.rb
              SiSU_Markup::Source.new(@opt).read
            end
            if @opt.act[:qrcode][:set]==:on                #% --qrcode, -Q
              requires('qrcode')                           # -Q     qrcode.rb
              SiSU_QRcode::Source.new(@opt).read
            end
            if @opt.act[:hash_digests][:set]==:on          #% --hash-digests, -N digest tree
              requires('digests')                          # -N     digests.rb
              SiSU_DigestView::Source.new(@opt).read
            end
            if @opt.act[:txt][:set]==:on                   #% --txt, -t -a
              requires('plaintext')                        # -t -a  plaintext.rb
              SiSU_Plaintext::Source.new(@opt).read
            end
            if @opt.act[:html][:set]==:on                  #% --html, -h
              requires('html')                             # -h -H  html.rb
              SiSU_HTML::Source.new(@opt).read
            end
            if @opt.act[:concordance][:set]==:on           #% --concordance, -w
              requires('concordance')                      # -w     concordance.rb
              SiSU_Concordance::Source.new(@opt).read
            end
            if @opt.act[:epub][:set]==:on                  #% --epub, -e
              requires('epub')                             # -e     epub.rb
              SiSU_EPUB::Source.new(@opt).read
            end
            if @opt.act[:odt][:set]==:on                   #% --odt, -o opendocument
              requires('odf')                              # -o     odf.rb
              SiSU_ODF::Source.new(@opt).read
            end
            if @opt.act[:xhtml][:set]==:on                 #% --xhtml, -b xhtml
              requires('xhtml')                            # -b     xhtml.rb
              SiSU_XHTML::Source.new(@opt).read
            end
            if @opt.act[:xml_sax][:set]==:on               #% --xml-sax, -x xml sax type
              requires('xml')                              # -x     xml.rb
              SiSU_XML_SAX::Source.new(@opt).read
            end
            if @opt.act[:xml_dom][:set]==:on               #% --xml-dom, -x xml dom type
              requires('xml_dom')                          # -X     xml_dom.rb
              SiSU_XML_DOM::Source.new(@opt).read
            end
            if @opt.act[:pdf][:set]==:on                   #% --pdf, -p latex/ texpdf
              requires('texpdf')                           # -p     texpdf.rb
              SiSU_TeX::Source.new(@opt).read
            end
            if @opt.act[:manpage][:set]==:on               #% --manpage, -i
              requires('manpage')                          # -i     manpage.rb
              SiSU_Manpage::Source.new(@opt).read
            end
            if @opt.act[:texinfo][:set]==:on               #% --texinfo, -I
              requires('texinfo')                          # -I     texinfo.rb
              SiSU_TexInfo::Source.new(@opt).read
            end
            if @opt.act[:sqlite_discreet][:set]==:on       #% --sqlite, -d DB sqlite
              requires('dbi_discreet')                     # -d     dbi_discreet.rb
              SiSU_DBI_Discreet::SQL.new(@opt).build
            end
            if @opt.act[:manifest][:set]==:on              #% --manifest, -y
              requires('manifest')                         # -y     manifest.rb
              SiSU_Manifest::Source.new(@opt).read
            end
          end
        end
        def pre_loop_files_on_given_option_do
          if @opt.act[:sisupod][:set]==:on               #% --sisupod, -S make sisupod
            requires('sisupod_make')                     # -S     sisupod_make.rb
            begin
              OptionLoopFiles.new(@opt).loop_files_on_given_option do
                SiSU_Doc::Source.new(@opt).read
              end
            ensure
              SiSU_Doc::Source.new(@opt).sisupod_tar_xz
            end
          end
        end
        def post_loop_files_on_given_option_do
          if @opt.act[:sisupod][:set]==:on               #% --sisupod, -S make sisupod
            requires('sisupod_make')                     # -S     sisupod_make.rb
            begin
              OptionLoopFiles.new(@opt).loop_files_on_given_option do
                SiSU_Doc::Source.new(@opt).read
              end
            ensure
              SiSU_Doc::Source.new(@opt).sisupod_tar_xz
            end
          end
          if @opt.act[:images][:set]==:on                  #% --images, -j
            requires('shared_images')
            OptionLoopFiles.new(@opt).loop_files_on_given_option do
              SiSU_Images::Source.new(@opt).read           # -j     shared_images.rb
            end
          end
          if @opt.act[:po4a][:set]==:on                    #% --po4a, -P
            requires('po4a')
            OptionLoopFiles.new(@opt).loop_files_on_given_option do
              SiSU_Po4a::Source.new(@opt).read             # -P     po4a.rb
            end
          end
          if @opt.act[:git][:set]==:on                     #% --git, -g sisu git
            requires('git')
            OptionLoopFiles.new(@opt).loop_files_on_given_option do
              SiSU_Git::Source.new(@opt).read              # -g     git.rb
            end
          end
          if @opt.cmd =~/T/                                #% -T termsheet/standard form
            SiSU_Help::Help.new('termsheet').help_request
            @opt.files.each do |fns|
              if FileTest.file?(fns)
                @opt.fns=fns
                case @opt.fns
                when /\.(termsheet.rb)$/
                  SiSU::Operations.new(@opt).termsheet
                else                                 #print "not processed --> ", fns, "\n"
                end
              else SiSU::Operations.new(@opt).not_found
              end
            end
            SiSU::Operations.new.counter
          end
          if @opt.cmd =~/k/                                #% -k temporary tests
            OptionLoopFiles.new(@opt).loop_files_on_given_option do
              #requires('xml_scaffold')
              #fix
            end
          end
          if @opt.act[:psql][:set]==:on                    #% --pg, -D DB postgresql
            requires('dbi')
            if @opt.files.length > 0 #switch test to actual commands
              OptionLoopFiles.new(@opt).loop_files_on_given_option do
                SiSU_DBI::SQL.new(@opt).connect            # -D -d  dbi.rb
              end
            else
              SiSU_DBI::SQL.new(@opt).connect              # -D -d  dbi.rb
            end
          end
          if @opt.act[:sqlite][:set]==:on                  #% --sqlite, -d DB sqlite
            requires('dbi')
            if @opt.files.length > 0 #switch test to actual commands
              OptionLoopFiles.new(@opt).loop_files_on_given_option do
                SiSU_DBI::SQL.new(@opt).connect            # -D -d  dbi.rb
              end
            else
              SiSU_DBI::SQL.new(@opt).connect              # -D -d  dbi.rb
            end
          end
          if @opt.act[:dal][:set]==:on                     #% --dal, -m embedded content
          # OptionLoopFiles.new(@opt).loop_files_on_given_option do
          #   requires('embedded')
          #   SiSU_Embedded::Source.new(@opt).read         # -m     embedded.rb (image and other content) #check
          # end
          end
          if @opt.act[:zap][:set]==:on                     #% --zap, -Z
          # OptionLoopFiles.new(@opt).loop_files_on_given_option do
          #   requires('zap')
          #   SiSU_Zap::Source.new(@opt).read              # -Z     zap.rb
          # end
          end
          if @opt.act[:sisupod][:set]==:on                 #% --sisupod, -S make sisupod
          # OptionLoopFiles.new(@opt).loop_files_on_given_option do
          #   requires('sisupod_make')
          #   SiSU_Doc::Source.new(@opt).read              # -S     sisupod_make.rb
          # end
          end
          if @opt.act[:manifest][:set]==:on                #% --manifest, -y
            requires('manifest')
            OptionLoopFiles.new(@opt).manifest_on_files_translated do
              SiSU_Manifest::Source.new(@opt).read         # -y     manifest.rb
            end
          end
          if @opt.act[:sitemap][:set]==:on                 #% --sitemap, -Y
            requires('sitemaps')
            OptionLoopFiles.new(@opt).loop_files_on_given_option do
              SiSU_Sitemaps::Source.new(@opt).read         # -Y     sitemaps.rb
            end
          end
          if @opt.act[:harvest][:set] !=:on
            if @opt.act[:scp][:set]==:on                   #% -r copy to remote server
              OptionLoopFiles.new(@opt).loop_files_on_given_option do
                SiSU_Remote::Put.new(@opt).scp             # -r
              end
            end
            if @opt.act[:rsync][:set]==:on                 #% -R copy to remote server
              OptionLoopFiles.new(@opt).loop_files_on_given_option do
                SiSU_Remote::Put.new(@opt).rsync           # -R
              end
            end
          else
          end
          if @opt.act[:urls_selected][:set]==:on           #% --sitemap, -Y
           requires('urls')
           OptionLoopFiles.new(@opt).loop_files_on_given_option do
             SiSU_Urls::Source.new(@opt).read              #% -u -v -V -M
           end
          end
        end
        if @opt.act[:site_init][:set]==:on                 #% -C
          requires('conf')                                 # -s     conf.rb
          SiSU_Initialize::Source.new(@opt).read
        end
        #pre_loop_files_on_given_option_do
        each_file_loop_options
        post_loop_files_on_given_option_do
        @msg,@msgs="\tsisu -W [to start ruby web-server on output directory]\n",nil unless @opt.act[:quiet][:set] ==:on
        @tell.call.print_brown if @opt.cmd =~/[uUvVM]/ unless @opt.files.join.empty?
        if defined? @@env.processing_path.processing \
        and @@env.user \
        and FileTest.directory?(@@env.processing_path.processing) \
        and @@env.processing_path.processing =~/#{@@env.user}$/ #clean temporary processing directory of content as is located in public area
          FileUtils::cd(@@env.processing_path.processing_base_tmp) do
            FileUtils::rm_rf(@@env.user) unless @opt.act[:maintenance][:set] ==:on
          end
        end
      elsif @opt.mod.inspect =~/--query/
        require_relative 'sst_identify_markup'          # sst_identify_markup.rb
        puts SiSU_Markup::MarkupHistory.new(@opt).query
      elsif @opt.mod.inspect =~/--identify/
        require_relative 'sst_identify_markup'          # sst_identify_markup.rb
        markup_version=SiSU_Markup::MarkupIdentify.new(@opt).markup_version?
      elsif  @opt.mod.inspect =~/--about/                  #% help instructions
        if @opt.mod.inspect =~/--about/ \
        and not @opt.what.empty?
          SiSU_Help::Help.new(@opt.what,'color_off').help_request
        else
          SiSU_Help::Help.new('list','color_off').help_request
        end
      elsif  @opt.mod.inspect =~/--sitemaps/               #% sitemaps
        require_relative 'sitemaps'                     # sitemaps.rb
        SiSU_Sitemaps::Source.new(@opt).read
        if @opt.act[:rsync][:set]==:on
          require_relative 'remote'                     # remote.rb
          SiSU_Remote::Put.new(@opt).rsync_sitemaps
        end
      else                                                 #% help instructions
        unless @opt.mod.inspect =~/--convert|--to|--from|--harvest/
          if @opt.mod.inspect =~/--help/ \
          and not @opt.what.empty?
            SiSU_Help::Help.new(@opt.what).help_request
          elsif @opt.mod.inspect =~/--help/
            SiSU_Help::Help.new('list').help_request
          else
            SiSU_Help::Help.new('env',@opt).sisu_version
            tell=SiSU_Screen::Ansi.new('',"  for HELP type:\n\tsisu --help [help request]\n\tman sisu\n  or see the system or online documentation on SiSU:\n    #{Config::CONFIG['datadir']}/doc/sisu/\n    <http://www.jus.uio.no/sisu/>\n    <http://sisudoc.org/>")
            tell.puts_grey
          end
        end
      end
      @opt.files.each do |fns|
        if FileTest.file?(fns)
          @opt.fns=fns
          unless @opt.fns =~ /(?:\.(?:(?:-|ssm\.)?sst|ssm|ssp|sx[sdn]\.xml|termsheet.rb)|\S+?\.ss[mt]\.(?:txz|zip)|sisupod\.(?:txz|zip)?|\S+?\.ssp)$/
            if @opt.cmd.inspect=~/-P/
            elsif @opt.fns=~/\.kdi$/ \
            and @opt.mod.inspect =~/--(?:convert(?:-from)?|from)[=-]kdi/
            elsif @opt.fns=~/\.sx[sdn]\.xml$/ \
            and @opt.mod.inspect =~/--(?:(?:convert(?:-from)?|from)[=-])?(?:xml2sst|sxml)/
            elsif @opt.fns=~/\.ssi$/ \
            and @opt.mod.inspect =~/--identify/
            else SiSU::Operations.new(@opt).not_recognised
            end
          end
          if @opt.fns =~/\.ssm\.sst$/ \
          and @opt.cmd !~/[S_M]/ # rework necessry, revist, the _ flag is a hack, to keep ._sst files
            @msg,@msgs='temporary file removed',nil
            @tell.call.warn unless @opt.cmd =~/V/
            File.unlink(@opt.fns) if File.exist?(@opt.fns) #CONSIDER
          end
        else                          #SiSU::Operations.new(fns,'html').not_found
        end
      end
    end
  end
  begin                                                              #% select what to do
    if RUBY_VERSION  < '1.9'
      require 'jcode'
      $KCODE='UTF8'
    end
    require_relative 'constants'                        # constants.rb
    require_relative 'options'                          # options.rb
    require_relative 'sysenv'                           # sysenv.rb
      include SiSU_Env; include SiSU_Screen
    require_relative 'param'                            # param.rb
      include SiSU_Param
    require_relative 'defaults'                         # defaults.rb
      include SiSU_Viz
    require_relative 'help'                             # help.rb
      include SiSU_Help
    require 'uri'
    home=ENV['HOME']
    argv=$*
    @opt=SiSU_Commandline::Options.new(argv)
    SiSU::Processing.new(@opt).actions
  rescue
    cmd=(@opt ? @opt.cmd : '')
    SiSU_Screen::Ansi.new(cmd,$!,$@).rescue do
      __LINE__.to_s + ':' + __FILE__
    end
  ensure
    Dir.chdir(@@pwd_the)
  end
end
__END__
