# coding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997 - 2010, Ralph Amissah, All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.jus.uio.no/sisu/gpl.fsf/toc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/doc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/plain.txt>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: SiSU information Structuring Universe, text structuring,
    processing, publishing, search

=end
module SiSU
  require "#{SiSU_lib}/constants"                          # constants.rb
  require "#{SiSU_lib}/sysenv"                             # sysenv.rb
    include SiSU_Screen
  @@pwd=Dir.pwd
  class Op
    @@env=SiSU_Env::Info_env.new
    def initialize(opt,req,message)
      @opt,@req,@message=opt,req,message
      @n_do=0
    end
    def pod_output(fns_pod)
      dir_pwd=@@env.path.pwd
      dir_pod=@@env.sisupod_gen(fns_pod)
      Dir.chdir(dir_pod)
      content=Dir.glob("*.ss[mt]").join(' ')
      if content =~/\.ss[mt]/
        Dir.chdir(dir_pwd)
        @opt.fns=content #check
        system("cd #{dir_pod}
          sisu -CC #{@opt.cmd} #{@opt.mod.join(' ')} #{content}
          cd -
        ")
      end
      @pwd=`pwd`.strip
      Dir.chdir(@pwd)
    end
    def select
      require "#{SiSU_lib}/#{@req}"
      if @req =~/^conf$/               # -C
        SiSU_Initialize::Source.new(@opt).read
      end
      if not @opt.files.empty?
        @opt.files.each do |fns|
          env=SiSU_Env::Info_env.new(fns)
          if fns =~ /sisupod(?:\.zip)?|\S+?(?:\.ss[mt]\.zip|\.ssp)$/
            require "#{SiSU_lib}/remote"                   # remote.rb #check
            pod_name=SiSU_Remote::Remote_download.new(fns).pod.name
            SiSU_Screen::Ansi.new(@opt.cmd,pod_name).puts_blue unless @opt.cmd =~/q/
            @opt.files.shift
            pod_output(pod_name)
            break
          else
            put=fns.gsub(/(.+)?\.ssm\.sst$/,'\1.ssm')
            @opt.fns=fns
            if @req !~/(?:urls|remote)$/
              if @req=~/^dal$/ \
              and FileTest.file?(@opt.fns) \
              and @opt.fns =~ /\.(?:(?:-|ssm\.)?sst|ssm)$/
                if fns =~ /\.ssm$/
                  require "#{SiSU_lib}/composite"          # composite.rb #pre-processing
                  SiSU_Assemble::Composite.new(@opt).read
                  @opt.fns=fns.gsub(/\.ssm$/,'.ssm.sst')
                end
                SiSU_DAL::Source.new(@opt).read                                         # -m
              elsif FileTest.file?(env.source_file_with_path)
                case @opt.fns
                when /\.(?:(?:-|ssm\.)?sst|ssm)$/
                  case @req
                  when /^dal$/
                    if fns =~ /\.ssm$/
                      require "#{SiSU_lib}/composite"      # composite.rb #pre-processing
                      SiSU_Assemble::Composite.new(@opt).read
                      @opt.fns=fns.gsub(/\.ssm$/,'.ssm.sst')
                    end
                                            SiSU_DAL::Source.new(@opt).read             # -m
                  when /^git$/;             SiSU_Git::Source.new(@opt).read             # -g
                  when /^concordance$/;     SiSU_Concordance::Source.new(@opt).read     # -w
                  when /^share_src$/;       SiSU_Markup::Source.new(@opt).read          # -s
                  when /^sisupod_make$/;    SiSU_Doc::Source.new(@opt).read             # -S
                  when /^source_kdissert$/; SiSU_Kdi_source::Source.new(@opt).read      ## -S
                  when /^digests$/;         SiSU_Digest_view::Source.new(@opt).read     # -N
                  when /^xml_scaffold$/;    SiSU_XML_scaffold::Source.new(@opt).read    # -k
                  when /^plaintext$/;       SiSU_Plaintext::Source.new(@opt).read       # -t -a
                 #when /^wikispeak$/;       SiSU_Wikispeak::Source.new(@opt).read       # -g
                  when /^epub$/;            SiSU_EPUB::Source.new(@opt).read            # -e
                  when /^odf$/;             SiSU_ODF::Source.new(@opt).read             # -o
                  when /^xml_md_oai_pmh_dc$/; SiSU_XML_metadata::OAI_PMH.new(@opt).read # -O
                  when /^texpdf$/;          SiSU_TeX::Source.new(@opt).read             # -p
                  when /^manpage$/;         SiSU_Manpage::Source.new(@opt).read         # -i
                  when /^texinfo$/;         SiSU_TexInfo::Source.new(@opt).read         # -I
                  when /^html$/;            SiSU_HTML::Source.new(@opt).read            # -h -H
                  when /^xml$/;             SiSU_XML_SAX::Source.new(@opt).read         # -x
                  when /^xml_dom$/;         SiSU_XML_DOM::Source.new(@opt).read         # -X
                  when /^xml_fictionbook$/; SiSU_XML_Fictionbook::Source.new(@opt).read # -f
                  when /^xhtml$/;           SiSU_XHTML::Source.new(@opt).read           # -b
                  when /^embedded$/;        SiSU_Embedded::Source.new(@opt).read        # -m (image and other content)
                  when /^manifest$/;        SiSU_Manifest::Source.new(@opt).read        # -y
                  when /^sitemaps$/;        SiSU_Sitemaps::Source.new(@opt).read        # -Y
                  when /^zap$/;             SiSU_Zap::Source.new(@opt).read             # -Z
                  when /^dbi$/;             SiSU_DBI::SiSU_SQL.new(@opt).connect        # -D -d
                  end
                  @n_do=@n_do+1
                  SiSU_Screen::Ansi.new(@opt.cmd,@n_do,"#{@req.upcase} processed").files_processed if @opt.cmd =~/[MVv]/
                  ObjectSpace.garbage_collect
                else                    #print "not processed --> ", fns, "\n"
                end
              else
               if @req !~/^conf$/ \
               and @opt.fns !~/http:\/\//
                  Operations.new(@opt).not_found
                end
              end
            elsif FileTest.file?(put)
              if @opt.mod.inspect !~/harvest/ #decide whether should permit harvest in single operation
                case @req
                when /^urls$/;           SiSU_urls::Source.new(@opt).read           # -u -v -V -M
                when /^remote$/
                  case @message
                  when /scp/;            SiSU_Remote::Put.new(@opt).scp             # -r
                  when /rsync/;          SiSU_Remote::Put.new(@opt).rsync           # -R
                  else                   #SiSU_Remote::Put.new(put,@opt.cmd).scp
                  end
                end
                @n_do=@n_do+1
                SiSU_Screen::Ansi.new(@opt.cmd,@n_do,"#{@req.upcase} processed").files_processed if @opt.cmd =~/[MVv]/
              end
            else Operations.new(@opt).not_found
            end
          end
        end
      elsif @req =~/^dbi$/;            SiSU_DBI::SiSU_SQL.new(@opt).connect    # -D -d
      elsif @req=~/^sisupod_make$/;    SiSU_Doc::Source.new(@opt).read         # -S
      end
      Operations.new.counter
    end
  end
  class Operations
    @@n_do=0
    def initialize(opt='')
      @opt=opt
      @cX=SiSU_Screen::Ansi.new(@opt).cX
    end
    def counter
      @@n_do=0
    end
    def remote_put_base_site_rsync                         # -CR
p "here #{__FILE__} #{__LINE__}" if @opt =~/M/
      require "#{SiSU_lib}/remote"                         # remote.rb
      SiSU_Remote::Put.new(@opt).rsync_base
    end
    def remote_put_base_site_rsync_match                   # -CCRZ
p "here #{__FILE__} #{__LINE__}" if @opt =~/M/
      require "#{SiSU_lib}/remote"                         # remote.rb
      SiSU_Remote::Put.new(@opt).rsync_base_sync
    end
    def remote_put_base_site                               # -Cr
p "here #{__FILE__} #{__LINE__}" if @opt =~/M/
      require "#{SiSU_lib}/remote"                         # remote.rb
      SiSU_Remote::Put.new(@opt).scp_base
    end
    def remote_put_base_site_all                           # -CCr
p "here #{__FILE__} #{__LINE__}" if @opt =~/M/
      require "#{SiSU_lib}/remote"                         # remote.rb
      SiSU_Remote::Put.new(@opt).scp_base_all
    end
    def cgi                                                # -F
      require "#{SiSU_lib}/cgi"                            # cgi.rb
      SiSU_CGI::SiSU_search.new(@opt).read
    end
    def encoding                                           # -K build character encoding db (uses KirbyBase)
      require "#{SiSU_lib}/character_encoding"             # character_encoding.rb
      SiSU_character_encode::Create.new.db
    end
    def termsheet                                          # -t
      system("sisu_termsheet #{@opt.cmd} #{@opt.fns}\n")
      @@n_do=@@n_do+1
      SiSU_Screen::Ansi.new(@opt.cmd,@@n_do,'Termsheet(s) processed').term_sheet_title unless @opt.cmd =~/q/
    end
    def webrick                                            # -W
      port=prt=@fns
      prt=if prt !~/\d+/
        'webrick default (sysenv)'
      else "webrick port set to #{prt}"
      end
      puts %{#{@cX.blue}<<#{@cX.off}#{@cX.green}Start Webrick web server on port: #{prt}#{@cX.off}#{@cX.blue}>> #{@cX.off*2} }
      system("sisu_webrick #{port}&\n")
    end
    def not_found
      puts "\n#{@cX.fuschia}FILE NOT FOUND:#{@cX.off} << #{@opt.fns} >> - requested #{@opt.cmd} processing skipped\n"
    end
    def convert_name_message(fns,type,i,o,rune)
      %{\nIn filename: "#{@cX.fuschia}#{fns}#{@cX.off}" << #{type} >> #{@cX.fuschia}is apre 0.36 markup filename.#{@cX.off} #{@cX.brown}Please rename your file.#{@cX.off}\n\tAs of sisu-0.37, SiSU markup files with #{@cX.brown}the extensions #{i} should be re-named #{o}#{@cX.off}\n\tif you have the program called 'rename' installed, the following rune should do the trick:\n\t\t#{rune}\n\talternatively try:\n\t\tsisu --convert --36to37 #{fns}\n\trequested #{@opt.cmd} processing skipped\n}
    end
    def not_recognised
      case @opt.fns
      when /(\.s[123])$/
        type=@opt.fns.gsub(/\S+?(#{$1})/,'\1')
        rune=%q{rename 's/\.s[123]$/\.sst/' *.s{1,2,3}}
        puts convert_name_message(@opt.fns,type,'.s1 .s2 and .s3','.sst',rune)
      when /(\.r[123])$/
        type=@opt.fns.gsub(/\S+?(#{$1})/,'\1')
        rune=%q{rename 's/\.r[123]$/\.ssm/' *.r{1,2,3}}
        puts convert_name_message(@opt.fns,type,'.r1 .r2 and .r3','.sst',rune)
        puts %{\n\tNote also that you will need to change the names of the files called/required\n\twithin the document text to build the composite document\n\t\t.s1 .s2 .s3 should be .sst \n\t\t.si should be .ssi\n\trequested #{@opt.cmd} processing skipped\n}
      when /(\.ssi)$/
        puts "\n#{@cX.fuschia}component filetype:#{@cX.off} << #{@opt.fns} >> - is not a processed filetype, (it may be used as a component of a .ssm markup file)\n\trequested #{@opt.cmd} processing skipped\n"
      else
        puts "\n#{@cX.fuschia}FILETYPE NOT RECOGNISED:#{@cX.off} << #{@opt.fns} >> - is not a recognized filetype,\n\trequested #{@opt.cmd} processing skipped\n"
      end
    end
  end
  class Processing
    require 'fileutils'
      include FileUtils
    @@env=SiSU_Env::Info_env.new
    attr_accessor :op
    def initialize(opt)
      @opt=opt
      @msg,@msgs='',nil
      @tell=lambda { SiSU_Screen::Ansi.new(@opt.cmd,@msg,"#{@msgs.inspect if @msgs}") }
    end
    def op(req,msg)
      Op.new(@opt,req,msg).select if req and msg
    end
    def actions
      if @opt.cmd =~/P/
        require 'profile'
      end
      if @opt.mod.inspect =~/--harvest/
        require "#{SiSU_lib}/harvest"                      # harvest.rb
      end
      if @opt.mod.inspect =~/--convert|--to|--from/
        require "#{SiSU_lib}/sst_convert_markup"           # sst_convert_markup.rb
      end
      if @opt.cmd =~/([AabCcDdeFfgGHhIiJjkLMmNnOopQqrRSsTtUuVvwWXxYyZ_0-9])/ \
      and @opt.cmd =~/^-/ \
      and @opt.mod.inspect !~/--(?:sitemaps|query|identify)/ \
      or @opt.mod.inspect =~/--(?:(?:sq)?lite|pg(?:sql)?)/ #and
        @@tell=SiSU_Screen::Ansi.new(@opt.cmd)
        @cX=SiSU_Screen::Ansi.new(@opt.cmd).cX
        flag=SiSU_Env::Info_processing_flag.new
        extra=''
        if @opt.cmd !~/[mn]/
          extra+=if @opt.cmd =~/[abegHhIiNOopTtwXxyz]/ \
          and @opt.cmd !~/[mn]/
            'm'                        #% add dal
          elsif ((@opt.cmd =~/[Dd]/ \
          or (@opt.mod.inspect =~/--(?:(?:sq)?lite|pg(?:sql)?)/)) \
          and @opt.mod.inspect !~/(?:remove|(?:(?:re)?create(?:all)?|dropall|drop)$)/) \
          and @opt.cmd !~/[mn]/
            'm'                                                                          #% add dal
          else ''
          end
        end
        if @opt.cmd !~/y/
          extra+=if @opt.cmd =~/[abeHhIiNopsSstwXxz]/ \
          and @opt.cmd !~/y/
            'ym'            #% add manifest
          elsif (@opt.cmd =~/[Dd]/ \
          or @opt.mod.inspect =~/--(?:(?:sq)?lite|pg(?:sql)?)/) \
          and @opt.files[0] !~/^remove$/ \
          and @opt.cmd !~/y/
            'ym' #% add manifest
          else ''
          end
        end
        @opt.cmd=@opt.cmd + extra
        opt=@opt.cmd.scan(/CC|\S/)
        @opt.cmd=opt.uniq.join
        if @opt.cmd =~/[vVM]/          #% version information
          if @opt.cmd =~/V/ \
          and @opt.files.empty?        #% environment
            SiSU_Help::Help.new('env',@opt).environment
          else SiSU_Help::Help.new('env',@opt).sisu_version
          end
        end
        if @opt.cmd =~/^-L$/           #% version information
          SiSU_Help::Help.new('license',@opt).help_request
        end
        if @opt.cmd =~/m/i             #% -m for -C
          path={}
          path[:css]=@@env.path.output + '/_sisu/css'
          path[:xml]=@@env.path.output + '/_sisu/xml'
          path[:xsd]=path[:xml] + '/xsd'
          path[:xsd]=path[:xml] + '/rnc'
          path[:xsd]=path[:xml] + '/rng'
          re_p=/(sisupod(?:\.zip)?|\S+?\.ss[mt]\.zip|[^\/]+?\.ssp)$/
          unless @opt.files.join(',') =~ re_p #do not mix pods with source markup files in command line
            unless ( FileTest.directory?(path[:css]) \
            and FileTest.directory?(path[:xsd]) )
              @opt.cmd=@opt.cmd +='C' unless @opt.cmd =~/C/ #FIX
            end
            if @opt.cmd =~/M/
              $VERBOSE=false                          #debug $VERBOSE=true
            end
          end
        end
        if @opt.cmd =~/C/              #% -C initialize/configure
          op('conf','configure site')
          if @opt.cmd =~/R/
            if @opt.mod.inspect =~/--init(?:ialize)?=site/ \
            and @opt.cmd =~/RZ/
              Operations.new(@opt).remote_put_base_site_rsync_match
            else Operations.new(@opt).remote_put_base_site_rsync
            end
          elsif @opt.cmd =~/r/
            if @opt.mod.inspect =~/--init(?:ialize)?=site/ \
            and @opt.cmd =~/CCr/
              Operations.new(@opt).remote_put_base_site_all
            else Operations.new(@opt).remote_put_base_site
            end
          end
        end
        if @opt.cmd =~/F/              #% -F cgi sample search form
          Operations.new(@opt).cgi
        end
        if @opt.cmd =~/W/              #% -W webrick #@argv==port
          Operations.new(@opt).webrick
        end
        if @opt.cmd =~/Z/              #% -Z wipe previous output clean
          op('zap','Zap, deletions')
        end
        if @opt.cmd =~/s/              #% -s sisu source
          op('share_src','SiSU markup source')
        end
        if @opt.cmd =~/g/              #% -g sisu git
          op('git','SiSU Git')
        end
        if @opt.cmd =~/m/              #% -m is remote url requested? (download if)
          @retry_count= -1
          begin
            path_image='./_sisu/processing/external_document/image'
            path_skin='./_sisu/processing/external_document/skin/doc'
            @get_s,@get_p=[],[]
            re_s=/((?:https?|file):\/\/\S+?\.sst)$/
            re_p=/((?:https?|file):\/\/\S+?(?:\/\S+?\.ss[mt]\.zip|sisupod(?:\.zip)?|\.ssp))/
            @opt.files.each do |fns|
              if fns =~re_s
                @get_s << re_s.match(fns)[1] if re_s
              end
              if fns =~re_p
                @get_p << re_p.match(fns)[1] if re_p
              end
            end
            if @get_s.length > 0       #% remote markup file .sst
              require "#{SiSU_lib}/remote"                 # remote.rb
              SiSU_Remote::Get.new(@opt,@get_s).fns
              Operations.new.counter
            end
            if @get_p.length > 0       #% remote sisupod
              require "#{SiSU_lib}/remote"                 # remote.rb
              SiSU_Remote::Get.new(@opt,@get_p).sisupod
            end
          rescue
            SiSU_Errors::Info_error.new($!,$@,@opt,@fns).error #ok
            @retry_count +=1
            retry unless @retry_count > 1
          ensure
          end
          @opt.files=@opt.files.collect {|x| x=x.gsub(/(?:https?|file):\/\/\S+\/(\S+)\.sst$/,'\1.-sst') }
        end
        if @opt.cmd=~/m/               #% -m dal
          op('dal','dal')
        end
        @opt.files=@opt.files.collect {|x| x=x.gsub(/\.ssm$/,'.ssm.sst') }
        if @opt.cmd =~/S/
          op('sisupod_make','sisupod (zip)') #% -S make sisupod
          if @opt.fns=~/\.kdi._sst/
            op('share_src_kdissert','kdissert (kdi)') #% -S share kdissert source
          end
        end
        if @opt.cmd =~/N/; op('digests','digests')             #% -N digest tree
        end
        if @opt.cmd =~/[hHz]/; op('html','html')               #% -h -H -z html css
        end
        if @opt.cmd =~/[at]/; op('plaintext','plaintext')         #% -t -a #-A -f -e -E plaintext -a creates ms-dos type; -A creates unix type, plaintext file
        end
        #if @opt.cmd =~/g/; op('git','git')         #% -g git
        #end
        #if @opt.cmd =~/g/; op('wikispeak','wikispeak')         #% -g wiki
        #end
        if @opt.cmd =~/e/; op('epub','ePub')                   #% -e epub
        end
        if @opt.cmd =~/o/; op('odf','OpenDocument')            #% -o opendocument
        end
        if @opt.cmd =~/x/; op('xml','xml sax')                 #% -x xml sax type
        end
        if @opt.cmd =~/X/; op('xml_dom','xml dom')             #% -X xml dom type
        end
        if @opt.cmd =~/f/; op('xml_fictionbook','xml fictionbook') #% -f xml fictionbook
        end
        if @opt.cmd =~/b/; op('xhtml','xhtml sax')             #% -b xhtml sax type
        end
        if @opt.cmd =~/w/; op('concordance','Concordance')     #% -w concordance
        end
        if @opt.cmd =~/O/; op('xml_md_oai_pmh_dc','OAI PMH')   #% -O open archive initiative, metadata harvesting
        end
        if @opt.cmd =~/T/                                      #% -T termsheet/standard form
          SiSU_Help::Help.new('termsheet').help_request
          @opt.files.each do |fns|
            if FileTest.file?(fns)
              @opt.fns=fns
              case @opt.fns
              when /\.(termsheet.rb)$/;            Operations.new(@opt).termsheet
              else                                 #print "not processed --> ", fns, "\n"
              end
            else Operations.new(@opt).not_found
            end
          end
          Operations.new.counter
        end
        if @opt.cmd =~/k/; op('xml_scaffold','XML scaffold')                   #% -T temporary tests
        end
        if @opt.cmd =~/p/; op('texpdf','LaTeX pdf')                            #% -p latex/ texpdf
        end
        if @opt.cmd =~/i/; op('manpage','manpage')                             #% -i manpage
        end
        if @opt.cmd =~/I/; op('texinfo','TeX Info')                            #% -I texinfo (i taken by db import)
        end
        if @opt.cmd =~/D/ \
        or @opt.mod.inspect =~/--pgsql/; op('dbi','postgresql')                #% -D DB postgresql
        end
        if @opt.cmd =~/d/ \
        or @opt.mod.inspect =~/--sqlite/; op('dbi','sqlite')                   #% -d DB sqlite
        end
        if @opt.cmd =~/G/; Operations.new(@opt).cgi                            #% -G cgi - used to make dbi intecface
        end
        if @opt.cmd=~/m/; op('embedded','Embedded Content')                    #% -m embedded content
        end
        if @opt.cmd =~/y/; op('manifest','Manifest')                           #% -y manifest
        end
        if @opt.cmd =~/Y/; op('sitemaps','Sitemap')                            #% -Y sitemap
        end
        if @opt.mod.inspect !~/--harvest/
          if @opt.cmd =~/r/; op('remote','scp')                                #% -r copy to remote server
          end
          if @opt.cmd =~/R/; op('remote','rsync')                              #% -R copy to remote server
          end
        else
        end
        op('urls','urls')
        @msg,@msgs="\tsisu -W [to start ruby web-server on output directory]\n",nil unless @opt.cmd =~/q/
        @tell.call.print_brown if @opt.cmd =~/[uUvVM]/ unless @opt.files.join.empty?
        if defined? @@env.path.processing \
        and @@env.user \
        and FileTest.directory?(@@env.path.processing) \
        and @@env.path.processing =~/#{@@env.user}$/ #clean temporary processing directory of content as is located in public area
          cd(@@env.path.processing_base_tmp) do
            rm_rf(@@env.user) unless @opt.cmd =~/M/
          end end
      elsif @opt.mod.inspect =~/--query/
        require "#{SiSU_lib}/sst_identify_markup"          # sst_identify_markup.rb
        puts SiSU_Markup::Markup_history.new(@opt).query
      elsif @opt.mod.inspect =~/--identify/
        require "#{SiSU_lib}/sst_identify_markup"          # sst_identify_markup.rb
        markup_version=SiSU_Markup::Markup_identify.new(@opt).markup_version?
      elsif  @opt.mod.inspect =~/--about/                            #% help instructions
        if @opt.mod.inspect =~/--about/ \
        and not @opt.what.empty?
          SiSU_Help::Help.new(@opt.what,'color_off').help_request
        else SiSU_Help::Help.new('list','color_off').help_request
        end
      elsif  @opt.mod.inspect =~/--sitemaps/                                   #% sitemaps
        require "#{SiSU_lib}/sitemaps"                     # sitemaps.rb
        SiSU_Sitemaps::Source.new(@opt).read
        if @opt.cmd =~/R/
          require "#{SiSU_lib}/remote"                     # remote.rb
          SiSU_Remote::Put.new(@opt).rsync_sitemaps
        end
      else                                                                     #% help instructions
        unless @opt.mod.inspect =~/--convert|--to|--from|--harvest/
          if @opt.mod.inspect =~/--help/ \
          and not @opt.what.empty?
            SiSU_Help::Help.new(@opt.what).help_request
          elsif @opt.mod.inspect =~/--help/; SiSU_Help::Help.new('list').help_request
          else SiSU_Help::Help.new('env',@opt).sisu_version
            tell=SiSU_Screen::Ansi.new('',"  for HELP type:\n\tsisu --help [help request]\n\tman sisu\n  or see the system or online documentation on SiSU:\n    #{Config::CONFIG['datadir']}/doc/sisu/\n    <http://www.jus.uio.no/sisu/>\n    <http://sisudoc.org/>"); tell.puts_grey
          end
        end
      end
      @opt.files.each do |fns|
        if FileTest.file?(fns)
          @opt.fns=fns
          unless @opt.fns =~ /(?:\.(?:(?:-|ssm\.)?sst|ssm|ssp|sx[sdn]\.xml|termsheet.rb)|\S+?\.ss[mt]\.zip|sisupod(?:\.zip)?|\S+?\.ssp)$/
            if @opt.fns=~/\.kdi$/ \
            and @opt.mod.inspect =~/--(?:convert(?:-from)?|from)[=-]kdi/
            elsif @opt.fns=~/\.sx[sdn]\.xml$/ \
            and @opt.mod.inspect =~/--(?:(?:convert(?:-from)?|from)[=-])?(?:xml2sst|sxml)/
            elsif @opt.fns=~/\.ssi$/ \
            and @opt.mod.inspect =~/--identify/
            else Operations.new(@opt).not_recognised
            end
          end
          if @opt.fns =~/\.ssm\.sst$/ \
          and @opt.cmd !~/[S_M]/ # rework necessry, revist, the _ flag is a hack, to keep ._sst files
            @msg,@msgs='temporary file removed',nil
            @tell.call.warn unless @opt.cmd =~/V/
            File.unlink(@opt.fns) if File.exist?(@opt.fns) #CONSIDER
          end
        else                          #Operations.new(fns,'html').not_found
        end
      end
    end
  end
  begin                                                              #% select what to do
    if RUBY_VERSION  < '1.9'
      require 'jcode'
      $KCODE='UTF8'
    end
    require "#{SiSU_lib}/constants"                        # constants.rb
    require "#{SiSU_lib}/options"                          # options.rb
    require "#{SiSU_lib}/sysenv"                           # sysenv.rb
      include SiSU_Env; include SiSU_Screen
    require "#{SiSU_lib}/param"                            # param.rb
      include SiSU_Param
    require "#{SiSU_lib}/defaults"                         # defaults.rb
      include SiSU_Viz
    require "#{SiSU_lib}/help"                             # help.rb
      include SiSU_Help
    require 'uri'
    home=ENV['HOME']
    argv=$*
    @opt=SiSU_commandline::Options.new(argv)
    Processing.new(@opt).actions
  rescue; STDERR.puts SiSU_Screen::Ansi.new(@opt,$!,$@,nil).rescue #fix
  ensure
    Dir.chdir(@@pwd)
  end
end
__END__
