# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008, 2009, 2010, 2011, 2012 Ralph Amissah, All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.sisudoc.org/sisu/en/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: urls for output files

=end
module SiSU_Urls
  require_relative 'particulars'                        # particulars.rb
    include SiSU_Particulars
  require_relative 'sysenv'                             # sysenv.rb
    include SiSU_Env; include SiSU_Screen
  class Source
    attr_reader :opt
    def initialize(opt)
      @opt=opt
    end
    def read
      begin
        SiSU_Urls::OutputUrls.new(@opt).songsheet if @opt.fnb
      rescue
        SiSU_Errors::InfoError.new($!,$@,@opt.cmd).error do
          __LINE__.to_s + ':' + __FILE__
        end
      ensure
      end
    end
  end
  class OutputUrls
    attr_reader :fns,:fnb,:cmd,:dir,:m_regular,:u
    def initialize(opt)
      @opt=opt
      @particulars=SiSU_Particulars::CombinedSingleton.instance.get_env_md(opt)
      @cmd=@opt.cmd
      @md=@particulars.md
      @env=@particulars.env
      @fnb=@env.fnb
      fn_set_lang=SiSU_Env::StandardiseLanguage.new(@opt.lng).language
      @fnl=@env.i18n.lang_filename(fn_set_lang[:c])
      @fn=SiSU_Env::EnvCall.new(@opt.fns).lang(fn_set_lang[:c])
      @m_regular=/(.+?)\.(?:(?:-|ssm\.)?sst|ssm)$/
      @prog=@env.program
      source=if @opt.fns =~/\.sst$/; @opt.fns
      elsif @opt.fns =~/\.ssm\.sst/; "#{@fnb}.ssm.sst"
      else 'not recognised file'
      end
      @u ||= {
        'b --xhtml (XHTML)'=>@fn[:xhtml],
        'D[iu] --psql (DBI import/update postgresql)'=>'dbi psql',
        'd --sqlite (DBI sqlite)'=>'dbi sqlite3',
        'd[iu] --sqlite (DBI sqlite)'=>'dbi sqlite3',
        'e --epub (EPUB)'=>@fn[:epub],
        'P --pot (Pot)'=>@fn[:pot],
        'h --html (HTML segmented)'=>@fn[:toc],
        'h --html (HTML scroll)'=>@fn[:doc],
        'I --texinfo (Info file)'=>'info',
        'i --manpage (manpage)'=>'manpage',
        'm --dal (Document Abstraction)'=>'dal',
        'N --hash-digests (Digests md5/sha256)'=>@fn[:digest],
        'o --odt (ODF:ODT - Open Document)'=>@fn[:odf],
        'p --pdf (PDF landscape)'=>@fn[:pdf_l],
        'p --pdf (PDF portrait)'=>@fn[:pdf_p],
        'E --profile (Ruby profiler)'=>'profile',
        's --source (sisu markup)'=>source,
        'S --sisupod (sisupod)'=>@fn[:sisupod],
        't --txt (Plain-text (endnotes))'=>@fn[:plain],
        'x --xml-sax (XML sax type)'=>@fn[:sax],
        'X --xml-dom (XML dom type)'=>@fn[:dom],
        'Q --qrcode (QR Code jpg)'=>@fn[:qrcode],
        'y --manifest (Manifest, html)'=>@fn[:manifest],
        'Y (Sitemap, xml)'=>@fn[:sitemap],
        'w --concordance (Concordance, html)'=>@fn[:concordance],
      }.sort {|a,b| a[0].downcase<=>b[0].downcase}
    end
    def songsheet
      begin
       @opt.cmd=~/U/ ? urls_all : (urls_select unless @opt.cmd=~/q/)
      rescue
        SiSU_Errors::InfoError.new($!,$@,@opt.cmd,@opt.fns).error do
          __LINE__.to_s + ':' + __FILE__
        end
      ensure
      end
    end
    def show
      def source
        def src(x,y)
          SiSU_Screen::Ansi.new(@opt.cmd,"[#{@opt.f_pth[:lng_is]}] -#{x}","#{@prog.text_editor} #{@md.file.output_path.src.dir}/#{y}").result
        end
        def pod(x,y)
          SiSU_Screen::Ansi.new(@opt.cmd,"[#{@opt.f_pth[:lng_is]}] -#{x}","#{@prog.web_browser} file://#{@md.file.output_path.sisupod.dir}/#{y}").result
        end
        self
      end
      def generic(x,y)
        SiSU_Screen::Ansi.new(@opt.cmd,"[#{@opt.f_pth[:lng_is]}] -#{x}","#{@prog.web_browser} #{@env.url.output_tell}/#{@fnb}/#{y}").result
      end
      def meta(x,y)
        SiSU_Screen::Ansi.new(@opt.cmd,"[#{@opt.f_pth[:lng_is]}] -#{x}","#{@prog.text_editor} ~#{y}/#{@fnb}.#{y}").result
      end
      def text(x)
        SiSU_Screen::Ansi.new(@opt.cmd,"[#{@opt.f_pth[:lng_is]}] -#{x}","#{@prog.web_browser} file://#{@md.file.output_path.txt.dir}/#{@md.file.base_filename.txt}").result
      end
      def epub(x)
        SiSU_Screen::Ansi.new(@opt.cmd,"[#{@opt.f_pth[:lng_is]}] -#{x}","#{@prog.epub_viewer} #{@md.file.output_path.epub.dir}/#{@md.file.base_filename.epub}").result
      end
      def html
        def scroll(x)
          SiSU_Screen::Ansi.new(@opt.cmd,"[#{@opt.f_pth[:lng_is]}] -#{x}","#{@prog.web_browser} file://#{@md.file.output_path.html_scroll.dir}/#{@md.file.base_filename.html_scroll}").result
        end
        def toc(x)
          SiSU_Screen::Ansi.new(@opt.cmd,"[#{@opt.f_pth[:lng_is]}] -#{x}","#{@prog.web_browser} file://#{@md.file.output_path.html_seg.dir}/#{@md.file.base_filename.html_segtoc}").result
        end
        def concordance(x)
          SiSU_Screen::Ansi.new(@opt.cmd,"[#{@opt.f_pth[:lng_is]}] -#{x}","#{@prog.web_browser} file://#{@md.file.output_path.html_concordance.dir}/#{@md.file.base_filename.html_concordance}").result
        end
        def manifest(x)
          SiSU_Screen::Ansi.new(@opt.cmd,"[#{@opt.f_pth[:lng_is]}] -#{x}","#{@prog.web_browser} file://#{@md.file.output_path.manifest.dir}/#{@md.file.base_filename.manifest}").result
        end
        self
      end
      def qrcode(x)
        SiSU_Screen::Ansi.new(@opt.cmd,"[#{@opt.f_pth[:lng_is]}] -#{x}","#{@prog.web_browser} file://#{@md.file.output_path.manifest.dir}/#{@md.file.base_filename.manifest}").result
      end
      def odt(x)
        SiSU_Screen::Ansi.new(@opt.cmd,"[#{@opt.f_pth[:lng_is]}] -#{x}","#{@prog.odf_viewer} file://#{@md.file.output_path.odt.dir}/#{@md.file.base_filename.odt}").result
      end
      def pdf
        def portrait(x)
          SiSU_Screen::Ansi.new(@opt.cmd,"[#{@opt.f_pth[:lng_is]}] -#{x}","#{@prog.pdf_viewer} #{@md.file.output_path.pdf.dir}/#{@md.file.base_filename.pdf_p}pdf").result
        end
        def landscape(x)
          SiSU_Screen::Ansi.new(@opt.cmd,"[#{@opt.f_pth[:lng_is]}] -#{x}","#{@prog.pdf_viewer} #{@md.file.output_path.pdf.dir}/#{@md.file.base_filename.pdf_l}pdf").result
        end
        self
      end
      def manpage(x)
        SiSU_Screen::Ansi.new(@opt.cmd,"[#{@opt.f_pth[:lng_is]}] -#{x}","#{@prog.manpage_viewer} #{@md.file.output_path.manpage.dir}/#{@md.file.base_filename.manpage}").result
      end
      def pinfo(x,y)
        SiSU_Screen::Ansi.new(@opt.cmd,"[#{@opt.f_pth[:lng_is]}] -#{x}","pinfo -f #{@md.file.output_path.texinfo.dir}/#{@md.file.base_filename.info}").result
      end
      def po4a
        def po(x,y)
          SiSU_Screen::Ansi.new(@opt.cmd,"-#{x}","#{@prog.text_editor} #{@md.file.output_path.po.dir}/#{y}").result
        end
        def pot(x,y)
          SiSU_Screen::Ansi.new(@opt.cmd,"-#{x}","#{@prog.text_editor} #{@md.file.output_path.pot.dir}/#{y}").result
        end
        self
      end
      def xhtml(x)
        SiSU_Screen::Ansi.new(@opt.cmd,"[#{@opt.f_pth[:lng_is]}] -#{x}","#{@prog.web_browser} file://#{@md.file.output_path.xhtml.dir}/#{@md.file.base_filename.xhtml}").result
      end
      def xml
        def sax(x)
          SiSU_Screen::Ansi.new(@opt.cmd,"[#{@opt.f_pth[:lng_is]}] -#{x}","#{@prog.web_browser} file://#{@md.file.output_path.xml_sax.dir}/#{@md.file.base_filename.xml_sax}").result
        end
        def dom(x)
          SiSU_Screen::Ansi.new(@opt.cmd,"[#{@opt.f_pth[:lng_is]}] -#{x}","#{@prog.web_browser} file://#{@md.file.output_path.xml_dom.dir}/#{@md.file.base_filename.xml_dom}").result
        end
        def sitemap(x) #BROKEN
          SiSU_Screen::Ansi.new(@opt.cmd,"[#{@opt.f_pth[:lng_is]}] -#{x}","#{@prog.web_browser} file://#{@md.file.output_path.sitemaps.dir}/#{@md.file.base_filename.sitemap}").result
        end
        self
      end
      def hash_digest(x)
        SiSU_Screen::Ansi.new(@opt.cmd,"[#{@opt.f_pth[:lng_is]}] -#{x}","#{@prog.web_browser} file://#{@md.file.output_path.hash_digest.dir}/#{@md.file.base_filename.hash_digest}").result
      end
      def db
        def psql(x,y)
          SiSU_Screen::Ansi.new(@opt.cmd,"[#{@opt.f_pth[:lng_is]}] -#{x} DBI psql","#{@pwd_stub}::#{@opt.fns}",y).result
        end
        def sqlite(x,y)
          SiSU_Screen::Ansi.new(@opt.cmd,"[#{@opt.f_pth[:lng_is]}] -#{x} DBI sqlite","sqlite3 #{@env.path.webserv}/#{@md.opt.f_pth[:pth_stub]}/sisu_sqlite.db").result
        end
        def sqlite_discreet(x,y)
          SiSU_Screen::Ansi.new(@opt.cmd,"[#{@opt.f_pth[:lng_is]}] -#{x}","sqlite3 #{@md.file.output_path.sqlite_discreet.dir}/#{@md.file.base_filename.sqlite_discreet}").result
        end
        self
      end
      self
    end
    def urls_maintenance(opt,x,y)
      if x=~/^([abcehHmNoptwxXy])/ \
      and opt.cmd =~/[abcehHmNoptwxXy]/ \
      and x=~/^[#{opt.cmd}]/ \
      and opt.cmd =~/[MV]/
        m=$1
        f=y
        tool=@prog.text_editor
        if x =~/^m/ \
        and @opt.cmd=~/m/ \
        and x=~/^[#{opt.cmd}]/
          SiSU_Screen::Ansi.new(@opt.cmd,"-#{x}","#{@prog.text_editor} #{@env.processing_path.dal}/#{@opt.fns}.meta").maintenance
        end
        if x=~/^([hw])/ \
        and @opt.cmd=~/[hw]/ \
        and x=~/^[#{@opt.cmd}]/ \
        and x !~/segmented/; "#{y}.html"
          SiSU_Screen::Ansi.new(@opt.cmd,"-#{x}","#{@prog.text_editor} #{@env.processing_path.tune}/#{@md.fns}.tune").maintenance
        end
        if x=~/^p/ \
        and @opt.cmd=~/p/ \
        and x=~/^[#{@opt.cmd}]/
          tool=@prog.pdf_viewer
          fns=@opt.fns.gsub(/~/,'-')
          unless @opt.cmd =~/q/
            tell=if x =~/landscape/
              SiSU_Screen::Ansi.new(@opt.cmd,"-#{x}","#{@prog.text_editor} #{@env.processing_path.tex}/#{fns}.landscape.tex")
            else SiSU_Screen::Ansi.new(@opt.cmd,"-#{x}","#{@prog.text_editor} #{@env.processing_path.tex}/#{fns}.tex")
            end
            tell.maintenance
          end
        end
        if x=~/^o/ \
        and @opt.cmd=~/o/ \
        and x=~/^[#{@opt.cmd}]/
          tool=@prog.odf_viewer
        end
        if x=~/^e/ \
        and @opt.cmd=~/e/ \
        and x=~/^[#{@opt.cmd}]/
          SiSU_Screen::Ansi.new(@opt.cmd,"-#{x}","#{@prog.text_editor} #{@env.processing_path.epub}/#{Ep[:d_oebps]}/toc.xhtml").maintenance
        end
        if x=~/^o/ \
        and @opt.cmd=~/o/ \
        and x=~/^[#{@opt.cmd}]/
          SiSU_Screen::Ansi.new(@opt.cmd,"-#{x}","#{@prog.text_editor} #{@env.processing_path.odf}/#{@opt.fns}/odt/content.xml").maintenance
        end
      end
    end
    def urls_select
      unless @opt.cmd =~/q/
        i="(output manifest) [#{@opt.f_pth[:lng_is]}] #{@md.file.output_path.manifest.dir}/#{@md.file.base_filename.manifest}"
        @opt.cmd=~/[MVvz]/ \
        ? SiSU_Screen::Ansi.new(@opt.cmd,'URLs').green_title_hi
        : SiSU_Screen::Ansi.new(@opt.cmd,'URL',i).grey_title_hi
        SiSU_Screen::Ansi.new(@opt.cmd,@opt.fns,"#{@md.file.output_path.manifest.dir}/#{@md.file.base_filename.manifest}").flow if @opt.cmd =~/[MVv]/
      end
      m=/.+\/(?:src\/)?(\S+)/im # m=/.+?\/(?:src\/)?([^\/]+)$/im # m=/.+\/(\S+)/m
      @pwd_stub="#{@env.url.output_tell}"[m,1]
      unless @opt.cmd =~/q/
        @u.each do |x,y|
          if @opt.fns =~ @m_regular
            if @opt.cmd =~/[MVv]/
              if x=~/--txt\b/ \
              and @opt.act[:txt][:set]==:on
                show.text(x)
              end
              if x=~/--xhtml\b/ \
              and @opt.act[:xhtml][:set]==:on
                show.xhtml(x)
              end
              if x=~/--psql\b/ \
              and @opt.act[:psql][:set]==:on
                show.db.psql(x,y)
              end
              if x=~/d\s+--sqlite\b|--sql\b/ \
              and @opt.act[:sqlite_discreet][:set]==:on
                show.db.sqlite_discreet(x,y)
              end
              if x=~/d\[iu\]\s+--sqlite\b/ \
              and @opt.act[:sqlite][:set]==:on
                show.db.sqlite(x,y)
              end
              if x=~/--epub\b/ \
              and @opt.act[:epub][:set]==:on
                show.epub(x)
              end
              if x=~/--html\b/ \
              and @opt.act[:html][:set]==:on
                if x =~/scroll/
                  show.html.scroll(x)
                else
                  show.html.toc(x)
                end
              end
              if x=~/--texinfo\b/ \
              and @opt.cmd =~/I/
                show.pinfo(x,y)
              end
              if x=~/--manpage\b/ \
              and @opt.act[:manpage][:set]==:on
                show.manpage(x)
              end
              if x=~/--hash-digests\b/ \
              and @opt.cmd =~/N/
                show.hash_digest(x)
              end
              if x=~/--odt\b|--odf\b/ \
              and @opt.act[:odt][:set]==:on
                show.odt(x)
              end
              if x=~/^P/ \
              and @opt.cmd =~/P/
                if @opt.fns =~/\S+?~\S{2}(?:_\S{2})?\.ss[mt]/
                  f=y.gsub(/\.pot$/,'.po')
                  show.po4a.po(x,f)
                else
                  show.po4a.pot(x,f)
                end
              end
              if x=~/--pdf\b/ \
              and @opt.act[:pdf][:set]==:on
                if x =~/portrait/
                  show.pdf.portrait(x)
                else
                  show.pdf.landscape(x)
                end
              end
              if x=~/--sisupod\b/ \
              and @opt.act[:sisupod][:set]==:on
                (@opt.fns =~/\.ssm\.sst$/) \
                ? y.gsub(/(?:\~\S{2,3})?(\.ssm.sst\.txz)$/,'.ssm.txz')
                : y.gsub(/(?:\~\S{2,3})?(\.sst\.txz)$/,'\1')
                show.source.pod(x,y)
              end
              if x=~/--source\b/ \
              and @opt.act[:share_source][:set]==:on
                show.source.src(x,y)
              end
              if x=~/--concordance\b/ \
              and @opt.act[:concordance][:set]==:on
                show.html.concordance(x)
              end
              if x=~/--xml-dom\b/ \
              and @opt.act[:xml_dom][:set]==:on
                show.xml.dom(x)
              end
              if x=~/--xml-sax\b/ \
              and @opt.act[:xml_sax][:set]==:on
                show.xml.sax(x)
              end
              if x=~/--qrcode\b/ \
              and @opt.act[:qrcode][:set]==:on
                show.qrcode(x)
              end
              if x=~/--sitemap\b/ \
              and @opt.cmd =~/Y/ #BROKEN
                show.xml.sitemap(x)
              end
              if x=~/--manifest\b/ \
              and @opt.act[:manifest][:set]==:on
                show.html.manifest(x)
              end
            end
            urls_maintenance(@opt,x,y) if @opt.cmd =~/[MV]/
          end
        end
      end
    end
    def urls_all
      i="(output manifest) [#{@opt.f_pth[:lng_is]}] #{@env.url.output_tell}/#{@fnb}/sisu_manifest.html"
      SiSU_Screen::Ansi.new(@opt.cmd,'URLs',i).grey_title_hi
      @u.each do |x,y|
        tell=case x
        when /^m/
          show.meta(x,y)
        when /^[BcdNsxXy]/
          show.generic(x,y)
        when /^[at]/
          show.text(x)
        when /^b/
          show.xhtml(x)
        when /^e/
          show.epub(x)
        when /^h/
          if x =~/scroll/
            show.html.scroll(x)
          else
            show.html.toc(x)
          end
        when /^o/
          show.odt(x)
        when /^p/
          if x =~/portrait/
            show.pdf.portrait(x)
          else
            show.pdf.landscape(x)
          end
        when /^w/
          show.html.concordance(x)
        when /^Y/
          show.xml.sitemap(x)
        when /^I/
          show.pinfo(x,y)
        when /^i/
          show.manpage(x)
        end
      end
    end
  end
end
__END__
