# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008, 2009, 2010, 2011, 2012 Ralph Amissah, All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.sisudoc.org/sisu/en/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: create sisupod filetype and copy it to output directory!

=end
module SiSU_Doc
  include SiSU_Env
  class Source
    require_relative 'sysenv'                           # sysenv.rb
    require_relative 'response'                         # response.rb
    require_relative 'particulars'                      # particulars.rb
    def initialize(opt)
      @opt=opt
      m=/.+\/(?:src\/)?(\S+)/im
      @date=SiSU_Env::InfoDate.new.dt
      @env=SiSU_Env::InfoEnv.new(@opt.fns)
      @ver=SiSU_Env::InfoVersion.instance.get_version
      @ans=SiSU_Response::Response.new
      pod_path="#{@env.processing_path.processing_sisupod(@opt)}"
      @v=(@opt.cmd =~/[VM]/) ? 'v' : ''
      @particulars=SiSU_Particulars::CombinedSingleton.instance.get_all(opt)
      @file=@particulars.file
      @local_path="#{@file.output_path.sisupod.dir}"
      @zipfile=@opt.fno.gsub(/(?:\~\S{2,3})?(\.ss[tm])$/,'\1')
      FileUtils::mkdir_p(pod_path) unless FileTest.directory?(pod_path)
      FileUtils::rm_rf("#{@env.processing_path.processing_sisupod(@opt)}/*") if FileTest.directory?("#{@env.processing_path.processing_sisupod(@opt)}")
    end
    def read
      unless @opt.cmd =~/q/
        @opt.cmd=~/[MVv]/ \
        ? SiSU_Screen::Ansi.new(@opt.cmd,'Share SiSU Document (txz)',"[#{@opt.f_pth[:lng_is]}] #{@opt.fno}").green_hi_blue
        : SiSU_Screen::Ansi.new(@opt.cmd,'Share SiSU Document (txz)',"[#{@opt.f_pth[:lng_is]}] #{@opt.fno}").green_title_hi
      end
      unless @opt.fns.empty?
        if @opt.cmd=~/[MVv]/
          SiSU_Screen::Ansi.new(@opt.cmd,'Make sisu document (txz) and place in output directory',"#{@opt.fns} -> file://#{@file.output_path.sisupod.dir}/#{@zipfile}.txz").warn if @opt.cmd =~/[MVv]/
        end
        directories
        sisupod_build
        #sisupod_tar_xz
      else
        if @opt.cmd =~/[MVv]/
          SiSU_Screen::Ansi.new(@opt.cmd,'Make (zip (txz)) of sisu work directory',"#{@env.stub_pwd}\_#{@date}.txz").warn
          SiSU_Screen::Ansi.new(@opt.cmd,'').blue_tab
        end
        ans=@ans.response?('make sisupod of entire directory?')
        if ans; sisupod_zip_directory
        end
      end
    end
    def sisupod_zip_directory
      sisupod_directory="sisupod-#{@env.stub_pwd}-#{@date}.ssp"
      unless File.symlink?('sisupod'); File.symlink(Dir.pwd,'sisupod')
      end
      re_base_dir='^sisupod/([^.][^/]*\.(ssm|ssi|sst)$|_sisu/)'
      re_files='/[a-zA-Z0-9.~_-]+\.(ssm|ssi|sst|rb|css|png|jpg|gif|yaml)$'
      re_ignore='/[.~_-][^/]+$'
      if File.symlink?('sisupod')
        info="SiSU sisupod #{@ver[:version]} directory contents #{sisupod_directory}"
        system(%{
          echo "#{info}"
          echo "#{info}" > sisu_zip.txt
          zip -qz #{sisupod_directory} sisu_zip.txt < sisu_zip.txt
          for I in `find -H sisupod -print | \
            egrep "#{re_base_dir}" | \
            egrep "#{re_files}" | \
            egrep -v "#{re_ignore}" `
          do zip #{sisupod_directory} $I
          done
        })
      else puts "the required systemlink 'sisupod' could not be created on the current directory: remove the file or directory named 'sisupod' within #{Dir.pwd}"
      end
      if @opt.cmd =~/[MVv]/
        SiSU_Screen::Ansi.new(@opt.cmd,'Share SiSU Document (tar xz)',@opt.fns).green_hi_blue
        SiSU_Screen::Ansi.new(@opt.cmd,'Zipped directory (tgz)',sisupod_directory).warn
        SiSU_Screen::Ansi.new('',sisupod_directory).blue_tab
      end
    end
    def directories
      SiSU_Env::InfoEnv.new.sisupod_v3(@opt)
    end
    def select_skin(skin='')                                                   #skin loading logic here
      load "#{SiSU_lib}/defaults.rb"
      @skin={}
      skin_path = [
        "#{@env.path.pwd}/_sisu/skin",
        "#{@env.path.home}/.sisu/skin",
        '/etc/sisu/skin',
        "#{@env.processing_path.processing_sisupod(@opt)}/external_document/skin"
      ]
      sk_doc,sk_dir="doc/#{skin}.rb","dir/skin_#{@env.stub_pwd}.rb"
      skin_path.each do |v|                                                    #document skin priority 1
        if FileTest.file?("#{v}/#{sk_doc}")
          @skin={ name_path: "#{v}/#{sk_doc}", type: :doc }
          break
        end
      end
      unless @skin.length > 0
        skin_path.each do |v|                                                  #directory skin priority 2
          if FileTest.file?("#{v}/#{sk_dir}")
            @skin={ name_path: "#{v}/#{sk_dir}", type: :dir }
            break
          end
        end
      end
      @skin
    end
    def images_extract(f,images)                                                # consider using param info
      rgx_image=/(?:^|[^_\\])\{(?:\s*|\~\^\s+)(\S+?\.(?:png|jpg|gif)\b)/m
      if f !~/^%+\s/ \
      and f =~rgx_image
        images << f.scan(rgx_image).uniq
      end
      images.flatten
    end
    def sisupod_build                                                          #see also sisupod in sysenv
      @pwd=Dir.pwd
      @rgx_rb_image=/["']\S*?([a-zA-Z0-9_-]+?\.(?:png|jpg|gif))["']/
      @rgx_image=/(?:^|[^_\\])\{\s*(\S+?\.(?:png|jpg|gif))/
      @rgx_skin=/^\s+:skin:\s+(\S+)/
      @rgx_doc_import=/^<<\s*(\S+?\.ss[ti])/
      file_array=IO.readlines(@opt.fno,'')
      skin,images,doc_import=[],[],[]
      doc_import_dir=@opt.sub_location
      file_array.each do |f|                                                   #% work area
        if f !~/^%+\s/
          skin << f.scan(@rgx_skin).uniq.flatten if f =~@rgx_skin
          f=f.gsub(/<:=(\S+?)>/,'{ c_\1.png 14x14 }image')                                                           # embedded symbol (image)
          if f !~/^%+\s/ \
          and f =~@rgx_image
            images=images_extract(f,images)
          end
          if @opt.fno =~/\.ssm$/
            doc_import << f.scan(@rgx_doc_import) if f =~@rgx_doc_import
          end
        end
      end
      if doc_import.length > 0
        doc_import=doc_import.uniq.flatten
        doc_import.each do |fn|
          file_array=IO.readlines(fn,'')
          file_array.each do |f|                                                   #% work area
            if f !~/^%+\s/ \
            and f =~@rgx_image
              images=images_extract(f,images)
            end
          end
        end
      end
      docskin=nil
      if skin \
      and skin.length > 0
        docskin=skin.pop.flatten.join
        skin_source=select_skin(docskin)
      else
        skin_source=select_skin
      end
      docskin_place="#{@env.processing_path.processing_sisupod(@opt)}/doc/_sisu/skin/#{skin_source[:type].to_s}"
      FileUtils::mkdir_p(docskin_place)
      if skin_source[:type] == :dir
        docskin_with_path="#{docskin_place}/skin_#{@env.stub_pwd}.rb"
        docskin=[docskin_with_path.gsub(/.+?\/(skin_\S+?)\.rb/,'\1')]
        docskin='skin_sisupod'
      end
      if skin_source \
      and skin_source[:name_path]
        unless skin_source[:name_path].nil? \
        or skin_source[:name_path].empty?
          if FileTest.file?(skin_source[:name_path])
            FileUtils::cp(skin_source[:name_path],"#{docskin_place}/#{docskin}.rb")
            skinfile_array=IO.readlines(skin_source[:name_path],'')
            para_images=[]
            skinfile_array.each do |f|                                           #% work area
              unless f =~/^%+ / #hmmm
                images << f.scan(@rgx_rb_image).uniq if f =~@rgx_rb_image
                #does not really discriminate, may duplicate images in sisu file, and may take images from default image pool
              end
            end
          else STDERR.puts %{\t*WARN* did not find - "#{skin_source[:name_path]}" [#{__FILE__}:#{__LINE__}]}
          end
        end
      end
      #1. mapping in doc dir?
      #2. need images used by skin, scan skin??
      if images \
      and images.length > 1
        images=images.flatten.uniq
        images.delete_if {|x| x =~/https?:\/\// }
        #images=images.sort
        path_pod="#{@env.processing_path.processing_sisupod(@opt)}"
        path_pod_conf="#{@env.processing_path.processing_sisupod(@opt)}/_sisu"
        images_path_pod="#{path_pod}/image"
        FileUtils::mkdir_p(images_path_pod)
        #unattractive hard coding ... !
        image_path='_sisu/image'
        images_pwd="#{@env.path.pwd}/#{image_path}"
        ##sequence copies base images, defaults used in all html outputs
          #image_source_base='/usr/share/sisu/image'
          #dir_pwd=Dir.pwd
          #Dir.chdir(image_source_base)
          #base_images=Dir.glob('*')
          #base_images.each do |i|
          #  FileUtils::cp_r(i,"#{images_path_pod}/#{i}")
          #end
          #Dir.chdir(dir_pwd)
        if FileTest.directory?(images_pwd)
          images=images.uniq
          images.each do |i|
            if FileTest.file?("#{images_pwd}/#{i}")
              FileUtils::cp("#{images_pwd}/#{i}","#{images_path_pod}/#{i}") if FileTest.file?("#{images_pwd}/#{i}")
            else STDERR.puts %{\t*WARN* did not find image - "#{images_pwd}/#{i}" [#{__FILE__}:#{__LINE__}]}
            end
          end
        else STDERR.puts %{\t*WARN* did not find - #{images_pwd} #{images_path_pod} [#{__FILE__}:#{__LINE__}]}
        end
      end
      if doc_import.length > 0 \
      and @opt.fno =~/\.ssm$/
        doc_import.each do |f|
          if FileTest.file?("#{@env.path.pwd}#{doc_import_dir}/#{f}")
            FileUtils::cp("#{@env.path.pwd}#{doc_import_dir}/#{f}","#{@env.processing_path.processing_sisupod(@opt)}/doc/#{@opt.lng}/#{f}")
          else STDERR.puts %{\t*WARN* did not find image - "#{@env.path.pwd}#{doc_import_dir}/#{f}" [#{__FILE__}:#{__LINE__}]}
          end
        end
      end
      x=@env.document_language_versions_found                                  #check multiple document language versions (param not used)
      if x[:f] \
      and x[:f].length > 0                                                     #store multiple document language versions, sisupod
        x[:f].each do |f|
          pth="#{@env.processing_path.processing_sisupod(@opt)}/doc/#{@opt.lng}"
          FileUtils::mkdir_p(pth) unless FileTest.directory?(pth)
          if f[:f] =~/\~(\S{2,3})\.ss[tm]$/
            lng_f=$1
            if @opt.lng == lng_f
              if @opt.fno =~/\.ssm$/
                if FileTest.file?("#{@env.path.pwd}#{doc_import_dir}/#{f[:f]}")
                  FileUtils::cp("#{@env.path.pwd}#{doc_import_dir}/#{f[:f]}",
                    "#{@env.processing_path.processing_sisupod(@opt)}/doc/#{@opt.lng}/#{f[:n]}")
                else STDERR.puts %{\t*WARN* did not find - "#{@env.path.pwd}#{doc_import_dir}/#{f[:f]}" [#{__FILE__}:#{__LINE__}]}
                end
              else
                if FileTest.file?("#{@env.path.pwd}/#{f[:f]}")
                  FileUtils::cp("#{@env.path.pwd}/#{f[:f]}",
                    "#{@env.processing_path.processing_sisupod(@opt)}/doc/#{@opt.lng}/#{f[:n]}")
                else STDERR.puts %{\t*WARN* did not find - "#{@env.path.pwd}/#{f[:f]}" [#{__FILE__}:#{__LINE__}]}
                end
              end
            end
          else
            if @opt.fno =~/\.ssm$/
              if FileTest.file?("#{@env.path.pwd}#{doc_import_dir}/#{f[:f]}")
                FileUtils::cp_r("#{@env.path.pwd}#{doc_import_dir}/#{f[:f]}",
                  "#{@env.processing_path.processing_sisupod(@opt)}/doc/#{@opt.lng}/#{f[:n]}")
              else STDERR.puts %{\t*WARN* did not find - "#{@env.path.pwd}#{doc_import_dir}/#{f[:f]}" [#{__FILE__}:#{__LINE__}]}
              end
            else
              if FileTest.file?("#{@env.path.pwd}/#{f[:f]}")
                FileUtils::cp("#{@env.path.pwd}/#{f[:f]}",
                  "#{@env.processing_path.processing_sisupod(@opt)}/doc/#{@opt.lng}/#{f[:n]}")
              else STDERR.puts %{\t*WARN* did not find - "#{@env.path.pwd}/#{f[:f]}" [#{__FILE__}:#{__LINE__}]}
              end
            end
          end
        end
      end #NB not all possibilies met, revisit, also in case of composite file may wish to add README
    end
    def sisupod_tar_xz
      FileUtils::mkdir_p(@file.output_path.sisupod.dir) unless FileTest.directory?(@file.output_path.sisupod.dir)
      tree=(@opt.cmd =~/[vVM]/ \
      && SiSU_Env::SystemCall.new.program_found?('tree')) \
      ? 'tree sisupod'
      : ''
      if FileTest.directory?(@env.processing_path.processing_sisupod(@opt))
        Dir.chdir("#{@env.processing_path.root_dir}/#{@env.processing_path.user}/pods/#{@opt.fns}")
        system(%{
          #{tree}
          tar -cJf #{@zipfile}.txz sisupod
          #echo "#{@file.place_file.sisupod.dir}"
        })
        FileUtils::mv("#{@zipfile}.txz",@file.place_file.sisupod.dir)
        FileUtils::rm_r(Dir.glob("sisupod/*"))
        Dir.chdir(@env.path.pwd)
        SiSU_Screen::Ansi.new('',"#{@opt.fns}.txz").blue_tab if @opt.cmd=~/[MVv]/
      else
        SiSU_Screen::Ansi.new('',"#{@opt.fns}.txz not built").blue_tab if @opt.cmd=~/[MVv]/
      end
    end
  end
end
__END__
question?:                   should you permit the packing of multiple documents in single .xz ?

  open @opt.fns, parse file
    extract from file content:
      images and copy each image from whatever image source to _sisu/sisupod/sisu/_sisu/image
      skin and copy active skin from whatever source to _sisu/sisupod/sisu/_sisu/skin/doc
      extract from skin images required by skin

   remove previously existing contents of _/sisu/sisupod &
   make directory structure:

v3 -->
   _sisu
     sisupod
       doc
         manifest.txt
         en/content.sst                [file content]
         fr/content.sst
         _sisu
           conf
             skin/
               doc                     [relevant skin if any other than default]
           image (ln -s ../../image)
           audio (ln -s ../../audio)
           video (ln -s ../../video)
       image                           [all images for specific document gathered here]
       audio
       video

v2 -->
   _sisu
     sisupod
       content.sst                     [file content]
       filename.sst                    [link to content.sst]
       _sisu/
         skin/
           doc                         [relevant skin if any other than default]
         image/                        [all images for specific document gathered here]

sisu
  _sisu
    sisurc.yml
    skin/
      dir/
      doc/
      misc/
      site/
      yaml/
    convert/
    standard_terms/
    image
    processing
      dal/
      tex/
      texinfo/
      tune/
    sisupod

special case

composite file (master), e.g.
SiSU.ssm
