# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997 - 2011, Ralph Amissah, All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.jus.uio.no/sisu/gpl.fsf/toc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/doc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/plain.txt>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: manpage text generation, stripped manpage output (unix,
     linefeed)

=end
module SiSU_Manpage
  require_relative 'dal'                                # dal.rb
  require_relative 'sysenv'                             # sysenv.rb
    include SiSU_Env
  include SiSU_Param
  include SiSU_Viz
  require_relative 'manpage_format'                     # manpage_format.rb
    include SiSU_Manpage_format
  require_relative 'shared_metadata'                    # shared_metadata.rb
  require_relative 'shared_txt'                         # shared_txt.rb
  pwd=Dir.pwd
  @@alt_id_count,@@alt_id_count,@@tablehead,@@number_of_cols=0,0,0,0
  @@tablefoot=''
  class Source
    def initialize(opt)
      @opt=opt
      if @opt.fns =~/(.+?)\.(?:-|ssm\.)?sst$/
        @@dostype='unix endnotes'
      else puts "#{sf} not a processed file type"
      end
    end
    def read
      begin
        @md=SiSU_Param::Parameters.new(@opt).get
        @env=SiSU_Env::Info_env.new(@opt.fns)
        path=@env.path.output_tell
        tool=(@opt.cmd =~/[MVv]/) \
        ?  "#{@env.program.text_editor} #{@md.file.output_path.manpage}/#{@md.file.base_filename.manpage}" \
        : ''
        SiSU_Screen::Ansi.new(@opt.cmd,'Manpage',tool).green_hi_blue unless @opt.cmd =~/q/
        SiSU_Screen::Ansi.new(@opt.cmd,@opt.fns,"#{@md.file.output_path.manpage}/#{@md.file.base_filename.manpage}").flow if @opt.cmd =~/[MV]/
        @dal_array=SiSU_DAL::Source.new(@opt).get # dal file drawn here
        SiSU_Manpage::Source::Scroll.new(@md,@dal_array).songsheet
        SiSU_Env::Info_skin.new(@md).select #watch
      rescue; SiSU_Errors::Info_error.new($!,$@,@opt.cmd,@opt.fns).error
      ensure
      end
    end
    private
    class Scroll <Source
      require_relative 'defaults'                       # defaults.rb
      require_relative 'shared_txt'                     # shared_txt.rb
        include SiSU_text_utils
      @@endnotes={ para: [], end: [] }
      def initialize(md,data)
        @md,@data=md,data
        @brace_url=SiSU_Viz::Skin.new.url_decoration
        @vz=SiSU_Env::Get_init.instance.skin
        @tab="\t"
        @br="\n"
        @@dostype='unix endnotes'
        @manpage={ body: [], open: [], close: [], head: [], metadata: [], tail: [], endnotes: [] }
      end
      def songsheet
        manpage=markup(@data)
        publish(manpage)
      end
      # Used for extraction of endnotes from paragraphs
      def extract_endnotes(para='')
        notes=para.scan(/(?:#{Mx[:en_a_o]}|#{Mx[:en_b_o]})([\d*+]+\s+.+?)\s*(?:#{Mx[:en_a_c]}|#{Mx[:en_b_c]})/m)
        @n=[]
        notes.flatten.each do |n| #high cost to deal with <br> appropriately within manpage, consider
          n=n.dup.to_s
          if n =~/#{Mx[:br_line]}/
            fix = n.split(/\s*#{Mx[:br_line]}+\s*/) #watch #added
            fix.each do |x|
              unless x.empty?; @n << x
              end
            end
          else                 @n << n
          end
        end
        notes=@n.flatten
        notes.each do |e|
          util=if e.to_s =~/^\[[\d*+]+\]:/; SiSU_text_utils::Wrap.new(e.to_s,78,4,1)
          else                              SiSU_text_utils::Wrap.new(e.to_s,78,0,1)
          end
          wrap=util.line_wrap
          if wrap =~ /^\s*[\d*+]+\s+.+?\s*\Z/m
            wrap.gsub!(/(^|&nbsp;|#{Mx[:nbsp]}|\s|\*)\\\*/,'\1\\\\\*') #man page requires
            wrap.gsub!(/\s\.(\S+)/,' \\.\1')
            wrap.gsub!(/^\s*([\d*+]+)\s+(.+?)\s*\Z/m, <<GSUB
.TP
.BI \\1.
\\2
GSUB
                      )
          else
            wrap.gsub!(/^\s*(.+)\Z/m, <<GSUB
\\1
GSUB
                      )
          end
          @@endnotes[:para] << wrap
          @@endnotes[:end] << wrap << "\n.br"
          @@endnotes
        end
      end
      def manpage_metadata
        @manpage[:metadata]=Metadata::Summary.new(@md).manpage.metadata
      end
      def manpage_tail
        SiSU_Env::Info_skin.new(@md).select
        vz=SiSU_Env::Get_init.instance.skin
        generator="Generated by: #{@md.sisu_version[:project]} #{@md.sisu_version[:version]} of #{@md.sisu_version[:date_stamp]} (#{@md.sisu_version[:date]})"  if @md.sisu_version[:version]
        lastdone="Last Generated on: #{Time.now}"
        rubyv="Ruby version: #{@md.ruby_version}"
        sc=if @md.sc_info
          "Source file:    #{@md.sc_filename}#{@br}Version number: #{@md.sc_number}#{@br}Version date:   #{@md.sc_date}#{@br}"
        else ''
        end
        @manpage[:tail] <<<<WOK
#{@br}
.TP
Other versions of this document:
.TP
manifest: <#{vz.url_root_http}/#{@md.fnb}/#{@md.fn[:manifest]}>
.TP
at: <#{vz.url_site}>
.TP
#{sc}
.TP
* #{generator}
.TP
* #{rubyv}
.TP
* #{lastdone}
.TP
* SiSU #{vz.url_sisu}
WOK
      end
      def manpage_structure(dob='',hname='') #% Used to extract the structure of a document
        if dob.is=='heading'
          lv=dob.ln
          n=dob.ln - 1
          n3=dob.ln + 2
        else lv=nil
        end
        wrapped=if dob.is=='para' \
        or dob.is=='heading'
          paragraph=dob.obj
          if dob.is=='para'
            if dob.indent =~/[1-9]/
              util=if dob.bullet_
                SiSU_text_utils::Wrap.new("* #{paragraph}",78,dob.indent.to_i*2)
              else SiSU_text_utils::Wrap.new(paragraph,78,dob.indent.to_i*2)
              end
            else
              util=if dob.bullet_
                SiSU_text_utils::Wrap.new("* #{paragraph}",78,0)
              else SiSU_text_utils::Wrap.new(paragraph,78,0)
              end
            end
          else util=SiSU_text_utils::Wrap.new(paragraph,78,0)
          end
          w=util.line_wrap
          w.gsub!(/^(\\\.)/,' \1')
          w
        end
        if lv
          times=wrapped.length
          times=78 if times > 78
          @manpage[:body] << case lv
          when 1;    '.SH ' << wrapped.upcase << @br << '.br'
          when 2..3; '.SH ' << wrapped.upcase << @br << '.br'
          when 4;    '.SH ' << wrapped.upcase << @br << '.br'
          when 5..6; '.SH ' << wrapped.upcase << @br
          end
        else
          @manpage[:body] << if  wrapped =~/^\.BI\s/ # main text, contents, body KEEP
            '.TP' << @br << wrapped.gsub!(/^\.BI\s/,'.B ') # sleight ... simpler output
          else
            '.br' << @br << wrapped
          end
        end
        if @@endnotes[:para] \
        and @@dostype =~/footnote/ #edit out to switch off endnotes following paragraph to which they belong
          @manpage[:body] << @br
          @@endnotes[:para].each { |e| @manpage[:body] << e << @br }
        elsif @@endnotes[:para] \
        and @@dostype =~/endnote/
          @manpage[:body] << @br*2
        end
        @@endnotes[:para]=[]
      end
      def markup(data)                                                       # Used for major markup instructions
        dir=SiSU_Env::Info_env.new(@md.fns)
        @data_mod,@endnotes,@level,@cont,@copen,@manpage_contents_close=Array.new(6){[]}
        (0..6).each { |x| @cont[x]=@level[x]=false }
        (4..6).each { |x| @manpage_contents_close[x]='' }
        manpage_tail #($1,$2)
        table_message='[table omitted, see other document formats]'
        fix=[]
        manpage_metadata
        data.each do |dob|
          if dob.is=='comment' \
          or dob.is=='heading_insert'
            dob.obj=''
          end
          dob.obj.gsub!(/.+?<-#>/,'')                                           # remove dummy headings (used by html) #check
          dob.obj.gsub!(/#{Mx[:fa_superscript_o]}(.+?)#{Mx[:fa_superscript_c]}/,'^\1^')
          dob.obj.gsub!(/#{Mx[:fa_subscript_o]}(.+?)#{Mx[:fa_subscript_c]}/,'[\1]')
          dob.obj.gsub!(/#{Mx[:fa_insert_o]}(.+?)#{Mx[:fa_insert_c]}/,'++\1++')
          dob.obj.gsub!(/#{Mx[:fa_strike_o]}(.+?)#{Mx[:fa_strike_c]}/,'--\1--')
          dob.obj.gsub!(/#{Mx[:fa_cite_o]}(.+?)#{Mx[:fa_cite_c]}/,'"\1"')
          dob.obj.gsub!(/#{Mx[:fa_monospace_o]}(.+?)#{Mx[:fa_monospace_c]}/,'\1')
          dob.obj.gsub!(/\A\s*#{Mx[:fa_italics_o]}(.+?)#{Mx[:fa_italics_c]}#{Mx[:br_line]}/m,"#{Mx[:br_line]}.I \\1#{Mx[:br_line]}")
          dob.obj.gsub!(/\s*#{Mx[:fa_italics_o]}(.+?)#{Mx[:fa_italics_c]}/m,"#{Mx[:br_line]}.I \\1#{Mx[:br_line]}")
          dob.obj.gsub!(/\A\s*#{Mx[:fa_bold_o]}(.+?)#{Mx[:fa_bold_c]}#{Mx[:br_line]}/m,"#{Mx[:br_line]}.BI \\1#{Mx[:br_line]}")
          dob.obj.gsub!(/\s*#{Mx[:fa_bold_o]}(.+?)#{Mx[:fa_bold_c]}/,"#{Mx[:br_line]}.B \\1#{Mx[:br_line]}")
          dob.obj.gsub!(/\s*#{Mx[:fa_underscore_o]}(.+?)#{Mx[:fa_underscore_c]}/,"#{Mx[:br_line]}.I \\1#{Mx[:br_line]}")
          unless dob.is=='code'
            dob.obj.gsub!(/(?:^|\s)#{Mx[:lnk_o]}(.+?)#{Mx[:lnk_c]}#{Mx[:url_o]}(\S+?)#{Mx[:url_c]}/,"\\1 #{@brace_url.txt_open}\\2#{@brace_url.txt_close}")
            dob.obj.gsub!(/(^|#{Mx[:gl_c]}|\s)#{Mx[:url_o]}(\S+?)#{Mx[:url_c]}/,"\\1#{@brace_url.txt_open}\\2#{@brace_url.txt_close}")
            @manpage[:endnotes]=extract_endnotes(dob.obj)
            dob.obj.gsub!(/#{Mx[:en_a_o]}([\d*+]+)\s*(?:.+?)#{Mx[:en_a_c]}/m,'[^\1]') # endnote marker marked up
            dob.obj.gsub!(/#{Mx[:en_b_o]}([\d*+]+)\s*(?:.+?)#{Mx[:en_b_c]}/m,'[^\1]') # endnote marker marked up
            dob.obj.gsub!(/#{Mx[:gl_o]}#amp#{Mx[:gl_c]}/,'&') ##{Mx[:gl_o]}#095#{Mx[:gl_c]}
            dob.obj.gsub!(/#{Mx[:gl_o]}#033#{Mx[:gl_c]}/,'!')
            dob.obj.gsub!(/#{Mx[:gl_o]}#035#{Mx[:gl_c]}/,'#')
            dob.obj.gsub!(/#{Mx[:gl_o]}#042#{Mx[:gl_c]}/,'*')
            dob.obj.gsub!(/#{Mx[:gl_o]}#045#{Mx[:gl_c]}/,'-')
            dob.obj.gsub!(/#{Mx[:gl_o]}#047#{Mx[:gl_c]}/,'/')
            dob.obj.gsub!(/#{Mx[:gl_o]}#095#{Mx[:gl_c]}/,'_')
            dob.obj.gsub!(/#{Mx[:gl_o]}#123#{Mx[:gl_c]}/,'{')
            dob.obj.gsub!(/#{Mx[:gl_o]}#125#{Mx[:gl_c]}/,'}')
            dob.obj.gsub!(/#{Mx[:gl_o]}#126#{Mx[:gl_c]}/,'~')
            dob.obj.gsub!(/#{Mx[:gl_o]}#169#{Mx[:gl_c]}/,'©')
          else
            dob.obj.gsub!(/(?:#{Mx[:br_line]}|#{Mx[:br_nl]})\s*/,"\n\n")                                   # watch
            #dob.obj.gsub!(/(?:#{Mx[:br_line]}|#{Mx[:br_nl]})+\s*/,"\n")                                   # watch
          end
          dob.obj.gsub!(/(^|&nbsp;|#{Mx[:nbsp]}|\s|\*)\\\*/,'\1\\\\\*') #man page requires
          dob.obj.gsub!(/┆/,'|')
          dob.obj.gsub!(/\s\.(\S+)/,' \\.\1')
          dob.obj.gsub!(/(\n\.)(\S\S\S+)/m,'\1\\.\2')
          dob.obj.gsub!(/-/,'\-') #manpages use this
          dob.obj.gsub!(/&#126;/,'~') if dob.obj #manpages use this
          if dob.is =~/block|group|verse|alt|code/
            if dob.is =='code'
              dob.obj.gsub!(/(^|[^}])_([<>])/m,'\1\2') # _> _<
              dob.obj.gsub!(/(^|[^}])_([<>])/m,'\1\2') # _<_<
              dob.obj.gsub!(/\A(.+)?\Z/m,".nf\n\n\\1\n\n.fi")
            end
          else
            dob.obj.gsub!(/(?:#{Mx[:br_line]}|#{Mx[:br_nl]})\s*/,"\n\n") #unless para =~/#{Mx[:lv_o]}\d:/                                   #watch introduces a bug
          end
          dob.obj.gsub!(/(?:#{Mx[:br_line]}|#{Mx[:br_nl]})+\s*/,"\n\n.br\n\n")                                   # watch
          blit=dob.obj.scan(/\[[^\]]+\]|[^\[]+/)
          blit_array=[]
          blit.each do |x|
            if x =~/^\[/
              x.gsub!(/\s+/,' \ ') #manpages use this
            else x
            end
            blit_array << x
          end
          dob.obj=blit_array.join
          dob.obj.gsub!(/#{Mx[:gl_o]}:name#\S+?#{Mx[:gl_c]}/mi,'') #added
          dob.obj.gsub!(/\s\\\s+(#{Mx[:br_line]}|#{Mx[:br_nl]})/,'\1') #a messy solution
          dob.obj.gsub!(/#{Mx[:br_page]}\s*|#{Mx[:br_page_new]}/,'')                                         # remove page breaks
          dob.obj.gsub!(/(^|#{Mx[:gl_c]}|\s)#{Mx[:url_o]}_(\S+?)#{Mx[:url_c]}/,'\1\2')
          dob.obj.gsub!(/<a href=".+?">(.+?)<\/a>/m,'\1')
          dob.obj.gsub!(/#{Mx[:mk_o]}name#\S+?#{Mx[:mk_c]}/,'')                                     # remove name links
          dob.obj.gsub!(/&nbsp;|#{Mx[:nbsp]}/,' ')                                          # decide on
          dob.obj.gsub!(/(?:^|[^_\\])#{Mx[:lnk_o]}\s*(\S+?\.(?:png|jpg|gif)) .+?#{Mx[:lnk_c]}#{Mx[:url_o]}\S+?#{Mx[:url_c]}/,'    [ \1 ]') #"[ #{dir.url.images_local}\/\\1 ]")
          dob.obj.gsub!(/(?:^|[^_\\])#{Mx[:lnk_o]}\s*(\S+?\.(?:png|jpg|gif)) .+?#{Mx[:lnk_c]}image/,'    [ \1 ]') #"[ #{dir.url.images_local}\/\\1 ]")
          dob.obj.gsub!(/^(?:^|[^_\\])#{Mx[:lnk_o]}\s*\S+?\.(?:png|jpg|gif)\s+.+?"(.*?)"\s*#{Mx[:lnk_c]}\S+/,'[image: "\1"]')
          wordlist=dob.obj.scan(/\S+/)
          if dob.obj !~/(^#{Rx[:meta]}|#{Mx[:br_eof]}|#{Mx[:br_endnotes]})/
            if dob.obj =~@regx #/.+?<~\d+;\w\d+;\w\d+>.*/ #watch change
              paranum=dob.obj[@regx,3]
              @p_num=SiSU_Manpage_format::Paragraph_number.new(paranum)
            end
            x=SiSU_Manpage_format::Format_text_object.new(@md,dob)
            if dob.is=='heading'
              manpage_structure(dob)
              dob.obj=case dob.ln
              when 1; x.heading_body1
              when 2; x.heading_body2
              when 3; x.heading_body3
              when 4; x.heading_body4
              when 5; x.heading_body5
              when 6; x.heading_body6
              end
            elsif dob.is=='para'
              manpage_structure(dob)
            else
              if dob.obj =~/#{table_message}/
                @manpage[:body] << dob.obj << @br
              end
            end
            if (dob.obj =~/<a name="n\d+">/ \
            and dob.obj =~/^(-\{{2}~\d+|<!e[:_]\d+!>)/) # -endnote
              dob.obj=''
            end
            if dob.obj
              dob.obj.gsub!(/\s(\[)/m,' \ \1')
              dob.obj.gsub!(/(?:#{Mx[:br_line]}|#{Mx[:br_nl]})/,"\n\n")
              dob.obj.gsub!(/#{Mx[:gl_o]}#126#{Mx[:gl_c]}/,'~')
              dob.obj.gsub!(/#{Mx[:gl_o]}#123#{Mx[:gl_c]}/,'{')
              dob.obj.gsub!(/#{Mx[:pa_o]}\S+#{Mx[:pa_c]}/,' ')
              dob.obj.gsub!(/<!.+!>/,' ')
              dob.obj.gsub!(/<:\S+>/,' ')
            end
            dob
          end
        end
        @manpage
      end
      def publish(manpage)
        divider='='
        content=[]
        date=if defined? @md.date.modified \
        and @md.date.modified
          @md.date.modified
        elsif defined? @md.date.published \
        and @md.date.published
          @md.date.published
        else SiSU_Env::Info_date.new.year #date missing decide on action
        end
        manpage_name,manpage_synopsis='',''
        manpg={}
        proj=SiSU_Env::Info_version.instance.get_version
        manpage[:open] = %{.TH "#{@md.fnb}" "#{@md.make.manpage['section']}" "#{date}" "#{proj[:version]}" "#{@md.title.main}"#{@md.make.manpage['name']}#{@md.make.manpage['synopsis']}}
        content << manpage[:open]
        content << manpage[:head]
        content << manpage[:body]
        content << @@endnotes[:end] if @@dostype =~/endnotes/
        content << manpage[:metadata]
        content << manpage[:tail]
        Output.new(@md,content).manpage
        @@endnotes={ para: [], end: [] }
      end
    end
    class Output <Source
      include SiSU_Param
      include SiSU_Env
      def initialize(md,content)
        @md,@content=md,content
      end
      def manpage                                                            #%manpage output
        SiSU_Env::SiSU_file.new(@md).mkdir
        filename_manpage=SiSU_Env::SiSU_file.new(@md).write_file.manpage
        @sisu=[]
        @content.each do |para|                                                # this is a hack
          if para.class==Array \
          and para.length > 0
            para.each do |line|
              line.gsub!(/\s+$/m,'')
              filename_manpage.puts line           #unix manpage
            end
          else filename_manpage.puts para          #unix manpage # /^([*=-]|\.){5}/
          end
        end
        filename_manpage.close
      end
    end
  end
end
__END__
