# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997 - 2011, Ralph Amissah, All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.jus.uio.no/sisu/gpl.fsf/toc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/doc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/plain.txt>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: html segment generation, processing

=end
module SiSU_HTML_seg
  require_relative 'shared_html'                        # shared_html.rb
  require_relative 'html'                               # html.rb
  require_relative 'html_promo'                         # html_promo.rb
  require_relative 'shared_metadata'                    # shared_metadata.rb
  class Seg_output
    def initialize(md,outputfile,seg,minitoc,type='')
      @md,@output_seg_file,@seg,@minitoc,@type=md,outputfile,seg,minitoc,type
      @title_banner_=SiSU_Env::Create_site.new(@md.opt.cmd).html_seg_title_banner?
      @file=SiSU_Env::SiSU_file.new(@md)
    end
    def output
      if @seg[:title] =~/\S/
        filename_seg=[]
        filename_seg << @seg[:title] << @seg[:tocband_banner]
        if @type=='endnotes'
          @seg[:headings]=[]
          format_head_seg=SiSU_HTML_Format::Head_seg.new(@md)
          if @title_banner_
            @seg[:headings] << format_head_seg.title_banner(@md.title.main,@md.title.sub,@author)
          end
          txt_obj={ txt: 'Endnotes', ocn_display: '' }
          format_seg=SiSU_HTML_Format::Format_seg.new(@md,txt_obj)
          @seg[:headings] << format_seg.title_heading1
          filename_seg << @seg[:heading_endnotes] << @minitoc << @seg[:headings] << %{\n<div class="content">\n} << @seg[:endnote_all] << '</div>' # << '</div>'
        elsif @type=='idx'
          @seg[:headings]=[]
          format_head_seg=SiSU_HTML_Format::Head_seg.new(@md)
          if @title_banner_
            @seg[:headings] << format_head_seg.title_banner(@md.title.main,@md.title.sub,@author)
          end
          txt_obj={ txt: 'Index', ocn_display: '' }
          format_seg=SiSU_HTML_Format::Format_seg.new(@md,txt_obj)
          @seg[:headings] << format_seg.title_heading1
          filename_seg << @seg[:heading_idx] << @minitoc << @seg[:headings] << %{\n<div class="content">\n} << @seg[:idx] << '</div>' # << '</div>'
        elsif @type=='metadata'
          metadata=Metadata::Summary.new(@md).xhtml_display.metadata
          @seg[:headings]=[]
          format_head_seg=SiSU_HTML_Format::Head_seg.new(@md)
          if @title_banner_
            @seg[:headings] << format_head_seg.title_banner(@md.title.main,@md.title.sub,@author)
          end
          txt_obj={ txt: 'Metadata', ocn_display: '' }
          format_seg=SiSU_HTML_Format::Format_seg.new(@md,txt_obj)
          @seg[:headings] << format_seg.title_heading1
          filename_seg << @seg[:heading_idx] << @minitoc << @seg[:headings] << %{\n<div class="content">\n} << metadata << '</div>' # << '</div>'
        else
          filename_seg << @minitoc << @seg[:headings] << @seg[:main] << "\n</div>\n"
        end
        filename_seg << @seg[:tail] << @seg[:tocband_bannerless] << @seg[:credits]
        filename_seg.flatten!.compact!
        filename_seg.each do |str|
          unless str =~/\A\s*\Z/
            str.strip!
            str.gsub!(Xx[:html_relative2],@file.path_rel_links.html_seg_2)
            str.gsub!(Xx[:html_relative1],@file.path_rel_links.html_seg_1)
            @output_seg_file << str
          end
        end
        @output_seg_file.close
      end
    end
  end
  class Seg
    require 'fileutils'
    include FileUtils
    @@seg,@@seg_subtoc,@@seg_endnotes,@@seg_ad={},{},{},{}
    @@seg_name,@@seg_name_html=[],[]
    @@seg_url=@@fn=@@get_hash_to=@@get_hash_fn=''
    @@loop_count=@@seg_total=@@tracker=0
    @@is4=@@is3=@@is2=@@is1=0
    @@heading1=@@heading2=@@heading3=@@heading4=0
    @@seg[:tocband_banner],@@seg[:tocband_bannerless],@@seg[:title],@@seg[:headings],@@seg[:main],@@seg[:idx],@@seg[:tail],@@seg[:credits],@@seg_subtoc_array,@@seg_endnotes_array,@@seg[:endnote_all]=Array.new(11){[]}
    @@seg[:heading_endnotes]=''
    @@tablehead,@@number_of_cols=0,0
    @@dp,@@segtocband=nil,nil
    @@fns_previous=''
    attr_reader :seg_name_html,:seg_name_html_tracker
    def initialize(md=nil,data='')
      @md,@data=md,data
      @vz=SiSU_Env::Get_init.instance.skin
      @seg_name_html=@@seg_name_html || nil
      @seg_name_html_tracker=@@tracker || nil
      @env=SiSU_Env::Info_env.new(@md.fns) if @md
      if @md
        @title_banner_=SiSU_Env::Create_site.new(@md.opt.cmd).html_seg_title_banner?
      end
    end
    def songsheet
      begin
        @minitoc=SiSU_HTML::Source::Toc.new(@md,@data).minitoc
        data=get_subtoc_endnotes(@data)
        data=articles(data)
        Seg.new.cleanup # (((( added ))))
        #### (((( END )))) ####
      rescue; SiSU_Errors::Info_error.new($!,$@,@md.opt.cmd,@md.fns).error
      ensure
        @@seg_name=[]
      end
    end
  protected
    def articles(data)
      track,tracking,newfile=0,0,0
      @@is4=@@is3=@@is2=@@is1=0
      printed_endnote_seg='n'
      idx_html=nil
      if @md.book_idx
        #my_make_source_file=SiSU_Env::Create_file.new(@md.fns)
        idx_html=SiSU_Particulars::Combined_singleton.instance.get_idx_html(@md.opt).html_idx
        idx_html.each {|x| @@seg[:idx] << x }
        @@seg[:heading_idx]=''
      end
      data.each do |dob|
        if (dob.is=='heading' or dob.is=='heading_insert') \
        and dob.ln==4
          @@seg_name << dob.name
          seg_name=dob.name
        end
      end
      @@seg_name_html=@@seg_name
      @@seg_total=@@seg_name.length
      testforartnum=@@seg_name_html
      SiSU_Screen::Ansi.new(@md.opt.cmd,@@seg_name.length).segmented if @md.opt.cmd =~/[MVv]/
      map_nametags=SiSU_Particulars::Combined_singleton.instance.get_map_nametags(@md).nametags_map #p map_nametags
      data.each do |dob|
        if defined? dob.obj \
        and dob.obj =~/href="#{Xx[:segment]}#+\S+?"/
          while dob.obj =~/href="#{Xx[:segment]}#+(\S+?)"/
            m=$1
            if map_nametags[m] \
            and map_nametags[m][:segname]
              dob.obj.sub!(/href="#{Xx[:segment]}#+(\S+?)"/,%{href="#{map_nametags[m][:segname]}#{Sfx[:html]}#\\1"})
            else
              p "NOT FOUND name_tags: #{m}"
              dob.obj.sub!(/href="#{Xx[:segment]}#+(\S+?)"/,%{href="#\\1"}) # not satisfactory
            end
          end
        end
        if (dob.is=='heading' or dob.is=='heading_insert') \
        and dob.ln==4
          if dob.ocn==0
            @@heading4=dob.obj
          else @@heading4=dob.obj
          end
          @@is4=newfile=1
        end
        if (dob.is=='heading' or dob.is=='heading_insert') \
        and dob.ln==3
          @@heading3=dob.obj
          @@is4,@@is3=0,1
        end
        if (dob.is=='heading' or dob.is=='heading_insert') \
        and dob.ln==2
          @@heading2=dob.obj
          @@is4,@@is3,@@is2=0,0,1
        end
        if (dob.is=='heading' or dob.is=='heading_insert') \
        and dob.ln==1
          @@heading1=dob.obj
          @@is4,@@is3,@@is2,@@is1=0,0,0,1
        end
        if (@@is1 && !@@is2 && !@@is3 && !@@is4)
          if not (dob.is=='heading' or dob.is=='heading_insert') \
          and dob.ln==1
            head1=$_ #; check
          end
        end
        if @@is4==1
          if newfile==1 \
          or dob.obj =~/^#{Mx[:br_endnotes]}|^#{Mx[:br_eof]}/
            newfile=0
            if (dob.is=='heading' or dob.is=='heading_insert') \
            and dob.ln==4
              if tracking != 0
                dirout=SiSU_Env::Info_env.new(@md.fns)
                dir_sisu=dirout.path.output
                @file=SiSU_Env::SiSU_file.new(@md)
                unless FileTest.directory?(@file.output_path.html_seg.dir)
                  mkdir_p(@file.output_path.html_seg.dir) if File.writable?("#{@file.output_path.base.dir}/.")
                end
                Seg.new(@md).tail
                segfilename="#{@file.output_path.html_seg.dir}/#{@@seg_name_html[tracking-1]}#{@md.lang_code_insert}#{Sfx[:html]}"
                output_seg_file=File.new(segfilename,'w') if @@seg_name_html[tracking-1]
                minitoc=(@env.html_minitoc?) \
                ? @minitoc \
                : ''
                if dob.is=='heading' \
                or @@seg_name_html[tracking-1] !~/endnotes|book_index|metadata/
                  Seg_output.new(@md,output_seg_file,@@seg,minitoc).output
                elsif dob.is=='heading_insert'
                  if @@seg_name_html[tracking-1]=='endnotes'
                    Seg_output.new(@md,output_seg_file,@@seg,minitoc,'endnotes').output
                  elsif @@seg_name_html[tracking-1]=='book_index'
                    Seg_output.new(@md,output_seg_file,@@seg,minitoc,'idx').output
                    @@seg[:idx]=[]
                  elsif @@seg_name_html[tracking-1]=='metadata'
                    Seg_output.new(@md,output_seg_file,@@seg,minitoc,'metadata').output
                  else puts "#{__FILE__}::#{__LINE__}"
                  end
                else puts "#{__FILE__}::#{__LINE__}"
                end
                Seg.new.reinitialise
                heading_art(dob)
                head(dob)
               #keep use for last segment, eg if metadata is last segment
               #if @@seg_name_html[tracking] =~/metadata/ # this is for metadata
               #  segfilename="#{@md.dir_out}/#{@md.fnl[:pre]}#{@@seg_name_html[tracking]}#{@md.fnl[:mid]}#{Sfx[:html]}#{@md.fnl[:post]}"
               #  output_seg_file=File.new(segfilename,'w')
               #  Seg_output.new(@md,output_seg_file,@@seg,minitoc,'metadata').output
               #  Seg.new.reinitialise
               #end
              end
              if tracking==0
                heading_art(dob)
                head(dob)
              end
            end
            tracking=tracking+1
          end
          @@get_hash_to=dob.name if (dob.is=='heading' or dob.is=='heading_insert') and dob.ln==4 and dob.name
          @@get_hash_fn=dob.name if (dob.is=='heading' or dob.is=='heading_insert') and dob.ln==4 and dob.name
          if dob.obj.class==String
            markup(dob)
          elsif dob.obj.class==Array
            dob.obj.each do |pg|
              markup(pg)
            end
          end
          if testforartnum[tracking-1] =~/endnote/
            if printed_endnote_seg=='n'
              printed_endnote_seg='y'
            end
          end
        end
      end
      data
    end
    def heading_art(dob)
      format_head_seg=SiSU_HTML_Format::Head_seg.new(@md)
      if (dob.is=='heading' or dob.is=='heading_insert') \
      and dob.ln.to_s =~/^[1-6]/
        if @@tracker < @@seg_total-1; @@seg[:dot_nav]=format_head_seg.dot_control_pre_next
        else                          @@seg[:dot_nav]=format_head_seg.dot_control_pre
        end
      end
      ads=SiSU_HTML_promo::Ad.new(@md)
      @@seg[:title]=format_head_seg.head_seg << ads.div.major
    end
    def head(dob)
      clean=/<!.*?!>|<:.*?>/
      format_head_seg=SiSU_HTML_Format::Head_seg.new(@md)
      if @@tracker < @@seg_total-1
        if @@tracker==0; @@segtocband=format_head_seg.toc_next2 #if format_head_seg.toc_next2
        else             @@segtocband=format_head_seg.toc_pre_next2 #if format_head_seg.toc_pre_next2
        end
      else @@segtocband=format_head_seg.toc_pre2 #if format_head_seg.toc_pre2
      end
      @p_num ||= ''
      if @@is1==1
        @author=%{<b>#{@md.author}</b>\n} if @md.author.to_s =~/\S/
        @@seg[:tocband_banner] << format_head_seg.navigation_band(@@segtocband,@@seg[:dot_nav])
        conditional_div_close=if @@get_hash_fn =~/metadata/ #watch
          '</div>'
        else ''
        end
        @@seg[:tocband_bannerless] << '<br />' << conditional_div_close << format_head_seg.navigation_band_bottom(@@segtocband,@@seg[:dot_nav])
        @@seg[:headings] << format_head_seg.seg_head_escript if SiSU_HTML_Format::Head_seg.method_defined? :seg_head_escript #debug PHP move up in text #bug
        if @title_banner_
          @@seg[:headings] << format_head_seg.title_banner(@md.title.main,@md.title.sub,@author).gsub(clean,'')
        end
        ocn=if @@heading1[/.+?#{Mx[:id_o]}~(\d+);(?:[oh]|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#{@dp}:#{@dp}#{Mx[:id_c]}$/]; $1 #fix
        else ''
        end
        @p_num=SiSU_HTML_Format::Paragraph_number.new(@md,ocn)
        txt_obj={ txt: @@heading1, ocn_display: @p_num.ocn_display }
        format_seg=SiSU_HTML_Format::Format_seg.new(@md,txt_obj)
        @@seg[:headings] << format_seg.title_heading1.gsub(clean,'')
        @@heading1.gsub!(/&nbsp;<a name="-[\d*+]+" href="#_[\d*+]+">&nbsp;<sup>[\d*+]+<\/sup>&nbsp;<\/a>/,'')
      end
      if @@is2==1
        heading2=@@heading2
        ocn=if heading2[/.+?#{Mx[:id_o]}~(\d+);(?:[oh]|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#{@dp}:#{@dp}#{Mx[:id_c]}$/]; $1 #fix
        else ''
        end
        @p_num=SiSU_HTML_Format::Paragraph_number.new(@md,ocn)
        txt_obj={ txt: heading2, ocn_display: @p_num.ocn_display }
        format_seg=SiSU_HTML_Format::Format_seg.new(@md,txt_obj)
        @@seg[:headings] << format_seg.title_heading2.gsub(clean,'')
        @@heading2.gsub!(/&nbsp;<a name="-[\d*+]+" href="#_[\d*+]+">&nbsp;<sup>[\d*+]+<\/sup>&nbsp;<\/a>/,'')
      end
      if @@is3==1
        heading3=@@heading3
        ocn=if heading3[/.+?#{Mx[:id_o]}~(\d+);(?:[oh]|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#{@dp}:#{@dp}#{Mx[:id_c]}$/]; $1 #fix
        else ''
        end
        @p_num=SiSU_HTML_Format::Paragraph_number.new(@md,ocn)
        txt_obj={ txt: heading3, ocn_display: @p_num.ocn_display }
        format_seg=SiSU_HTML_Format::Format_seg.new(@md,txt_obj)
        @@seg[:headings] << format_seg.title_heading3.gsub(clean,'')
        @@heading3.gsub!(/&nbsp;<a name="-[\d*+]+" href="#_[\d*+]+">&nbsp;<sup>[\d*+]+<\/sup>&nbsp;<\/a>/,'')
      end
      if @@is4==1
        heading4=@@heading4
        ocn=if heading4[/.+?#{Mx[:id_o]}~(\d+);(?:[oh]|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#{@dp}:#{@dp}#{Mx[:id_c]}$/]; $1 #fix
        else ''
        end
        @p_num=SiSU_HTML_Format::Paragraph_number.new(@md,ocn)
        txt_obj={ txt: heading4, ocn_display: @p_num.ocn_display }
        format_seg=SiSU_HTML_Format::Format_seg.new(@md,txt_obj)
        @@seg[:headings] << format_seg.title_heading4.gsub(clean,'')
      end
      @@tracker=@@tracker+1
    end
    def markup(dob)
      @debug=[]
      format_head_seg=SiSU_HTML_Format::Head_seg.new(@md)
      if dob.is !~/meta/
        if dob.is =~/(?:heading|para)/ #extend as necessary FIX
          @p_num=SiSU_HTML_Format::Paragraph_number.new(@md,dob.ocn)
        end
        sto=SiSU_HTML_Format::Format_text_object.new(@md,dob)
        dob_html=if dob.is =~/heading|para/
          dob_html=if (dob.is=='heading' \
          or dob.is=='heading_insert')
            x=if dob.ln==4
              sto.seg_heading4
            elsif dob.ln==5
              sto.seg_heading5
            elsif dob.ln==6
              sto.seg_heading6
            end
          elsif dob.is=='para'
            if dob.indent \
            and dob.indent =~/[1-9]/
              if dob.bullet_
                sto.format('li',"i#{dob.indent}")
              else sto.format('p',"i#{dob.indent}")
              end
            else
              if dob.bullet_
                sto.format('li','bullet')
              else sto.para
              end
            end
          end
        elsif dob.is=='block'
          sto.block
        elsif dob.is=='group'
          sto.group
        elsif dob.is=='alt'
          sto.alt
        elsif dob.is=='verse'
          sto.verse
        elsif dob.is=='code'
          sto.code
        elsif dob.is=='table'
          sto.table
        elsif dob.is=='break'
          sto.break
        end
        if @md.flag_separate_endnotes
          dob.obj.gsub!(/"\s+href="#_(\d+)">/,%{" href=\"endnotes#{Sfx[:html]}#_\\1">})       #endnote- twice #removed file type
        end
        if dob.obj !~/#{@vz.margin_txt_w1}|#{@vz.margin_txt_w2}/
          if dob.is =~/heading|para/ and (not dob.ocn or dob.ocn.to_s.empty?)
            format_seg=SiSU_HTML_Format::Format_seg.new(@md,dob)
          end
          dob.obj.gsub!(/\s*(-\{{2}~\d+|<:e[:_]\d+>).*/,'')                   #potentially dagerous - removes all paragraphs with <!e_!> #?? workpoint
          if dob.obj =~/<a name="_\d+" href="#-\d+">&nbsp;<sup>/                #endnote- note-
            format_seg=SiSU_HTML_Format::Format_seg.new(@md,dob)
            dob=format_seg.no_paranum
          end
        end
        if (dob.is=='heading' or dob.is=='heading_insert') \
        and dob.ln==4
          @@seg[:main] << %{\n<div class="content">\n}
          @@seg[:main] << dob_html
          @@seg[:main] << @@seg_subtoc[@@get_hash_fn]                       #% insertion of sub-toc
        else
          @@seg[:main] << dob_html #unless @@flag_alt==true
        end
      end
    end
    def tail
      format_head_seg=SiSU_HTML_Format::Head_seg.new(@md)
      if @md.flag_auto_endnotes and @@seg_endnotes[@@get_hash_fn]
        @@seg[:tail] <<  %{\n<div class="content">\n<div class="endnote">\n}
        if @@seg_endnotes[@@get_hash_fn].flatten.length > 0
          @@seg[:tail] << format_head_seg.endnote_mark
          @@seg[:tail] << @@seg_endnotes[@@get_hash_fn].flatten #endnotes deposited at end of individual segments ||@|EXTRACTION OF ENDNOTES|
        end
        @@seg[:tail] << '</div>'
        @@seg[:tail] << '</div>' #this div closes div class content
      end
      ads=SiSU_HTML_promo::Ad.new(@md)
      @@seg[:credits] << format_head_seg.credit << ads.div.close << ads.display << format_head_seg.html_close
    end
    def reinitialise
      @@seg[:title],@@seg[:dot_nav],@@seg[:tocband_banner],@@seg[:tocband_bannerless],@@seg[:headings],@@seg[:main],@@seg[:tail],@@seg[:credits]=Array.new(8){[]}
      @@segtocband=nil
    end
    def cleanup
      reinitialise
      @@seg_total,@@tracker=0,0
      @@seg_endnotes,@@seg_subtoc={},{}
      @@seg_endnotes_array,@@seg_subtoc_array=[],[]
      @@seg[:endnote_all]=[]
    end
    def get_subtoc_endnotes(data) #get endnotes & sub-table of contents subtoc
      data.each do |dob|
        dob.obj.gsub!(/<a name=\"h\d.*?\">(.+?)<\/a>/mi,'\1')
        if @md.flag_auto_endnotes
          if (dob.is=='heading' or dob.is=='heading_insert') \
          and dob.ln.to_s =~/^[1234]/ \
          and not @@fn.to_s.empty?
            @@seg_endnotes[@@fn]=[]
            @@seg_endnotes[@@fn] << @@seg_endnotes_array
            @@seg_endnotes_array=[] if dob.ln==4
            @@fns_previous=@md.fns if dob.ln==4 and dob.name =~/^meta/
          end
          if (dob.is=='heading' or dob.is=='heading_insert') \
          and dob.ln==4                                              #%  EXTRACTION OF SUB-TOCs & SEGMENT NAME, after EXTRACTION OF ENDNOTES & SUB-TOCs
            @@seg_subtoc[@@fn]=@@seg_subtoc_array
            @@seg_subtoc_array=[]
            if dob.name \
            and dob.obj
              @@fn=dob.name
            else
              if dob.name =~/\S+/
                @@fn=dob.name
              else @@fn=''
              end
            end
          end
        end
        if dob.is=='heading' \
        and dob.ln.to_s =~/^[56]/
          case dob.ln
          when 5
            txt_obj={ txt: dob.obj.strip, ocn: dob.ocn }
            format_seg=SiSU_HTML_Format::Format_seg.new(@md,txt_obj)
            subtoc=format_seg.subtoc_lev5 #keep and make available, this is the subtoc
          when 6
            txt_obj={ txt: dob.obj.strip, ocn: dob.ocn }
            format_seg=SiSU_HTML_Format::Format_seg.new(@md,txt_obj)
            subtoc=format_seg.subtoc_lev6 #keep and make available, this is the subtoc
          end
          @@seg_subtoc_array << subtoc
        end
        if @md.flag_auto_endnotes
          if dob.obj =~/(?:#{Mx[:en_a_o]}|#{Mx[:en_b_o]})[\d*+]+ <a name="_[\d*+]+"/ \
          and dob.is !~/^code/ # endnote-
            endnote_array=[]
            if dob.obj=~/#{Mx[:en_a_o]}.+?#{Mx[:en_a_c]}/m
              endnote_array << dob.obj.scan(/#{Mx[:en_a_o]}.+?#{Mx[:en_a_c]}/m)
            end
            if dob.obj=~/#{Mx[:en_b_o]}[*]\d+\s.+?#{Mx[:en_b_c]}/m
              endnote_array << dob.obj.scan(/#{Mx[:en_b_o]}[*]\d+\s.+?#{Mx[:en_b_c]}/m)
            end
            if dob.obj=~/#{Mx[:en_b_o]}[+]\d+\s.+?#{Mx[:en_b_c]}/m
              endnote_array << dob.obj.scan(/#{Mx[:en_b_o]}[+]\d+\s.+?#{Mx[:en_b_c]}/m)
            end
            endnote_array.flatten!.compact! #check compacting
            endnote_array.each do |note|
              note_match=note.dup
              note_match_seg=note.dup
              e_n=note_match_seg[/(?:#{Mx[:en_a_o]}[\d*+]+|#{Mx[:en_b_o]}[*+]\d+)\s+(.+?)(?:#{Mx[:en_a_c]}|#{Mx[:en_b_c]})/m,1]
              try=e_n.split(/<br \/>/)
              try.each do |e|
                txt_obj={ txt: e }
                format_seg=SiSU_HTML_Format::Format_seg.new(@md,txt_obj)
                note_match=if e =~/#{Mx[:pa_o]}i[1-9]#{Mx[:pa_c]}/
                  format_seg.endnote_body_indent
                else format_seg.endnote_body
                end
                @@seg_endnotes_array << note_match
              end
              try.join('<br \/>')
              #% creation of separate end segment/page of all endnotes referenced back to reference segment
              m=/(?:#{Mx[:en_a_o]}[\d*+]+|#{Mx[:en_b_o]}[*+]\d+)\s+(.+?href=")(#-[\d*+]+".+)(?:#{Mx[:en_a_c]}|#{Mx[:en_b_c]})/mi
              endnote_part_a=note_match_seg[m,1]
              endnote_part_b=note_match_seg[m,2]
              txt_obj={ endnote_part_a: endnote_part_a, endnote_part_b: endnote_part_b }
              format_seg=SiSU_HTML_Format::Format_seg.new(@md,txt_obj)
              note_match_all_seg=format_seg.endnote_seg_body(@@fn) #BUG WATCH 200408
              @@seg[:endnote_all] << note_match_all_seg
            end
            dob.obj.gsub!(/(?:#{Mx[:en_a_o]}.+?#{Mx[:en_a_c]}|#{Mx[:en_b_o]}.+?#{Mx[:en_b_c]})\s*/m,' ')
          end
        end
      end
    end
  end
end
__END__
