# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997 - 2011, Ralph Amissah, All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.jus.uio.no/sisu/gpl.fsf/toc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/doc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/plain.txt>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: epub generation, processing

=end
module SiSU_EPUB
  require 'pstore'
  require_relative 'particulars'                        # particulars.rb
    include SiSU_Particulars
  require_relative 'defaults'                           # defaults.rb
    include SiSU_Viz
  require_relative 'xhtml_table'                        # xhtml_table.rb
  require_relative 'epub_format'                        # epub_format.rb
    include SiSU_EPUB_Format
  require_relative 'epub_segments'                      # epub_segments.rb
    include SiSU_EPUB_seg
  require_relative 'epub_tune'                          # epub_tune.rb
    include SiSU_EPUB_Tune
  require_relative 'epub_concordance'                   # epub_concordance.rb
  class Source
    def initialize(opt)
      @opt=opt
      @particulars=SiSU_Particulars::Combined_singleton.instance.get_all(opt)
    end
    def read
      songsheet
    end
    def songsheet
      begin
        @md=@particulars.md
        @fnb=@md.fnb
        @env=@particulars.env
        loc=@env.path.url.output_tell
        unless @opt.cmd =~/q/
          tool=if @opt.cmd =~/[MVvz]/; "#{@env.program.epub_viewer} #{@md.file.output_path.epub.dir}/#{@md.file.base_filename.epub}"
          else                      @opt.fns
          end
          @opt.cmd=~/[MVvz]/ \
          ? SiSU_Screen::Ansi.new(@opt.cmd,'EPUB',tool).green_hi_blue \
          : SiSU_Screen::Ansi.new(@opt.cmd,'EPUB',tool).green_title_hi
          SiSU_Screen::Ansi.new(@opt.cmd,@opt.fns,"#{@md.file.output_path.epub.dir}/#{@md.file.base_filename.epub}").flow if @opt.cmd =~/[MV]/
        end
        @env.processing_path.epub_bld #(@md)
        @env.processing_path.epub_cp_images(@md)
        dir_epub=@env.processing_path.epub
        SiSU_Env::Info_skin.new(@md).select
        data=nil
        SiSU_Env::SiSU_file.new(@md).mkdir.output.epub
        @tuned_file_array=SiSU_EPUB::Source::XHtml_environment.new(@particulars).tuned_file_instructions
        data=@tuned_file_array
        scr_endnotes=SiSU_EPUB::Source::Endnotes.new(@md,data).scroll
        toc=SiSU_EPUB::Source::Toc.new(@md,data).songsheet
        data=@tuned_file_array
        scr_toc=SiSU_EPUB::Source::Scroll_head_and_segtoc.new(@md,toc).in_common #watch
        SiSU_EPUB::Source::Seg.new(@md,data).songsheet
        SiSU_EPUB::Source::Epub_output.new(@md).songsheet
      rescue; SiSU_Errors::Info_error.new($!,$@,@opt.cmd,@opt.fns).error
      ensure
        unless @opt.cmd =~/[MV]/ #check maintenance flag
          texfiles=Dir["#{@env.processing_path.tune}/#{@opt.fns}*"]
          texfiles.each do |f|
            if FileTest.file?(f)
              File.unlink(f)
            end
          end
        end
        SiSU_Env::Clear.new(@opt.cmd,@opt.fns).param_instantiate
        @@flag,@@scr,@@seg,@@seg_endnotes,@@seg_subtoc,@@seg_ad={},{},{},{},{},{}
        @@seg_total,@@tracker,@@loop_count,@@tablehead,@@number_of_cols=0,0,0,0,0
        @@seg_name,@@seg_name_html,@@seg_subtoc_array,@@seg_endnotes_array,@@segtocband,@@tablefoot=Array.new(7){[]}
        @@filename_seg,@@seg_url,@@fn,@@to_lev4,@@get_hash_to,@@get_hash_fn='','','','','','',''
        @@is4=@@is3=@@is2=@@is1=@@heading1=@@heading2=@@heading3=@@heading4=0
      end
    end
    private
    class XHtml_environment
      def initialize(particulars)
        @particulars=particulars
        @md,@env=particulars.md,particulars.env
        @vz=SiSU_Env::Get_init.instance.skin
        @env,@css,@symlnk=particulars.env,SiSU_Style::CSS.new,SiSU_Env::Create_system_link.new #home
      end
      def link_images
        @symlnk.images
      end
      def directories
        title=File.basename(@md.fns,'.rb')
        SiSU_Env::SiSU_file.new(@md).mkdir.output.epub
      end
      def tuned_file_instructions
        @tell=SiSU_Screen::Ansi.new(@md.opt.cmd)
        @md.opt.cmd=@md.opt.cmd.gsub(/H/,'h')
        @md.file_type='html' if @md.opt.cmd =~/[hon]/
        directories
        dal_array=@particulars.dal_array # dal file drawn here
        @tuned_file_array=SiSU_EPUB_Tune::Tune.new(dal_array,@md).songsheet
        @tuned_file_array
      end
    end
    class Endnotes
      include SiSU_EPUB_Format
      def initialize(md,data)
        @md,@data=md,data
      end
      def scroll
        @scr_endnotes=[]
        format_head_scroll=SiSU_EPUB_Format::Head_scroll.new(@md)
        @data.each do |dob|
          pg=dob.dup
          unless pg.is =~/^code/
            if pg.obj =~/(?:#{Mx[:en_a_o]}|#{Mx[:en_b_o]})[\d*+]+ /
              endnote_array=[]
              if pg.obj=~/#{Mx[:en_a_o]}[\d*+].+?#{Mx[:en_a_c]}/m
                endnote_array = pg.obj.scan(/#{Mx[:en_a_o]}[\d*+]+(.+?)#{Mx[:en_a_c]}/m)
              end
              if pg.obj=~/#{Mx[:en_b_o]}[\d*]+\s.+?#{Mx[:en_b_c]}/m
                endnote_array = pg.obj.scan(/#{Mx[:en_b_o]}[\d*]+(.+?)#{Mx[:en_b_c]}/m)
              end
              if pg.obj=~/#{Mx[:en_b_o]}[\d+]+\s.+?#{Mx[:en_b_c]}/m
                endnote_array = pg.obj.scan(/#{Mx[:en_b_o]}[\d+]+(.+?)#{Mx[:en_b_c]}/m)
              end
              endnote_array.flatten.each do |note|
                txt_obj={ txt: note }
                format_scroll=SiSU_EPUB_Format::Format_scroll.new(@md,txt_obj)
                @scr_endnotes << format_scroll.endnote_body
              end
            end
          end
        end
        @scr_endnotes
      end
    end
    class Toc
      @@toc={ seg: [], seg_mini: [], scr: [], ncx: [], opf: [] }
      @@seg_url=''
      @@firstseg=nil
      def initialize(md=nil,data='')
        @md,@data=md,data
        @vz=SiSU_Env::Get_init.instance.skin
        @epub=SiSU_EPUB_Format::Head_information.new(@md)
        @tell=SiSU_Screen::Ansi.new(@md.opt.cmd) if @md
      end
      def songsheet #extracts toc for scroll & seg
        SiSU_Screen::Ansi.new(@md.opt.cmd,'Toc').txt_grey if @md.opt.cmd =~/[MVv]/
        toc=nil
        @@firstseg=nil
        @@toc={ seg: [], seg_mini: [], scr: [], ncx: [], opf: [] }
        md_opf_a_content,md_opf_a_spine=[],[]
        @nav_no=1
        @@toc[:ncx] << @epub.toc_ncx.open #epub ncx navmap
        @@toc[:ncx] << @epub.toc_ncx.head_open << @epub.toc_ncx.head << @epub.toc_ncx.head_close
        @@toc[:ncx] << @epub.toc_ncx.doc_title << @epub.toc_ncx.doc_author
        @@toc[:ncx] << @epub.toc_ncx.navmap_open
        @@toc[:opf] << @epub.metadata_opf.package_open
        @@toc[:opf] << @epub.metadata_opf.metadata
        @@toc[:opf] << @epub.metadata_opf.manifest_open
        @@toc[:ncx] << @epub.toc_ncx.navmap_sisu_toc(@nav_no) #epub ncx navmap, toc
        @@toc[:seg] << %{<div class="content">\n<div class="substance">}
        @@toc[:scr] << %{<div class="content">\n<div class="substance">}
        md_opf_a_content << @epub.metadata_opf.manifest_content_sisu_toc
        md_opf_a_spine << @epub.metadata_opf.spine_sisu_toc
        @ncxo=[nil,false,false,false,false,false,false]
        @dob_toc2,@dob_toc3=nil,nil
        @ncx_cls=[]
        @data.each do |dob|
          if dob.is=='heading' \
          or dob.is=='heading_insert'
            dob_toc=dob.dup
            toc=case dob_toc.ln
            when 1
              Toc.new(@md,dob_toc).level_1
            when 2
              @nav_no+=1
              @nav_no2=@nav_no
              @ncx_cls << @epub.toc_ncx.navpoint_close if @ncxo[4]
              @ncx_cls << @epub.toc_ncx.navpoint_close if @ncxo[3]
              @ncx_cls << @epub.toc_ncx.navpoint_close if @ncxo[2]
              @ncxo[2],@ncxo[3],@ncxo[4]=false,false,false
              @dob_toc2=dob_toc
              @ncxo[2]=true
              Toc.new(@md,dob_toc).level_2
            when 3
              @nav_no+=1
              @nav_no3=@nav_no
              @ncx_cls << @epub.toc_ncx.navpoint_close if @ncxo[4]
              @ncx_cls << @epub.toc_ncx.navpoint_close if @ncxo[3]
              @ncxo[3],@ncxo[4]=false,false
              @dob_toc3=dob_toc
              @ncxo[3]=true
              Toc.new(@md,dob_toc).level_3
            when 4
              @@toc[:ncx] << @ncx_cls if @ncx_cls.length > 0
              @ncx_cls=[]
              @@toc[:ncx] << @epub.toc_ncx.navpoint_top3(@dob_toc2,@nav_no2,dob_toc.name) if @dob_toc2 #epub ncx navmap
              @@toc[:ncx] << @epub.toc_ncx.navpoint_top3(@dob_toc3,@nav_no3,dob_toc.name) if @dob_toc3 #epub ncx navmap
              @dob_toc2,@dob_toc3=nil,nil
              @nav_no+=1
              @@toc[:ncx] << @epub.toc_ncx.navpoint_close if @ncxo[4]
              @ncxo[4]=false
              @@toc[:ncx] << @epub.toc_ncx.navpoint(dob_toc,@nav_no) if dob_toc #epub ncx navmap
              @ncxo[4]=true
              md_opf_a_content << @epub.metadata_opf.manifest_content(dob_toc)
              md_opf_a_spine << @epub.metadata_opf.spine(dob_toc)
              Toc.new(@md,dob_toc).level_4
            when 5; Toc.new(@md,dob_toc).level_5
            when 6; Toc.new(@md,dob_toc).level_6
            else nil
            end
            toc.each do |k,d|
              d.gsub!(/(?:#{Mx[:en_a_o]}.+?#{Mx[:en_a_c]}|#{Mx[:en_b_o]}.+?#{Mx[:en_b_c]})\s*/m,' ')
            end if toc
            if @@firstseg.nil? \
            and dob.ln==4 \
            and dob.name =~/\S+/
              @@firstseg=dob.name
            end
            if toc
              begin
                @@toc[:seg] << toc[:seg]
                @@toc[:scr] << toc[:seg]
                @@toc[:seg_mini] << toc[:seg_mini] if toc[:seg_mini]
              rescue; SiSU_Errors::Info_error.new($!,$@,@md.opt.cmd,@md.fns).error
              end
            end
          end
        end
        @@toc[:ncx] << @epub.toc_ncx.navpoint_close if @ncxo[4]
        @@toc[:ncx] << @epub.toc_ncx.navpoint_close if @ncxo[3]
        @@toc[:ncx] << @epub.toc_ncx.navpoint_close if @ncxo[2]
        @ncxo[1],@ncxo[2],@ncxo[3],@ncxo[4]=false,false,false,false
        md_opf_a_content << @epub.metadata_opf.manifest_images(@md.ec[:image])
        @@toc[:seg] << "</div>\n</div>"
        @@toc[:scr] << "</div>\n</div>"
        @@toc[:ncx] << @epub.toc_ncx.navmap_close
        @@toc[:ncx] << @epub.toc_ncx.close
        @@toc[:opf] << md_opf_a_content << @epub.metadata_opf.manifest_close
        @@toc[:opf] << @epub.metadata_opf.spine_open << md_opf_a_spine << @epub.metadata_opf.spine_close
        @@toc[:opf] << @epub.metadata_opf.package_close
        @@toc[:opf]=@@toc[:opf].flatten
        Epub_output.new(@md,@@toc[:opf]).epub_metadata_opf
        Epub_output.new(@md,@@toc[:ncx]).epub_toc_ncx
        @md.firstseg=@@firstseg
        @@toc
      end
      def minitoc
        minitoc=@@toc[:seg_mini].join("\n")
        '<div class="toc">' + minitoc + '</div>'
      end
    protected
      def level_1
        dob=@data
        linkname,link=dob.obj.strip,dob.ocn
        if link \
        and link !~/#/ #% keep eye on link
          p_num=SiSU_EPUB_Format::Paragraph_number.new(@md,link)
        end
        title=if dob.obj !~/Document Information/; linkname
        else
          link='metadata'
          %{<b><a href="#{link}#{@md.lang_code_insert}#{Sfx[:epub_xhtml]}">#{linkname}</a></b>}
        end
        toc={}
        txt_obj={ txt: title }
        format_toc=SiSU_EPUB_Format::Format_toc.new(@md,txt_obj)
        toc[:seg]=if dob.name =~/^meta/ \
        and dob.obj =~/Document Information/ #check
          format_toc.lev0
        else format_toc.lev1
        end
        toc[:seg_mini]=if dob.name =~/^meta/ \
        and dob.obj =~/Document Information/ #check
          x=if @md.concord_make
            format_toc.mini_concord_tail
          else format_toc.mini_tail
          end
        else format_toc.mini_lev1
        end
        title=if dob.ocn ==0
          if dob.name =~/^meta/ \
          and dob.obj =~/Document Information/
            %{<a href="#docinfo">#{linkname}</a>}
          else linkname
          end
        else
          @@toc[:scr] <<  '<br />'
          link=if dob.ln; dob.ln
          else ''
          end
          %{<b><a href="##{link}">#{linkname}</a></b>}
        end
        txt_obj={ txt: title }
        format_toc=SiSU_EPUB_Format::Format_toc.new(@md,txt_obj)
        toc[:scr]=if dob.name =~/^meta/ \
        and dob.obj =~/Document Information/
          format_toc.lev0
        else format_toc.lev1
        end
        toc
      end
      def level_2
        dob=@data
        linkname,ocn=dob.obj.strip,dob.ocn
        if ocn \
        and ocn !~/#/
          p_num=SiSU_EPUB_Format::Paragraph_number.new(@md,ocn)
        end
        txt_obj={ txt: linkname }
        format_toc=SiSU_EPUB_Format::Format_toc.new(@md,txt_obj)
        toc={}
        toc[:seg]=format_toc.lev2
        toc[:seg_mini]=format_toc.mini_lev2
        if p_num
          title=%{#{p_num.goto}#{linkname}</a>}
          txt_obj={ txt: title }
          format_toc=SiSU_EPUB_Format::Format_toc.new(@md,txt_obj)
          toc[:scr]=format_toc.lev2
        end
        toc
      end
      def level_3
        dob=@data
        linkname,ocn=dob.obj.strip,dob.ocn
        if ocn \
        and ocn !~/#/
          p_num=SiSU_EPUB_Format::Paragraph_number.new(@md,ocn)
        end
        txt_obj={ txt: linkname }
        format_toc=SiSU_EPUB_Format::Format_toc.new(@md,txt_obj)
        toc={}
        toc[:seg]=format_toc.lev3
        toc[:seg_mini]=format_toc.mini_lev3
        if p_num
          title=%{#{p_num.goto}#{linkname}</a>}
          txt_obj={ txt: title }
          format_toc=SiSU_EPUB_Format::Format_toc.new(@md,txt_obj)
          toc[:scr]=format_toc.lev3
        end
        toc
      end
      def level_4
        dob=@data
        linkname,ocn=dob.obj.strip,dob.ocn
        p_num=SiSU_EPUB_Format::Paragraph_number.new(@md,ocn) if ocn
        if dob.ln==4
          seg_link=%{  <a href="#{dob.name}#{@md.lang_code_insert}#{Sfx[:epub_xhtml]}">
    #{dob.obj}
  </a> }
          @@seg_url=dob.name
        elsif dob.obj =~/\d+.\d+.\d+.\d+|\d+.\d+.\d+|\d+.\d+|\d+/
          seg_link=dob.obj.gsub(/^(\d+.\d+.\d+.\d+|\d+.\d+.\d+|\d+.\d+|\d+)(.*)/,
            %{<a href="\\1#{@md.lang_code_insert}#{Sfx[:epub_xhtml]}">} +
            %{\\1 \\2</a> })
        end
        p_num=SiSU_EPUB_Format::Paragraph_number.new(@md,ocn) if ocn
        txt_obj={ txt: seg_link }
        format_toc=SiSU_EPUB_Format::Format_toc.new(@md,txt_obj)
        toc={}
        toc[:seg]=format_toc.lev4
        toc[:seg_mini]=format_toc.mini_lev4
        title=%{#{p_num.goto}#{linkname}</a>} if p_num
        txt_obj={ txt: title }
        format_toc=SiSU_EPUB_Format::Format_toc.new(@md,txt_obj)
        toc[:scr]=format_toc.lev4
        toc
      end
      def level_5
        dob=@data
        linkname,ocn=dob.obj.strip,dob.ocn
        toc={}
        if ocn \
        and ocn !~/#/
          p_num=SiSU_EPUB_Format::Paragraph_number.new(@md,ocn)
          lnk_n_txt=%{  <a href="#{@@seg_url}#{@md.lang_code_insert}#{Sfx[:epub_xhtml]}#o#{ocn}">
    #{linkname}
  </a>}
          txt_obj={ txt: lnk_n_txt }
          format_toc=SiSU_EPUB_Format::Format_toc.new(@md,txt_obj)
          toc[:seg]=format_toc.lev5
          toc[:seg_mini]=format_toc.mini_lev5
          title=%{#{p_num.goto}#{linkname}</a>}
          txt_obj={ txt: title }
          format_toc=SiSU_EPUB_Format::Format_toc.new(@md,txt_obj)
          toc[:scr]=format_toc.lev5
        end
        toc
      end
      def level_6
        dob=@data
        linkname,ocn=dob.obj.strip,dob.ocn
        toc={}
        if ocn \
        and ocn !~/#/
          p_num=SiSU_EPUB_Format::Paragraph_number.new(@md,ocn)
          lnk_n_txt=%{  <a href="#{@@seg_url}#{@md.lang_code_insert}#{Sfx[:epub_xhtml]}#o#{ocn}">
  #{linkname}
</a>}
          txt_obj={ txt: lnk_n_txt }
          format_toc=SiSU_EPUB_Format::Format_toc.new(@md,txt_obj)
          toc[:seg]=format_toc.lev6
          toc[:seg_mini]=format_toc.mini_lev6
          title=%{#{p_num.goto}#{linkname}</a>}
          txt_obj={ txt: title }
          format_toc=SiSU_EPUB_Format::Format_toc.new(@md,txt_obj)
          toc[:scr]=format_toc.lev6
        end
        toc
      end
      def level_crosslink
        dob=@data
        if dob !~/^4~!/
          dob.gsub!(/^4~!\s+(\S+)\s+(.+)/,
            %{<table><tr><td width =\"80\"></td>
  <td><a href="http://\\1">
    #{@png.crosslink_ext}
      &nbsp;&nbsp;\\2
    <\/a>
  </td></tr></table>
})
        else
          dob.gsub!(/^4~!\s+(\S+)\s+(.+)/,
            %{<table><tr><td width ="80">
  </td><td>
    <a href="\\1">
      #{@png.crosslink}
        &nbsp;&nbsp;\\2
    <\/a>
  </td></tr></table>
})
        end
      end
    end
    class Scroll_head_and_segtoc < Toc
      def initialize(md='',toc='',links_guide_toc='')
        @md,@toc,@links_guide_toc=md,toc,links_guide_toc
        @vz=SiSU_Env::Get_init.instance.skin
      end
      def in_common
        toc_shared=[]
        segtoc=[]
        SiSU_Screen::Ansi.new(@md.opt.cmd,'Scroll & Segtoc').txt_grey if @md.opt.cmd =~/[MVv]/
        format_head_toc=SiSU_EPUB_Format::Head_toc.new(@md)
        dochead=format_head_toc.head
        dochead.gsub!(/toc\.(html)/,'doc.\1') #kludge
        toc_shared << dochead #<< ads.div.major
        segtoc << format_head_toc.head #<< ads.div.major
        toc_shared << format_head_toc.toc_head_escript if SiSU_EPUB_Format::Head_toc.method_defined? :toc_head_escript
        segtoc << format_head_toc.toc_head_escript if SiSU_EPUB_Format::Head_toc.method_defined? :toc_head_escript
        if defined? @md.rights.all \
        and @md.rights.all
          rights=format_head_toc.rights.all
          rights=SiSU_EPUB_Tune::Clean_xhtml.new(rights).clean
        end
        if defined? @md.notes.prefix_b \
        and @md.notes.prefix_b
          prefix_b=format_head_toc.prefix_b
          prefix_b=SiSU_EPUB_Tune::Clean_xhtml.new(prefix_b).clean
        end
        seg_toc_band=format_head_toc.seg_head_navigation_band
        seg_toc_band_bottom=format_head_toc.seg_head_navigation_band_bottom
        tmp_head=nil
        doc_title_endnote=@md.title.full.gsub(/(\*+)/,'<sup><a href="#endnotes">\1</a></sup>')
        tmp_head=doc_title_endnote + "\n"
        txt_obj={ txt: tmp_head }
        format_txt_obj=SiSU_EPUB_Format::Format_text_object.new(@md,txt_obj)
        toc_shared << format_txt_obj.center_bold
        segtoc << format_txt_obj.center_bold
        if defined? @md.creator.author \
        and @md.creator.author
          creator_endnote=@md.creator.author.gsub(/(\*+)/,%{&nbsp;<sup><a href="#notes">\\1</a></sup>})
          tmp_head=creator_endnote + "\n"
          txt_obj={ txt: tmp_head }
          format_txt_obj=SiSU_EPUB_Format::Format_text_object.new(@md,txt_obj)
          toc_shared << format_txt_obj.center_bold
          segtoc << format_txt_obj.center_bold
        end
        segtoc << seg_toc_band
        tmp_head=nil
        if defined? @md.prefix_a \
        and @md.prefix_a
          tmp_head ||= %{#{@md.prefix_a}\n}
          toc_shared << tmp_head.dup
          segtoc << tmp_head.dup
        end
        tmp_head=nil
        toc_shared << @links_guide_toc
        if defined? @md.rights.all \
        and @md.rights.all
          toc_shared << rights
        end
        if defined? @md.prefix_b \
        and @md.prefix_b
          toc_shared << prefix_b
        end
        #Table of Contents added/appended here
        toc_shared << @toc[:scr]
        segtoc << @links_guide_toc
        segtoc << @toc[:seg]
        if defined? @md.rights.all \
        and @md.rights.all
          segtoc << rights
        end
        if defined? @md.prefix_b \
        and @md.prefix_b
          segtoc << prefix_b
        end
        #Segtoc tail added here
        segtoc << seg_toc_band_bottom
        segtoc << format_head_toc.xhtml_close
        segtoc.flatten!.compact!
        Epub_output.new(@md,segtoc).segtoc
        segtoc=[]
        @toc[:scr],@toc[:seg]=[],[]
        toc_shared
      end
    end
    class Table < SiSU_XHTML_table::Table_xhtml
    end
    class Seg < SiSU_EPUB_seg::Seg
    end
    class Epub_output
      require 'fileutils'
        include FileUtils #::Verbose
      def initialize(md,output='')
        @md,@output=md,output
        @epub_doc="#{@md.fnb}.epub"
        @epub_header=SiSU_EPUB_Format::Head_information.new(@md)
        @make=SiSU_Env::Create_file.new(@md.fns)
      end
      def songsheet
        mimetype
        metainf_container
        css
        images if @md.ec[:image]
       #concordance #uncomment to enable inclusion of concordance file
        output_zip
      end
      def mimetype
        out=@make.epub.mimetype
        out<<@epub_header.mimetype
        out.close
      end
      def metainf_container #container.xml file in META-INF directory
        out=@make.epub.metainf_cont
        out<<@epub_header.metainf_container
        out.close
      end
      def css
        out=@make.epub.xhtml_css
        out << SiSU_EPUB_Format::Css.new.css_epub_xhtml
        out.close
      end
      def epub_toc_ncx
        begin
          out=@make.epub.toc_ncx
          @output.each do |para|
            unless para =~/\A\s*\Z/
              out.puts para
            end
          end
          out.close
        rescue; SiSU_Errors::Info_error.new($!,$@,@md.opt.cmd,@md.fns).error
        end
      end
      def epub_metadata_opf
        begin
          out=@make.epub.metadata
          @output.each do |para|
            unless para =~/\A\s*\Z/
              out.puts para
            end
          end
          out.close
        rescue; SiSU_Errors::Info_error.new($!,$@,@md.opt.cmd,@md.fns).error
        end
      end
      def images
        img_pth=@md.env.path.image_source_include
        @md.ec[:image].each do |x|
          if FileTest.directory?("#{@md.env.processing_path.epub}/OPS/image") \
          and FileTest.file?("#{img_pth}/#{x}")
            cp("#{img_pth}/#{x}","#{@md.env.processing_path.epub}/OPS/image")
          end
        end
      end
      def concordance
        SiSU_EPUB_Concordance::Source.new(@md.opt).read
      end
      def output_zip
        mkdir_p(@md.file.output_path.epub.dir) unless FileTest.directory?(@md.file.output_path.epub.dir)
        system("
          cd #{@md.env.processing_path.epub}
          zip -qXr9D #{@epub_doc} *
          mv #{@epub_doc} #{@md.file.place_file.epub.dir}
          cd #{Dir.pwd}
        ")
        unless @md.opt.cmd.inspect =~/M/
          system("rm -r #{@md.env.processing_path.epub}")
        end
      end
      def segtoc
        begin
          filename_html_segtoc=@make.epub.xhtml_segtoc
          filename_html_index=@make.epub.xhtml_index
          @output.each do |para|
            para.strip!
            unless para =~/\A\s*\Z/
              filename_html_segtoc.puts para,"\n"
              filename_html_index.puts para,"\n"
            end
          end
          filename_html_segtoc.close
          filename_html_index.close
        rescue; SiSU_Errors::Info_error.new($!,$@,@md.opt.cmd,@md.fns).error
        end
      end
    end
  end
end
__END__
