# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997 - 2011, Ralph Amissah, All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.jus.uio.no/sisu/gpl.fsf/toc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/doc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/plain.txt>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: SiSU information Structuring Universe, command line options
    parsing

=end
module SiSU_commandline
  require "pathname"
  require_relative 'sysenv'                             # sysenv.rb
  @@base_path=nil
  class Options
    attr_accessor :cmd,:mod,:act,:dir_structure_by,:f_pths,:files,:base_path,:paths,:lngs,:f_pth,:pth,:fns,:fnb,:fnc,:fncb,:lng,:what
    def initialize(a)
      @cmd,@f_pth,@pth,@fns,@fnb,@fnc,@fncb,@what,@lng,@base_path='','','','','','','','','','',''
      @f_pths,@files,@paths,@mod,@act=Array.new(5){[]}
      @env=SiSU_Env::Info_env.new
      @dir_structure_by=SiSU_Env::Env_call.new.output_dir_structure.by?
      @@base_path ||=Dir.pwd
      @base_path=@@base_path
      @a=sisu_glob_rules(a)
      @a.freeze
      init
    end
    def find_all(find_flag,opt)
      if find_flag
        pwd_set=Dir.pwd
        x=Dir.glob('*.ss[tm]')
        Px[:lng_lst].each do |d|
          if FileTest.directory?(d)
            x << Dir.glob("#{d}/*.ss[tm]")
          end
        end
        opt + x.flatten!
      end
    end
    def find_select(find_flag,opt)
      if find_flag
        pwd_set=Dir.pwd
        x=[]
        if opt.inspect =~/"[a-zA-Z][a-zA-Z0-9._-]+?"/
          opt.each do |g|
            x <<=if g =~/.ss[tm]/
              Dir.glob("*#{g}")
            else
              Dir.glob("*#{g}*.ss[tm]")
            end

            Px[:lng_lst].each do |d|
              if FileTest.directory?(d)
                x <<=if g =~/.ss[tm]/
                  Dir.glob("#{d}/*#{g}")
                else
                  Dir.glob("#{d}/*#{g}*.ss[tm]")
                end
              end
            end
          end
        end
        x.flatten!
     end
    end
    def sisu_glob_rules(a)
      b=[]
      f=[]
      find_flag=false
      a.each do |y|
        if y =~ /^-/ \
        or y =~ /\.ss[tm]$/
          if y =~/^-/ \
          && y =~/[fG]|--find|--glob/
            find_flag=true
          end
          b << y
        end
        if find_flag \
        && y !~ /^-/ \
        && y =~ /\S+/
          f << y
        elsif y =~ /^-/
          b << y
        end
      end
      r=Px[:lng_lst].join('|')
      r.gsub!(/\|en\|/,'|')
      @lang_regx=%r{(?:#{r})}
      z=if find_flag
        if f.length > 0
          b + find_select(find_flag,f)
        else
          find_all(find_flag,b)
        end
      elsif a.inspect =~/"(?:-\S+?|--\S+?)"/ \
      && a.inspect =~/"#{@lang_regx}\/?"/ \
      && a.inspect =~/"en\/\S+?\.ss[tm]"/
        init_selected_lang_dirs(a)
      else b
      end
    end
    def init_selected_lang_dirs(a)
      @z=[]
      a.each do |y|
        if y =~/^en\/(\S+?\.ss[tm])$/
          @fn=$1
          @z << y
        elsif y =~/^#{@lang_regx}\/?$/
          @z << "#{y}/#{@fn}"
        else @z << y
        end
      end
      @z
    end
    def init
      a=@a
      s=expand_numeric_shortcuts(a)
      q=set_files_and_paths_and_general_extract(s)
      @cmd,@mod=opt_cmd_and_mod_adjust(q[:cmd],q[:mod])
      @what=q[:what] unless q[:what].empty?
      @paths = q[:paths]
      @files = q[:files]
      @f_pths = q[:f_pths]
      @lngs = q[:lngs]
      if @files.length > 0 \
      and @cmd.empty? \
      and @mod.length==0 #% if no other action called on filename given, default is sisu -0 [filename(s)] configured as flag default
        @cmd=shortcut.cf_0
      end
      SiSU_Screen::Ansi.new(@cmd,"\tsisu " + @cmd +  ' ' + @mod.join(' ') + ' ' + @files.join(' ') + "\n").print_brown if @cmd =~/[vVM]/
#     @files.uniq!
      @act=opt_act
      @files
      self
    end
    def set_files_and_paths_and_general_extract(s)
      c,w='',''
      m,f,pth,z,lng,lngs=[],[],[],[],[],[]
      a=s.split(/\s+/)
      a.each do |x|
        if x =~/^-[a-z0-5]+/i \
        or x =~/^--\S+/
          if x =~/^-([a-z0-5]+)/i; c << $1
          end
          if x =~/^--\S+/;        m << x
          end
        elsif x =~ /(?:\.(?:(?:-|ssm\.)?sst(?:\.xml)?|ssm|ssi|sx[sdn]\.xml|s[1-3]|kdi|ssp)|\S+?\.ss[mt]\.zip|sisupod(\.zip)?)$/
          if x =~/^(?:https?|file):\/\/\S+/;  f << x
          elsif FileTest.file?(x)
### FIX
            pt=Pathname.new(x)
            pth << pt.split[0].realpath.to_s     #remove?
            f << pt.split[1].to_s                #remove?
            r=Px[:lng_lst].join('|')
            u=/.+?\/([^\/]+)(?:\/(?:#{r})$|$)/
            t=/.+\/(#{r})$/
            l_p = (pt.split[0].realpath.to_s[t,1]) \
              ? pt.split[0].realpath.to_s[t,1] \
              : nil
              #: ''
            lng << l_p
            lngs << if l_p
              l_p
            elsif x =~/~(#{r})\.ss[tm]/
              $1
            else 'en'
            end
            f_pths << {
              pth: pt.split[0].realpath.to_s,
              f: pt.split[1].to_s,
              pth_stub: pt.split[0].realpath.to_s[u,1],
              lng: (pt.split[0].realpath.to_s[t,1]) \
                ? pt.split[0].realpath.to_s[t,1] \
                : nil
            }
#           Dir.chdir(pt.split[0].realpath)
          else  puts "file not found: #{x}"
          end
        elsif x =~ /\.termsheet\.rb$/
          if FileTest.file?(x); f << x
          else  puts "file not found: #{x}"
          end
        else w=x
          puts "#{x} in #{a.join(' ')}?"
        end
      end
      { cmd: c, mod: m, what: w, paths: pth, files: f, f_pths: f_pths, lng: lng, lngs: lngs }
    end
    def expand_numeric_shortcuts(a)
      shortcut=SiSU_Env::Info_processing_flag.new
      s=''
      a.each do |x|
        y=case x
        when /0/
          (x=~/^-1\S+/) \
          ? x.gsub(/^-0(\S+)/,shortcut.cf_0 + ' -\1') \
          : x.gsub(/^-0/,shortcut.cf_0 + ' ')
        when /1/
          (x=~/^-1\S+/) \
          ? x.gsub(/^-1(\S+)/,shortcut.cf_1 + ' -\1') \
          : x.gsub(/^-1/,shortcut.cf_1 + ' ')
        when /2/
          (x=~/^-2\S+/) \
          ? x.gsub(/^-2(\S+)/,shortcut.cf_2 + ' -\1') \
          : x.gsub(/^-2/,shortcut.cf_2 + ' ')
        when /3/
          (x=~/^-3\S+/) \
          ? x.gsub(/^-3(\S+)/,shortcut.cf_3 + ' -\1') \
          : x.gsub(/^-3/,shortcut.cf_3 + ' ')
        when /4/
          (x=~/^-4\S+/) \
          ? x.gsub(/^-4(\S+)/,shortcut.cf_4 + ' -\1') \
          : x.gsub(/^-4/,shortcut.cf_4 + ' ')
        when /5/
          (x=~/^-5\S+/) \
          ? x.gsub(/^-5(\S+)/,shortcut.cf_5 + ' -\1') \
          : x.gsub(/^-5/,shortcut.cf_5 + ' ')
        when /6/
          (x=~/^-6\S+/) \
          ? x.gsub(/^-6(\S+)/,shortcut.cf_5 + ' -\1') \
          : x.gsub(/^-6/,shortcut.cf_5 + ' ')
        else x
        end
        s << " #{y}" unless y.empty?
      end
      s.strip!
    end
    def opt_cmd_and_mod_adjust(c,m)
      cmd,mod,files=@cmd,@mod,@files
      unless m.empty?
        m.each do |m|
          case m
          when /^--(?:color-toggle)$/;                       c=c+'c'
          when /^--(?:configure)$/;                          c=c+'CC'
          when /^--(?:dal?|machine|abstraction|abs)$/;       c=c+'m'
          when /^--(?:txt|text|plaintext)$/;                 c=c+'t'
          when /^--(?:html)$/;                               c=c+'h'
          when /^--(?:epub)$/;                               c=c+'e'
          when /^--(?:od[ft])$/;                             c=c+'o'
          when /^--(?:pdf)$/;                                c=c+'p'
          when /^--(?:concordance|wordmap)$/;                c=c+'w'
          when /^--(?:manpage)$/;                            c=c+'i'
          when /^--(?:texinfo)$/;                            c=c+'I'
          when /^--(?:xhtml)$/;                              c=c+'b'
          when /^--(?:xml-sax)$/;                            c=c+'x'
          when /^--(?:xml-dom)$/;                            c=c+'X'
          when /^--(?:hash-digests)$/;                       c=c+'N'
          when /^--(?:po4a|pot?)$/;                          c=c+'P'
          when /^--(?:termsheet)$/;                          c=c+'T'
          when /^--(?:manifest)$/;                           c=c+'y'
          when /^--(?:sqlite)$/;                             c=c+'d'
          when /^--(?:pg|pg?sql|postgresql)$/;               c=c+'D'
          when /^--(?:remote|rsync)$/;                       c=c+'R'
          when /^--(?:scp)$/;                                c=c+'r'
          when /^--(?:source)$/;                             c=c+'s'
          when /^--(?:sisupod|pod)$/;                        c=c+'S'
          when /^--(?:git)$/;                                c=c+'g'
          when /^--(?:urls)$/;                               c=c+'U'
          when /^--(?:zap|delete)$/;                         c=c+'Z'
          when /^--(?:sample-search-form)$/;                 c=c+'F'
          when /^--(?:webserv|webrick)$/;                    c=c+'W'
          when /^--(?:maintenance|keep-processing-files)$/;  c=c+'M'
          when /^--(?:verbose[=-]3)$/;                       c=c+'VM'
          when /^--(?:verbose[=-]2|Verbose|VERBOSE)$/;       c=c+'V'
          when /^--(?:verbose(?:[=-]1)?)$/;                  c=c+'v'
          when /^--(?:verbose[=-]0|quiet|silent)$/;          c=c+'q'
          else mod << m                                     #mod only contains command modifiers; commands converted to character
          end
        end
      end
      ca=[]
      unless c.empty?
        c.gsub!(/-/,'')
        c.scan(/CC|\S/) {|x| ca << x}
        cmd= '-' + ca.uniq.join
      end
      extra=''
      if cmd !~/[mn]/
        extra+=if cmd =~/[abegHhIiNOoPpTtwXxyz]/ \
        and cmd !~/[mn]/
          'm'                        #% add dal
        elsif ((cmd =~/[Dd]/ \
        or (mod.inspect =~/--(?:(?:sq)?lite|pg(?:sql)?)/)) \
        and mod.inspect !~/(?:remove|(?:(?:re)?create(?:all)?|dropall|drop)$)/) \
        and cmd !~/[mn]/
          'm'                                                                          #% add dal
        else ''
        end
      end
      if cmd !~/y/
        extra+=if cmd =~/[abeHhIiNopsSstwXxz]/ \
        and cmd !~/y/
          'ym'            #% add manifest
        elsif (cmd =~/[Dd]/ \
        or mod.inspect =~/--(?:(?:sq)?lite|pg(?:sql)?)/) \
        and files[0] !~/^remove$/ \
        and cmd !~/y/
          'ym' #% add manifest
        else ''
        end
      end
      cmd=cmd + extra
      cmds=cmd.scan(/CC|\S/)
      [cmds.uniq.join,mod]
    end
    def opt_act #note mod line commands have already been converted to command characters, cmd
      cmd,mod=@cmd,@mod
      act={}
      act[:license]=if cmd =~/L/ \
      or mod.inspect =~/"--license/
        true
      else false
      end
      act[:site_init]=if cmd =~/C/ \
      or mod.inspect =~/"--init-site/
        true
      else false
      end
      act[:verbose]=if cmd =~/v/ \
      or mod.inspect =~/"--verbose"/
        true
      else false
      end
      act[:quiet]=if cmd =~/q/ \
      or mod.inspect =~/"--quiet"/
        true
      else false
      end
      act[:color_state]=if mod.inspect =~/"--color-on"|"--color"/
        true
      elsif mod.inspect =~/"--color-off"/
        true
      else true #fix default color
      end
#     act[:color_toggle]=if cmd =~/c/ \
#     or mod.inspect =~/"--color-toggle"/
#       true
#     else false
#     end
      act[:maintenance]=if cmd =~/M/ \
      or mod.inspect =~/"--maintenance|--keep-processing-files"/
        true
      else false
      end
      act[:ocn]=if mod.inspect =~/"--no-ocn"/
        false
      else true
      end
      act[:dal]=if cmd =~/m/ \
      or mod.inspect =~/"--dal"/
        true
      else false
      end
      act[:html]=if cmd =~/h/ \
      or mod.inspect =~/"--html"/
        true
      else false
      end
      act[:concordance]=if cmd =~/w/ \
      or mod.inspect =~/"--concordance"/
        true
      else false
      end
      act[:pdf]=if cmd =~/p/ \
      or mod.inspect =~/"--pdf"/
        true
      else false
      end
      act[:epub]=if cmd =~/e/ \
      or mod.inspect =~/"--epub"/
        true
      else false
      end
      act[:odt]=if cmd =~/o/ \
      or mod.inspect =~/"--odf"/
        true
      else false
      end
      act[:xml_sax]=if cmd =~/x/ \
      or mod.inspect =~/"--xml-sax"/
        true
      else false
      end
      act[:xml_dom]=if cmd =~/X/ \
      or mod.inspect =~/"--xml-dom"/
        true
      else false
      end
      act[:xhtml]=if cmd =~/b/ \
      or mod.inspect =~/"--xhtml"/
        true
      else false
      end
      act[:txt]=if cmd =~/[at]/ \
      or mod.inspect =~/"--txt"/
        true
      else false
      end
      act[:manpage]=if cmd =~/i/ \
      or mod.inspect =~/"--manpage"/
        true
      else false
      end
      act[:texinfo]=if cmd =~/I/ \
      or mod.inspect =~/"--texinfo"/
        true
      else false
      end
      act[:fictionbook]=if cmd =~/f/ \
      or mod.inspect =~/"--fictionbook"/
        true
      else false
      end
      act[:psql]=if cmd =~/D/ \
      or mod.inspect =~/"--pg"|"--pgsql"/
        true
      else false
      end
      act[:sqlite]=if cmd =~/d/ \
      or mod.inspect =~/"--sqlite"/
        true
      else false
      end
      act[:harvest]=if mod.inspect =~/"--harvest"/
        true
      else false
      end
      act[:po4a]=if cmd =~/P/ \
      or mod.inspect =~/"--po4a"|"--pot?"/
        true
      else false
      end
      act[:git]=if cmd =~/g/ \
      or mod.inspect =~/"--git"/
        true
      else false
      end
      act[:hash_digests]=if cmd =~/N/ \
      or mod.inspect =~/"--hash-digests"/
        true
      else false
      end
      act[:sample_search_form]=if cmd =~/F/ \
      or mod.inspect =~/"--sample-search-form"/
        true
      else false
      end
      act[:webrick]=if cmd =~/W/ \
      or mod.inspect =~/"--webrick"/
        true
      else false
      end
      act[:share_source]=if cmd =~/s/ \
      or mod.inspect =~/"--source"/
        true
      else false
      end
      act[:sisupod]=if cmd =~/S/ \
      or mod.inspect =~/"--sisupod"/
        true
      else false
      end
      act[:scp]=if cmd =~/r/ \
      or mod.inspect =~/"--scp"/
        true
      else false
      end
      act[:rsync]=if cmd =~/R/ \
      or mod.inspect =~/"--rsync"/
        true
      else false
      end
      act[:delete_output]=if cmd =~/z/ \
      or mod.inspect =~/"--delete"|"--zap"/
        true
      else false
      end
      act[:urls_all]=if cmd =~/U/ \
      or mod.inspect =~/"--urls-all"/
        true
      else false
      end
      act[:urls_seleted]=if cmd =~/u/ \
      or mod.inspect =~/"--urls"/
        true
      else false
      end
      act[:sitemap]=if cmd =~/Y/ \
      or mod.inspect =~/"--sitemap"/
        true
      else false
      end
      act[:manifest]=if cmd =~/y/ \
      or mod.inspect =~/"--manifest"/
        true
      else false
      end
      act[:help]=if mod.inspect =~/"--help/
        true
      else false
      end
      @act=act
    end
    def cmd
      @cmd
    end
    def mod
      @mod
    end
    def act
      @act
    end
    def f_pth
      @f_pth
    end
    def pth
      @pth
    end
    def lng
      @lng
    end
    def fns
      @fns
    end
    def what
      @what
    end
    def fnb
      unless fns.empty?
        fns[/(.+?)\.(?:(?:-|ssm\.)?sst|ssm)$/,1]
      end
    end
    def fnc
      @fnc=if @fns =~/\.(?:ssm\.sst|ssm)$/; fnb + '.ssm.sst'
      else @fns
      end
    end
    def fncb
      @fncb=if @fns =~/(?:\~\S{2,3})?\.(?:ssm\.sst|ssm)$/; fnb + '.ssm.sst'
      else @fns.gsub(/(?:\~\S{2,3})?(\.sst)$/,'\1')
      end
    end
  end
end
__END__
note usually named @opt
is carried in Param usually as @md
@opt is a subset of @md
where @md is passed, contents of @opt are available
passing @opt as well is duplication
check for fns & fnb
