"%% SiSU Vim color file
" Name:            Slate
" Maintainer:      Ralph Amissah <ralph@amissah.com>
" Last Change:     2011-05-10
" URL:             <http://git.sisudoc.org/?p=code/sisu.git;a=blob;f=data/sisu/v3/conf/editor-syntax-etc/vim/colors/slate.vim;hb=HEAD>
" Notes:          cterm now uses frugal-sisu 8 colors for term
"                 (for gui originally looked at desert Hans Fugal <hans@fugal.net>
"                  <http://hans.fugal.net/vim/colors/desert.vim> (April/May 2003))
:set background=dark
:hi clear
if exists("syntax_on")
  syntax reset
endif
:let colors_name = "slate"
" 0 = black, 1 = red, 2 = green, 3 = yellow/orange, 4 = blue, 5 = magenta, 6 = cyan, 7 = white
:hi Normal                                                           ctermbg=0           ctermfg=7                     guibg=grey15        guifg=white
:hi Cursor         term=reverse             cterm=reverse                                                              guibg=khaki         guifg=slategrey
:hi lCursor        term=reverse             cterm=reverse
:hi StatusLine     term=reverse             cterm=bold,reverse                                               gui=none  guibg=#c2bfa5       guifg=black
:hi StatusLineNC   term=reverse             cterm=reverse                                                    gui=none  guibg=#c2bfa5       guifg=grey40
:hi Search         term=reverse             cterm=none               ctermbg=2           ctermfg=0                     guibg=peru          guifg=wheat
:hi IncSearch      term=reverse             cterm=bold               ctermbg=2           ctermfg=7                     guibg=black         guifg=green
:hi SpecialKey     term=bold                                                             ctermfg=4                                         guifg=yellowgreen
:hi Visual         term=reverse             cterm=reverse                                                    gui=none  guibg=olivedrab     guifg=khaki
:hi VisualNOS      term=bold,underline      cterm=bold,underline
:hi MoreMsg        term=bold                                                             ctermfg=2                                         guifg=SeaGreen
:hi ModeMsg        term=bold                cterm=bold                                                                                     guifg=goldenrod
:hi Question       term=standout                                                         ctermfg=2                                         guifg=springgreen
:hi Title          term=bold                cterm=bold                                   ctermfg=3           gui=bold                      guifg=gold
:hi NonText        term=bold                cterm=bold                                   ctermfg=4                     guibg=grey15        guifg=RoyalBlue
:hi LineNr         term=underline           cterm=bold               ctermbg=0           ctermfg=0*                                        guifg=grey50
:hi Directory      term=bold                                                             ctermfg=4
:hi WildMenu       term=standout                                     ctermbg=3           ctermfg=0                     guibg=darkyellow    guifg=black
:hi VertSplit      term=reverse             cterm=reverse                                                    gui=none  guibg=#c2bfa5       guifg=grey40
:hi Folded         term=standout            cterm=none               ctermbg=0           ctermfg=7                     guibg=black         guifg=grey40
:hi FoldColumn     term=standout                                     ctermbg=7           ctermfg=4                     guibg=black         guifg=grey20
:hi DiffChange                              cterm=none               ctermbg=7           ctermfg=0                     guibg=darkgrey      guifg=white
:hi DiffText                                cterm=none               ctermbg=6           ctermfg=0                     guibg=darkcyan      guifg=white
:hi DiffAdd                                 cterm=none               ctermbg=2           ctermfg=0                     guibg=darkgreen     guifg=white
:hi DiffDelete                              cterm=none               ctermbg=7           ctermfg=0                     guibg=darkgrey      guifg=black
:hi String                                  cterm=none                                   ctermfg=3                                         guifg=SkyBlue
:hi Comment        term=bold                cterm=none               ctermbg=0           ctermfg=7                                         guifg=grey40
:hi Constant       term=underline                                                        ctermfg=1                                         guifg=#ffa0a0
:hi Special        term=bold                                                             ctermfg=6                                         guifg=darkkhaki
:hi Identifier     term=underline                                                        ctermfg=6                                         guifg=salmon
:hi Statement      term=bold                                                             ctermfg=6                                         guifg=CornflowerBlue
:hi Operator       term=bold                                                             ctermfg=1                                         guifg=red
:hi PreProc        term=underline                                    ctermbg=7           ctermfg=1                     guibg=white         guifg=red
:hi Type           term=underline                                                        ctermfg=2                                         guifg=CornflowerBlue
:hi Delimiter      term=none                cterm=none                                   ctermfg=1
:hi Ignore                                  cterm=bold                                   ctermfg=7                                         guifg=grey40
:hi Todo           term=standout                                     ctermbg=3           ctermfg=0                     guibg=yellow2       guifg=orangered
:hi Underlined     term=underline           cterm=underline
:hi Include                                                                              ctermfg=1                                         guifg=red
:hi Define                                                                               ctermfg=3           gui=bold                      guifg=gold
:hi Function                                                                             ctermfg=6                                         guifg=navajowhite
:hi Structure                                                                            ctermfg=2                                         guifg=green
:hi CursorLine                                                       ctermbg=4                                         guibg=black
:hi CursorColumn                                                     ctermbg=4                                         guibg=black
:hi MatchParen                              cterm=bold               ctermbg=4           ctermfg=7
:hi SpellBad       term=underline,standout  cterm=none               ctermbg=7           ctermfg=0                     guibg=darkmagenta   guifg=white
:hi SpellCap       term=underline,standout  cterm=none               ctermbg=7           ctermfg=0
:hi SpellLocal     term=underline,standout  cterm=none               ctermbg=7           ctermfg=0                     guibg=darkmagenta   guifg=white
:hi SpellRare      term=underline,standout  cterm=none               ctermbg=7           ctermfg=0
:hi WarningMsg     term=standout                                                         ctermfg=1                     guibg=darkmagenta   guifg=salmon
:hi ErrorMsg       term=standout            cterm=bold               ctermbg=1           ctermfg=7                     guibg=darkmagenta   guifg=white
:hi Error          term=reverse             cterm=bold               ctermbg=1           ctermfg=7                     guibg=darkmagenta   guifg=white
:hi Black                                                            ctermbg=grey        ctermfg=black                 guibg=grey          guifg=black
:hi Red                                                              ctermbg=black       ctermfg=red                   guibg=black         guifg=red
:hi Magenta                                                          ctermbg=black       ctermfg=magenta               guibg=black         guifg=magenta
:hi Blue                                                             ctermbg=black       ctermfg=blue                  guibg=black         guifg=blue
:hi Cyan                                                             ctermbg=black       ctermfg=cyan                  guibg=black         guifg=cyan
:hi Green                                                            ctermbg=black       ctermfg=green                 guibg=black         guifg=green
:hi Yellow                                                           ctermbg=black       ctermfg=yellow                guibg=black         guifg=yellow
:hi White                                                            ctermbg=black       ctermfg=white                 guibg=black         guifg=white
