# coding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997 - 2010, Ralph Amissah, All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.jus.uio.no/sisu/gpl.fsf/toc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/doc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/plain.txt>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: opendocument formatting, default opendocument template

=end
module SiSU_ODF_format
  require "#{SiSU_lib}/param"                              # param.rb
    include SiSU_Param
  include SiSU_Viz
  class Paragraph_number
    def initialize(paranum)
      @paranum=/(\d+)/m.match(paranum)[1]
    end
    def display
      @paranum.gsub(/(\d+)/,'<font size="1" color="#777777">&nbsp;&nbsp;\1</font>')
    end
    def name
      @paranum.gsub(/(\d+)/,'<a name="\1"></a>')
    end
    def goto
      @paranum.gsub(/(\d+)/,'<a href="#\1">')
    end
  end
  class Format_text_object
    def initialize(md,t_o)
      @md,@t_o=md,t_o
      if t_o.class==Hash
        @txt =t_o[:txt]            || nil
      else
        p t_o.class
        p caller
      end
      rgx=/#{Mx[:en_a_o]}\d+\s+(.+?)#{Mx[:en_a_c]}/
      @txt.gsub!(rgx,'\1') if @txt =~rgx
      @vz=SiSU_Env::Get_init.instance.skin
    end
    def scr_endnote_body
      "<endnote>#{@txt}</endnote> "
    end
    def heading_body1
    end
    def heading_body2
    end
    def heading_body3
    end
    def heading_body4
    end
    def heading_body5
    end
    def heading_body6
    end
  end
  class Table
    @@tablehead,@@table_counter=0,0 #reinitialise on new file
    @@tablefoot=[] #watch
    @@fns=''
    def initialize(md,dob)
      @md,@dob,@txt,@vz=md,dob,dob.obj,SiSU_Env::Get_init.instance.skin
      if @md.fns != @@fns
        @@table_counter=0
        @@fns=@md.fns
      end
    end
    def table_head_open(count)
      type=if @dob.head_; 1
      else       2
      end
      alpha=case @dob.cols
      when  1; 'A'
      when  2; 'B'
      when  3; 'C'
      when  4; 'D'
      when  5; 'E'
      when  6; 'F'
      when  7; 'G'
      when  8; 'H'
      when  9; 'I'
      when 10; 'J'
      when 11; 'K'
      when 12; 'L'
      when 13; 'M'
      when 14; 'N'
      else     'D'
      end
      %{<table:table table:name="Table#{count}" table:style-name="Table#{type}">#{@br}} +
      %{<table:table-column table:style-name="Table#{type}.#{alpha}" table:number-columns-repeated="#{@dob.cols}"/>#{@br}}
    end
    def table_close(tablefoot='')
      '</table:table>'
    end
    def table_tag_cell(str,i)
      txt_name_cell=if i==0 \
      and @dob.head_
        'Table_20_Heading'
      else 'P7'
      end
      str.gsub!(/^~$/,'') # tilde / empty cell
      %{<table:table-cell office:value-type="string">#{@br}} +
      %{<text:p text:style-name="#{txt_name_cell}">#{@br}} +
      %{#{str}} +
      %{</text:p>#{@br}} +
      %{</table:table-cell>#{@br}}
    end
    def table_tag_row(str,i)
      %{<table:table-row>#{@br}} +
      %{#{str}} +
      %{</table:table-row>#{@br}}
    end
    def table_tag_row_dump(str,i)
      txt_name_row=if i==0 \
      and @dob.head_
        'Table_20_Heading'
      else 'P7'
      end
      %{<table:table-row>#{@br}} +
      %{<table:table-cell office:value-type="string">#{@br}} +
      %{<text:p text:style-name="#{txt_name_row}">#{@br}}
      %{#{str}} +
      %{</text:p>#{@br}} +
      %{</table:table-cell>#{@br}} +
      %{</table:table-row>#{@br}}
    end
    def table_row(row,i)
      row='' if row =~/^<!$/
      m=row[/<!f(.+?)!>/,1]
      @@tablefoot << m if m
      row.gsub!(/<!f.+?!>/,'')
      @cells=[]
      row.split(/\s*#{Mx[:tc_p]}/).each do |cell|
        @cells << table_tag_cell(cell,i)
      end
      row=@cells.join
      row=table_tag_row(row,i)
      row
    end
    def table
      @@table_counter+=1
      table_head_open(@@table_counter)
      @table=[]
      @dob.obj.split(/\s*#{Mx[:tc_c]}/).each_with_index do |r,i|
        @table << table_row(r,i)
      end
      @dob.obj= table_head_open(@@table_counter) + @table.join + table_close
      @dob
    end
  end
  class XML
  end
end
__END__
