# coding: utf-8
=begin
 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997 - 2010, Ralph Amissah, All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.jus.uio.no/sisu/gpl.fsf/toc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/doc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/plain.txt>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: modules related to locales, character encoding for different
    output generators [requires kirbybase]

=end
module SiSU_character_encode
  require 'kirbybase'
  require "#{SiSU_lib}/sysenv"
  class Characters
    attr_accessor(:character_encoding,:glyph,:dec,:hex,:rb,:html,:html_name,:tex,:tex_licr,:tex_alt,:name)
    def initialize(&block)
      instance_eval(&block)
    end
  end
  class Create <Characters
    def initialize
      #NOTE places character_encoding.tbl in correct subdirectory ./_sisu_processing/encoding
      #@env=SiSU_Env::Info_env.new
      #env=@env.path.encoding
      #@db=KirbyBase.new(:local,nil,nil,env)
      @db=KirbyBase.new                                         #default database location, pwd
      @ce_tbl=@db.create_table.documents(:character_encoding, :glyph,:String, :dec,:Integer, :hex,:String, :rb,:String, :html,:String, :html_name,:String, :tex,:String, :tex_licr,:String, :tex_alt,:String, :name,:String)
    end
    def db
      x=Character_encoding.new.table
      #x.each {|y| puts y[2].inspect}
      x.each do |c|
        #puts "#{c[0]}, #{c[1]}, #{c[2]}, #{c[3]}, #{c[4]}, #{c[5]}, #{c[6]}, #{c[7]}, #{c[8]}, #{c[9]}"
        @ce_tbl.insert(c[0], c[1], c[2], c[3], c[4], c[5], c[6], c[7], c[8], c[9])
      end
    end
  end
  class Query
    def initialize(find='',show='')
      #NOTE character_encoding.tbl not read from subdirectory ./_sisu_processing/encoding
      @db=KirbyBase.new                                         #default database location, pwd
      @ce_tbl=@db.get_table(:character_encoding)
      @find=find
    end
    def selected(selected,show)
      @y=[]
      selected.each do |x|
        @y<<case show
        when 'glyph';     x.glyph
        when 'dec';       x.dec
        when 'hex';       x.hex
        when 'rb';        x.rb
        when 'html';      x.html
        when 'html_name'; x.html_name
        when 'tex';       x.tex
        when 'ot1';       x.ot1
        when 'ts1';       x.ts1
        when 'name';      x.name
        else              x.hex
        end
      end
      #@ce_tbl.select(:glyph,:name) { |r| r.hex == hex }.each do |r|
      #  puts '%s %s' % [r.glyph, r.name]
      #end
      #:glyph,:dec,:hex,:rb,:html,:html_name,:tex,:tex_licr,:tex_alt,:name
      #list=['number','glyph','html','hex','rb','tex','ot1','ts1','name']
    end
    def hex(hex,show)
      select=@ce_tbl.select(:glyph,:dec,:hex,:rb,:html,:html_name,:tex,:tex_licr,:tex_alt,:name) { |r| r.hex == hex }
      selected(select,show)
      @y
    end
    def dec(dec,show)
      select=@ce_tbl.select(:glyph,:dec,:hex,:rb,:html,:html_name,:tex,:tex_licr,:tex_alt,:name) { |r| r.dec == dec }
      selected(select,show)
      @y
    end
    def name(name,show)
      select=@ce_tbl.select(:glyph,:dec,:hex,:rb,:html,:html_name,:tex,:tex_licr,:tex_alt,:name) { |r| r.name =~ /#{name}/ }
      selected(select,show)
      @y
    end
    def report
      puts @ce_tbl.select(:glyph,:dec,:hex,:rb,:html,:html_name,:tex,:tex_licr,:tex_alt,:name).to_report
    end
    def table
      selected=@ce_tbl.select
      #selected=@ce_tbl.select(:glyph,:dec,:hex,:rb,:html,:html_name,:tex,:tex_licr,:tex_alt,:name)
      selected.each do |c|
        puts '%s %s %s %s %s %s %s %s %s %s' % [c.glyph,c.dec,c.hex,c.rb,c.html,c.html_name,c.tex,c.tex_licr,c.tex_alt,c.name]
        #puts "#{c.glyph}, #{c.dec}, #{c.hex}, #{c.rb}, #{c.html}, #{c.name}, #{c.tex}, #{c.tec_licr}, #{c.tex_alt}, #{c.c_name}"
      end
    end
  end
  class Character_encoding
    def table
      x=[]
#:glyph, :dec,:hex,  :rb,            :xml ,   :html_name,  :tex,    :tex_licr,         :tex_alt,          :name
      x=[
  ['',     9, '',    '',             '&#009;', nil,         '',     '',                '',                'Horizontal tab'  ],
  ['',    15, '',    '',             '&#015;', nil,         '',     '',                '',                'Line feed'       ],
  ['',    17, '',    '',             '&#017;', nil,         '',     '',                '',                'Carriage return' ],
  [' ',   32, '40',  '\40',          '&#032;', nil,         '',     '',                '',                'Space'           ],
  ['!',   33, '41',  '\41',          '&#033;', nil,         '!',    '!',               '!',               'Punctuation Exclamation !' ],
  ['',    34, '42',  '\42',          '&#034;', '&quot;',    '',     '',                '',                'Punctuation Quotation mark' ],
  ['#',   35, '43',  '\43',          '&#035;', nil,         '{\#}', '\#',              '',                'Hash mark    #' ],
  ['$',   36, '44',  '\44',          '&#036;', nil,         '{\$}', '\textdollar',     '',                'Dollar sign  $' ],
  ['%',   37, '45',  '\45',          '&#037;', nil,         '{\%}', '\%',              '',                'Percent sign %' ],
  ['&',   38, '46',  '\46',          '&#038;', '&amp;',     '{\&}', '\&',              '',                'Ampersand    &' ],
  ['\'',  39, '47',  '\47',          '&#039;', nil,         '',     '',                '',                'Apostrophe   \''],
  ['(',   40, '50',  '\50',          '&#040;', nil,         '',     '',                '',                'Left parenthesis  (' ],
  [')',   41, '51',  '\51',          '&#041;', nil,         '',     '',                '',                'Right parenthesis )' ],
  ['*',   42, '52',  '\52',          '&#042;', nil,         '',     '',                '',                'Asterisk     *' ],
  ['+',   43, '53',  '\53',          '&#043;', nil,         '',     '',                '',                'Plus sign    +' ],
  [',',   44, '54',  '\54',          '&#044;', nil,         ',',    ',',               ',',               'Puncutation Comma  ,' ],
  ['-',   45, '55',  '\55',          '&#045;', nil,         '-',    '-',               '-',               'Puncutation Hyphen -' ],
  ['.',   46, '56',  '\56',          '&#046;', nil,         '.',    '.',               '.',               'Puncutation Period .' ],
  ['/',   47, '57',  '\57',          '&#047;', nil,         '/',    '/',               '/',               'Puncutation Slash  /' ],
  ['0',   48, '60',  '\60',          '&#048;', nil,         '0',    '0',               '0',               'Digit zero  0' ],
  ['1',   49, '61',  '\61',          '&#049;', nil,         '1',    '1',               '1',               'Digit one   1' ],
  ['2',   50, '62',  '\62',          '&#050;', nil,         '2',    '2',               '2',               'Digit two   2' ],
  ['3',   51, '63',  '\63',          '&#051;', nil,         '3',    '3',               '3',               'Digit three 3' ],
  ['4',   52, '64',  '\64',          '&#052;', nil,         '4',    '4',               '4',               'Digit four  4' ],
  ['5',   53, '65',  '\65',          '&#053;', nil,         '5',    '5',               '5',               'Digit five  5' ],
  ['6',   54, '66',  '\66',          '&#054;', nil,         '6',    '6',               '6',               'Digit six   6' ],
  ['7',   55, '67',  '\67',          '&#055;', nil,         '7',    '7',               '7',               'Digit seven 7' ],
  ['8',   56, '70',  '\70',          '&#056;', nil,         '8',    '8',               '8',               'Digit eight 8' ],
  ['9',   57, '71',  '\71',          '&#057;', nil,         '9',    '9',               '9',               'Digit nine  9' ],
  [':',   58, '72',  '\72',          '&#058;', nil,         '',     '',                '',                'Punctuation Colon     :' ],
  [';',   59, '73',  '\73',          '&#059;', nil,         '',     '',                '',                'Punctuation Semicolon ;' ],
  ['<',   60, '74',  '\74',          '&#060;', '&lt;',      '',     '',                '',                'Less than    <' ],
  ['=',   61, '75',  '\75',          '&#061;', nil,         '',     '',                '',                'Equals sign  =' ],
  ['>',   62, '76',  '\76',          '&#062;', '&gt;',      '',     '',                '',                'Greater than >' ],
  ['?',   63, '77',  '\77',          '&#063;', nil,         '?',    '?',               '?',               'Punctuation Question mark ?' ],
  ['@',   64, '100', '\100',         '&#064;', nil,         '',     '',                '',                'Commercial at sign           @' ],
  ['A',   65, '101', '\101',         '&#065;', nil,         'A',    'A',               'A',               'Captial A' ],
  ['B',   66, '102', '\102',         '&#066;', nil,         'B',    'B',               'B',               'Captial B' ],
  ['C',   67, '103', '\103',         '&#067;', nil,         'C',    'C',               'C',               'Captial C' ],
  ['D',   68, '104', '\104',         '&#068;', nil,         'D',    'D',               'D',               'Captial D' ],
  ['E',   69, '105', '\105',         '&#069;', nil,         'E',    'E',               'E',               'Captial E' ],
  ['F',   70, '106', '\106',         '&#070;', nil,         'F',    'F',               'F',               'Captial F' ],
  ['G',   71, '107', '\107',         '&#071;', nil,         'G',    'G',               'G',               'Captial G' ],
  ['H',   72, '110', '\110',         '&#072;', nil,         'H',    'H',               'H',               'Captial H' ],
  ['I',   73, '111', '\111',         '&#073;', nil,         'I',    'I',               'I',               'Captial I' ],
  ['J',   74, '112', '\112',         '&#074;', nil,         'J',    'J',               'J',               'Captial J' ],
  ['K',   75, '113', '\113',         '&#075;', nil,         'K',    'K',               'K',               'Captial K' ],
  ['L',   76, '114', '\114',         '&#076;', nil,         'L',    'L',               'L',               'Captial L' ],
  ['M',   77, '115', '\115',         '&#077;', nil,         'M',    'M',               'M',               'Captial M' ],
  ['N',   78, '116', '\116',         '&#078;', nil,         'N',    'N',               'N',               'Captial N' ],
  ['O',   79, '117', '\117',         '&#079;', nil,         'O',    'O',               'O',               'Captial O' ],
  ['P',   80, '120', '\120',         '&#080;', nil,         'P',    'P',               'P',               'Captial P' ],
  ['Q',   81, '121', '\121',         '&#081;', nil,         'Q',    'Q',               'Q',               'Captial Q' ],
  ['R',   82, '122', '\122',         '&#082;', nil,         'R',    'R',               'R',               'Captial R' ],
  ['S',   83, '123', '\123',         '&#083;', nil,         'S',    'S',               'S',               'Captial S' ],
  ['T',   84, '124', '\124',         '&#084;', nil,         'T',    'T',               'T',               'Captial T' ],
  ['U',   85, '125', '\125',         '&#085;', nil,         'U',    'U',               'U',               'Captial U' ],
  ['V',   86, '126', '\126',         '&#086;', nil,         'V',    'V',               'V',               'Captial V' ],
  ['W',   87, '127', '\127',         '&#087;', nil,         'W',    'W',               'W',               'Captial W' ],
  ['X',   88, '130', '\130',         '&#088;', nil,         'X',    'X',               'X',               'Captial X' ],
  ['Y',   89, '131', '\131',         '&#089;', nil,         'Y',    'Y',               'Y',               'Captial Y' ],
  ['Z',   90, '132', '\132',         '&#090;', nil,         'Z',    'Z',               'Z',               'Captial Z' ],
  ['[',   91, '133', '\133',         '&#091;', nil,         '',     '',                '',                'Left square bracket  [' ],
  ['\\',  92, '134', '\134',         '&#092;', nil,         '',     '\textbackslash',  '',                'Backslash            \\'],
  [']',   93, '135', '\135',         '&#093;', nil,         '',     '',                '',                'Right square bracket ]' ],
  ['^',   94, '136', '\136',         '&#094;', nil,         '',     '',                '',                'Caret                ^' ],
  ['_',   95, '137', '\137',         '&#095;', nil,         '{\_}', '\textunderscore', '',                'Underscore           _' ],
  ['`',   96, '140', '\140',         '&#096;', nil,         '',     '',                '',                'Grave accent         `' ],
  ['a',   97, '141', '\141',         '&#097;', nil,         'a',    'a',               'a',               'Small a' ],
  ['b',   98, '142', '\142',         '&#098;', nil,         'b',    'b',               'b',               'Small b' ],
  ['c',   99, '143', '\143',         '&#099;', nil,         'c',    'c',               'c',               'Small c' ],
  ['d',  100, '144', '\144',         '&#100;', nil,         'd',    'd',               'd',               'Small d' ],
  ['e',  101, '145', '\145',         '&#101;', nil,         'e',    'e',               'e',               'Small e' ],
  ['f',  102, '146', '\146',         '&#102;', nil,         'f',    'f',               'f',               'Small f' ],
  ['g',  103, '147', '\147',         '&#103;', nil,         'g',    'g',               'g',               'Small g' ],
  ['h',  104, '150', '\150',         '&#104;', nil,         'h',    'h',               'h',               'Small h' ],
  ['i',  105, '151', '\151',         '&#105;', nil,         'i',    'i',               'i',               'Small i' ],
  ['j',  106, '152', '\152',         '&#106;', nil,         'j',    'j',               'j',               'Small j' ],
  ['k',  107, '153', '\153',         '&#107;', nil,         'k',    'k',               'k',               'Small k' ],
  ['l',  108, '154', '\154',         '&#108;', nil,         'l',    'l',               'l',               'Small l' ],
  ['m',  109, '155', '\155',         '&#109;', nil,         'm',    'm',               'm',               'Small m' ],
  ['n',  110, '156', '\156',         '&#110;', nil,         'n',    'n',               'n',               'Small n' ],
  ['o',  111, '157', '\157',         '&#111;', nil,         'o',    'o',               'o',               'Small o' ],
  ['p',  112, '160', '\160',         '&#112;', nil,         'p',    'p',               'p',               'Small p' ],
  ['q',  113, '161', '\161',         '&#113;', nil,         'q',    'q',               'q',               'Small q' ],
  ['r',  114, '162', '\162',         '&#114;', nil,         'r',    'r',               'r',               'Small r' ],
  ['s',  115, '163', '\163',         '&#115;', nil,         's',    's',               's',               'Small s' ],
  ['t',  116, '164', '\164',         '&#116;', nil,         't',    't',               't',               'Small t' ],
  ['u',  117, '165', '\165',         '&#117;', nil,         'u',    'u',               'u',               'Small u' ],
  ['v',  118, '166', '\166',         '&#118;', nil,         'v',    'v',               'v',               'Small v' ],
  ['w',  119, '167', '\167',         '&#119;', nil,         'w',    'w',               'w',               'Small w' ],
  ['x',  120, '170', '\170',         '&#120;', nil,         'x',    'x',               'x',               'Small x' ],
  ['y',  121, '171', '\171',         '&#121;', nil,         'y',    'y',               'y',               'Small y' ],
  ['z',  122, '172', '\172',         '&#122;', nil,         'z',    'z',               'z',               'Small z' ],
  ['{',  123, '173', '\173',         '&#123;', nil,         '{\{}', '\{',              '',                'Left curly brace     {' ],
  ['|',  124, '174', '\174',         '&#124;', nil,         '',     '',                '',                'Vertical bar / pipe  |' ],
  ['}',  125, '175', '\175',         '&#125;', nil,         '{\}}', '\}',              '',                'Right curly brace    }' ],
  ['~',  126, '176', '\176',         '&#126;', nil,         '',     '',                '',                'Tilde                ~' ],
  ['',   127, '177', '',             '&#127;', nil,         '',     '',                '',                '                      ' ],
  ['',   128, '200', '',             '&#128;', nil,         '',     '',                '',                '                      ' ],
  ['',   129, '201', '',             '&#129;', nil,         '',     '',                '',                '                      ' ],
  ['\'', 130, '202', '',             '&#130;', nil,         '',     '',                '',                'Low left single quote        \''],
  [' ',  131, '203', '',             '&#131;', nil,         '',     '',                '',                'Florin                        ' ],
  ['"',  132, '204', '',             '&#132;', nil,         '',     '',                '',                'Low left double quote        "' ],
  ['…',  133, '205', '\342\200\246', '&#133;', nil,         '…',    '\textellipsis',   '',                'Ellipsis             …' ],
  ['†',  134, '206', '\342\200\240', '&#134;', nil,         '†',    '\textdagger',     '',                'Dagger               †' ],
  ['‡',  135, '207', '\342\200\241', '&#135;', nil,         '‡',    '\textdaggerbl',   '',                'Double dagger        ‡' ],
  ['^',  136, '210', '',             '&#136;', nil,         '',     '',                '',                'Circumflex           ^' ],
  ['',   137, '211', '',             '&#137;', nil,         '',     '',                '',                'Permil               ' ],
  ['',   138, '212', '',             '&#138;', nil,         '',     '',                '',                'Capital S, caron     ' ],
  ['<',  139, '213', '',             '&#139;', nil,         '',     '',                '',                'Less than sign (see &060;)   <' ],
  ['',   140, '214', '',             '&#140;', nil,         '',     '',                '',                'Capital OE ligature   ' ],
  ['',   141, '215', '',             '&#141;', nil,         '',     '',                '',                '                      ' ],
  ['',   142, '216', '',             '&#142;', nil,         '',     '',                '',                'Capital Z, caron      ' ],
  ['',   143, '217', '',             '&#143;', nil,         '',     '',                '',                '                      ' ],
  ['',   144, '220', '',             '&#144;', nil,         '',     '',                '',                '                      ' ],
  ['',   145, '221', '',             '&#145;', nil,         '',     '',                '',                'Left single quote     ' ],
  ['',   146, '222', '',             '&#146;', nil,         '',     '',                '',                'Right single quote    ' ],
  ['',   147, '223', '',             '&#147;', nil,         '',     '',                '',                'Left double quote     ' ],
  ['',   148, '224', '',             '&#148;', nil,         '',     '',                '',                'Right double quote    ' ],
  ['',   149, '225', '',             '&#149;', nil,         '',     '',                '',                'Bullet                ' ],
  ['-',  150, '226', '',             '&#150;', nil,         '',     '',                '',                'En dash              -' ],
  ['',   151, '227', '',             '&#151;', nil,         '',     '',                '',                'Em dash              -' ],
  ['~',  152, '230', '',             '&#152;', nil,         '',     '',                '',                'Tilde (see &126;)    ~' ],
  ['t',  153, '231', '',             '&#153;', nil,         '',     '',                '',                'Trademark            t' ],
  ['',   154, '232', '',             '&#154;', nil,         '',     '',                '',                'small s, caron        ' ],
  ['',   155, '233', '',             '&#155;', nil,         '',     '',                '',                'Greater than sign (see &062;) ' ],
  ['',   156, '234', '',             '&#156;', nil,         '',     '',                '',                'Small oe ligature        ' ],
  ['',   157, '235', '',             '&#157;', nil,         '',     '',                '',                '                         ' ],
  ['',   158, '236', '',             '&#158;', nil,         '',     '',                '',                'Small z, caron           ' ],
  ['',   159, '237', '',             '&#159;', nil,         '',     '',                '',                'Capital Y, umlaut        ' ],
  ['',   160, '240', '',             '&#160;', '&nbsp;',    '',     '',                '',                'Non-breaking space       ' ],
  ['¡',  161, '241', '\302\241',     '&#161;', '&iexcl;',   '¡',    '',                '',                'Inverted exclamation     ' ],
  ['¢',  162, '242', '\302\242',     '&#162;', '&cent;',    '¢',    '',                '',                'Cent sign               ¢' ],
  ['£',  163, '243', '\302\243',     '&#163;', '&pound;',   '£',    '\textsterling',   '',                'Pound sign              £' ],
  ['¤',  164, '244', '\302\244',     '&#164;', '&curren;',  '¤',    '\textcurrency',   '',                'General currency sign    ' ],
  ['¥',  165, '245', '\302\245',     '&#165;', '&yen;',     '¥',    '',                '',                'Yen sign                ¥' ],
  ['¦',  166, '246', '\302\246',     '&#166;', '&brvbar;',  '¦',    '',                '',                'Broken vertical bar      ' ],
  ['§',  167, '247', '\302\247',     '&#167;', '&sect;',    '§',    '\textsection',    '',                'Section sign            §' ],
  ['¨',  168, '250', '\302\250',     '&#168;', '&uml;',     '¨',    '\"',              '',                'Umlaut                   ' ],
  ['©',  169, '251', '\302\251',     '&#169;', '&copy;',    '©',    '\copyright',      '\textcopyright',  'Copyright               ©' ],
  ['ª',  170, '252', '\302\252',     '&#170;', '&ordf;',    'ª',    '',                '',                'Feminine ordinal        ª' ],
  ['«',  171, '253', '\302\253',     '&#171;', '&laquo;',   '«',    '',                '',                'Left angle quote        «' ],
  ['¬',  172, '254', '\302\254',     '&#172;', '&not;',     '¬',    '',                '',                'Not sign                 ' ],
  ['­',  173, '255', '\302\255',     '&#173;', '&shy;',     '­',    '',                '',                'Soft hyphen              ' ],
  ['®',  174, '256', '\302\256',     '&#174;', '&reg;',     '®',    '',                '',                'Registered trademark    ®' ],
  ['¯',  175, '257', '\302\257',     '&#175;', '&macr;',    '¯',    '',                '',                'Macron accent            ' ],
  ['°',  176, '260', '\302\260',     '&#176;', '&deg;',     '°',    '',                '',                'Degree sign             °' ],
  ['±',  177, '261', '\302\261',     '&#177;', '&plusmin;', '±',    '',                '',                'Plus or minus           ±' ],
  ['²',  178, '262', '\302\262',     '&#178;', '&sup2;',    '²',    '',                '',                'Superscript 2           ²' ],
  ['³',  179, '263', '\302\263',     '&#179;', '&sup3;',    '³',    '',                '',                'Superscript 3           ³' ],
  ['',   180, '264', '\302\264',     '&#180;', '&acute;',   ''',    '',                '',                'Acute accent             ' ],
  ['µ',  181, '265', '\302\265',     '&#181;', '&micro;',   'µ',    '',                '',                'Micro sign (Greek mu)   µ' ],
  ['¶',  182, '266', '\302\266',     '&#182;', '&para;',    '¶',    '\textparagraph',  '',                'Paragraph sign          ¶' ],
  ['·',  183, '267', '\302\267',     '&#183;', '&middot;',  %q{·},  '',                %q{},              'Middle dot               ' ],
  ['¸',  184, '270', '\302\270',     '&#184;', '&cedil;',   '¸',    '',                '',                'Cedilla                  ' ],
  ['¹',  185, '271', '\302\271',     '&#185;', '&sup1;',    '¹',    '',                '',                'Superscript 1           ¹' ],
  ['º',  186, '272', '\302\272',     '&#186;', '&ordm;',    'º',    '',                '',                'Masculine ordinal       º' ],
  ['»',  187, '273', '\302\273',     '&#187;', '&raquo;',   '»',    '',                '',                'Right angle quote        ' ],
  ['¼',  188, '274', '\302\274',     '&#188;', '&frac14;',  '¼',    '',                '',                'Fraction one quarter    ¼' ],
  ['½',  189, '275', '\302\275',     '&#189;', '&frac12;',  '½',    '',                '',                'Fraction on half        ½' ],
  ['¾',  190, '276', '\302\276',     '&#190;', '&frac34;',  '¾',    '',                '',                'Fraction three quarters ¾' ],
  ['¿',  191, '277', '\302\277',     '&#191;', '&iquest;',  '¿',    '',                '',                'Inverted question mark  ¿' ],
  ['À',  192, '300', '\303\200',     '&#192;', '&Agrave;',  'À',    '\`{A}',           '',                'Capital A, grave accent À' ],
  ['Á',  193, '301', '\303\201',     '&#193;', '&Aacute;',  'Á',    %q{\'{A}},         '',                'Capital A, acute accent Á' ],
  ['Â',  194, '302', '\303\202',     '&#194;', '&Acirc;',   'Â',    '^{A}',            '',                'Capital A, circumflex accent Â' ],
  ['Ã',  195, '303', '\303\203',     '&#195;', '&Atilde;',  'Ã',    '~{A}',            '',                'Capital A, tilde        Ã' ],
  ['Ä',  196, '304', '\303\204',     '&#196;', '&Auml;',    'Ä',    '"{A}',            '',                'Capital A, umlaut       Ä' ],
  ['Å',  197, '305', '\303\205',     '&#197;', '&Aring;',   'Å',    'r{A}',            '',                'Capital A, ring         Å' ],
  ['Æ',  198, '306', '\303\206',     '&#198;', '&AElig;',   'Æ',    'AE',              '',                'Capital AE ligature     Æ' ],
  ['Ç',  199, '307', '\303\207',     '&#199;', '&Ccedil;',  'Ç',    '',                '',                'Capital C, cedilla      Ç' ],
  ['È',  200, '310', '\303\210',     '&#200;', '&Egrave;',  'È',    '`{E}',            '',                'Capital E, grave accent È' ],
  ['É',  201, '311', '\303\211',     '&#201;', '&Eacute;',  'É',    ''{E}',            '',                'Capital E, acute accent É' ],
  ['Ê',  202, '312', '\303\212',     '&#202;', '&Ecirc;',   'Ê',    '^{E}',            '',                'Capital E, circumflex accent Ê' ],
  ['Ë',  203, '313', '\303\213',     '&#203;', '&Euml;',    'Ë',    '"{E}',            '',                'Capital E, umlaut       Ë' ],
  ['Ì',  204, '314', '\303\214',     '&#204;', '&Igrave;',  'Ì',    '`{I}',            '',                'Capital I, grave accent Ì' ],
  ['Í',  205, '315', '\303\215',     '&#205;', '&Iacute;',  'Í',    ''{I}',            '',                'Capital I, acute accent Í' ],
  ['Î',  206, '316', '\303\216',     '&#206;', '&Icirc;',   'Î',    '^{I}',            '',                'Capital I, circumflex accent Î' ],
  ['Ï',  207, '317', '\303\217',     '&#207;', '&Iuml;',    'Ï',    '"{I}',            '',                'Capital I, umlaut       Ï' ],
  ['Ð',  208, '320', '\303\220',     '&#208;', '&ETH;',     'Ð',    '',                '',                'Capital eth, Icelandic   ' ],
  ['Ñ',  209, '321', '\303\221',     '&#209;', '&Ntilde;',  'Ñ',    '',                '',                'Capital N, tilde        Ñ' ],
  ['Ò',  210, '322', '\303\222',     '&#210;', '&Ograve;',  'Ò',    '`{O}',            '',                'Capital O, grave accent Ò' ],
  ['Ó',  211, '323', '\303\223',     '&#211;', '&Oacute;',  'Ó',    ''{O}',            '',                'Capital O, acute accent Ó' ],
  ['Ô',  212, '324', '\303\224',     '&#212;', '&Ocirc;',   'Ô',    '^{O}',            '',                'Capital O, circumflex accent Ô' ],
  ['Õ',  213, '325', '\303\225',     '&#213;', '&Otilde;',  'Õ',    '~{O}',            '',                'Capital O, tilde        Õ' ],
  ['Ö',  214, '326', '\303\226',     '&#214;', '&Ouml;',    'Ö',    '"{O}',            '',                'Capital O, umlaut       Ö' ],
  ['×',  215, '327', '\303\227',     '&#215;', '&times;',   '×',    '',                '',                'Multiply sign           ×' ],
  ['Ø',  216, '330', '\303\230',     '&#216;', '&Oslash;',  'Ø',    'O',               '',                'Capital O, slash        Ø' ],
  ['Ù',  217, '331', '\303\231',     '&#217;', '&Ugrave;',  'Ù',    '',                '',                'Capital U, grave accent Ù' ],
  ['Ú',  218, '332', '\303\232',     '&#218;', '&Uacute;',  'Ú',    '',                '',                'Capital U, acute accent Ú' ],
  ['Û',  219, '333', '\303\233',     '&#219;', '&Ucirc;',   'Û',    '',                '',                'Capital U, circumflex accent Û' ],
  ['Ü',  220, '334', '\303\234',     '&#220;', '&Uuml;',    'Ü',    '',                '',                'Capital U, umlaut       Ü' ],
  ['Ý',  221, '335', '\303\235',     '&#221;', '&Yacute;',  'Ý',    '',                '',                'Capital Y, acute accent Ý' ],
  ['Þ',  222, '336', '\303\236',     '&#222;', '&THORN;',   'Þ',    '',                '',                'Capital thorn, Icelandic     Þ' ],
  ['ß',  223, '337', '\303\237',     '&#223;', '&szlig;',   'ß',    '',                '',                'Small sz ligature, German    ß' ],
  ['à',  224, '340', '\303\240',     '&#224;', '&agrave;',  'à',    '\`{a}',           '',                'Small a, grave accent   à' ],
  ['á',  225, '341', '\303\241',     '&#225;', '&aacute;',  'á',    %q{\'{a}},         '',                'Small a, acute accent   á' ],
  ['â',  226, '342', '\303\242',     '&#226;', '&acirc;',   'â',    '\^{a}',           '',                'Small a, circumflex accent   â' ],
  ['ã',  227, '343', '\303\243',     '&#227;', '&atilde;',  'ã',    '\~{a}',           '',                'Small a, tilde          ã' ],
  ['ä',  228, '344', '\303\244',     '&#228;', '&auml;',    'ä',    '\"{a}',           '',                'Small a, umlaut         ä' ],
  ['å',  229, '345', '\303\245',     '&#229;', '&aring;',   'å',    '\r{a}',           '',                'Small a, ring           å' ],
  ['æ',  230, '346', '\303\246',     '&#230;', '&aelig;',   'æ',    '\ae',             '',                'Small ae ligature       æ' ],
  ['ç',  231, '347', '\303\257',     '&#231;', '&ccedil;',  'ç',    '',                '',                'Small c, cedilla        ç' ],
  ['è',  232, '350', '\303\250',     '&#232;', '&egrave;',  'è',    '\`{e}',           '',                'Small e, grave accent   è' ],
  ['é',  233, '351', '\303\251',     '&#233;', '&eacute;',  'é',    %q{\'{e}},         '',                'Small e, acute accent   é' ],
  ['ê',  234, '352', '\303\252',     '&#234;', '&ecirc;',   'ê',    '\^{e}',           '',                'Small e, circumflex accent   ê' ],
  ['ë',  235, '353', '\303\253',     '&#235;', '&euml;',    'ë',    '\"{e}',           '',                'Small e, umlaut         ë' ],
  ['ì',  236, '354', '\303\254',     '&#236;', '&igrave;',  'ì',    '\`{i}',           '',                'Small i, grave accent   ì' ],
  ['í',  237, '355', '\303\255',     '&#237;', '&iacute;',  'í',    '\'{i}',           '',                'Small i, acute accent   í' ],
  ['î',  238, '356', '\303\256',     '&#238;', '&icirc;',   'î',    '\^{i}',           '',                'Small i, circumflex accent   î' ],
  ['ï',  239, '357', '\303\257',     '&#239;', '&iuml;',    'ï',    '\"{i}',           '',                'Small i, umlaut         ï' ],
  ['ð',  240, '360', '\303\260',     '&#240;', '&eth;',     'ð',    '',                '',                'Small eth, Icelandic    ð' ],
  ['ñ',  241, '361', '\303\261',     '&#241;', '&ntilde;',  'ñ',    '',                '',                'Small n, tilde          ñ' ],
  ['ò',  242, '362', '\303\262',     '&#242;', '&ograve;',  'ò',    '\`{o}',           '',                'Small o, grave accent   ò' ],
  ['ó',  243, '363', '\303\263',     '&#243;', '&oacute;',  'ó',    %q{\'{o}},         '',                'Small o, acute accent   ó' ],
  ['ô',  244, '364', '\303\264',     '&#244;', '&ocirc;',   'ô',    '\^{o}',           '',                'Small o, circumflex accent   ô' ],
  ['õ',  245, '365', '\303\265',     '&#245;', '&otilde;',  'õ',    '\^{o}',           '',                'Small o, tilde          õ' ],
  ['ö',  246, '366', '\303\266',     '&#246;', '&ouml;',    'ö',    '\"{o}',           '',                'Small o, umlaut         ö' ],
  ['÷',  247, '367', '\303\267',     '&#247;', '&divide;',  '÷',    '',                '',                'Divide sign             ÷' ],
  ['ø',  248, '370', '\303\270',     '&#248;', '&oslash;',  'ø',    '',                '',                'Small o, slash          ø' ],
  ['ù',  249, '371', '\303\271',     '&#249;', '&ugrave;',  'ù',    '\`{u}',           '',                'Small u, grave accent   ù' ],
  ['ú',  250, '372', '\303\272',     '&#250;', '&uacute;',  'ú',    %q{\'{u}},         '',                'Small u, acute accent   ú' ],
  ['û',  251, '373', '\303\273',     '&#251;', '&ucirc;',   'û',    '\^{u}',           '',                'Small u, circumflex accent   û' ],
  ['ü',  252, '374', '\303\274',     '&#252;', '&uuml;',    'ü',    '\"{u}',           '',                'Small u, umlaut         ü' ],
  ['ý',  253, '375', '\303\275',     '&#253;', '&yacute;',  'ý',    '',                '',                'Small y, acute accent   ý' ],
  ['þ',  254, '376', '\303\276',     '&#254;', '&thorn;',   'þ',    '',                '',                'Small thorn, Icelandic  þ' ],
  ['ÿ',  255, '377', '\303\277',     '&#255;', '&yuml;',    'ÿ',    '',                '',                'Smally y, umlaut        ÿ' ],
  ['∝',     ,    '',         '',    '&#8733;', '&prop;',    '∝',    '',                '',                'proportional to  U+221D (8733) ∝' ],
  ['∞',     ,    '',         '',    '&#8734;', '&infin;',   '∞',    '',                '',                'infinity  U+221E (8734) ∞' ],
]
    end
  end
end
__END__
