# coding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search
   minitoc

 * Author: Ralph Amissah

 * Copyright: (C) 1997 - 2009 Ralph Amissah All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/copyleft/gpl.html>

   <http://www.jus.uio.no/sisu/gpl.fsf/toc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/doc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/plain.txt>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: system environment, resource control and configuration details

=end
  module SiSU_HTML_minitoc
    require "#{SiSU_lib}/html_tune"
    include SiSU_HTML_Tune
    class Toc_mini
      @@seg_mini=nil
      @@seg_url=''
      @@dp,@@firstseg=nil,nil
      def initialize(md,data)
        @md,@data=md,data
        @dp=@@dp ||=SiSU_Env::Info_env.new.digest.pattern
        @pat_heading=/^#{Mx[:lv_o]}[1-6]:\S*?#{Mx[:lv_c]}\s*(.*)#{Mx[:id_o]}~(\d+);(?:[hm]|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]}$/
        @pat_strip_heading_name=/<a name="h?\d.*?">(.+?)<\/a>/
        @tell=SiSU_Screen::Ansi.new(@md.cmd) if @md
      end
      def songsheet
        SiSU_Screen::Ansi.new(@md.cmd,'Toc').txt_grey unless @md.cmd =~/q/
        toc=nil
        @toc=[]
        @data.each do |txt|
          if txt =~/^(?:#{Mx[:lv_o]}[1-6]:|4~!)/
            txt.gsub!(/(?:#{Mx[:en_a_o]}|#{Mx[:en_b_o]}).+?(?:#{Mx[:en_a_c]}|#{Mx[:en_b_c]})/m,'') #remove endnotes from toc
            txt.gsub!(/<a name="-\d+" href="#_\d+">&nbsp;<sup>\d+<\/sup>&nbsp;<\/a>/,'')
            txt.gsub!(@pat_strip_heading_name,'\1')
            txt.gsub(/(.*?)<a name="(\d+)"><\/a>(.*)/,'\1') #2002w42 altered gsub! - problematic? - suspect
            toc=case txt
            when /^\s*#{Mx[:lv_o]}1:\S*/; Toc_mini.new(@md,txt).level_1
            when /^\s*#{Mx[:lv_o]}2:\S*/; Toc_mini.new(@md,txt).level_2
            when /^\s*#{Mx[:lv_o]}3:\S*/; Toc_mini.new(@md,txt).level_3
            when /^\s*#{Mx[:lv_o]}4:\S+/; Toc_mini.new(@md,txt).level_4
            when /^\s*#{Mx[:lv_o]}5:\S*/; Toc_mini.new(@md,txt).level_5
            when /^\s*#{Mx[:lv_o]}6:\S*/; Toc_mini.new(@md,txt).level_6
            when /^\s*4~!/;      Toc.new(txt).level_crosslink
            else
            end
            @toc << toc
          end
        end
        @toc
      end
    protected
      def level_concordance
        format_head_toc=SiSU_HTML_Format::Head_toc.new(@md)
        @@seg_mini << format_head_toc.mini_seg_concordance
      end
      def level_metadata
        format_head_toc=SiSU_HTML_Format::Head_toc.new(@md)
        @@seg_mini << format_head_toc.mini_seg_metadata
      end
      def level_word_index
        format_head_toc=SiSU_HTML_Format::Head_toc.new(@d0c)
        @@seg_mini << format_head_toc.mini_concordance
      end
      def level_1
        txt=@data
        unless txt =~/#{Mx[:id_o]}~0;(?:\w|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]}$/
          txt.gsub!(@pat_strip_heading_name,'\1')
        end
        txt[@pat_heading]
        linkname,ocn=$1.strip,$2 if $&
          title=unless txt =~/Document Information/; linkname
        else
          link='metadata'
          %{<b><a href="#{@md.fnl[:pre]}#{link}#{@md.fnl[:mid]}#{Sfx[:html]}#{@md.fnl[:post]}">#{linkname}</a></b>}
        end
        toc={}
        txt_obj={:txt =>title}
        format_toc=SiSU_HTML_Format::Format_toc.new(@md,txt_obj)
        toc_mini=if txt =~/^#{Mx[:lv_o]}\d:meta#{Mx[:lv_c]}\s*Document Information/
          format_toc.mini_tail
        else format_toc.mini_lev1
        end
        toc_mini
      end
      def level_2
        txt=@data
        unless txt =~/#{Mx[:id_o]}~0;(?:\w|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]}$/
          txt.gsub!(@pat_strip_heading_name,'\1')
        end
        txt[@pat_heading]
        linkname,ocn=$1.strip,$2 if $&
        txt_obj={:txt =>linkname}
        format_toc=SiSU_HTML_Format::Format_toc.new(@md,txt_obj)
        toc_mini=format_toc.mini_lev2
        toc_mini
      end
      def level_3
        txt=@data
        txt[@pat_heading]
        linkname,ocn=$1.strip,$2 if $&
        txt_obj={:txt =>linkname}
        format_toc=SiSU_HTML_Format::Format_toc.new(@md,txt_obj)
        toc_mini=format_toc.mini_lev3
        toc_mini
      end
      def level_4
        txt=@data
        unless txt =~/~metadata/
          unless txt =~/#{Mx[:id_o]}~0;(?:\w|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]}$/
            txt.gsub!(@pat_strip_heading_name,'\1')
            txt[@pat_heading]
            linkname,ocn=$1.strip,$2 if $&
          end
          txt.gsub!(/#{Mx[:id_o]}~0;(?:\w|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]}$/,'')
          if txt =~/^#{Mx[:lv_o]}4:/
            seg_link=txt.gsub(/^\s*#{Mx[:lv_o]}4:(\S+?)#{Mx[:lv_c]}\s*(.+?)$/,
              %{  <a href="#{@md.fnl[:pre]}\\1#{@md.fnl[:mid]}#{Sfx[:html]}#{@md.fnl[:post]}" target="_top">
    \\2
  </a> })
            if seg_link =~/(#{Mx[:id_o]}\~\d+;(?:\w|[0-6]:\d+);\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]})$/m
              m=/#{$1}/m
              seg_link.gsub!(m,'')
            end
            @@seg_url=txt[/^#{Mx[:lv_o]}4:(\S+?)#{Mx[:lv_c]}.+?$/,1]
          elsif txt =~/\d+.\d+.\d+.\d+|\d+.\d+.\d+|\d+.\d+|\d+/
            seg_link=txt.gsub(/^\s*(#{@md.lv4}\s+)\s*(\d+.\d+.\d+.\d+|\d+.\d+.\d+|\d+.\d+|\d+)(.*)/,
              %{<a href="#{@md.fnl[:pre]}\\2#{@md.fnl[:mid]}#{Sfx[:html]}#{@md.fnl[:post]}" } +
              %{target="_top">\\1 \\2 \\3</a> })
          end
          txt_obj={:txt =>seg_link}
          format_toc=SiSU_HTML_Format::Format_toc.new(@md,txt_obj)
          toc_mini=format_toc.mini_lev4
          toc_mini
        end
      end
      def level_5
        txt=@data
        if txt !~/#{Mx[:id_o]}~0;(?:\w|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]}$/
          txt.gsub!(@pat_strip_heading_name,'\1')
        end
        txt[@pat_heading]
        linkname,ocn=$1.strip,$2 if $&
        if ocn \
        and ocn !~/#/
          p_num=SiSU_HTML_Format::Paragraph_number.new(@md,ocn)
        end
        toc={}
        if txt =~/#{Mx[:id_o]}~0;(?:\w|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]}$/
          m=/#{$1}/
          txt.gsub!(m,'')
          title=linkname
        else
          lnk_n_txt=%{  <a href="#{@md.fnl[:pre]}#{@@seg_url}#{@md.fnl[:mid]}#{Sfx[:html]}#{@md.fnl[:post]}##{ocn}">
    #{linkname}
  </a>}
          txt_obj={:txt =>lnk_n_txt}
          format_toc=SiSU_HTML_Format::Format_toc.new(@md,txt_obj)
          toc_mini=format_toc.mini_lev5
        end
        toc_mini
      end
      def level_6
        txt=@data
        if txt !~/#{Mx[:id_o]}~0;(?:\w|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]}$/
          txt.gsub!(@pat_strip_heading_name,'\1')
        end
        txt[@pat_heading]
        linkname,ocn=$1.strip,$2 if $&
        if ocn \
        and ocn !~/#/
          p_num=SiSU_HTML_Format::Paragraph_number.new(@md,ocn)
        end
        toc={}
        if txt =~/#{Mx[:id_o]}~0;(?:\w|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]}$/
          m=/#{$1}/
          txt.gsub!(m,'')
          title=linkname
        else
          lnk_n_txt=%{  <a href="#{@md.fnl[:pre]}#{@@seg_url}#{@md.fnl[:mid]}#{Sfx[:html]}#{@md.fnl[:post]}##{ocn}">
    #{linkname}
  </a>}
          txt_obj={:txt =>lnk_n_txt}
          format_toc=SiSU_HTML_Format::Format_toc.new(@md,txt_obj)
          toc_mini=format_toc.mini_lev6
        end
        toc_mini
      end
    end
  end
__END__

