# coding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search
   harvest metadata from document corpus (suitable for medium sized sites)
   (concept example, [to remove size constraint: implement SQL equivalent])

 * Author: Ralph Amissah

 * Copyright: (C) 1997 - 2009 Ralph Amissah All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/copyleft/gpl.html>

   <http://www.jus.uio.no/sisu/gpl.fsf/toc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/doc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/plain.txt>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: system environment, resource control and configuration details

=end
def help
  puts <<WOK
  harvest --harvest   extracts document index metadata

WOK
end
def css(opt)
  require "#{SiSU_lib}/css"
  css=SiSU_Style::CSS.new
  fn_css=SiSU_Env::CSS_default.new
  style=File.new("#{@env.path.pwd}/#{fn_css.harvest}",'w')
  #style=File.new("#{@env.path.pwd}/harvest.css",'w')
  style << css.harvest
  style.close
end
def cases(opt)
  case opt.mod.inspect
  when/--harvest/i
    css(opt) if opt.cmd.inspect =~/M/
    HARVEST_authors::Songsheet.new(opt).songsheet
    HARVEST_topics::Songsheet.new(opt).songsheet
    if opt.cmd.inspect =~/R/
      require "#{SiSU_lib}/remote"
      SiSU_Remote::Put.new(opt).rsync_harvest
    end
  else
    help
  end
end
require "#{SiSU_lib}/options"
require "#{SiSU_lib}/harvest_topics"
require "#{SiSU_lib}/harvest_authors"
require "#{SiSU_lib}/sysenv"
include SiSU_Env
@env=SiSU_Env::Info_env.new
@@the_idx_topics,@@the_idx_authors={},{}
argv=$*
opt=SiSU_commandline::Options.new(argv)
argv.shift
#instruct = 'help' if opt.mod.nil? or instruct == ''
mkdir_p(@env.path.output_md_harvest) unless FileTest.directory?(@env.path.output_md_harvest)
cases(opt)
__END__
