# coding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997 - 2009 Ralph Amissah All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.jus.uio.no/sisu/gpl.fsf/toc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/doc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/plain.txt>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: html formating, css template

=end
module SiSU_HTML_Format
  include SiSU_Viz
  class Paragraph_number
    def initialize(md,ocn)
      @md,@ocn=md,ocn[/(\d+)/m,1]
      @ocn ||=''
      vz=SiSU_Env::Get_init.instance.skin
      @skin_no_ocn=if defined? vz.ocn_display_off \
      and vz.ocn_display_off == true
        true
      else false
      end
    end
    def ocn_display
      if @md.markup.inspect =~/no_ocn/ \
      or @md.mod.inspect =~/--no-ocn/ \
      or @skin_no_ocn
        ocn_class='ocn_off'
        @ocn.gsub(/^(\d+|)$/,
        %{<label class="#{ocn_class}">&nbsp;</label>})
      elsif @ocn.to_i == 0
        @ocn.gsub(/^(\d+|)$/,
        %{<label class="#{ocn_class}"><a name="#{@ocn}">&nbsp;</a></label>})
      else
        ocn_class='ocn'
        @ocn.gsub(/^(\d+|)$/,
        %{<label class="#{ocn_class}"><a name="#{@ocn}">\\1</a></label>})
      end
    end
    def name
      %{<a name="#{@ocn}"></a>}
    end
    def id #w3c? "tidy" complains about numbers as identifiers ! annoying
      %{id="o#{@ocn}"}
    end
    def goto
      %{<a href="##{@ocn}">}
    end
  end
  class Head_information
    include SiSU_Viz
    attr_reader :md,:sfx,:pdf,:rdf,:vz
    def initialize(md)
      @md=md
      @sfx,@pdf=@md.sfx,@md.pdf
      @rdf=SiSU_XML_tags::RDF.new(md)
      # DublinCore 1 - title
      @vz=SiSU_Env::Get_init.instance.skin
      @css=SiSU_Env::CSS_stylesheet.new(md)
      @seg_name_html=(SiSU_HTML::Source::Seg.new.seg_name_html || [])
      @seg_name_html_tracker=(SiSU_HTML::Source::Seg.new.seg_name_html_tracker || [])
      case @md.file_type
      when /php/; @index='index' # @index="index.php"
      else        @index='index'
      end
      @metalink='#metadata'
      @tocband_scroll,@tocband_segtoc=nil,nil
    end
    def doc_type
      %{<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">\n}
    end
    def toc_head_escript #embedded script in this case PHP
      # %{<p>PHP or other embedded script for object persistence may go HERE</p>}
    end
    def seg_head_escript #embedded script in this case PHP
      # %{<p>PHP or other embedded script for object persistence may go HERE</p>}
    end
    def table_close
      %{  </font>
#{@vz.table_close}}
    end
    def buttons_home
      %{<!- home and index buttons -!>
  #{@vz.banner_home_and_index_buttons}
<!- home and index buttons -!>}
    end
    def copyat
      %{#{@vz.paragraph_font_tiny}copy @
  <a href="#{@vz.url_home}" #{@vz.js_home}>
    #{@vz.txt_home}
  </a></h1>}
    end
    def html_close #moved
    %{</body>
</html>}
    end
  end
  class Widget < Head_information
    def initialize(md)
      super(md)
      @md=md
      @cf_defaults=SiSU_Env::Info_processing_flag.new
    end
    def home
      %{<td align="center" bgcolor=#{@vz.color_band2}>
  <a href="../index.html" target="_top">
  #{@vz.png_homepage}</a>
</td>
}
    end
    def scroll(text)
      if @md.fns =~ /\.(?:-|ssm\.)?sst$/
        scroll=%{<td align="center" bgcolor=#{@vz.color_band2}>
  <a href="#{@md.fn[:doc]}" target="_top" #{@vz.js_doc}>
    #{text}
  </a>
</td>
}
      end
    end
    def seg(text)
      %{<td align="center" bgcolor="#99CC66">
  <a href="#{@md.fn[:toc]}" target="_top" #{@vz.js_doc}>
    #{text}
  </a>
</td>
}
    end
    def search
      env=SiSU_Env::Info_env.new(@md.fns,@md)
      env.widget.search_form('sisusearch',nil,nil,true)
    end
    def manifest
      %{<td align="center" bgcolor=#{@vz.color_band2}>
  <a href="#{@md.fn[:manifest]}" target="_top" #{@vz.js_manifest}>
    #{@vz.nav_txt_manifest}
  </a>
</td>}
    end
    def pdf
      pdf=if @md.programs[:pdf] \
      and @cf_defaults.cf_0 =~/p/
        %{
<td align="center" bgcolor=#{@vz.color_band2}>
  <a href="#{@md.fn[:pdf_p]}" target="_top" #{@vz.js_portrait}>
    #{@vz.nav_txt_pdf_portrait}
  </a>
</td>
<td align="center" bgcolor=#{@vz.color_band2}>
  <a href="#{@md.fn[:pdf_l]}" target="_top" #{@vz.js_landscape}>
    #{@vz.nav_txt_pdf_landscape}
  </a>
</td>
}
      else ''
      end
    end
    def odf
      odf=if @cf_defaults.cf_0 =~/o/
        %{
<td align="center" bgcolor=#{@vz.color_band2}>
  <a href="#{@md.fn[:odf]}" target="_top" #{@vz.js_odf}>
    #{@vz.nav_txt_odf}
  </a>
</td>}
      else ''
      end
    end
    def concordance(text)
      if @md.concord_make \
      and @md.wc_words < 300000 #max word count for display of concordance here as would now be a large file
  %{<td align="center" bgcolor=#{@vz.color_band2}>
    <a href="#{@md.fn[:concordance]}" target="_top" #{@vz.js_concordance}>
      #{text}
    </a>
  </td>}
      else ''
      end
    end
  end
  class XML
  end
  class Head_toc < Head_information
    def initialize(md)
      super(md)
      @md=md
      @tocband_scroll,@tocband_segtoc=make_scroll,make_seg
    end
    def scroll_head_navigation_band
      pdf=if @md.programs[:pdf]
        <<WOK
<td align="center" width="60%">
  #{make_seg_scroll_pdf}
</td>
WOK
      else ''
      end
      %{<table summary="table of contents scroll navigation band" id="toc" width="100%" bgcolor=#{@vz.color_band1}>
<tr><td width="20%">
  #{@vz.banner_band}
</td>#{pdf}
<td width="20%">
  &nbsp;
#{@vz.table_close}
<p />}
    end
    def concordance_navigation_band(type='')
      if type=~/pdf/
        @tocband_concordance=make_concordance
      end
      %{<table summary="concordance navigation band" id="toc" width="100%" bgcolor=#{@vz.color_band1}>
<tr><td width="20%">
 #{@vz.banner_band}
</td>
<td width="60%" align="center">
  #@tocband_concordance
</td>
<td width="20%" align="right">
  &nbsp;<a href="index.html" target="_top" alt="-&gt;">
      #{@vz.png_nav_toc}
    </a>&nbsp;
#{@vz.table_close}
<p />}
    end
    def seg_head_navigation_band(type='')
      if type=~/pdf/
        @tocband_segtoc=make_scroll_seg_pdf
      end
      firstseg=%{<a href="#{@md.fnl[:pre]}#{@md.firstseg}#{@md.fnl[:mid]}#@sfx#{@md.fnl[:post]}" target="_top" alt="-&gt;">
      #{@vz.png_nav_nxt}
    </a>} if @md.firstseg =~/\S+/
      %{<table summary="table of contents segment navigation band" id="toc" width="100%" bgcolor=#{@vz.color_band1}>
<tr><td width="20%">
 #{@vz.banner_band}
</td>
<td width="60%" align="center">
  #@tocband_segtoc
</td>
<td width="20%" align="right">
  &nbsp;#{firstseg}&nbsp;
#{@vz.table_close}
<p />}
    end
    def seg_head_navigation_band_bottom(type='')
      if type=~/pdf/
        @tocband_segtoc=make_scroll_seg_pdf
      end
      firstseg=%{<a href="#{@md.fnl[:pre]}#{@md.firstseg}#{@md.fnl[:mid]}#@sfx#{@md.fnl[:post]}" target="_top" alt="-&gt;">
      #{@vz.png_nav_nxt}
    </a>} if @md.firstseg =~/\S+/
      %{<table summary="table of contents segment navigation band" id="toc" width="100%" bgcolor=#{@vz.color_band1}>
<tr><td width="20%">
 &nbsp;
</td>
<td width="60%" align="center">
  #@tocband_segtoc
</td>
<td width="20%" align="right">
  &nbsp;#{firstseg}&nbsp;
#{@vz.table_close}
<p />}
    end
    def manifest_link(text)
  %{<font size=2>
    <a href="#{@md.fn[:manifest]}" target="_top" #{@vz.js_manifest}>#{text}</a>
  </font>}
    end
    def concordance_link(text)
      if @md.concord_make
  %{<font size=2>
    <a href="#{@md.fn[:concordance]}" target="_top" #{@vz.js_concordance}>
      #{text}
    </a>
  </font>}
      else ''
      end
    end
    def make_seg_scroll_pdf
      wgt=Widget.new(@md)
      scroll=%{<td align="center" bgcolor=#{@vz.color_band2}>
  #{@vz.nav_txt_doc_link}
</td>
}
      %{<table summary="toc segment and scroll with pdf" border="0" cellpadding="3" cellspacing="0">
<tr>
  #{scroll}
  #{wgt.seg(@vz.nav_txt_toc_link)}#{wgt.pdf}#{wgt.odf}
  #{wgt.concordance(@vz.nav_txt_concordance)}
  #{wgt.manifest}
  #{wgt.search}
  #{wgt.home}
</tr></table>}
    end
    def make_scroll_seg_pdf
      manifest=scroll=seg=''
      wgt=Widget.new(@md)
      seg=%{<td align="center" bgcolor=#{@vz.color_band2}>
  #{@vz.nav_txt_toc_link}
</td>
}
      %{<table summary="toc scroll and segment with pdf" border="0" cellpadding="3" cellspacing="0">
<tr>
  #{seg}
  #{wgt.scroll(@vz.nav_txt_doc_link)}#{wgt.pdf}#{wgt.odf}
<td align="center" bgcolor=#{@vz.color_band2}>
  #{wgt.concordance(@vz.nav_txt_concordance)}
  #{wgt.manifest}
  #{wgt.search}
  #{wgt.home}
</tr></table>}
    end
    def make_concordance
      manifest=scroll=seg=''
      wgt=Widget.new(@md)
      %{<table summary="toc scroll and segment with pdf" border="0" cellpadding="3" cellspacing="0">
<tr>
  #{wgt.seg(@vz.nav_txt_toc_link)}#{wgt.scroll(@vz.nav_txt_doc_link)}#{wgt.pdf}#{wgt.odf}
<td align="center" bgcolor=#{@vz.color_band2}>
  #{wgt.concordance(@vz.nav_txt_concordance)}
  #{wgt.manifest}
  #{wgt.search}
  #{wgt.home}
</tr></table>}
    end
    def head
      %{#{doc_type}
<head>
  <title>
    #{@md.html_title}
  </title>
<meta http-equiv="Content-Type" content="text/html;charset=utf-8" />
#{@rdf.rdftoc}
#{@rdf.metatag_html}
#{@css.html}
</head>
#{@vz.color_body}
<a name="top" id="top"></a>
<a name="up" id="up"></a>
<a name="start" id="start"></a>
#{@vz.js_top}}
    end
    def concordance
      if @md.concord_make
      %{#{@vz.margin_css}
  <h4 class="toc">
    <a href="./#{@md.fn[:concordance]}" #{@vz.js_concordance}>
      <i>Concordance</i>
    </a>
  </h4>
#{@vz.table_close}}
      else
      %{#{@vz.margin_css}
#{@vz.table_close}}
      end
    end
    def links_guide_vertical_open #???
      url=(defined? @vz.url_hp) && @vz.url_hp =~/^http:\/\/\S+$/ ? @vz.url_hp : @vz.url_home
      %{
<div id="vertical_links">
  <ul id="vertical">
  <li class="refbold">
    <a href="#{url}" #{@vz.js_home}>
      #{@vz.txt_hp}
    </a>
  </li>
  <li class="ref">
     Quick Ref.:
  </li>
  <li class="ref">
    <a href="#{@md.fn[:manifest]}" alt="Document Manifest" target="_top">
      Manifest
    </a>
  </li>
<!- quick ref -!>}
    end
    def links_guide_horizontal_open #???
      url=(defined? @vz.url_hp) && @vz.url_hp =~/^http:\/\/\S+$/ ? @vz.url_hp : @vz.url_home
      %{
<div id="horizontal_links">
  <ul id="horizontal">
  <li class="refbold">
    <a href="#{url}" #{@vz.js_home}>
      #{@vz.txt_hp}
    </a>
  </li>
  <li class="ref">
     Quick Ref.:
  </li>
  <li class="ref">
    <a href="#{@md.fn[:manifest]}" alt="Document Manifest" target="_top">
      Manifest
    </a>
  </li>
<!- quick ref -!>}
    end
    def links_guide_open(type='horizontal')
      if type=='vertical'; links_guide_vertical_open
      else                 links_guide_horizontal_open
      end
    end
    def links_guide_close #(type='horizontal')
      insert=''
      insert=@vz.banner_home_guide if @md.sfx_src =~/lm?/
      #insert=@vz.banner_home_guide if @md.sfx_src =~/s?/
      insert=if @md.sfx_src =~/s?/
        link='http://www.jus.uio.no/sisu'                      #get from defaults
        url='www.jus.uio.no/sisu'
        name='SiSU electronic documents'                            #get from defaults
        #name='SiSU electronic documents/books'                      #get from defaults
        insert= %{  <li class="refbold">
    <a href="#{link}" alt="#{name}" target="_top">
      #{name}
    </a>
  </li>
  <li class="ref">
    <a href="#{link}" alt="#{name}" target="_top">
      #{url}
    </a>
  </li>
  </ul>
</div>
}
      end
      %{ #{insert}
<!- quick ref -!>}
    end
    def prefix_a
    end
    def rights
      rights=@md.rights.gsub(/^\s*Copyright\s+\(C\)/,'Copyright <sup>&copy;</sup>&nbsp;')
      %{<p class="small_left">Rights: #{rights}</p>
<p />}
    end
    def prefix_b
      %{<p class="small_left">Prefix: #{@md.prefix_b}<p />}
    end
    def scroll_head_title_banner_open
      %{<center>
#{@md.icon}
</center>
#{@vz.banner_instrument_cover_band_scr}}
    end
    def seg_head_title_banner_open
      %{<center>
  #{@md.icon}
</center>
#{@vz.banner_instrument_cover_band_seg}}
    end
    def make_scroll
      concord=concordance_link(@vz.nav_txt_concordance)
      %{<table summary="toc scroll" border="0" cellpadding="3" cellspacing="0">
<tr><td align="center" bgcolor="white" border="0">
  #{@vz.nav_txt_doc_link}
</td>
<td align="center" bgcolor="white">
   #{concord}
#{@vz.table_close}}
    end
    def make_seg
      concord=concordance_link(@vz.nav_txt_concordance)
      %{<table summary="toc segment" border="0" cellpadding="3" cellspacing="0">
<tr><td align="center" bgcolor="white">
  #{@vz.nav_txt_toc_link}
</td>
<td align="center" bgcolor="white">
  <font size=2>
   #{concord}
#{@vz.table_close}}
    end
    def manifest #check structure
      manifest=manifest_link(@vz.nav_txt_manifest)
      %{#{@vz.margin_txt_3}
  #{@vz.paragraph_font_small}
   #{manifest}
    </font>
#{@vz.table_close}}
    end
    def concordance #check structure
      concord=concordance_link(@vz.nav_txt_concordance)
      %{#{@vz.margin_txt_3}
  #{@vz.paragraph_font_small}
   #{concord}
    </font>
#{@vz.table_close}}
    end
    def metadata
      %{#{@vz.margin_css}
  <h4 class="toc">
    <a href="#@metalink" #{@vz.js_metalink}>
      <i>MetaData</i>
    </a>
  </h4>
#{@vz.table_close}}
    end
    def seg_metadata
      @metalink=%{./#{@md.fn[:metadata]}}
      metadata
    end
    def seg_tail
      %{
<div class="main_column">
<p>&nbsp;<p>
<table summary="toc segment tail" bgcolor=#{@vz.color_band1}>
<tr><td width="20%">
  #{@vz.banner_band}
</td>
<td width="60%">
  <center>
    #{@tocband_segtoc}
  </center>
</td></tr>
</table>
<p>&nbsp;</p>
#{@vz.credits_splash}
#{@vz.credits_sisu}
<a name="bottom" id="bottom"></a>
<a name="down" id="down"></a>
<a name="end" id="end"></a>
<a name="finish" id="finish"></a>
<a name="stop" id="stop"></a>
<a name="credits"></a>
</div>
</div>
</div>
}
    end
    def scroll_tail #debug
      nav=scroll_head_navigation_band
      %{
<div class="main_column">
#{nav}
#{@vz.credits_splash}
#{@vz.credits_sisu}
<a name="bottom" id="bottom"></a>
<a name="down" id="down"></a>
<a name="end" id="end"></a>
<a name="finish" id="finish"></a>
<a name="stop" id="stop"></a>
<a name="credits"></a>
</div>
</div>
</div>
}
    end
    def seg_navigation_tail #this is a bug area, look up and "tidy"
      #nav=scroll_head_navigation_band
      %{
<div class="main_column">
<p>&nbsp;</p>
#{@vz.credits_splash}
#{@vz.credits_sisu}
<a name="bottom" id="bottom"></a>
<a name="down" id="down"></a>
<a name="end" id="end"></a>
<a name="finish" id="finish"></a>
<a name="stop" id="stop"></a>
<a name="credits"></a>
</div>
</div>
</div>
}
    end
  end
  class Head_seg < Head_information
    def initialize(md) #(md='')
      super(md)
    end
    def head
      %{#{doc_type}
<head>
  <title>
    #{@seg_name_html[@seg_name_html_tracker]} -
    #{@md.html_title}
  </title>
<meta http-equiv="Content-Type" content="text/html;charset=utf-8" />
#{@rdf.rdfseg}
#{@rdf.metatag_html}
#{@vz.font_css_table_file}
</head>
#{@vz.color_body}
<a name="top" id="top"></a>
<a name="up" id="up"></a>
<a name="start" id="start"></a>
#{@vz.js_top}}
    end
    def title_banner(title,subtitle,creator)
    end
    def dot_control_pre_next
      %{<table summary="segment hidden control pre and next" width="100%" border="0" cellpadding="0" bgcolor=#{@vz.color_grey_pale} align="center">
<tr><td align="left">
  <a href="#{@md.fnl[:pre]}#{@seg_name_html[@seg_name_html_tracker-1]}#{@md.fnl[:mid]}#@sfx#{@md.fnl[:post]}" target="_top" #{@vz.js_prev}>
    #{@vz.png_nav_dot_pre}
  </a>
</td>
<td align="center">
  <a href="#{@md.fnl[:pre]}#@index#{@md.fnl[:mid]}#@sfx#{@md.fnl[:post]}" target="_top" #{@vz.js_toc}>
    #{@vz.png_nav_dot_toc}
  </a>
</td>
<td align="right">
  <a href="#{@md.fnl[:pre]}#{@seg_name_html[@seg_name_html_tracker+1]}#{@md.fnl[:mid]}#@sfx#{@md.fnl[:post]}" target="_top" #{@vz.js_next}>
    #{@vz.png_nav_dot_nxt}
  </a>
#{@vz.table_close}}
    end
    def dot_control_pre
      %{<table summary="segment hidden control pre" width="100%" border="0" cellpadding="0" bgcolor=#{@vz.color_grey_pale} align="center">
<tr><td align="left">
  <a href="#{@md.fnl[:pre]}#{@seg_name_html[@seg_name_html_tracker-2]}#{@md.fnl[:mid]}#@sfx#{@md.fnl[:post]}" target="_top" #{@vz.js_prev}>
    #{@vz.png_nav_dot_pre}
  </a>
</td>
<td align="center">
  <a href="#{@md.fnl[:pre]}#@index#{@md.fnl[:mid]}#@sfx#{@md.fnl[:post]}" target="_top" #{@vz.js_toc}>
    #{@vz.png_nav_dot_toc}
  </a>
</td>
<td align="right">
  <a href="#{@md.fn[:toc]}" target="_top" #{@vz.js_next}>
    #{@vz.png_nav_dot_nxt}
  </a>
#{@vz.table_close}}
    end
    def toc_nav(f_pre=false,f_nxt=false,use=1)
      pre=nxt=''
      toc=%{<td align="center" bgcolor=#{@vz.color_band1}>
  <a href="#{@md.fnl[:pre]}#@index#{@md.fnl[:mid]}#@sfx#{@md.fnl[:post]}" target="_top" #{@vz.js_toc}>
    #{@vz.png_nav_toc}
  </a>
</td>}
      pre=%{<td align="center" bgcolor=#{@vz.color_band1}>
  <a href="#{@md.fnl[:pre]}#{@seg_name_html[@seg_name_html_tracker-use]}#{@md.fnl[:mid]}#@sfx#{@md.fnl[:post]}" target="_top" #{@vz.js_prev}>
    #{@vz.png_nav_pre}
  </a>
</td>} if f_pre==true
      nxt=%{<td align="center" bgcolor=#{@vz.color_band1}>
  <a href="#{@md.fnl[:pre]}#{@seg_name_html[@seg_name_html_tracker+1]}#{@md.fnl[:mid]}#@sfx#{@md.fnl[:post]}" target="_top" #{@vz.js_next}>
    #{@vz.png_nav_nxt}
  </a>
</td>} if f_nxt==true
      %{<table summary="segment navigation pre/next" border="0" cellpadding="3" cellspacing="0">
<tr>
#{pre}
#{toc}
#{nxt}
<td>
#{@vz.table_close}}
    end
    def toc_next2
      pre,nxt=false,true
      toc_nav(false,true).dup
    end
    def toc_pre_next2
      toc_nav(true,true).dup
    end
    def toc_pre2
      toc_nav(true,false,2).dup
    end
    def manifest_link(text)
  %{<font size=2>
    <a href="#{@md.fn[:manifest]}" target="_top" #{@vz.js_manifest}>
      #{text}
    </a>
  </font>}
    end
    def concordance_link(text)
      if @md.concord_make
  %{<font size=2>
    <a href="#{@md.fn[:concordance]}" target="_top" #{@vz.js_concordance}>
      #{text}
    </a>
  </font>}
      else ''
      end
    end
    def doc_types #used in seg_nav_band ###
      scroll=seg=''
      wgt=Widget.new(@md)
      #dir=SiSU_Env::Info_env.new(@md.fns)
      x=if @md.concord_make
        %{
<table summary="segment navigation available documents types: toc,doc,pdf,concordance" border="0" cellpadding="3" cellspacing="0">
<tr>
  #{wgt.seg(@vz.nav_txt_toc_link)}
  #{wgt.scroll(@vz.nav_txt_doc_link)}
  #{wgt.pdf}#{wgt.odf}
<td align="center" bgcolor=#{@vz.color_band2}>
  #{wgt.concordance(@vz.nav_txt_concordance)}
  #{wgt.manifest}
  #{wgt.search}
  #{wgt.home}
</tr></table>}
      else
        %{
<table summary="segment navigation available documents types: toc,doc,pdf,concordance" border="0" cellpadding="3" cellspacing="0">
<tr>
  #{wgt.seg(@vz.nav_txt_toc_link)}
  #{wgt.scroll(@vz.nav_txt_doc_link)}
  #{wgt.pdf}#{wgt.odf}
<td align="center" bgcolor=#{@vz.color_band2}>
  #{wgt.manifest}
  #{wgt.search}
  #{wgt.home}
</tr></table>}
      end
    end
    def title_endnote(title,subtitle,creator,table_top_control)
#      %{#{@vz.banner_instrument_cover_band_seg}
#  <h1 class="banner">
#    #{title}
#  </h1>
#  <h1 class="subbanner">
#   #{subtitle}
#  </h1>
#  <h1 class="subbanner">
#    #{creator}
#  </h1>
#  <h4 class="banner">
#    Endnotes
#  </h4>
##{@vz.table_close}
#<h1>Endnotes</h1>}
    end
    def navigation_table
      %{<table summary="navigation segment table" width=#{@vz.table_width_1} border="0" bgcolor="white" cellpadding="0">
<tr><th width="#{@@indent['leve_1']}" align="right">
</td>
<td valign="top">
  <font size=2>}
    end
    def navigation_table1
      %{<table summary="navigation segment table1" width=#{@vz.table_width_1} border="0" cellpadding=#{@vz.table_cellpad_box} bgcolor=#{@vz.color_table1} align="left">
<tr><td valign="top">
  <font size="2">}
    end
    def navigation_table2
      %{<table summary="navigation segment table2" width=#{@vz.table_width_2} border="0" cellpadding=#{@vz.table_cellpad_box} bgcolor=#{@vz.color_table2} align="left">
<tr><td valign="top">
  <font size="2">}
    end
    def header_advert_local_1
      dir=SiSU_Env::Info_env.new(@fns)
      %{  <center>
<table summary="image" border="0" cellpadding="3" cellspacing="0" align="center">
<tr><td align="center" bgcolor="white">
  <a href="http://#{@md.ad_url}#@sfx" target="_top">
    <img border="0" src="#{dir.url.images_local}/#{@md.ad_png}" alt="#{@md.ad_alt}">
  </a>
  <p />
#{@vz.table_close}
</center>}
    end
    def header_advert_local_2
      dir=SiSU_Env::Info_env.new(@fns)
      %{  <center>
<table summary="image" border="0" cellpadding="3" cellspacing="0" align="center">
<tr><td align="center" bgcolor="white">
  <a href="#{@md.ad_url}#@sfx" target="_top">
    <img border="0" src="#{dir.url.images_local}/#{@md.ad_png}" alt="#{@md.ad_alt}">
  </a>
  <p />
#{@vz.table_close}
</center>}
    end
    def header_advert_external
      dir=SiSU_Env::Info_env.new(@fns)
      %{  <center>
<table summary="image" border="0" cellpadding="3" cellspacing="0" align="center">
<tr><td align="center" bgcolor="white">
  <a href="#{@md.ad_url}#@sfx" target="external">
    <img border="0" src="#{dir.url.images_local}/#{@md.ad_png}" alt="#{@md.ad_alt}">
  </a>
  <p />
#{@vz.table_close}
</center>}
    end
    def credit
      %{
<div class="main_column">
#{@vz.credits_splash}
#{@vz.credits_sisu}
<a name="bottom" id="bottom"></a>
<a name="down" id="down"></a>
<a name="end" id="end"></a>
<a name="finish" id="finish"></a>
<a name="stop" id="stop"></a>
<a name="credits" id="credits"></a>
</div></div>
}
    end
    def navigation_band(segtocband,seg_table_top_control) #change name to navigaion_band_banner
      %{<table summary="segment navigation band with banner" bgcolor=#{@vz.color_band1} width="100%"><tr>
<td width="20%" align="left">
#{@vz.banner_band}
</td>
<td width="60%" align="center">
  #{doc_types}
</td>
<td width="20%" align="right">
  #{segtocband}
</td></tr>
</table>
#{seg_table_top_control}}
    end
    def navigation_band_bottom(segtocband,seg_table_top_control) #change name to navigaion_band_bannerless
      %{
<div class="main_column">
  <table summary="segment navigation band" bgcolor=#{@vz.color_band1} width="100%"><tr>
  <td width="70%" align="center">
    #{doc_types}
  </td>
  <td width="30%" align="right">
    #{segtocband}
  </td></tr>
  </table>
  #{seg_table_top_control}
</div>
}
    end
    def endnote_mark
%{
<p class="center" id="endnotes">
  <hr class="endnote" />
</p>}
    end
    def endnote_section_open
%{
<div class="endnote">
}
    end
    def endnote_section_close
%{
</div>
} #revisit
    end
    def head
      %{#{doc_type}
<head>
  <title>
    #{@seg_name_html[@seg_name_html_tracker]} -
    #{@md.html_title}
  </title>
<meta http-equiv="Content-Type" content="text/html;charset=utf-8" />
#{@rdf.rdfseg}
#{@rdf.metatag_html}
#{@css.html}
</head>
#{@vz.color_body}
<a name="top" id="top"></a>
<a name="up" id="up"></a>
<a name="start" id="start"></a>
#{@vz.js_top}}
    end
    def toc_metadata
      @metalink=%{./#{@md.fn[:meatadata]}}
      toc_metadata
    end
    def title_banner(title,subtitle,creator)
      %{
<div class="summary">
  <p class="tiny">
    #{title}
  </p>
  <p class="tiny">
    #{subtitle}
  </p>
  <p class="tiny">
    #{creator}
  </p>
  <p class="tiny">
    copy @
    <a href="#{@vz.url_home}">
      #{@vz.txt_home}
    </a>
  </p>
</div>
}
    end
  end
  class Head_scroll < Head_toc
    def initialize(md) #(md='')
      super(md)
    end
    def toc_owner_details
      %{#{@vz.margin_txt_3}
#{@vz.paragraph_font_small}
  <a href="#owner.details">
    Owner Details
    <font size="1" color="#777777">
      &nbsp;&nbsp;&nbsp;
    </font>
  </a>
  </font>
#{@vz.table_close}}
    end
    def table
      %{<table summary="scroll table" width=#{@vz.table_width_1} border="0" bgcolor="white" cellpadding="0">
<tr><th width=#{@@indent['level_1']} align="right">
</th>
<td valign="top">
#{@vz.paragraph_txt}}
    end
    def table1
      %{<table summary="scroll table1" width=#{@vz.table_width_1} border="0" cellpadding=#{@vz.table_cellpad_box} #{@vz.color_color_table1} align="justify">
<tr><td valign="top">
#{@vz.paragraph_txt}}
    end
    def table2
      %{<table summary="scroll table2" width=#{@vz.table_width_1} border="0" cellpadding=#{@vz.table_cellpad_box} #{@vz.color_color_table2} align="justify">
<tr><td valign="top">
#{@vz.paragraph_txt}}
    end
##     def toc_endnote
##       %{#{@vz.margin_txt_3}
## #{@vz.paragraph_font_small}
##   <a href="#endnotes">
##     Endnotes
##   </a>
## #{@vz.table_close}}
##     end
#    def toc_endnote
#      %{#{@vz.margin_css}
#  <h4 class="toc">
#    <a href="#endnotes">
#      Endnotes
#    </a>
#  </h4>
##{@vz.table_close}}
#    end
    def title_endnote #revisit
#      %{#{@vz.margin_txt_0}
#  #{@vz.paragraph_txt}
#  <a name="endnotes" id="endnotes"></a>
##{@vz.margin_num}
#  &nbsp;
##{@vz.table_close}}
    end
  end
  class Format_text_object
    @vz=SiSU_Env::Get_init.instance.skin
    @@dp=nil
    attr_accessor :md,:t_o,:txt,:ocn,:format,:table,:link,:linkname,:paranum,:p_num,:headname,:banner,:url
    def initialize(md,t_o)
      @md,@t_o=md,t_o
      if t_o.class == Hash
        @txt            =t_o[:txt]            || nil
        @ocn            =t_o[:ocn]            || nil
        @ocn_display    =t_o[:ocn_display]    || nil
        @headname       =t_o[:headname]       || nil
        @trailer        =t_o[:trailer]        || nil
        @endnote_part_a =t_o[:endnote_part_a] || nil
        @endnote_part_b =t_o[:endnote_part_b] || nil
        @lnk_url        =t_o[:lnk_url]        || nil
        @lnk_txt        =t_o[:lnk_txt]        || nil
        @format         =t_o[:format]         || nil
        @target         =t_o[:target]         || nil #occasionally passed but not used
      else
        if @md.cmd =~/M/
          p t_o.class
          p caller
        end
      end
      if @txt and not @txt.empty?
        @txt.gsub!(/#{Mx[:mk_o]}[-~]##{Mx[:mk_c]}/,'')
      end
      if @ocn and @ocn=~/\d+/ #WATCH FIX
        @p_num=Paragraph_number.new(@md,@ocn)
      end
      if @format and not @format.empty?
        if @format=~/^\d:(\S+)/ #need more reliable marker #if @format =~ /#{Rx[:lv]}/
          headname=$1 #format[/\d~(\S+)/m,1]
          @headname=if headname =~/^[a-zA-Z]/; %{<a name="#{headname}" id="#{headname}"></a>} #consider: h_#{headname}
          else %{<a name="h#{headname}" id="h#{headname}"></a>}
          end
        end
      end
      @vz=SiSU_Env::Get_init.instance.skin
    end
    def endnote_body
      %{
<p class="endnote">
  #{@txt}
</p>
}
    end
    def endnote_body_indent
      %{
  <p class="endnote_indent">
    #{@txt}
  </p>
}
    end
    def no_paranum
      %{
<div class="substance">
  <label class="ocn">&nbsp;</label>
  <p class="norm">
    #{@txt}
  </p>
</div>
}
    end
    def para_form_css(tag,attrib)                                                    # regular paragraphs shaped here
      ul=ulc=''
      ul,ulc="<ul>\n  ","\n  </ul>" if @tag =~/li/
      %{
<div class="substance">
  #{@p_num.ocn_display}
  #{ul}<#{tag} class="#{attrib}" #{@p_num.id}>
    #{@txt}
  </#{tag}>#{ulc}
</div>
}
    end
    def para
      para_form_css('p','norm')
    end
    def code
      para_form_css('p','code')
    end
    def center
      para_form_css('p','center')
    end
    def bold
      para_form_css('p','bold')
    end
    def bullet
      para_form_css('li','bullet')
    end
    def format(tag,attrib)
      para_form_css(tag,attrib)
    end

    def header_normal(tag,attrib)
      %{
<div class="substance">
  #{@p_num.ocn_display}
  <#{tag} class="#{attrib}" #{@p_num.id}>#{@p_num.name}
    #{@headname}#{@txt}
  </#{tag}>
</div>
}
    end
    def heading_body
      header_normal('p','norm')
    end
    def heading_body1
      header_normal('h1','norm')
    end
    def heading_body2
      header_normal('h2','norm')
    end
    def heading_body3
      header_normal('h3','norm')
    end
    def heading_body4
      header_normal('h4','norm')
    end
    def heading_body5
      header_normal('h5','norm')
    end
    def heading_body6
      header_normal('h6','norm')
    end
    def title_header(tag,attrib)
      %{
<div class="content">
<#{tag} class="#{attrib}">
    #{@txt}
  </#{tag}>
</div>
}
    end
    def title_header1
      title_header('h1','tiny')
    end
    def title_header2
      title_header('h2','tiny')
    end
    def title_header3
      title_header('h3','tiny')
    end
    def title_header4
      ''
    end
    def title_header4_old
      %{
<div class="substance">
  <label class="ocn">&nbsp;</label>
  <h4 class="banner">
    #{@txt}
  </h4>
</div>
}
    end
    def dl #check :trailer
      "<dl><b>#{@txt}</b> #{@trailer}</dl>"
    end
    def table_css_end      #<!TZ!>
      '</table>
    </p>
  </div>'
    end
    def gsub_body
      case @txt
      when /^(?:#{Mx[:pa_o]}i[1-9]#{Mx[:pa_c]}\s*)?\((i+|iv|v|vi+|ix|x|xi+)\)/
        @txt.gsub!(/^\((i+|iv|v|vi+|ix|x|xi+)\)/,'<b>(\1)</b>')
        @txt.gsub!(/^(#{Mx[:pa_o]}i[1-9]#{Mx[:pa_c]})\s*\((i+|iv|v|vi+|ix|x|xi+)\)/,'\1<b>(\2)</b>')
      when /^(?:#{Mx[:pa_o]}i[1-9]#{Mx[:pa_c]}\s*)?\(?(\d|[a-z])+\)/
        @txt.gsub!(/^\((\d+|[a-z])+\)/,'<b>(\1)</b>')
        @txt.gsub!(/^(#{Mx[:pa_o]}i[1-9]#{Mx[:pa_c]})\s*\((\d+|[a-z])+\)/,'\1<b>(\2)</b>')
      when /^\s*\d{1,3}\.\s/
        @txt.gsub!(/^\s*(\d+\.)/,'<b>\1</b>')
      when /^\s*[A-Z]\.\s/
        @txt.gsub!(/^\s*([A-Z]\.)/,'<b>\1</b>')
      end
    end
    def bold_para
      %{#{@vz.margin_txt_0}
  <p class="bold">
    #{@txt}
  </p>
#{@vz.margin_num_css}
  &nbsp;&nbsp;&nbsp;
#{@vz.table_close}}
    end
    def bold_header
      @txt.gsub!(/[1-9]~(\S+)/,'<a name="\1"></a>')
      @txt.gsub!(/[1-9]~/,'')
      @txt.gsub!(/#{Mx[:id_o]}~0;[um]\d+;[um]\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]}\s*$/i,'') #watch & do differently
      %{<p class="bold">
    #{@txt}
  </p>
#{@vz.margin_num_css}
  &nbsp;&nbsp;&nbsp;
#{@vz.table_close}}
    end
    def toc_head_copy_at
      %{<p class="center">#{@txt}</p>\n}
    end
    def center
      %{<p class="center">#{@txt}</p>\n}
    end
    def bold
      %{<p class="bold">#{@txt}</p>\n}
    end
    def center_bold
      %{<p class="centerbold">#{@txt}</p>\n}
    end
  end
  class Format_scroll < Format_text_object
    def initialize(md,txt)
      super(md,txt)
      @vz=SiSU_Env::Get_init.instance.skin
    end
  end
  class Format_seg < Format_text_object
    def initialize(md,txt)
      super(md,txt)
    end
    def navigation_toc_lev1_advert
      %{#{@banner.home_button}\n
<center>
#{@txt}
#@two
</a></center><p />}
    end
    def navigation_toc_lev1
      %{#{@banner.nav_toc}}
    end
    def navigation_toc_lev2                                                      #change bold use css
      %{<p />
<table summary="navigation segment level 2">
<tr><td width ="20">
</td>
<td>
  <font size="3" #{@vz.font_face}>
    <b>#{@txt}</b>
  </font>
  </p>
#{@vz.table_close}}
    end
    def navigation_toc_lev3                                                      #change bold use css
      %{<p />
<table summary="navigation segment level 3">
<tr><td width ="20">
</td>
<td>
  <font size="3" #{@vz.font_face}>
    <b>#{@txt}</b>
  </font>
  </p>
#{@vz.table_close}}
    end
    def navigation_toc_lev4
      %{<table summary="navigation segment level 4">
<tr><td width ="80">
</td>
<td>
<p>
  #{@txt}
</p>
#{@vz.table_close}}
    end
    def navigation_toc_lev5
    end
    def navigation_toc_lev6
    end
    def endnote_seg_body(fn='')  #FIX                                                #url construction keep within single line... BUG WATCH 200408
      fn='doc' if fn.empty? #you may wish to reconsider, sends to 'doc' where no segment info
      %{
  <p class="endnote">
    #{@endnote_part_a}#{@md.fnl[:pre]}#{fn}#{@md.fnl[:mid]}#{@md.sfx}#{@md.fnl[:post]}#{@endnote_part_b}
  </p>
}
    end
    def subtoc_lev(tag,attrib)
      txt=if @txt \
      and @txt =~/<\/?i>|<a\s+name="\S+?">/mi
        @txt.gsub(/<\/?i>|<a\s+name="\S+?">/mi,'') #removes name markers from subtoc, go directly to substantive text
      else @txt
      end
      note=''
      if txt =~/((?:#{Mx[:en_a_o]}|#{Mx[:en_b_o]}).+?(?:#{Mx[:en_a_c]}|#{Mx[:en_b_c]})\s*)/m #this is a clumsy fix, revisit and address upstream
        note=$1
        note.gsub!(/[\n\s]+/m,' ')
        txt.gsub!(/(?:#{Mx[:en_a_o]}|#{Mx[:en_b_o]}).+?(?:#{Mx[:en_a_c]}|#{Mx[:en_b_c]})\s*/m,' ')
        txt.gsub!(/<a[\n\s]+name="-\d+"[\n\s]+href="#_\d+">&nbsp;<sup>\d+<\/sup>&nbsp;/m,'')
      end
      %{<#{tag} class="#{attrib}">
    <a href="##{@ocn}"><i>#{txt}</i></a> #{note}
  </#{tag}>}
    end
    def subtoc_lev5
      subtoc_lev('h5','subtoc') if @txt
    end
    def subtoc_lev6
      subtoc_lev('h6','subtoc') if @txt
    end
    #% para sisu
    def header_sub(tag,attrib)
      @txt.gsub!(/(?:#{Mx[:en_a_o]}|#{Mx[:en_b_o]}).+?(?:#{Mx[:en_a_c]}|#{Mx[:en_b_c]})\s*/m,' ')
      %{
<div class="substance">
  #{@p_num.ocn_display}
  <#{tag} class="#{attrib}" #{@p_num.id}>#{@p_num.name} #{@headname}
    #{@txt}
  </#{tag}>
</div>
}
    end
    def header5
      header_sub('p','bold')
    end
    def header6
      header_sub('p','bold')
    end
    def header4
      %{
<div class="substance">
  #{@p_num.ocn_display}
  <h1 class="norm" #{@p_num.id}>#{@p_num.name}
    #{@t_o[:format]}
    #{@txt}
  </h1>
</div>
}
    end
    def navigation_header4
      %{<table summary="navigation segment header 4" width=100% bgcolor="#08163f" border="0">
<tr><td align="center">
<p class="bold">
  #{@txt}
</p>
#{@vz.table_close}}
    end
    def navigation_header5
      %{<p class="bold">
  #{@txt}
</p>}
    end
    def navigation_header6
      %{<p class="bold">
  #{@txt}
</p>}
    end
    def navigation_center
      "<center>#{@txt}</center>"
    end
  end
  class Format_toc < Format_text_object
    def initialize(md,txt)
      super(md,txt)
    end
    def links_guide
      %{  <li class="doc">
    <a href="#{@lnk_url}" target="_top">
      #{@lnk_txt}
    </a>
  </li>
}
    end
    def lev(tag,attrib)
      if @txt
        %{<#{tag} class="#{attrib}">
    #{@txt}
  </#{tag}>
}
      else ''
      end
    end
    def lev1
      lev('h1','toc')
    end
    def lev2
      lev('h2','toc')
    end
    def lev3
      lev('h3','toc')
    end
    def lev4
      lev('h4','toc')
    end
    def lev5
      lev('h5','toc')
    end
    def lev6
      lev('h6','toc')
    end
    def lev0 #docinfo
      lev('h0','toc')
    end
    def mini_lev1
      lev('h1','minitoc')
    end
    def mini_lev2
      lev('h2','minitoc')
    end
    def mini_lev3
      lev('h3','minitoc')
    end
    def mini_lev4
      lev('h4','minitoc')
    end
    def mini_lev5
      lev('h5','minitoc')
    end
    def mini_lev6
      lev('h6','minitoc')
    end
    def mini_lev0 #docinfo
      lev('h0','minitoc')
    end
    def mini_tail
#  <h0 class="minitoc">
#    <a href="metadata.html">Document Information (metadata)</a>
#  </h0>
  %{
  <h4 class="minitoc">
    <a href="sisu_manifest.html">Manifest (alternative outputs)</a>
  </h4>
}
    end
    def mini_concord_tail
  %{
  <h4 class="minitoc">
    <a href="concordance.html">Concordance (wordlist)</a>
  </h4>
  <h4 class="minitoc">
    <a href="sisu_manifest.html">Manifest (alternative outputs)</a>
  </h4>
}
    end
  end
end
__END__
