# coding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008 Ralph Amissah All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.jus.uio.no/sisu/gpl.fsf/toc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/doc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/plain.txt>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: webrick share - note sisu by default does not link with file
    suffixes, see man pages for options

=end
def brick(port,get='')
  cgidir=if get=~/pwd/; Dir.pwd
  else                  '/usr/lib/cgi-bin'  # @env.path.cgi
  end
  port=SiSU_Env::Info_port.new.webrick
  begin
    s=HTTPServer.new(
      :Port         => port,
      :DocumentRoot => Dir::pwd + '/htdocs',
      :CGIPathEnv   => ENV['PATH']
    )
    cgi_dir=File.expand_path(cgidir)
    @mount.each { |x,y|                                                        # mount subdirectories
      s.mount(x, HTTPServlet::FileHandler, y, true)
    }
    s.mount('/cgi-bin', HTTPServlet::FileHandler, cgi_dir, {:FancyIndexing=>true})
    #### mount subdirectories, true added to permit dir listing
    trap("INT"){ s.shutdown }
    s.start
  rescue; SiSU_Errors::Info_error.new($!,$@,'-W',nil).error #fix
  ensure
  end
end
begin                                                                          #%
  require 'webrick'
  include WEBrick
  require 'time'
  require 'fileutils'
  include FileUtils
  require "#{SiSU_lib}/sysenv"
  include SiSU_Env
  include SiSU_Screen
  @cX=SiSU_Screen::Ansi.new('yes').cX
  @env=SiSU_Env::Info_env.new
  port=SiSU_Env::Info_port.new
  @argv=$*
  @host=@env.url.webrick
  #@host=ENV['HOSTNAME']
  host='localhost'
  @port="#{@argv[0].to_i}"
  @port="#{port.webrick}" if @port =~ /^0$/
  @serve=[]
  Dir.foreach(@env.path.webserv) {|x| @serve << x if x !~/^\./ and FileTest.directory?("#{@env.path.webserv}/#{x}") }
  @mount=[]
  @serve.each {|x| @mount << ["/#{x}", "#{@env.path.webserv}/#{x}"]}
  @pwd=Dir.pwd
  @week=Time.now.strftime(%{%Yw%W})
  puts "\n"
  @mount.each { |x,y|
    puts "        #{@cX.cyan}#{x}#{@cX.off}\t#{@cX.grey}see#{@cX.off} #{@cX.blue}#@host:#@port#{x}/wb.cgi#{@cX.off} #{@cX.ruby}@#{@cX.off} #{@cX.blue}#@host:#@port#{x}/#{@cX.off}"
  }
  puts "#{@cX.grey}"
                                                          #%
  wb_s2=[]
                                                           #% writes file wb.cgi to shared directories ...
                                                           #% wb_top
  wb_top=%q(#!/usr/bin/env ruby
  # * arch-tag: webrick info on environment, mounted directories, and contents of pwd
  require 'time'
  require 'cgi'
  require 'fcgi'
  ls=Dir.entries('./')
  dir_contents=[]
  ls.each { |x| dir_contents << "<a href=\"./#{x}/\">#{x}</a><br>" unless x =~/^(\.)+$/ }
  dir_contents=dir_contents.sort.join(' ')
  #host=ENV['HOSTNAME']
  #host=%x{echo $HOSTNAME}
  )
                                                           #% wb_s1
  wb_s1=<<WOK

  page=CGI.new "html3"
  page.out {
    page.html {
      page.head { page.title {"#@host Webrick Report"} } +
      page.body {
        page.h1 {"Webrick #@host"} +
        page.p {"Webrick is Ruby's built in webserver."} +
        page.center {"Host name: " + page.b{"#@host "} + "(#@host)  port: " + page.b{"#@port"}} +
        page.center {"#{Time.now}"} +
        page.center {"#{Time.now.strftime(%{%Yw%W})}"} +
        #page.center { "Center " + page.em{"emphasise "} + page.i{"italicise " } + page.b{"bold "} + page.u{"underline "}} +
        page.p {''} +
        page.p {''} +
        page.p {page.b{"Webrick Served Directories: "}} +
WOK
                                                           #% wb_s2 (mounts)
  @mount.each do |x,y| wb_s2 <<<<WOK
        page.p {page.b{'<a href="#@host:#@port#{x}/">#{x}</a> '} + '<a href="#@host:#@port#{x}/">#@host:#@port#{x}</a> (mounts: #{y}/)   <a href="#@host:#@port#{x}/wb.cgi">info (wb.cgi)</a>'} +
WOK
end
                                                           #% wb_end
  wb_end=<<WOK
        page.p {page.b{"Contents of PWD (see URL): "}} +
        page.p {"#\{dir_contents}"}
      }
    }
  }
WOK
  @mount.each { |x,y|                                      #% wb puts
    puts y
      filename=File.new("#{y}/wb.cgi",'w')
      filename << wb_top
      filename << wb_s1
      filename << wb_s2
      filename << wb_end
      filename.close
      chmod(0755,"#{y}/wb.cgi &") if FileTest.file?("#{y}/wb.cgi &")
  }
  puts "        #{@cX.off}"
  get=@argv.shift if @argv[0] =~/pwd/                      #% argv
  brick(@port,get)
rescue; SiSU_Errors::Info_error.new($!,$@,'-W',nil).error #fix
ensure
end
