# coding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008 Ralph Amissah All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.jus.uio.no/sisu/gpl.fsf/toc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/doc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/plain.txt>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: SiSU information Structuring Universe, command line options
    parsing

=end
module SiSU_commandline
  require "#{SiSU_lib}/sysenv"
  class Options
    attr_accessor :cmd,:mod,:files,:fns,:fnb,:fnc,:fncb,:what
    def initialize(a)
      @cmd,@files,@fns,@fnb,@fnc,@fncb,@what,c,w,s='','','','','','','','','','',''
      @files,@mod,m,f,z,ca=[],[],[],[],[],[]
      @env=SiSU_Env::Info_env.new
      shortcut=SiSU_Env::Info_processing_flag.new
      a.each do |x|
        y=case x
        when /0/
          if x=~/^-1\S+/; x.gsub(/^-0(\S+)/,shortcut.cf_0 + ' -\1')
          else            x.gsub(/^-0/,shortcut.cf_0 + ' ')
          end
        when /1/
          if x=~/^-1\S+/; x.gsub(/^-1(\S+)/,shortcut.cf_1 + ' -\1')
          else            x.gsub(/^-1/,shortcut.cf_1 + ' ')
          end
        when /2/
          if x=~/^-2\S+/; x.gsub(/^-2(\S+)/,shortcut.cf_2 + ' -\1')
          else            x.gsub(/^-2/,shortcut.cf_2 + ' ')
          end
        when /3/
          if x=~/^-3\S+/; x.gsub(/^-3(\S+)/,shortcut.cf_3 + ' -\1')
          else            x.gsub(/^-3/,shortcut.cf_3 + ' ')
          end
        when /4/
          if x=~/^-4\S+/; x.gsub(/^-4(\S+)/,shortcut.cf_4 + ' -\1')
          else            x.gsub(/^-4/,shortcut.cf_4 + ' ')
          end
        when /5/
          if x=~/^-5\S+/; x.gsub(/^-5(\S+)/,shortcut.cf_5 + ' -\1')
          else            x.gsub(/^-5/,shortcut.cf_5 + ' ')
          end
        else x
        end
        s << " #{y}" unless y.empty?
      end
      s.strip!
      a=s.split(/\s+/)
      a.each do |x|
        if x =~/^-[a-z0-5]+/i \
        or x =~/^--\S+/
          if x =~/^-([a-z0-5]+)/i; c << $1
          end
          if x =~/^--\S+/;        m << x
          end
        elsif x =~ /(?:\.(?:(?:-|ssm\.)?sst(?:\.xml)?|ssm|ssi|sx[sdn]\.xml|s[1-3]|kdi|ssp)|\S+?\.ss[mt]\.zip|sisupod(\.zip)?)$/
          if x =~/^(?:https?|file):\/\/\S+/;  f << x
          elsif FileTest.file?(x); f << x
          else  puts "file not found: #{x}"
          end
        elsif x =~ /\.termsheet\.rb$/
          if FileTest.file?(x); f << x
          else  puts "file not found: #{x}"
          end
        else w=x
          puts "#{x} in #{a.join(' ')}?"
        end
      end
      unless m.empty?
        m.each do |m|
          case m
          when /--maintenance/
            c=c+'M'
          when /--verbose[=-]3/
            c=c+'VM'
          when /--verbose[=-]2|--Verbose|--VERBOSE/
            c=c+'V'
          when /--verbose(?:[=-]1)?/
            c=c+'v'
          when /--verbose[=-]0|--quiet|--silent/
            c=c+'q'
          else @mod << m
          end
        end
      end
      unless c.empty?
        c.gsub!(/-/,'')
        c.scan(/./) {|x| ca << x}
        @cmd= '-' + ca.uniq.join
      end
      unless w.empty? ;  @what=w
      end
      @files << f
      @files.flatten!
      if @files.length > 0 \
      and @cmd.empty? \
      and @mod.length == 0 #% if no other action called on filename given, default is sisu -0 [filename(s)] configured as flag default
        @cmd=shortcut.cf_0
      end
      tell=SiSU_Screen::Ansi.new(@cmd,"\tsisu " + @cmd +  ' ' + @mod.join(' ') + ' ' + @files.join(' ') + "\n")
      tell.print_brown if @cmd =~/[vVM]/
      @files.uniq!
    end
    def cmd
      @cmd
    end
    def mod
      @mod
    end
    def fns
      @fns
    end
    def what
      @what
    end
    def fnb
      unless fns.empty?
        fns[/(.+?)\.(?:(?:-|ssm\.)?sst|ssm)$/,1]
      end
    end
    def fnc
      @fnc=if @fns =~/\.(?:ssm\.sst|ssm)$/; fnb + '.ssm.sst'
      else @fns
      end
    end
    def fncb
      @fncb=if @fns =~/(?:\~\S{2,3})?\.(?:ssm\.sst|ssm)$/; fnb + '.ssm.sst'
      else @fns.gsub(/(?:\~\S{2,3})?(\.sst)$/,'\1')
      end
    end
  end
end
__END__
note usually named @opt
is carried in Param usually as @md
@opt is a subset of @md
where @md is passed, contents of @opt are available
passing @opt as well is duplication
check for fns & fnb
