=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007 Ralph Amissah All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007 Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licenses/gpl.html>
   <http://www.gnu.org/copyleft/gpl.html>
   <http://www.jus.uio.no/sisu/gpl.fsf>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: LaTeX formatting template, unicode utf-8 version, used for pdf

=end
module SiSU_TeX_Pdf
  @@table_pg_break_counter=1
  require "#{SiSU_lib}/param"
  include SiSU_Param
  include SiSU_Viz
  class Use_TeX
    attr_accessor :url,:txt,:date
    def initialize(md,orientation='')
      @md,@orientation=md,orientation
      @vz=SiSU_Env::Get_init.instance.skin
      @date=SiSU_Env::Info_date.new # #{@date.year}
      @copymark='{\\begin{footnotesize}\\raisebox{1ex}{\\copyright}\\end{footnotesize}}'
      @url_brace=SiSU_Viz::Skin.new.url_decoration
    end
    def skip
      "\n\\vspace*{\\smallskipamount} \n"
    end
    def paraskip_normal
      '\setlength{\parskip}{1ex plus0.5ex minus0.2ex}'
    end
    def paraskip_small
      '\setlength{\parskip}{0.5ex plus0.2ex minus0.1ex}'
    end
    def skip_small
      #"\\smallskip{}"
    end
    def skip_small_vspace
      "\n\\vspace*{\\smallskipamount} \n"
    end
    def skip_small_footnote
      #"\n\\smallskip{}\n"
    end
    def skip_medium
      "\n\\medskip{}\n\n"
    end
    def skip_dummy
      "\n"
    end
    def header
      "\\lhead[ ]{ }\n" +
      "\\chead[ \\fancyplain{} \\bfseries \\footnotesize  \\leftmark ]{ \\fancyplain{} \\bfseries \\footnotesize \\rightmark }\n" +
      "\\rhead[ ]{ }\n"
    end
    def footer
      base_prog_txt=if @md.base_program
        case @md.base_program
        when /kdissert/i; " \\\\ \\href{http://freehackers.org/~tnagy/kdissert/}{Kdissert}"
        else ''
        end
      else ''
      end
      "\\lfoot[\\textrm{\\thepage}]{\\tiny \\href{#{@vz.url_sisu}}{#{@vz.txt_signature}}#{base_prog_txt}}\n" +
      "\\cfoot[\\href{#{@vz.url_home}}{#{@vz.url_txt}}]{\\href{#{@vz.url_home}}{#{@vz.url_txt}}}\n" +
      "\\rfoot[\\tiny \\href{#{@vz.url_sisu}}{#{@vz.txt_signature}}]{\\textrm{\\thepage}}\n"
    end
    def site
      "\\href{#{@vz.url_home}}{#{@vz.url_txt}}"
    end
    def sitename                                   #owners site, eg freeculture, free.for.all, gutenberg etc.
      "\\href{#{@vz.url_home}}{#{@vz.txt_home}}"
    end
    def owner_chapter
      "Contact Details for Original Promulgating Authority"
    end
    #BOOK standard dimensions - 229x156
    def newpage
      case @orientation
      when /landscape/ # using longtable latex package
<<WOK
\\clearpage
WOK
      when /portrait/
<<WOK
\\newpage
WOK
      end
    end
    def sisu_rights
      v=SiSU_Env::Info_version.new.get_version
      base_prog_txt=if @md.base_program
        case @md.base_program
        when /kdissert/i; "\n\\\\ This document prepared using \\href{http://freehackers.org/~tnagy/kdissert/}{Kdissert \\ http://freehackers.org/~tnagy/kdissert/ } \\\\ Kdissert is Document Mapping software by Thomas Nagy"
        else ''
        end
      else ''
      end
<<WOK
\\\\ ~
{\\begin{footnotesize}#{base_prog_txt}
\\\\ Generated by \\href{http://www.jus.uio.no/sisu}{SiSU} \\begin{tiny}[ #{v[:project]} #{v[:version]} of #{v[:date_stamp]} ]\\end{tiny} \\href{http://www.jus.uio.no/sisu}{www.jus.uio.no/sisu}
\\\\ Copyright #@copymark 1997, current #{@date.year_static} Ralph Amissah, All Rights Reserved.
\\\\ SiSU is software for document structuring, publishing and search (with object citation numbering), \\href{http://www.sisudoc.org}{www.sisudoc.org}
\\\\ SiSU is released under \\href{http://www.fsf.org/licenses/gpl.html}{GPL 3 } or later, #{@url_brace.tex_open}\\href{http://www.fsf.org/licenses/gpl.html}{http://www.fsf.org/licenses/gpl.html}#{@url_brace.tex_close}.
{\\end{footnotesize}
\\\\
WOK
    end
    def doc_sc_info_footnote_full
<<WOK
\\footnote{%\nGenerated by \\href{http://www.jus.uio.no/sisu}{SiSU \\ www.jus.uio.no/sisu }\\ \\newline \\scriptsize{Document version information: \\emph{sourcefile} \\uline{#{@md.fnstex}}; \\emph{version} \\uline{#{@md.sc_number}}; \\emph{date} \\uline{#{@md.sc_date}}; \\emph{time} \\uline{#{@md.sc_time}}}}
WOK
    end
    def doc_sc_info_footnote_brief
      " \\footnote{%\nGenerated by \\href{http://www.jus.uio.no/sisu}{SiSU} \\ \\href{http://www.jus.uio.no/sisu}{www.jus.uio.no/sisu} \\newline \\href{http://www.sisudoc.org}{www.sisudoc.org} \\\n}"
    end
    def doc_sc_info
      v=SiSU_Env::Info_version.new.get_version
<<WOK
\\\\
{\\begin{footnotesize}
Document version information: \\\\
\\emph{sourcefile} \\uline{#{@md.fnstex}}; \\emph{version} \\uline{#{@md.sc_number}}; \\emph{date} \\uline{#{@md.sc_date}}; \\emph{time} \\uline{#{@md.sc_time}} \\\\
Generated by \\href{http://www.jus.uio.no/sisu}{SiSU www.jus.uio.no/sisu }\\- version information: \\\\
\\uline{ #{v[:project]} #{v[:version]} of #{v[:date_stamp]}}
\\end{footnotesize}}&
WOK
    end
    def doc_no_sc_info
      v=SiSU_Env::Info_version.new.get_version
<<WOK
\\\\
{\\begin{small}
Document information: \\\\
\\emph{sourcefile} \\uline{#{@md.fnstex}} \\\\
Generated by \\href{http://www.jus.uio.no/sisu}{SiSU www.jus.uio.no/sisu } \\\\ version information: \\
\\uline{ #{v[:project]} #{v[:version]} of #{v[:date_stamp]}}

\\end{small}}&
WOK
    end
    def manifest_info
      url=@md.fnb.gsub(/(?:\\)*([$&~%_#}{^])/,'\\\\\1')
      fn=@md.fn[:manifest].gsub(/(?:\\)*([$&~%_#}{^])/,'\\\\\1')
<<WOK
{\\begin{footnotesize}
\\\\ For alternative output formats of this document check:
\\\\ #{@url_brace.tex_open}\\begin{scriptsize}\\href{#{@vz.url_root_http}/#{url}/#{fn}}{#{@vz.url_root_http}/#{url}/#{fn}}\\end{scriptsize}#{@url_brace.tex_close}
\\end{footnotesize}}&
WOK
    end
    def endnotes #not used should be inserted before MetaData section which preceeds doc_tail, but is "part of document"
<<WOK
\\subsection*{Endnotes}
\\addcontentsline{toc}{section}{Endnotes}
\\
\\listofendnotes
WOK
    end
    def doc_tail
      dir=SiSU_Env::Info_env.new(@md.fns)
      base_html="#{dir.url.root}/#{@md.fnb}"
      v=SiSU_Env::Info_version.new.get_version
      sisu_ico=if FileTest.file?("#{dir.path.image_source_tex}/sisu.png")
        "\\includegraphics*[width=60pt]{#{dir.path.image_source_tex}/sisu.png}"
      else
        tell=SiSU_Screen::Ansi.new(@md.cmd,'WARNING - image directory or image(s) missing:', %{"#{dir.path.image_source_tex}"} )
        tell.warn unless @md.cmd =~/q/
        " SiSU "
      end
      url=@md.fnb.gsub(/(?:\\)*([$&~%_#}{^])/,'\\\\\1')
<<WOK
\\subsection*{Information on this document copy and an unofficial List of Some web related information and sources}
\\addcontentsline{toc}{section}{Information on this document copy and an unofficial List of Some web related information and sources}
\\\\
\"Support Open Standards and Software Libre for the Information Technology Infrastructure\" RA\\subsubsection*{Information on this document copy #{site}}
\\addcontentsline{toc}{subsection}{Information on this document copy}
{\\begin{footnotesize}
\\\\ Generated by \\href{http://www.jus.uio.no/sisu/}{SiSU} found at \\href{http://www.jus.uio.no/sisu/}{www.jus.uio.no/sisu} \\begin{tiny}[ #{v[:project]} #{v[:version]} #{v[:date_stamp]} ]\\end{tiny}  \\href{http://www.sisudoc.org}{www.sisudoc.org}. SiSU is software for document structuring, publishing and search (using SiSU: object citation numbering, markup, meta-markup, and system) Copyright #@copymark 1997, current #{@date.year_static} Ralph Amissah, All Rights Reserved.
\\\\ SiSU is released under \\href{http://www.fsf.org/licenses/gpl.html}{GPL 3 } or later (\\href{http://www.fsf.org/licenses/gpl.html}{www.fsf.org/licenses/gpl.html}). {\\end{footnotesize}
{\\begin{small}
\\\\ W3 since October 3 1993 \\href{http://www.jus.uio.no/sisu/}{#{sisu_ico}}SiSU 1997, current #{@date.year_static}. \\\\ #{sitename} presentations at \\begin{bfseries}#{site}\\end{bfseries} \\\\ \\\\ #{@md.title} \\textbf{pdf} versions can be found at:  \\\\
{\\end{small}
\\begin{scriptsize}\\href{#{@vz.url_root_http}/#{url}/#{@md.fn[:pdf_p]}}{#{@vz.url_root_http}/#{url}/#{@md.fn[:pdf_p]}}\\end{scriptsize}  \\\\
\\begin{scriptsize}\\href{#{@vz.url_root_http}/#{url}/#{@md.fn[:pdf_l]}}{#{@vz.url_root_http}/#{url}/#{@md.fn[:pdf_l]}}\\end{scriptsize}  \\\\
\\\\\n#{@md.title} \\textbf{html} versions may be found at: \\\\
\\begin{scriptsize}\\href{#{@vz.url_root_http}/#{url}/#{@md.fn[:toc]}}{#{@vz.url_root_http}/#{url}/#{@md.fn[:toc]}}\\end{scriptsize} or \\\\
\\begin{scriptsize}\\href{#{@vz.url_root_http}/#{url}/#{@md.fn[:doc]}}{#{@vz.url_root_http}/#{url}/#{@md.fn[:doc]}}\\end{scriptsize}
\\\\
\\\\
\\href{#{@vz.url_root_http}/#{url}/#{@md.fn[:manifest]}}{SiSU Manifest} of document output and metadata may be found at: \\\\
\\begin{scriptsize}\\href{#{@vz.url_root_http}/#{url}/#{@md.fn[:manifest]}}{#{@vz.url_root_http}/#{url}/#{@md.fnl[:pre]}sisu\\_manifest#{@md.fnl[:mid]}.html#{@md.fnl[:post]}}\\end{scriptsize}
\\\\
\\\\
 #{sitename} found at: \\begin{bfseries}#{site}\\end{bfseries}\\subsubsection*{Links that may be of interest at #{@vz.txt_home} and elsewhere:}
\\addcontentsline{toc}{subsection}{Links that may be of interest}
WOK
    end
    def mail_tail #not retested, the old mail_tail is commented out and appended to this program
      dir=SiSU_Env::Info_env.new(@md.fns)
<<WOK
\\subsection*{Mail sender details}
\\addcontentsline{toc}{subsection}{Mail sender details}
\\\\
Mail from: ralph@amissah.com\\\\
44 20 8789 3452\\\\
44 77 9669 4448
\\\\
 \"Support Open Standards and Open Sources for the Information Technology Infrastructure\" RA
\\subsubsection*{Information on this document copy #{site}\\copyright}
Presentations' look and feel generated by \\href{http://www.jus.uio.no/sisu/}{SiSU Scribe} \\href{http://www.jus.uio.no/sisu/}{http://www.jus.uio.no/sisu/} programmed in Ruby on Debian/Gnu/Linux by Copyright \\copyright Ralph Amissah, W3 since October 3 1993 \\href{http://www.jus.uio.no/sisu/}{\\includegraphics*[width=35pt]{#{dir.path.image_source_tex}/sisu.png}}for #{sitename}. SiSU Scribe (sisu information structuring unit) produces Electronic Documents, i.e. it generates structured output for use in a number of file formats, including the pdf file produced here.
WOK
    end
  end
  class Format_text_object
    require 'iconv'
    require "#{SiSU_lib}/defaults"
    attr_accessor :string,:string1,:string,:orientation,:url,:dir,:tex
    @@sys=SiSU_Env::System_call.new
    @@tex_backslash="\\\\"
    @@tilde='\\\\\\~' #?? debug crazy
    @@tex_pattern_margin_number="\\\\begin\\\{tiny\\\}~\\\\end\\\{tiny\\\}\\\{\\\\marginpar.+?\s+"
    @@tableheader=0
    @@sys=SiSU_Env::System_call.new
    @@flag_code=false
    @@dp=nil
    def initialize(md,string,string1=nil)
      @md,@string,@string1=md,string,string1
      if defined? @md.image \
      and @md.image =~/center/
        @center_begin,@center_end='\begin{center}','\end{center}'
      else @center_begin,@center_end='',''
      end
      @start_table=''
      @dp=@@dp ||=SiSU_Env::Info_env.new.digest.pattern
      @tx=SiSU_Env::Get_init.instance.tex
      @url_brace=SiSU_Viz::Skin.new.url_decoration
    end
    def longtable_landscape
      @end_table='\end{longtable}'
      @row_break='\\\\\\'
      if @string[/<!Th?¡\s+c(\d+);(.+?)!\\~(\d+;\w\d+;\w\d+)>/]
        no_of_cols,cols_width,ocn=$1,$2,$3
        tw=case @md.papersize
        when /a4/i;      @tx.a4.landscape.w     #European default, SiSU default
        when /letter/i;  @tx.letter.landscape.w #U.S. default
        when /legal/i;   @tx.legal.landscape.w  #U.S. alternative
        when /book|b5/i; @tx.b5.landscape.w     #book default - larger
        when /a5/i;      @tx.a5.landscape.w
        else             @tx.a4.landscape.w     #default currently A4
        end
        textwidth=(tw.to_i/2) - 24
        @@tableheader=1 if @string =~/<!Th/
        @w=cols_width.split(/;\s*/)
        @@number_of_cols=no_of_cols
        @colW=[]
        @colW << '{'
        @w.each  do |x|
          x.strip!
          x=(x.to_i * textwidth)/100
          col_w=x.to_s # x.gsub(/.+/,'l\|') #unless x.nil?
          @colW << "p{#{col_w}mm}" if col_w
        end
        @colW << '}'
        @colW=@colW.join
        @start_table="<~#{ocn}>\n\\setlength{\\LTleft}{0pt}\n\\setlength{\\LTright}{\\fill}\n" +
          "\\begin{tiny}\n\\begin{longtable}#@colW\n"
        @string.gsub!(/<!Th?¡\s+c\d+?;.+!\\~\d+;\w\d+;\w\d+>/,@start_table)
      end
      if @string =~/<!TZ!>/
        @string.gsub!(/<!TZ!>/," #@end_table\n\\end{tiny}")
      end
      @string.gsub!(/<!¡/,'')
      if @@tableheader == 1
        if @string =~/¡\d+?¡(.+?)(?:¡|!)/
          tablefoot=@string[/\<!f(.+?)!\>/,1]
          @string.gsub!(/\<!f(.+?)!\>/,'')
          @string.gsub!(/¡\d+?¡(.+?)(?:¡|!)/,'\bfseries \1&')
          @string.gsub!(/&>\s*$/," #@row_break \\hline\\endhead #@row_break")
          @string="#@string \\multicolumn{#{@@number_of_cols}}{l}{\\tiny #{tablefoot}} \\\\ \\hline\n\\endfoot\n\\hline\n" if tablefoot
          @@tableheader,@@number_of_cols=0,0
        end
      else
        if @string =~/¡\d+?¡(.+?)(?:¡|!)/
          @string.gsub!(/¡\d+?¡(.+?)(?:¡|!)/,'\1&')
          @string.gsub!(/&>\s*$/," #@row_break")
        end
      end
      @string="<~#{ocn}>" + @string
    end
    def longtable_portrait
      @end_table='\end{longtable}'
      @row_break='\\\\\\'
      if @string[/<!Th?¡\s+c(\d+);(.+?)!\\~(\d+;\w\d+;\w\d+)>/]
        no_of_cols,cols_width,ocn=$1,$2,$3
        tw=case @md.papersize
        when /a4/i;      @tx.a4.portrait.w     #European default, SiSU default
        when /letter/i;  @tx.letter.portrait.w #U.S. default
        when /legal/i;   @tx.legal.portrait.w  #U.S. alternative
        when /book|b5/i; @tx.b5.portrait.w     #book default - larger
        when /a5/i;      @tx.a5.portrait.w
        else             @tx.a4.portrait.w     #default currently A4
        end
        textwidth=tw.to_i - 20
        @@tableheader=1 if @string =~/<!Th/
        @w=cols_width.split(/;\s*/)
        @@number_of_cols=no_of_cols
        @colW=[]
        @colW << '{'
        @w.each  do |x|
          x.strip!
          x=(x.to_i * textwidth)/100
          #x=(x.to_i/100.0 * 160)
          col_w=x.to_s # x.gsub(/.+/,'l\|') #unless x.nil?
          @colW << "p{#{col_w}mm}" if col_w
        end
        @colW << '}'
        @colW=@colW.join
        @start_table="<~#{ocn}>\n\\setlength{\\LTleft}{0pt}\n\\setlength{\\LTright}{\\fill}\n" +
          "\\begin{tiny}\n\\begin{longtable}#@colW\n"
        @string.gsub!(/<!Th?¡\s+c\d+?;.+!\\~\d+;\w\d+;\w\d+>/,"#@start_table")
      end
      if @string =~/<!TZ!>/
        @string.gsub!(/<!TZ!>/," #@end_table\n\\end{tiny}")
      end
      @string.gsub!(/<!¡/,'')
      if @@tableheader == 1
        if @string =~/¡\d+?¡(.+?)(?:¡|!)/
          tablefoot=@string[/\<!f(.+?)!\>/,1]
          @string.gsub!(/\<!f(.+?)!\>/,'')
          @string.gsub!(/¡\d+?¡(.+?)(?:¡|!)/,'\bfseries \1&')
          @string.gsub!(/&>\s*$/," #@row_break \\hline\\endhead #@row_break")
          @string="#@string \\multicolumn{#{@@number_of_cols}}{l}{\\tiny #{tablefoot}} \\\\ \\hline\n\\endfoot\n\\hline\n" if tablefoot
          @@tableheader,@@number_of_cols=0,0
        end
      else
        if @string =~/¡\d+?¡(.+?)(?:¡|!)/
          @string.gsub!(/¡\d+?¡(.+?)(?:¡|!)/,'\1&')
          @string.gsub!(/&>\s*$/," #@row_break")
        end
      end
      @string="<~#{ocn}>" + @string
    end
    def scopedtable
      # some features related to headers have been incorporated in longtable that are not included yet here,
      # so until synced is broken on some input files, work needs to be done if is to work as before
      @end_table="\\end{tabular}"
      @row_break='\\\\\\\\'
      @break_page="#@row_break\n#@row_break \n"
      if @string[/<!Th?¡\s+c(\d+);(.+?)!>/]
        no_of_cols,cols_width=$1,$2
        @w=cols_width.split(/;\s*/)
        @colW=[]
        @w.each  do |x|
          col_w=((x.to_i*12)/100.00).to_s #unless x.nil?
          @colW << "p{#{col_w}cm}" if col_w
        end
        @start_table="\\begin{tabular}{#@colW}\n"
        @string.gsub!(/<!Th?¡\s+c\d+?;.+!>/,"#@start_table}")
      end
      if @string =~/<!TZ!>/
        @string.gsub!(/<!TZ!>/,"#@end_table")
        @@table_pg_break_counter=1
      end
      if @string =~/<!¡/
        if @@table_pg_break_counter == 28 # taken from 34 ideal for portrait to 28 which suits landscape
          @string="\n\n#@end_table \n#@break_page#@start_table\n"
          @@table_pg_break_counter=1
        else
          @string.gsub!(/<!¡/,'')
          @@table_pg_break_counter+=1
          tablefoot=@string[/\<!f(.+?)!\>/,1]
          @string.gsub!(/\<!f(.+?)!\>/,'')
        end
      end
      if @string =~/¡\d+?¡(.+?)(?:¡|!)/
      @string.gsub!(/¡\d+?¡(.+?)(?:¡|!)/,"\\1&")
      @string.gsub!(/&>\s*$/,"#@row_break")
      end
      @string
    end
    def special_characters_1(para)             # ~ ^ $ & % _ { }  #LaTeX special characters - KEEP list
      #p @@utf_8.list
      #@string=Iconv.conv('ISO-8859-1', 'UTF-8', @string)
      word=@string.scan(/\S+|\n/) #unless line =~/^(?:0~\S|%+\s)/
      para_array=[]
      if word
        word.each do |w| # _ - / # | : ! ^ ~
          unless para =~/^(?:0~|%+ |<!Th?¡ )/m
            w.gsub!(/[\\]?~/,'<=tilde>') unless w=~/^[1-6]~|~\{|\}~|~\[|\]~|^\^~\s|~\^|\*~\S+|~#|\{t~|<~\d+;(?:[ohmu]|[0-6]:)\d+;\w\d+>/
            w.gsub!(/&#(?:126|152);/,'<=tilde>') #126 usual
            #w.gsub!(/&#(?:126|152);/,'<=tilde>') unless w=~/https?:\/\/\S+/ #126 usual
            w.gsub!(/\\?\||&#124;/,'<=pipe>') #unless w=~/<~\d+;(?:[ohmu]|[0-6]:)\d+;\w\d+>/ # | SiSU not really special sisu character but done, also LaTeX
          end
          para_array << w
        end
        para=para_array.join(' ')
        @string=para.strip
      end
      @string.gsub!(/<~\d+;(?:\w|[0-6]:)\d+;[umdv]\d+><#@dp:#@dp>/,'')
      @string.gsub!(/.+?<-#>/,'')
      @string.gsub!(/<EOF>/,'')
      @string.gsub!(/<ENDNOTES?>/,'')
      #problem sequence ->
      @string.gsub!(/&(?:nbsp);/,'<=hardspace>')                                 # < SiSU special character also LaTeX
      @string.gsub!(/&(?:lt|#060);/,'<=lt>')                                     # < SiSU special character also LaTeX
      @string.gsub!(/&(?:gt|#062);/,'<=gt>')                                     # > SiSU special character also LaTeX
      @string.gsub!(/&#123;/,'<=curlyopen>')                                     # { SiSU special character also LaTeX
      @string.gsub!(/&#125;/,'<=curlyclose>')                                    # } SiSU special character also LaTeX
      @string.gsub!(/&#(?:126|152);/,'<=tilde>')                                 # ~ SiSU special character also LaTeX
      @string.gsub!(/&#035;/,'\#')                                               # # SiSU special character also LaTeX
      @string.gsub!(/&#033;/,'!')                                                # ! SiSU not really special sisu character but done, also LaTeX
      @string.gsub!(/&#042;/,'*')                                                # * should you wish to escape astrisk e.g. describing \*{bold}*
      @string.gsub!(/&#045;/,'-')                                                # - SiSU special character also LaTeX
      @string.gsub!(/&#043;/,'+')                                                # + SiSU special character also LaTeX
      @string.gsub!(/&#044;/,',')                                                # + SiSU special character also LaTeX
      @string.gsub!(/&#038;/,'<=amp>') #unless @string=~/<:code>/                   # / SiSU special character also LaTeX
      @string.gsub!(/&#047;/,'<=slash>')                                         # / SiSU special character also LaTeX
      @string.gsub!(/&#092;/,'<=backslash>')                                     # \ SiSU special character also LaTeX
      @string.gsub!(/&#095;/,'<=underscore>')                                    # _ SiSU special character also LaTeX
      @string.gsub!(/&#124;/,'|')                                                # | SiSU not really special sisu character but done, also LaTeX
      @string.gsub!(/&#058;/,':')                                                # : SiSU not really special sisu character but done, also LaTeX
      @string.gsub!(/&#094;|\^/,'<=caret>')                                      # ^ SiSU not really special sisu character but done, also LaTeX
      @string.gsub!(/\#/,'<=hash>')
      ##watch placement, problem sequence ^
      @string.gsub!(/<sup><font face=symbol>&atild;<\/font><\/sup>/,' ')
      @string.gsub!(/<:pb>/,'\newpage')
      @string.gsub!(/<:pn>/,'\clearpage')
      @string.gsub!(/\\copy(right|mark)?/,'<=copymark>') # ok problem with superscript
    end
    def special_characters_2(para)
      @string.gsub!(/&#156;/,'\oe ')
      @string.gsub!(/\$/,'\$')
      @string.gsub!(/\#/,'\#')
      @string.gsub!(/\%/,'\%')
      @string.gsub!(/\~/,'\~') #revist, should not be necessary to mark remaining tildes
      if @string !~/^\s*<:image|\}:image\s/
        @string.gsub!(/_/,'\_')
      end
      @string.gsub!(/\{/,'\{')
      @string.gsub!(/\}/,'\}')
      @string.gsub!(/&nbsp;/,'~') # ~ character for hardspace
      # sequence important must appear after removal of { and }
      @string.gsub!(/&\S+?;/,'') #hmmm
      # sequence imortant place before removal of &
      if @string=~/<:code>/;        @@flag_code=true
      elsif @string=~/<:code-end>/; @@flag_code=false
      end
      if @@flag_code; @string.gsub!(/&/,'{\\\&}')
      else @string.gsub!(/(\s+&\s+)/,' and ')
      end
      @string.gsub!(/§/,'\S') #latex: space between next character not preserved? #@string.gsub!(/§ /,'\S ')
      @string.gsub!(/£/,'\pounds')
      @string.gsub!(/&\S+?;/,' ')
      @string.gsub!(/<a href=".+?">/,' ')
      @string.gsub!(/<\/a>/,' ')
      @string.gsub!(/[^\}>_]((?:https?|file|ftp):\/\/\S+?)(<\/\S>)/,' \begin{scriptsize}\href{\1}{\1} \end{scriptsize}\2') #special case
      @string.gsub!(/((?:^|\s)[}])((?:https?|file|ftp):\/\/\S+?\.[^'"><\s]+?)([;.,]?(?:\s|$))/,'\1\begin{scriptsize}\\href{\2}{\2}\end{scriptsize}\3') #special case \{ e.g. \}http://url
      @string.gsub!(/\B(?:\\_|\\)((?:https?|file|ftp):\/\/\S+?\.[^'"><\s]+?)([;.,]?(?:\s|$))/,'\begin{scriptsize}\\href{\1}{\1}\end{scriptsize}\2') #specially escaped url no decoration
      unless @@flag_code
        @string.gsub!(/(^|\s)((?:https?|file|ftp):\/\/\S+?\.[^'"><\s]+?)([;.,]?(?=\s|$))/,"\\1#{@url_brace.tex_open}\\begin{scriptsize}\\href{\\2}{\\2}\\end{scriptsize}#{@url_brace.tex_close}\\3") #url matching with decoration <url> positive lookahead, sequence issue with { linked }http://url cannot use \b at start
      else #code-block: angle brackets special characters, note _ already escaped
        @string.gsub!(/\\_</,'{\UseTextSymbol{OML}{<}}')
        @string.gsub!(/\\_>/,'{\UseTextSymbol{OML}{>}}')
      end
      @string.gsub!(/<:ee>/,'')
      @string.gsub!(/<!>/,' ')
      #proposed change, insert, but may be redundant
      @string.gsub!(/ \/><:i[12]>(.+?)(?:\}~|<br)/,' \begin{ParagraphIndent}{0.01\columnwidth}\1\end{ParagraphIndent} ') # footnote indents, problems if match exists in ordinary paragraphs? check! Work Area 200501 a bit tricky as must be able to match multiple times, and to clean remainder
      @string.gsub!(/<(br|p)>|<\/\s*(br|p)>|<(br|p)\s*\/>/," #{@@tex_backslash*2} ") # Work Area
      @string.gsub!(/<b>(.+?)<\/b>/,'\begin{bfseries}\1 \end{bfseries}')
      @string.gsub!(/<em>(.+?)<\/em>/,'\begin{bfseries}\1 \end{bfseries}')
      @string.gsub!(/<(bold|strong)>(.+?)<\/(bold|strong)>/,'\begin{bfseries}\1 \end{bfseries}')
      @string.gsub!(/<h\d+>(.+?)<\/h\d+>/,'\begin{bfseries}\1 \end{bfseries}')
      @string.gsub!(/<i>(.+?)<\/i>/,'\emph{\1}')
      @string.gsub!(/<italic>(.+?)<\/italic>/,'\emph{\1}')
      @string.gsub!(/<u>(.+?)<\/u>/,'\uline{\1}') # ulem
      @string.gsub!(/<cite>(.+?)<\/cite>/,"``\\1''") # quote
      @string.gsub!(/<ins>(.+?)<\/ins>/,'\uline{\1}') # ulem
      @string.gsub!(/<del>(.+?)<\/del>/,'\sout{\1}') # ulem
      @string.gsub!(/<sub>(.+?)<\/sub>/,"\$_{\\textrm{\\1}}\$")
      @string.gsub!(/<sup>(.+?)<\/sup>/,"\$^{\\textrm{\\1}}\$")
      unless @@flag_code
        @string.gsub!(/"(.+?)"/,"``\\1''")  # quote marks / quotations open & close " need condition exclude for code
        @string.gsub!(/\s+"/,' ``')                                          # open "
        @string.gsub!(/^([1-6-]#{@@tilde}\S*|<.+?>)?\s*"/,'\1``')       # open "
        @string.gsub!(/"(\s|\.|,|:|;)/,"''\\1")                              # close "
        @string.gsub!(/"([1-6-]#{@@tilde}\S*|<.+?>)?\s*$/,"''\\1")      # close "
        @string.gsub!(/"(\.|,)/,"''")                                        # close "
        @string.gsub!(/\s+'/,' `')                                           # open '
        @string.gsub!(/^([1-6-]#{@@tilde}\S*|<.+?>)?\s*'/,'\1`')        # open '
      end
      @string.gsub!(/^(<:i[1-9]>)?\s*\\_\*\s*/,'\1 \begin{math} \bullet \end{math}~~') #bullets - added 2004w17 watch \\_
      @string.gsub!(/(<font.*?>|<\/font>)/,'')
      @string.gsub!(/\s*<sup>(\S+?)<\/sup>/,'^\1')
      @string.gsub!(/(<sup>|<\/sup>)/,'')
      @string
    end
    def special_characters_3(para)
      @string.gsub!(/<br(\s*[^\/][^>])/,'\1') # clean up, incredibly messy :-( footnote indents, problems if match exists in ordinary paragraphs? check! Work Area 200501 a bit tricky as must be able to match multiple times, and to clean remainder
      @string.gsub!(/([^<][^b][^r]\s+)\/>/,'\1') # clean up, incredibly messy :-( footnote indents, problems if match exists in ordinary paragraphs? check! Work Area 200501 a bit tricky as must be able to match multiple times, and to clean remainder
      #problem sequence (another kludge) ->
      @string.gsub!(/<=lt>/,'{\UseTextSymbol{OML}{<}}')
      @string.gsub!(/<=gt>/,'{\UseTextSymbol{OML}{>}}')
      #@string.gsub!(/<=lt>/,'\<')
      #@string.gsub!(/<=gt>/,'\>')
      @string.gsub!(/<=underscore>/,'\_')
      @string.gsub!(/(\href\{http:\/\/\S+?)(?:(?:<=tilde>)(\S+))+\}/,'\1\~\2}') #tildes in urls \href treated differently from text
      @string.gsub!(/<=tilde>/,'{\~~}')
      @string.gsub!(/<=pipe>/,'{\textbar}')
      @string.gsub!(/<=caret>/,'{\^{~}}')
      #@string.gsub!(/<=caret>/,'\^{}')
      @string.gsub!(/<=exclaim>/,'\Verbatim{!}')
      @string.gsub!(/<=hash>/,'{\#}')
      #@string.gsub!(/<=hash>/,'{\UseTextSymbol{OT1}{#}}')
      #@string.gsub!(/<=slash>/,'{\slash}')
      @string.gsub!(/<=hardspace>/,'{~}') #changed ... 2005
      @string.gsub!(/<=amp>/,'{\\\&}') #changed ... 2005
      #@string.gsub!(/<=amp>/,'{\UseTextSymbol{OT1}{&}}')
      @string.gsub!(/<=slash>/,'{/}')
      @string.gsub!(/<=backslash>/,'{\textbackslash}')
      #@string.gsub!(/<=asterisk>/,'*')
      #@string.gsub!(/<=exclaim>/,'!')
      #@string.gsub!(/<=asterisk>/,'{\ast}')
      #@string.gsub!(/<=copymark>/,"^{\\copyright} ") # watch has been problematic
      #copymark='{\\begin{small}\\raisebox{1ex}{\\copyright}\\end{small}} '
      @string.gsub!(/<=copymark>\s*(.+)?\s+(<\\~\d+;\w(?:[0-6]:)?\d+;\w\d+><#@dp:#@dp>)/,"^\\copyright \\textnormal{\\1} \\2") # watch likely to be problematic
      @string
    end
    def special_characters_curly(para)
      @string.gsub!(/<=curlyopen>/,'\{')
      @string.gsub!(/<=curlyclose>/,'\}')
      @string
    end
    def special_characters_unsafe_1(para) #depreciated, make obsolete
      # some substitutions are sequence sensitive, rearrange with care.
      @string.gsub!(/\\backslash (copyright|clearpage|newpage)/,"\\\\\\1")  #kludge bad solution, find out where tail is sent through specChar !
    end
    def special_characters_unsafe_2(para)
    end
    def special_characters_unsafe_3(para)
    end
    def special_characters                                                       #special characters - some substitutions are sequence sensitive, rearrange with care.
      special_characters_1(@string)
      special_characters_unsafe_1(@string)
      special_characters_2(@string)
      special_characters_3(@string)
    end
    def special_characters_safe                                                  #special characters - some substitutions are sequence sensitive, rearrange with care.
      special_characters_1(@string)
      special_characters_2(@string)
      #special_characters_3(@string)
    end
    def heading_major(para,lev)
      title=@md.title
      para.strip! if para
      para.gsub!(/(?:\\begin\{bfseries\}|\\begin\{itshape\})(.+?)(?:\\end\{bfseries\}|\\end\{itshape\})/m,'\1')
      cont_ln=para.dup
      cont_ln.gsub!(/#{@@tex_pattern_margin_number}/,'')
      cont_ln.gsub!(/#{lev}#{@@tilde}(?:\S+)?\s+/,'')
      if para =~/\\[Ff]ootnote/ #and para =~/^[1-6]#{@@tilde}/ # removing footnotes from headings!
        cont_ln.gsub!(/\s*\\footnote\[\d+\]\{%\n .+? \}\s*/,' ')
        cont_ln.gsub!(/\s*\\Footnote[A]\{[*+]+\d*\}\{%\n .+? \}\s*/,' ')
      end
      para.gsub!(/(#{@md.lev}.*)\n?$/m,"\\part*{\\1}
\\addcontentsline{toc}{section}{#{cont_ln}}
\\markboth{#{title}}\n") if (para !~/#{lev}#{@@tilde}/)
      para.gsub!(/^#{lev}#{@@tilde}\s*(.*)\n?$/m,
        "\\part*{\\1}
\\addcontentsline{toc}{section}{#{cont_ln}}
\\markboth{#{title}}\n")
    end
    def level1
      heading_major(@string,1)
    end
    def level2
      heading_major(@string,2)
    end
    def level3
      heading_major(@string,3)
    end
    def level4
      @string.strip! if @string
      @string.gsub!(/(?:\\begin\{bfseries\}|\\begin\{itshape\})(.+?)(?:\\end\{bfseries\}|\\end\{itshape\})/m,'\1')
      cont_ln=@string.dup
      cont_ln.gsub!(/#{@@tex_pattern_margin_number}/,'')
      cont_ln.gsub!(/#{@@tex_backslash*2}/,"#{@@tex_backslash*4}") # added w42
      cont_ln.gsub!(/4#{@@tilde}\S+\s+/,'')
      cont_ln.gsub!(/\\footnote\[\d+\]\{%.+?\\end\{scriptsize\}\s*\}/m,'') #arbitrary bugfix, revisit should not be necessary, eg. wta.1994 2004w22
      cont_ln.gsub!(/\\Footnote[A]\{[*+]+\d*\}\{%.+?\\end\{scriptsize\}\s*\}/m,'') #arbitrary bugfix, revisit should not be necessary, eg. wta.1994 2004w22
      title=@md.title
      @string.gsub!(/#{@md.lv4}\s+(#{@md.lv4})/m,'\1')
      if @string =~/4#{@@tilde}endnotes|<:4-endnotes>/
        # watch exclusion removes endnotes marker from pdf 2003w03
        @string.gsub!(/.+/m,'')
      end
      if @string =~/\\footnote/ #and para =~/^[1-6]#{@@tilde}/ # removing footnotes from headings!
        cont_ln.gsub!(/\s*\\footnote\[\d+\]\{%\n .+? \}\s*/,' ')
        cont_ln.gsub!(/\s*\\Footnote[A]\{[*+]+\d*\}\{%\n .+? \}\s*/,' ')
      end
      if @string !~/4#{@@tilde}/
        @string.gsub!(/(#{@md.lv4}.*)\n?$/m,"\\subsubsection*{\\1}
\\addcontentsline{toc}{subsection}{#{cont_ln}}
\\markright{#{title}}")
      else
        @string.gsub!(/^\s*4#{@@tilde}\S+\s*(.*)?\n?$/m,"\\subsubsection*{\\1}
\\addcontentsline{toc}{subsection}{#{cont_ln}}
\\markright{#{title}}")
      end
      @string.gsub!(/#{@md.lv4}\s*(.marginpar)/m,'\1')
    end
    def level5
      # there is a problem here with creation of headers does not do what you would want it to header starts with a * and is not in bold work on \\@string*, same for next section 2002w46
      @string.strip! if @string
      @string.gsub!(/(?:\\begin\{bfseries\}|\\begin\{itshape\})(.+?)(?:\\end\{bfseries\}|\\end\{itshape\})/m,'\1')
      cont_ln=@string.dup
      cont_ln.gsub!(/#{@@tex_pattern_margin_number}/,'')
      cont_ln.gsub!(/5#{@@tilde}\S*\s+/,'')
      cont_ln.gsub!(/\\footnote\[\d+\]\{%.+?\\end\{scriptsize\}\s*\}/m,'') #arbitrary bugfix, revisit should not be necessary, eg. wta.1994 2004w22
      cont_ln.gsub!(/\\Footnote[A]\{[*+]+\d*\}\{%.+?\\end\{scriptsize\}\s*\}/m,'') #arbitrary bugfix, revisit should not be necessary, eg. wta.1994 2004w22
      cont_ln.gsub!(/\\\&/,' and ') #revisit: tmp bugfix 200507, substitutes & with 'and' in toc, needed e.g. for AT&T, see ffa
      @string.gsub!(/#{@md.lv5}\s+(#{@md.lv5})/m,'\1')
      if @string =~/\\footnote/ #and para =~/^[1-6]#{@@tilde}/ # removing footnotes from headings!
        cont_ln.gsub!(/\s*\\footnote\[\d+\]\{%\n .+? \}\s*/,' ')
        cont_ln.gsub!(/\s*\\Footnote[A]\{[*+]+\d*\}\{%\n .+? \}\s*/,' ')
      end
      if @string !~/5#{@@tilde}/
        @string.gsub!(/(#{@md.lv5}.*?)\n?$/m,"\\subsubsection*{\\1}
\\addcontentsline{toc}{subsubsection}{#{cont_ln} \\\\
}")
      else
        @string.gsub!(/^\s*5#{@@tilde}\S*\s*(.*)?\n?$/m,"\\subsubsection*{\\1}
\\addcontentsline{toc}{subsubsection}{#{cont_ln} \\\\
}")
      end
      @string.gsub!(/#{@md.lv5}\s*(.marginpar)/m,'\1')
    end
    def level6
      # there is a problem here with creation of headers does not do what you would want it to header starts with a * and is not in bold work on \\sub@string*, same for previous section 2002w46
      @string.strip! if @string
      @string.gsub!(/(?:\\begin\{bfseries\}|\\begin\{itshape\})(.+?)(?:\\end\{bfseries\}|\\end\{itshape\})/m,'\1')
      cont_ln=@string.dup
      cont_ln.gsub!(/#{@@tex_pattern_margin_number}/,'')
      cont_ln.gsub!(/6#{@@tilde}\S*\s+/,'')
      cont_ln.gsub!(/\\footnote\[\d+\]\{%.+?\\end\{scriptsize\}\s*\}/m,'') #arbitrary bugfix, revisit should not be necessary, eg. wta.1994 2004w22
      cont_ln.gsub!(/\\Footnote[A]\{[*+]+\d*\}\{%.+?\\end\{scriptsize\}\s*\}/m,'') #arbitrary bugfix, revisit should not be necessary, eg. wta.1994 2004w22
      @string.gsub!(/#{@md.lv6}\s+(#{@md.lv6})/m,'\1')
      if @string =~/\\footnote/ #and para =~/^[1-6]#{@@tilde}/ # removing footnotes from headings!
        cont_ln.gsub!(/\s*\\footnote\[\d+\]\{%\n .+? \}\s*/,' ')
        cont_ln.gsub!(/\s*\\Footnote[A]\{[*+]+\d*\}\{%\n .+? \}\s*/,' ')
      end
      @string.gsub!(/(#{@md.lv6}.*)\n?$/m,
        "\\subsubsection*{\\1}") if (@string !~/6#{@@tilde}/)
      @string.gsub!(/^\s*6#{@@tilde}\S*\s*(.*)?\n?$/m,
        '\subsubsection*{\1}')
      @string.gsub!(/#{@md.lv6}\s*(.marginpar)/m,'\1')
      #end BUGWATCH
    end
    def indent(lev)
      indent=case lev
      when /1/; '0mm'
      when /2/; '10mm'
      when /3/; '20mm'
      when /4/; '30mm'
      when /5/; '40mm'
      when /6/; '50mm'
      when /7/; '60mm'
      when /8/; '70mm'
      when /9/; '80mm'
      end
      @string.gsub!(/<:i#{lev}>\s*(.*)/m,
        "\\begin{ParagraphIndent}{#{indent}}\\1
\\end{ParagraphIndent}}")
    end
    def symbol_graphic
      dir=SiSU_Env::Info_env.new(@md.fns)
      image='c_' + /<:=\s*(\S+?)\s*>/m.match(@string).captures.join + '.png' #watch
      if FileTest.file?("#{dir.path.image_source_tex}/#{image}")
        @string.gsub!(/<:=\s*(\S+?)\s*>/,
          "\\includegraphics*[width=11pt]{#{dir.path.image_source_tex}/c_\\1.png}")
      else
        tell=SiSU_Screen::Ansi.new(@md.cmd,"ERROR - image:",%{"#{image}" missing},"search path: #{dir.path.image_source_tex}")
        tell.error2 unless @md.cmd =~/q/
        @string.gsub!(/\{\S+\.(png|jpg|gif).+?\}(?:https?|file|ftp):\/\/\S+/,'') # fragile match operator\\ fragile !
      end
    end
    def image
      dir=SiSU_Env::Info_env.new(@md.fns)
      image,m=/<:image\s+(\S+)\s+.+?width=``(\d+)''.+?>/m.match(@string).captures
      width=m[1] || '100'
      width=width.to_i*0.4
      image_source=if @md.fns =~/\.(?:ssm\.)?sst$/ \
      and FileTest.file?("#{dir.path.image_source_local_tex}/#{image}")
        dir.path.image_source_local_tex
      elsif @md.fns =~/\.-ss[tm]$/ \
      and FileTest.file?("#{dir.path.image_source_remote_tex}/#{image}")
        dir.path.image_source_remote_tex
      elsif FileTest.file?("#{dir.path.image_source_tex}/#{image}")
        dir.path.image_source_tex
      else
        tell=SiSU_Screen::Ansi.new(@md.cmd,"ERROR - image:",%{"#{image}" missing},"search locations: #{dir.path.image_source_local_tex},#{dir.path.image_source_remote_tex} and #{dir.path.image_source_tex}")
        tell.error2 unless @md.cmd =~/q/
        nil
      end
      if image_source
        @string.gsub!(/<:image\s+((?:https?|file|ftp)\S+)\s+(\S+)\s+.+\s+?>/,
          @center_begin + "\\href{\\1}{\\includegraphics*[width=#{width}pt]{#{image_source}/\\2}}" + @center_end )
        @string.gsub!(/<:image\s+(\S+)\s+.+\s+?>/,
          @center_begin + "\\includegraphics*[width=#{width}pt]{#{image_source}/\\1}" + @center_end )
      else @string.gsub!(/<:image\s+(\S+)\s+.+\s+?>/,'\1}')
      end
    end
    def png #fc missing image check
      dir=SiSU_Env::Info_env.new(@md.fns)
      # messy clean up
      z=@string[/\\\{(\S.+?)\}(?:image|png)/,1].strip if @string =~ /\\\{\S.+?\}(?:image|png)/ # match operator for z \\ fragile !
      if z #debug 2004w14
        image=z[/(\S+?\.(?:png|jpg|gif)\b)/m]
        image.gsub!(/\\/,'')
        width=if z =~ /\d+x\d*/
          w=(z[/(\d+)x\d*/,1]).to_i
          w*0.8
        else '100' #revisit, is bug for small images/icons
        end
        width='380' if width.to_i > 380
        c=z[/``(.+?)''/m]
      end
      hsp="\n{\\color{mywhite} .}&~\n" # ~ character for hardspace
      caption="{\\\\\\\ \n\\begin{scriptsize}#{hsp*3}#{c}\\end{scriptsize}&}" if c
      #caption="{\\\\\\\ \n\\begin{scriptsize}#{hsp*3}#{c[1]}\\end{scriptsize}&}" if c
      image_source=if @md.fns =~/\.(?:ssm\.)?sst$/ \
      and FileTest.file?("#{dir.path.image_source_local_tex}/#{image}")
        dir.path.image_source_local_tex
      elsif @md.fns =~/\.-ss[tm]$/ \
      and FileTest.file?("#{dir.path.image_source_remote_tex}/#{image}")
        dir.path.image_source_remote_tex
      elsif FileTest.file?("#{dir.path.image_source_tex}/#{image}")
        dir.path.image_source_tex
      else
        unless image.nil? \
        or image.length < 2
          tell=SiSU_Screen::Ansi.new(@md.cmd,"ERROR - image:",%{"#{image}" missing},"search locations: #{dir.path.image_source_local_tex},#{dir.path.image_source_remote_tex} and #{dir.path.image_source_tex}")
          tell.error2 unless @md.cmd =~/q/
        end
        nil
      end
      if image_source
        @string.gsub!(/\\\{\S+\.(png|jpg|gif).+?\}(image|png)/, # fragile match operator\\ fragile !
          "#@center_begin\n\\includegraphics*[width=#{width}pt]{#{image_source}/#{image}}#{caption}#@center_end")
      else
        @string.gsub!(/\\\{\S+\.(png|jpg|gif).+?\}(image|png)/,'') # fragile match operator\\ fragile !
      end
    end
    def http_word_mode(orientation='')
      # clean up ! - work area, testing
      dir=SiSU_Env::Info_env.new(@md.fns)
      @words=[]
      @string.each do |word|
        @words << if word=~/\\\{.+?\\\}(?:https?|file|ftp):\S+/
          if word =~/\\\{(.+?)\\\}((?:https?|file|ftp):\/\/\S+?\.[^'"><\s]+?)([;.,]?(?:\s|$))/
            r=%r/\\\{(.+?)\\?\}((?:https?|file|ftp):\/\/\S+?\.[^'"><\s]+?)(?:[;.,]?(?:\s|$)|(?:\s|$))/
            d=/\\\{.+?\\?\}(?:https?|file|ftp):\/\/\S+?\.[^'"><\s]+?([;.,]?(?:\s|$))/.match(word).captures.to_s
          else
            r=%r/\\\{(.+?)\\?\}((?:https?|file|ftp):\S+)/
            d=''
          end
          z,url=r.match(word).captures if word =~r
          url=url.strip
          if word =~/\{\s*\S+\.?(?:png|jpg|gif)/ \
          and word=~/\s+\d+x\d+\s+/
            image,x,y=z.scan(/\S+/)
            image.gsub!(/\\/,'')
            width=200
            width=z[/(\d+)x\d*/,1] ||='200' #watch
            dm=case @md.papersize
            when /a4/;     @tx.a4
            when /letter/; @tx.letter
            when /legal/;  @tx.legal
            when /b5/;     @tx.b5
            when /a5/;     @tx.a5
            else           @tx.a4
            end
            width=if orientation =~/portrait/ #value is not currently passed
              width=if width.to_i > dm.portrait.img_px; dm.portrait.img_px
              else                                      width
              end
            else
              width=if width.to_i > dm.landscape.img_px; dm.landscape.img_px
              else                                       width
              end
            end
            c=z[/``(.+?)''/m,1]
            hsp="\n{\\color{mywhite} .}&~\n" # ~ character for hardspace
            caption="{\\\\\ \n\\begin{scriptsize}#{hsp*3}#{c}\\end{scriptsize}&}" if c
          elsif word =~/\{\s*(\S+\.?\.(?:png|jpg|gif))/
            tell=SiSU_Screen::Ansi.new(@md.cmd,%{document built without image: "#{$1}" as image dimensions not provided (& librmagick-ruby is not installed)?\n})
            tell.print_grey #unless @opt.cmd =~/q/
          end
          ins=if image #most images fc etc. #% clean up !
            out=if @md.fns =~/\.(?:ssm\.)?sst$/ \
            and FileTest.file?("#{dir.path.image_source_local_tex}/#{image}")
              @center_begin +
              "\\\n\\href{#{url}}" + #not satisfactory: \\ added to ^line to mimic reference file output
              "{\\includegraphics*[width=#{width}pt]" +
              "{#{dir.path.image_source_local_tex}/#{image}}}" +
              "#{caption}" +
              @center_end if word =~ /(\{[a-zA-Z0-9_\\]+\.(?:png|jpg|gif).+?\}(?:https?|file|ftp):\/\/\S+)/
            elsif @md.fns =~/\.-ss[tm]$/ \
            and FileTest.file?("#{dir.path.image_source_remote_tex}/#{image}")
              @center_begin +
              "\\\n\\href{#{url}}" + #not satisfactory: \\ added to ^line to mimic reference file output
              "{\\includegraphics*[width=#{width}pt]" +
              "{#{dir.path.image_source_remote_tex}/#{image}}}"  +
              "#{caption}" +
              @center_end if word =~ /(\{[a-zA-Z0-9_\\]+\.(?:png|jpg|gif).+?\}(?:https?|file|ftp):\/\/\S+)/
            elsif FileTest.file?("#{dir.path.image_source_tex}/#{image}")
              @center_begin +
              "\\\n\\href{#{url}}\n" + #not satisfactory: \\ added to ^line to mimic reference file output, mirror above ... not tested
              "{\\includegraphics*[width=#{width}pt]" +
              "{#{dir.path.image_source_tex}/#{image}}}" +
              "#{caption}" +
              @center_end if word =~/(\{[a-zA-Z0-9_\\]+\.(?:png|jpg|gif).+?\}(?:https?|file|ftp):\/\/\S+)/
            else
              tell=SiSU_Screen::Ansi.new(@md.cmd,"ERROR - image:",%{"#{image}" missing},"search locations: #{dir.path.image_source_local_tex},#{dir.path.image_source_remote_tex} and #{dir.path.image_source_tex}")
              tell.error2 unless @md.cmd =~/q/
              '' if word =~ /\{\S+\.(png|jpg|gif).+?\}(?:https?|file|ftp):\/\/\S+/
            end
          else
            link=z.strip #[/(.+?)\\/m,1]
            word="\\href{#{url}}{#{link}}#{d}" if word =~/\\\{.+?\\\}(?:https?|file|ftp):\/\/\S+/
          end
        else word
        end
      end
      @words.join
    end
    def http(orientation)
      wm=@string.dup.scan(/\\\{.+?\\\}(?:(?:https?|file|ftp):\S+|image)|\w+\s*|./m)
      @string=SiSU_TeX_Pdf::Format_text_object.new(@md,wm).http_word_mode(orientation)
    end
    def language
      @lang=if @md.dc_language[:code]
        case @md.dc_language[:code]
        when 'en'; 'english'
        when 'us'; 'USenglish' # depreciated, see iso-639-2
        when 'fr'; 'french'
        when 'de'; 'ngerman'
        when 'it'; 'italian'
        when 'es'; 'spanish'
        when 'pt'; 'portuges'
        #when 'br'; 'brazilian' # depreciated, see iso-639-2
        when 'sv'; 'swedish'
        when 'da'; 'danish'
        when 'fi'; 'finnish'
        when 'no'; 'norske,nynorsk'
        when 'is'; 'icelandic'
        when 'nl'; 'dutch'
        when 'et'; 'estonian'
        when 'hu'; 'magyar'
        when 'pl'; 'polish'
        when 'ro'; 'romanian'
        when 'ru'; 'russian'
        when 'gl'; 'greek'
        when 'uk'; 'ukrainian'
        when 'tr'; 'turkish'
        when 'sk'; 'slovak'
        when 'sl'; 'slovenian'
        when 'hr'; 'croatian'
        when 'cs'; 'czech'
        when 'bg'; 'bulgarian'
        else       'english'
        end
      else         'english'
      end
    end
    def title
      @string=Format_text_object.new(@md,@string).special_characters_safe
      if @string1
        @string1=Format_text_object.new(@md,@string1).special_characters_safe
        @string1.gsub!(/\$/,"\\$")
        "\n\\title{#@string#{@@tex_backslash*2} \\textbf{\\normalsize #@string1}\\normalsize}"
      else "\n\\title{#@string}"
      end
    end
    def title_landscape
      title
    end
    def title_portrait
      title
    end
    def tex_head_lang #babel 18n
      language
      #@md.dc_language[:name]
      lang=if @lang =~/^(?:en)$/; @lang
      else "#@lang,english"
      end
    end
    def tex_head_encode
      case @md.file_encoding
      when /iso-?8859/i                                                         #% iso8859
      <<WOK
\\usepackage[latin1]{inputenc}
WOK
      else                                                                      #% utf-8 assumed
      <<WOK
\\usepackage{babel}
\\usepackage{ucs}
\\usepackage[utf8x]{inputenc}
WOK
      end
    end
    def tex_head_info
      generator="Generated by: #{@md.sisu_version[:project]} #{@md.sisu_version[:version]} of #{@md.sisu_version[:date_stamp]} (#{@md.sisu_version[:date]})"  if @md.sisu_version[:version]
      lastdone="Last Generated on: #{Time.now}"
      rubyv="Ruby version: #{@md.ruby_version}"
      <<WOK
%% SiSU (Linux & Ruby - \"better ways\") LaTeX output
%% #{generator}
%% #{rubyv}
%% LaTeX output
%% #{lastdone}
%% SiSU http://www.jus.uio.no/sisu
WOK
    end
    def tex_head_paper_portrait(d)
      <<WOK
#{tex_head_info}
\\documentclass[#{d[:fontsize]},#{d[:papertype]},#{tex_head_lang},titlepage]{scrartcl}        %with titlepage
\\setlength{\\textheight}{#{d[:textheight]}mm}  \\setlength{\\textwidth}{#{d[:textwidth]}mm}
\\setlength{\\oddsidemargin}{#{d[:oddsidemargin]}}  \\setlength{\\evensidemargin}{#{d[:evensidemargin]}}
\\setlength{\\topmargin}{#{d[:topmargin]}}  \\setlength{\\headheight}{#{d[:headheight]}}
\\setlength{\\headsep}{#{d[:headsep]}}
\\setlength{\\marginparsep}{#{d[:marginparsep]}}
\\setlength{\\marginparwidth}{#{d[:marginparwidth]}}
WOK
    end
    def tex_head_paper_landscape(d)
      <<WOK
#{tex_head_info}
\\documentclass[#{d[:fontsize]},#{d[:papertype]},#{tex_head_lang}, landscape, titlepage, twocolumn]{scrartcl}        %with titlepage
\\setlength{\\textheight}{#{d[:textheight]}mm}  \\setlength{\\textwidth}{#{d[:textwidth]}mm}
\\setlength{\\oddsidemargin}{#{d[:oddsidemargin]}}  \\setlength{\\evensidemargin}{#{d[:evensidemargin]}}
\\setlength{\\topmargin}{#{d[:topmargin]}}  \\setlength{\\headheight}{#{d[:headheight]}}
\\setlength{\\headsep}{#{d[:headsep]}}
\\setlength{\\columnsep}{#{d[:columnsep]}}
\\setlength{\\marginparsep}{#{d[:marginparsep]}}
\\setlength{\\marginparwidth}{#{d[:marginparwidth]}}
WOK
    end
    def tex_head_paper_dimensions
      d={}
      case @string
      when /portrait/
        #textheight,textwidth=@tx.a4.portrait.h,@tx.a4.portrait.w
        d[:papertype],d[:fontsize]='a4paper','11pt'
        d[:oddsidemargin],d[:evensidemargin],d[:topmargin]='0mm','0mm','-12pt'
        d[:headheight],d[:headsep],d[:columnsep]='12pt','35pt',''
        d[:marginparsep],d[:marginparwidth]='4mm','8mm'
        case @md.papersize
        when /a4/i           #European default, SiSU default
          d[:papertype],d[:fontsize]='a4paper','12pt'
          d[:textheight],d[:textwidth]=@tx.a4.portrait.h,@tx.a4.portrait.w
        when /letter/i   #U.S. default
          d[:papertype],d[:fontsize]='letterpaper','12pt'
          d[:textheight],d[:textwidth]=@tx.letter.portrait.h,@tx.letter.portrait.w
        when /legal/i     #U.S. alternative
          d[:papertype],d[:fontsize]='legalpaper','12pt'
          d[:textheight],d[:textwidth]=@tx.legal.portrait.h,@tx.legal.portrait.w
        when /book|b5/i   #book default - larger
          d[:papertype],d[:fontsize]='b5paper','11pt'
          d[:textheight],d[:textwidth]=@tx.b5.portrait.h,@tx.b5.portrait.w
        when /a5/i
          d[:papertype],d[:fontsize]='a5paper','11pt'
          d[:textheight],d[:textwidth]=@tx.a5.portrait.h,@tx.a5.portrait.w
        else           #default currently A4
          d[:papertype],d[:fontsize]='a4paper','12pt'
          d[:textheight],d[:textwidth]=@tx.a4.portrait.h,@tx.a4.portrait.w
        end
      when /landscape/
        #d[:textheight],d[:textwidth]=@tx.a4.landscape.h,@tx.a4.landscape.w
        d[:papertype],d[:fontsize]='a4paper','11pt'
        d[:oddsidemargin],d[:evensidemargin],d[:topmargin]='-8mm','-8mm','-18mm'
        d[:headheight],d[:headsep],d[:columnsep]='12pt','20pt','40pt'
        d[:marginparsep],d[:marginparwidth]='4mm','8mm'
        case @md.papersize
        when /a4/i                            #European default, SiSU default
          d[:papertype],d[:fontsize]='a4paper','12pt'
          d[:textheight],d[:textwidth]=@tx.a4.landscape.h,@tx.a4.landscape.w
        when /letter/i                    #U.S. default
          d[:papertype],d[:fontsize]='letterpaper','11pt'
          d[:textheight],d[:textwidth]=@tx.letter.landscape.h,@tx.letter.landscape.w
        when /legal/i #U.S. alternative
          d[:papertype],d[:fontsize],d[:columnsep]='legalpaper','11pt','48pt'
          d[:textheight],d[:textwidth]=@tx.legal.landscape.h,@tx.legal.landscape.w
        when /book|b5/i       #book default - larger
          d[:papertype],d[:fontsize],d[:columnsep]='b5paper','11pt','35pt'
          d[:textheight],d[:textwidth]=@tx.b5.landscape.h,@tx.b5.landscape.w
        when /a5/i
          d[:papertype],d[:fontsize],d[:columnsep]='a5paper','10pt','38pt'
          d[:textheight],d[:textwidth]='10pt',@tx.a5.landscape.h,@tx.a5.landscape.w
        else                            #default currently A4
          d[:papertype],d[:fontsize]='a4paper','12pt'
          d[:textheight],d[:textwidth]=@tx.a4.landscape.h,@tx.a4.landscape.w
        end
      end
      d
    end
    def tex_head_paper
      d={}
      case @string
      when /portrait/
        tex_head_paper_portrait(tex_head_paper_dimensions)
      when /landscape/
        tex_head_paper_landscape(tex_head_paper_dimensions)
      end
    end
    def tex_head_pdftex
      color=case @string
      when /portrait/
      <<WOK
  colorlinks=true,
  urlcolor=myblack,
  filecolor=myblack,
  linkcolor=myblack,
WOK
      when /landscape/
      <<WOK
  colorlinks=true,
  urlcolor=myblue,    % \\href{...}{...}   external url
  filecolor=mygreen,  % \\href{...}     local file
  linkcolor=myred,    % \\href{...} and \\pageref{...}
WOK
      end
      <<WOK
\\usepackage{url}
\\usepackage{alltt}
\\usepackage{thumbpdf}
\\usepackage[pdftex,
  #{color.strip}
  pdftitle={#@string1},
%  pdftitle={Untitled},
  pdfauthor={LM-sisu-scribe},
  pdfsubject={law},
  pdfkeywords={law},
  pageanchor=true,
  plainpages=true,
  pdfpagelabels=true,
  pagebackref,
  bookmarks=true,
  bookmarksopen=true,
  pdfmenubar=true,
  pdfpagemode=UseOutline,
  pdffitwindow=true,
  pdfwindowui=true,
  plainpages=false,
%  pdfusetitle=true,
%  pdfpagelayout=SinglePage,
%  pdfpagelayout=TwoColumnRight,
%  pdfpagelayout=TwoColumnLeft,
%  pdfstartpage=3,
  pdfstartview=FitH
]
{hyperref}
\\usepackage[usenames]{color}
\\definecolor{myblack}{rgb}{0,0,0}
\\definecolor{myred}{rgb}{0.75,0,0}
\\definecolor{mygreen}{rgb}{0,0.5,0}
\\definecolor{myblue}{rgb}{0,0,0.5}
\\definecolor{mywhite}{rgb}{1,1,1}
WOK
    end
    def tex_head_misc
      <<WOK
\\usepackage{textcomp}
\\usepackage[parfill]{parskip}
\\usepackage[normalem]{ulem}
\\usepackage{soul}
\\usepackage{longtable}
\\usepackage{graphicx}
\\makeatletter
\\parindent0pt
\\usepackage{mathptmx}
\\usepackage{amssymb}
% amssymb used for backslash
WOK
    end
    def document_head_with_orientation
      endnotes=("\\usepackage{endnotes}" if @string =~/endnotes?/)||'' #not implemented see also def endnotes
      language
      <<WOK
#{tex_head_paper}
#{tex_head_encode}
#{tex_head_pdftex}
#{tex_head_misc}
\\setcounter{secnumdepth}{2}
\\setcounter{tocdepth}{4}
\\makeatletter
#{endnotes}
\\usepackage[multiple,marginal]{footmisc}
% \\setlength\\footnotemargin{40pt}
\\usepackage[para]{manyfoot}
\\DeclareNewFootnote{A}
%\\DeclareNewFootnote[para]{A}
\\newenvironment{ParagraphIndent}[1]%
{
\\begin{list}{}{%
\\setlength\\topsep{0pt}%
\\addtolength{\\leftmargin}{#1}
\\setlength\\parsep{0pt plus 1pt}%
}
\\item[]
}
{\\end{list}}
\\usepackage{fancyhdr}
\\lhead{}
\\renewcommand{\\part}{\\\@startsection
{part}%
{1}%
{-2mm}%
{-\\baselineskip}%
{0.5\\baselineskip}%
{\\bfseries\\large\\scshape}}%
\\renewcommand{\\section}{\\\@startsection
{section}%
{2}%
{-2mm}%
{-\\baselineskip}%
{0.5\\baselineskip}%
{\\bfseries\\Large\\upshape}}%
\\renewcommand{\\subsection}{\\\@startsection
{subsection}%
{3}%
{-2mm}%
{-\\baselineskip}%
{0.5\\baselineskip}%
{\\bfseries\\large\\upshape}}%
\\renewcommand{\\subsubsection}{\\\@startsection
{subsubsection}%
{4}%
{-2mm}%
{-\\baselineskip}%
{0.5\\baselineskip}%
{\\bfseries\\normalsize\\upshape}}%
\\renewcommand{\\paragraph}{\\\@startsection
{paragraph}%
{5}%
{-2mm}%
{-\\baselineskip}%
{0.5\\baselineskip}%
{\\normalfont\\normalsize\\itshape}}%
\\renewcommand{\\subparagraph}{\\\@startsection
{subparagraph}%
{6}%
{-2mm}%
{-\\baselineskip}%
{0.5\\baselineskip}%
{\\normalfont\\normalsize\\itshape}}%
\\selectlanguage{#{language}}
WOK
    end
    def a4generic
    end
    def para_num
      paranumber_display=if @md.markup.inspect =~/no_ocn/ \
      or @md.mod.inspect =~/--no-ocn/
        ''
      else "\\begin{tiny}~\\end{tiny}{\\marginpar{\\begin{tiny}#@string1\\end{tiny}}}" #ocn object citation numbering
      end
      if @string !~/^([1-6a-z-]#{@@tilde}\S*|<:.+?>|#{@md.lv1}|#{@md.lv2}|#{@md.lv3}|#{@md.lv4}|#{@md.lv5}|#{@md.lv6})/
        @string.gsub!(/^\s*(.+)/m,"#{paranumber_display}\\1\n") #watch - in 1-6 is suspect
      else
        if (@string =~/^(?:[1-6a-z-]#{@@tilde}\S*|<:.+?>)/) #watch - in 1-6 is suspect
          @string.gsub!(/^([1-6a-z-]#{@@tilde}\S*)\s*(.+)/m,"\\1 #{paranumber_display} \\2\n") #watch - in 1-6 is suspect
          @string.gsub!(/^(<:.+?>)\s*(.+)/m,"\\1 #{paranumber_display}\\2\n")
        else
          @string.gsub!(/((#{@md.lv1}|#{@md.lv2}|#{@md.lv3}|#{@md.lv4}|#{@md.lv5}|#{@md.lv6}).+)$/,"\\2 #{paranumber_display}\\1\n")
        end
      end
      @string
    end
  end
end
__END__
