=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007 Ralph Amissah All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007 Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licenses/gpl.html>
   <http://www.gnu.org/copyleft/gpl.html>
   <http://www.jus.uio.no/sisu/gpl.fsf>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: Conversion script from kdissert .kdi to sisu markup .ssm
    (master document)

=end
module SiSU_Kdissert
  require "#{SiSU_lib}/sysenv"
  class Convert
    require 'rexml/document'
    include REXML
    def initialize(opt)
      @opt=opt
      @sisu,@sisu_base=[],[]
      @ver=SiSU_Env::Info_version.new.get_version
    end
    def read
      kdissert_to_sisu
    end
    def sisu_head
      sisu_head=<<WOK
% SiSU #{@ver[:version]} auto-conversion from Kdissert file [check necessary]

@title: #@title

@prefix: Kdissert document map, converted to SiSU markup

@links: {Kdissert}http://freehackers.org/~tnagy/kdissert/

@base_program: kdissert

@skin: skin_kdissert

% @date:

@rcs:+ $Id$

@level: num_top=1

WOK
    end
    def kdissert_to_sisu
      unless @opt.files.empty?
        @opt.files.each do |kdi|
          @sisu_base=[]
          if kdi =~/\.kdi$/
            tell=SiSU_Screen::Ansi.new(@opt.cmd,'Kdissert to SiSU',"#{kdi} --> #{kdi}.ssm")
            tell.green_hi_blue unless @opt.cmd =~/q/
            system("cp #{kdi} /tmp/. && cd /tmp && tar xzvf /tmp/#{kdi} && cd -")
            file=File.new("/tmp/maindoc.xml")
            @output=File.new("#{kdi}.ssm",'w')
            doc=Document.new(file)
            root=doc.root
            @el=[]
            root.each do |x|
            end
            root.each_with_index do |content,idx|
              if root.elements["item[#{idx}]/summary"]
                id,ma,ch=nil,nil,[]
                if root.elements["item[#{idx}]/id"]
                  id=root.elements["item[#{idx}]/id"].text.to_i
                end
                if root.elements["item[#{idx}]/parent"]
                  ma=root.elements["item[#{idx}]/parent"].text.to_s
                end
                if root.elements["item[#{idx}]/child"] #problem only get one child, even where several
                  root.get_elements("item[#{idx}]/child").each do |x|
                    ch << x.text
                  end
                end
                if root.elements["item[#{idx}]/summary"]
                  sum=root.elements["item[#{idx}]/summary"].text.to_s.strip
                end
                if root.elements["item[#{idx}]/text"]
                  txt=root.elements["item[#{idx}]/text"].text.to_s.strip
                end
                @el[id]={ :id=>id,:ma=>ma,:ch=>ch,:sum=>sum,:txt=>txt }
                if ma == '-1'
                  @el[id][:lev]=':A'
                  @top=id
                end
              end
            end
            @doc=[]
            @title=@el[@top][:sum]
            puts @el[@top][:sum].inspect
            @doc << @el[@top][:txt] #% careful: hack to make it possible to modify sisu headers
            @doc << ':A~ ' + @el[@top][:sum]
            @el[@top][:ch].each do |x|
              @el[x.to_i][:lev]='1'
              @doc << '1~ ' + @el[x.to_i][:sum]
              @doc << @el[x.to_i][:txt]
              @el[x.to_i][:ch].each do |y|
                @el[y.to_i][:lev]='2'
                @doc << '2~ ' + @el[y.to_i][:sum]
                @doc << @el[y.to_i][:txt]
                @el[y.to_i][:ch].each do |z|
                  @el[z.to_i][:lev]='3'
                  @doc << '3~ ' + @el[z.to_i][:sum]
                  @doc << @el[z.to_i][:txt]
                  @el[z.to_i][:ch].each do |za|  #unsupported... consder
                    @el[za.to_i][:lev]='4'
                    @doc << '!_ ' + @el[za.to_i][:sum]
                    @doc << @el[za.to_i][:txt]
                  end
                end
              end
            end
      # regexs strip most kdissert markup, and provide minimal info for sisu markup -->
            @doc.each do |c,idx|
              c.gsub!(/<\/summary>/,'')
              c.gsub!(/<html>.+?\n|<\/body>|<\/html>|<p>/m,'')
              c.gsub!(/<\/p>/,"\n")
              c.gsub!(/<span style="font-weight:600">(.+?)<\/span>/,' *{ \1 }* ')
              c.gsub!(/<span style="text-decoration:underline">(.+?)<\/span>/,' _{ \1 }_ ')
              c.gsub!(/<span style="font-style:italic">(.+?)<\/span>/,' /{ \1 }/ ')
              c.gsub!(/<ul type="disc">/,'_* ')
              c.gsub!(/<\S+?>/,'')
              c.gsub!(/&lt;br&gt;/,'<br>')
              c.gsub!(/&lt;(:p[bn])&gt;/,'<\1>')
              c.gsub!(/&lt;&lt;([|]\S+[|]@[|].?[|])/,'<<\1')
              c.gsub!(/&lt;/,'\<')
              c.gsub!(/&gt;/,'\>')
              c.gsub!(/&quot;/,'"')
              c.gsub!(/ \s+/,' ')
              @sisu_base << c.strip + "\n\n"
            end
          else puts ".kdi extension expected, filename not recognised: << #{kdi} >>"
          end
          @output << sisu_head << @sisu_base
        end
      else puts '.kdi file for conversion to sisu expected'
      end
      @opt.files.each do |f|
        f.gsub!(/.kdi$/,'.kdi.ssm')
      end
      puts @opt.files.inspect
    end
  end
end
__END__
