=begin
 * Name: SiSU - Simple information Structuring Universe - Structured information, Serialized Units
 * Author: Ralph Amissah
   * http://www.jus.uio.no/sisu
   * http://www.jus.uio.no/sisu/SiSU/download

 * Description: update previous output (with similar output file type formats)
   * $Id$
 * Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005 Ralph Amissah

 * License: GPL 2 or later

  Summary of GPL 2

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation; either version 2 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA

  If you have Internet connection, the latest version of the GPL should be
  available at these locations:
    http://www.fsf.org/licenses/gpl.html
    http://www.gnu.org/copyleft/gpl.html
    http://www.jus.uio.no/sisu/gpl2.fsf

  SiSU was first released to the public on January 4th 2005

  SiSU uses:
  
  *  Standard SiSU markup syntax,
  *  Standard SiSU meta-markup syntax, and the
  *  Standard SiSU object citation numbering and system
  
  © Ralph Amissah 1997, current 2005.
  All Rights Reserved.

 * Notes: tidy -ascii index.xml >> index.tidy

 * Ralph Amissah: ralph@amissah.com
                  ralph.amissah@gmail.com
=end
module SiSU_Update_control_flag
  require "#{SiSU_lib}/sysenv"
  include SiSU_Env
  include SiSU_Param
  class Check
    def initialize(fns,cf)
      @fns,@cf=fns,cf
      @md=SiSU_Param::Parameters.new(@fns,@cf).get
      @fnb=@md.fnb
    end
    def read
      begin
        @dir=SiSU_Env::Info_dir.new(@fns)
        out=@dir.data_o
        base_path="#{out}/#@fnb"
        tell=SiSU_Screen::Ansi.new(@cf,'Checking previous output',base_path)
        tell.greenHiBlue unless @cf =~/q/
        #tell=SiSU_Screen::Ansi.new(@cf,"links2 #{base_path}")
        #tell.grey_tab if @cf =~/v/
        Set_CF.new(@md,@fns).set_flags
      rescue: SiSU_Errors::Info_error.new($!,$@,@cf,@fns).error
      ensure
      end
    end
    private
    class Set_CF
      def initialize(md,fns)
        @md,@fns=md,fns
        @dir=SiSU_Env::Info_dir.new(fns)
        @fnb=@md.fnb
        out=@dir.data_o
        @base_path="#{out}/#@fnb"
      end
      def set_flags #-mNhwpoabxXyv
        flag='-v'
        if FileTest.file?("#@base_path/#{@md.fn[:doc]}")==true
          flag=flag + 'a'
        end
        if FileTest.file?("#@base_path/#{@md.fn[:toc]}")==true \
        or FileTest.file?("#@base_path/#{@md.fn[:doc]}")==true
          flag=flag + 'h'
        end
        if FileTest.file?("#@base_path/#{@md.fn[:xhtml]}")==true
          flag=flag + 'b'
        end
        if FileTest.file?("#@base_path/#{@md.fn[:sax]}")==true
          flag=flag + 'x'
        end
        if FileTest.file?("#@base_path/#{@md.fn[:dom]}")==true
          flag=flag + 'X'
        end
        if FileTest.file?("#@base_path/#{@md.fn[:odf]}")==true
          flag=flag + 'o'
        end
        if FileTest.file?("#@base_path/#{@md.fn[:pdf_p]}")==true \
        or FileTest.file?("#@base_path/#{@md.fn[:pdf_l]}")==true
          flag=flag + 'p'
        end
        if FileTest.file?("#@base_path/#{@md.fn[:wmap]}")==true
          flag=flag + 'w'
        end
        if FileTest.file?("#@base_path/#{@md.fn[:digest]}")==true
          flag=flag + 'N'
        end
        if FileTest.file?("#@base_path/#@fns")==true
          flag=flag + 's'
        end
        if FileTest.file?("#@base_path/sisudoc.tgz")==true
          flag=flag + 'S'
        end
        p flag
        flag
      end
    end
  end
end
__END__
        if FileTest.file?("#@base_path/#@fns.tex")==true \
        or FileTest.file?("#@base_path/#@fns.tex")==true
          flag=flag + 'w'
        end
        if FileTest.file?("#@base_path/#@fns.meta")==true
          id,file='Markup (SiSU source)','#@fns.meta'
        end
        if FileTest.file?("#@base_path/#@fns.tgz")==true
          id,file='SiSUdoc (tar gzip)','#@fns.tgz'
        end
