=begin
 * Name: SiSU - Simple information Structuring Universe - Structured information, Serialized Units
 * Author: Ralph Amissah
   * http://www.jus.uio.no/sisu
   * http://www.jus.uio.no/sisu/SiSU/download

 * Description: texinfo formatting template
   * $Id$
 * Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005 Ralph Amissah

 * License: GPL 2 or later

  Summary of GPL 2

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation; either version 2 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA

  If you have Internet connection, the latest version of the GPL should be
  available at these locations:
    http://www.fsf.org/licenses/gpl.html
    http://www.gnu.org/copyleft/gpl.html
    http://www.jus.uio.no/sisu/gpl2.fsf

  SiSU was first released to the public on January 4th 2005

  SiSU uses:
  
  *  Standard SiSU markup syntax,
  *  Standard SiSU meta-markup syntax, and the
  *  Standard SiSU object citation numbering and system
  
  © Ralph Amissah 1997, current 2005.
  All Rights Reserved.

 * Ralph Amissah: ralph@amissah.com
                  ralph.amissah@gmail.com
=end
module TexInfoFormat
  @@table_pg_break_counter=1
  require "#{SiSU_lib}/param"
  include SiSU_Param
  include SiSU_Viz
  class Texinfo
    @@tex_backslash="\\\\"
    @@tex_1='\\\\~' #?? debug
    @@tabular="{tabular}"
    @@tex_pattern_margin_number="\\\\marginpar.+?\s+"
    def initialize(data=nil,md=nil,three=nil)
      @para=@one=data
      @md=md
      @url=SiSU_Viz::Url.new
    end
    def head
      t=Time.now
      year = t.year
      filename=%{#{@md.fns}}[/(.+?)\.\w\w\d\d$/, 1]
      title=Texinfo.new(@md.title).specChar
      title=title.gsub(/<(br|p|i)>|<\/\s*(br|p|i)>|<(br|p)\s*\/>/i, " #{@@tex_backslash*2} ")
      title.gsub!(/\$/, "\\$")
      title.gsub!(/[,]\s*/, ' - ')
      if @md.subtitle
        subtitle=Texinfo.new(@md.subtitle).specChar
        subtitle=subtitle.gsub(/<(br|p|i)>|<\/\s*(br|p|i)>|<(br|p)\s*\/>/i, " #{@@tex_backslash*2} ")
        subtitle.gsub!(/\$/, "\\$")
        subtitle.gsub!(/[,]\s*/, ' - ')
        subtitle="@subtitle @value{VERSION}, @value{UPDATED}\n" #bugwatch
      end
      subtitle ||=''
      author=@md.dc_creator if @md.dc_creator
      author ||=''
      author.gsub!(/[\*]/, '') #if author
      head =<<WOK
\\input texinfo   @c -*-texinfo-*-
@comment $Id$
@comment %**start of header
@setfilename #{@md.fnb}.info
@settitle #{title} @value{VERSION}
@syncodeindex pg cp
@comment %**end of header
@c {{{ 2
@copying
SiSU in texinfo version of #{title}
(version @value{VERSION}, @value{UPDATED})

Copyright @copyright{} #{year} #{author}.

@quotation
Copyright #{author}, generated by ``SiSU''
@end quotation
@end copying

@dircategory SiSU Texinfo
@direntry
* sisu: SiSU texinfo file.
@end direntry
WOK
      if @md.subtitle
        titlepage=<<WOK
@c {{{ 3
@titlepage
@title #{title} #{subtitle}
@author #{author}
@page
@vskip 0pt plus 1filll
@insertcopying
@end titlepage
@contents
WOK
      else
        titlepage=<<WOK
@c {{{ 3
@titlepage
@title #{title}
@value{VERSION}, @value{UPDATED}
@author #{author}
@page
@vskip 0pt plus 1filll
@insertcopying
@end titlepage

@contents
WOK
      end
      "#{head}#{titlepage}"
    end
    def topnode
      @one=Texinfo.new(@one).specChar
      @one=@one.gsub(/<(br|p|i)>|<\/\s*(br|p|i)>|<(br|p)\s*\/>/i, " #{@@tex_backslash*2} ")
      @one.gsub!(/\$/, "\\$")
      @one.gsub!(/[,]\s*/, ' - ')
      "@c {{{ 4\n" +
        "@ifnottex\n" +
        "@node Top\n" +
        "@top #@one\n\n" +
        "@insertcopying\n" +
        "@end ifnottex\n\n" +
        "@menu\n"
    end
    def dublincore
      title=Texinfo.new(@md.title).specChar if @md.title
      subtitle=Texinfo.new(@md.subtitle).specChar if @md.subtitle
      dcTitle="#{title} - #{subtitle}"
      dcCreator=Texinfo.new(@md.dc_creator).specChar if @md.dc_creator 
      dcSubject=Texinfo.new(@md.dc_subject).specChar if @md.dc_subject  
      dcDescription=Texinfo.new(@md.dc_description).specChar if @md.dc_description
      dcPublisher=Texinfo.new(@md.dc_publisher).specChar if @md.dc_publisher
      dcContributor=Texinfo.new(@md.dc_contributor).specChar if @md.dc_contributor
      dcDate=Texinfo.new(@md.dc_date).specChar if @md.dc_date  
      dcDateCreated=Texinfo.new(@md.dc_date_created).specChar if @md.dc_date_created
      dcDateIssued=Texinfo.new(@md.dc_date_issued).specChar if @md.dc_date_issued  
      dcDateAvailable=Texinfo.new(@md.dc_date_available).specChar if @md.dc_date_available
      dcDateValid=Texinfo.new(@md.dc_date_valid).specChar if @md.dc_date_valid
      dcDateModified=Texinfo.new(@md.dc_date_modified).specChar if @md.dc_date_modified  
      dcType=Texinfo.new(@md.dc_type).specChar if @md.dc_type
      dcFormat=Texinfo.new(@md.dc_format).specChar if @md.dc_format
      dcIdentifier=Texinfo.new(@md.dc_identifier).specChar if @md.dc_identifier
      dcSource=Texinfo.new(@md.dc_source).specChar if @md.dc_source
      dcLanguage=Texinfo.new(@md.dc_language[:name]).specChar if @md.dc_language[:name]
      #original_language=Texinfo.new(@md.original_language[:name]).specChar if @md.original_language[:name]
      dcRelation=Texinfo.new(@md.dc_relation).specChar if @md.dc_relation
      dcCoverage=Texinfo.new(@md.dc_coverage).specChar if @md.dc_coverage
      dcRights=Texinfo.new(@md.dc_rights).specChar if @md.dc_rights
      dcTitle="Title: #{dcTitle}\n\n" if dcTitle
      dcCreator="Creator: #{dcCreator}\n\n" if dcCreator
      dcSubject="Subject: #{dcSubject}\n\n" if dcSubject
      dcDescription="Description: #{dcDescription}\n\n" if dcDescription
      dcPublisher="Publisher: #{dcPublisher}\n\n" if dcPublisher
      dcContributor="Contributor: #{dcContributor}\n\n" if dcContributor
      dcDate="Date: #{dcDate}\n\n" if dcDate
      dcDateCreated="Date Created: #{dcDateCreated}\n\n" if dcDateCreated
      dcDateIssued="Date Issued: #{dcDateIssued}\n\n" if dcDateIssued
      dcDateAvailable="Date Available: #{dcDateAvailable}\n\n" if dcDateAvailable
      dcDateValid="Date Valid: #{dcDateValid}\n\n" if dcDateValid
      dcDateModified="Date Modified: #{dcDateModified}\n\n" if dcDateModified
      dcFormat="Format: #{dcFormat}\n\n" if dcFormat
      dcIdentifier="Identifier: #{identifier}\n\n" if dcIdentifier
      dcSource="Source: #{dcSource}\n\n" if dcSource
      dcLanguage="Language: #{dcLanguage}\n\n" if dcLanguage
      dcRelation="Relation: #{dcRelation}\n\n" if dcRelation
      dcCoverage="Coverage: #{dcCoverage}\n\n" if dcCoverage
      dcRights="Rights: #{dcRights}\n\n" if dcRights
      "@node Dublin Core\n" +
        "@chapter Dublin Core\n" +
        "@cindex chapter, Dublin Core\n\n" +
        "#{dcTitle}" +
        "#{dcCreator}" +
        "#{dcSubject}" +
        "#{dcDescription}" +
        "#{dcPublisher}" +
        "#{dcContributor}" +
        "#{dcDate}" +
        "#{dcDateCreated}" +
        "#{dcDateIssued}" +
        "#{dcDateAvailable}" +
        "#{dcDateValid}" +
        "#{dcDateModified}" +
        "#{dcFormat}" +
        "#{dcIdentifier}" +
        "#{dcSource}" +
        "#{dcLanguage}" +
        "#{dcRelation}" +
        "#{dcCoverage}" +
        "#{dcRights}" +
        "\n\n"
    end
    def tail
     "@c {{{ 6\n" +
      "@node Index\n" +
      "@unnumbered Index\n" +
      "@printindex cp\n\n" +
      "@bye"
    end
    def menu
      @para.gsub!(/<\\~(\d+);\w\d+;\w\d+><[0-9a-f]{32}:[0-9a-f]{32}>/, "~[\\1]")
      @para.gsub!(/\s*[,:]\s*/, ' - ')
      @para.gsub!(/<:#>/, '')
      @para.strip!
      "* #@para::"
    end
    def level1
      @para.gsub!(/[1]\\+~/, '')
      @para.gsub!(/<\\~(\d+);\w\d+;\w\d+><[0-9a-f]{32}:[0-9a-f]{32}>/, "~[\\1]")
      @para.gsub!(/\s*[,:]\s*/, ' - ')
      @para.gsub!(/<:#>/, '')
      @para.strip!
      para="@node #@para\n@chapter #@para\n@cindex chapter, #@para\n"
      @para.gsub!(/.+/, "#{para}")
    end
    def level2
      @para.gsub!(/[2]\\+~/, '')
      @para.gsub!(/<\\~(\d+);\w\d+;\w\d+><[0-9a-f]{32}:[0-9a-f]{32}>/, "~[\\1]")
      @para.gsub!(/\s*[,:]\s*/, ' - ')
      @para.gsub!(/<:#>/, '')
      @para.strip!
      para="@node #@para\n@chapter #@para\n@cindex chapter, #@para\n"
      @para.gsub!(/.+/, "#{para}")
    end
    def level3
      @para.gsub!(/[3]\\+\~/, '')
      @para.gsub!(/<\\~(\d+);\w\d+;\w\d+><[0-9a-f]{32}:[0-9a-f]{32}>/, "~[\\1]")
      @para.gsub!(/\s*[,:]\s*/, ' - ')
      @para.gsub!(/<:#>/, '')
      @para.strip!
      para="@node #@para\n@chapter #@para\n@cindex chapter, #@para\n"
      @para.gsub!(/.+/, "#{para}")
    end
    def level4
      @para.gsub!(/[4]\\+~\S+/, '')
      @para.gsub!(/<\\~(\d+);\w\d+;\w\d+><[0-9a-f]{32}:[0-9a-f]{32}>/, "~[\\1]")
      @para.gsub!(/\s*[,:]\s*/, ' - ')
      @para.gsub!(/<:#>/, '')
      @para.strip!
      para="@node #@para\n@chapter #@para\n@cindex chapter, #@para\n"
      @para.gsub!(/.+/, "#{para}")
    end
    def level5
      @para.gsub!(/[5]\\+~\S+/, '')
      @para.gsub!(/<\\~(\d+);\w\d+;\w\d+><[0-9a-f]{32}:[0-9a-f]{32}>/, "~[\\1]")
      @para.gsub!(/\s*[,:]\s*/, ' - ')
      @para.gsub!(/<:#>/, '')
      @para.strip!
      para="@node #@para\n@chapter #@para\n@cindex chapter, #@para\n"
      @para.gsub!(/.+/, "#{para}")
    end
    def level6
      @para.gsub!(/[6]\\+~\S+/, '')
      @para.gsub!(/<\\~(\d+);\w\d+;\w\d+><[0-9a-f]{32}:[0-9a-f]{32}>/, "~[\\1]")
      @para.gsub!(/\s*[,:]\s*/, ' - ')
      @para.gsub!(/<:#>/, '')
      @para.strip!
      para="@node #@para\n@chapter #@para\n@cindex chapter, #@para\n"
      @para.gsub!(/.+/, "#{para}")
    end
    def submenu
      @para=@para.join("\n")
      @para.gsub!(/[5]\\+~\S+/, '')
      @para.gsub!(/<\\~(\d+);\w\d+;\w\d+><[0-9a-f]{32}:[0-9a-f]{32}>/, "~[\\1]")
      @para.gsub!(/\s*[,]\s*/, ' - ')
      @para.gsub!(/<:#>/, '')
      @para.strip!
      para="@menu\n#@para\n@end menu\n\n"
      @para.gsub!(/.+/m, "#{para}")
    end
    def subsubmenu
      @para=@para.join("\n")
      @para.gsub!(/[6]\\+~\S+/, '')
      @para.gsub!(/<\\~(\d+);\w\d+;\w\d+><[0-9a-f]{32}:[0-9a-f]{32}>/, "~[\\1]")
      @para.gsub!(/\s*[,]\s*/, ' - ')
      @para.gsub!(/<:#>/, '')
      @para.strip!
      para="@menu\n#@para\n@menu\n\n"
      @para.gsub!(/.+/m, "#{para}")
    end
    def indent1
      @para.gsub!(/<:i1>(.*)/i, "\\1")
    end
    def indent2
      @para.gsub!(/<:i2>(.*)/i, "\\1")
    end
    def specChar # special characters
      @para.gsub!(/<EOF>/i, "")
      @para.gsub!(/@/i, '@@')
      @para.gsub!(/&(lt|#060);/i, '\<&nbsp;')
      @para.gsub!(/&(gt|#062);/i, '&nbsp;\>')
      @para.gsub!(/&#123;/i, '\{&nbsp;')
      @para.gsub!(/&#125;/i, '\}&nbsp;')
      @para.gsub!(/&#(126|152);/i, '~&nbsp;')
      @para.gsub!(/<sup><font face=symbol>&atild;<\/font><\/sup>/i, " ")
      @para.gsub!(/\\/, '\\backslash ')
      @para.gsub!(/<:pb>/i, '\\newpage')
      @para.gsub!(/\\backslash copyright/, '\\copyright ')
      @para.gsub!(/\^/, '\\wedge ')
      @para.gsub!(/(\$)/, "\\$")
      @para.gsub!(/\~/, '\\~')
      @para.gsub!(/%/, "\\%")
      if @para !~ /^\s*<:image|\}:image\s/
        @para.gsub!(/_/, '\_')
      end
      @para.gsub!(/\{/, "\\{")
      @para.gsub!(/\}/, "\\}")
        @para.gsub!(/&nbsp;&nbsp;/i, " ")  # ~ character for hardspace
        @para.gsub!(/&nbsp;/i, " ")        # ~ character for hardspace
      @para.gsub!(/&(\S+?);/i, "")
      @para.gsub!(/(\s+&\s+)/, " and ")
      @para.gsub!(/(\&)/, "\\&")
      @para.gsub!(/§/i, "\\S")
      @para.gsub!(/£/i, "\\pounds")
      @para.gsub!(/å/i, "\\aa")
      @para.gsub!(/æ/i, "\\ae")
      @para.gsub!(/ø/i, "\\o")
      @para.gsub!(/Å/i, "\\AA")
      @para.gsub!(/Æ/i, "\\AE")
      @para.gsub!(/Ø/i, "\\O")
      @para.gsub!(/&(.+?);/i, " ")
      @para.gsub!(/<a href=".+?">/i, " ")
      @para.gsub!(/<\/a>/i, " ")
      @para.gsub!(/<:ee>/i, "")
      @para.gsub!(/<!>/i, " ")
      @para.gsub!(/<b>(.+?)<\/b>/i, "\*\\1\*")
      @para.gsub!(/<i>(.+?)<\/i>/i, "\/\\1\/")
      @para.gsub!(/<u>(.+?)<\/u>/i, "\_\\1\_")
      @para.gsub!(/"(.+?)"/i, "`\\1'")                                        # open & close "
      @para.gsub!(/\s+"/i, " `")                                              # open "
      @para.gsub!(/^([1-6-]\\+(?:~\S+)?|<.+?>)?\s*"/i, "\\1`")       # open "
      @para.gsub!(/"(\s|\.|,|:|;)/i, "'\\1")                                  # close "
      @para.gsub!(/"([1-6-]\\+(?:~\S+)?|<.+?>)?\s*$/i, "'\\1")       # close "
      @para.gsub!(/"(\.|,)/i, "'")                                            # close "
      @para.gsub!(/\s+'/i, " `")                                              # open '
      @para.gsub!(/^([1-6-]\\+(?:~\S+)?|<.+?>)?\s*'/i, "\\1`")       # open '
      #if @para=~/#{@@tex_1}/
      #end
      #@para.gsub!(/^([1-6-](?:#{@@tex_2}|#{@@tex_1})(?:\\~\S+)?|<.+?>)?\s*"/i, "\\1`")       # open "
      #@para.gsub!(/"([1-6-](?:#{@@tex_2}|#{@@tex_1})(?:\\~\S+)?|<.+?>)?\s*$/i, "'\\1")       # close "
      #@para.gsub!(/^([1-6-](?:#{@@tex_2}|#{@@tex_1})(?:\\~\S+)?|<.+?>)?\s*'/i, "\\1`")       # open '
      @para.gsub!(/(<font.*?>|<\/font>)/i, "")
      @para.gsub!(/\s*<sup>(\S+?)<\/sup>/i, "^\\1")
      @para.gsub!(/(<sup>|<\/sup>)/i, "")
      @para
    end
    def longtable
      @endTable="\\end{longtable}"
      @rowBreak='\\\\\\'
      if @para[/<!Th?¡\s+c(\d+);(.+?)!>/i]
        no_of_cols, cols_width=$1,$2
        @@tableheader=1 if @para =~ /<!Th/i
        @w=cols_width.split(/;\s+/)
        @@number_of_cols=no_of_cols
        @colW=Array.new
        @colW << '{'
        @w.each  do |x|
          col_w=x.gsub(/.+/, 'l\|') #unless x.nil?
          @colW << "#{col_w}" if col_w
        end
        @colW << '}'
        @colW=@colW.join
        @@startTable="\\setlength{\\LTleft}{0pt}\n\\setlength{\\LTright}{\\fill}\n" +
          "\\begin{longtable}[hb]#@colW\n"
        @para.gsub!(/<!Th?¡\s+c\d+?;.+!>/, "#{@@startTable}")
      end
      if @para =~/<!TZ!>/
        @para.gsub!(/<!TZ!>/,
          " #@endTable")
      end
      @para.gsub!(/<!¡/, "")
      if @@tableheader==1
        if @para =~/¡\d+?¡(.+?)(?:¡|!)/
          tablefoot=para[/\<!f(.+?)!\>/, 1]
          @para.gsub!(/\<!f(.+?)!\>/, '')
          @para.gsub!(/¡\d+?¡(.+?)(?:¡|!)/,
          "{\\begin{tiny} {\\bfseries \\1}\\end{tiny}}&")
          @para.gsub!(/&>\s*$/,
          " #@rowBreak \\hline\\endhead #@rowBreak")
          @para="#@para \\multicolumn{#{@@number_of_cols}}{l}{\\tiny #{tablefoot}} \\\\ \\hline\n\\endfoot\n\\hline\n" if tablefoot
          @@tableheader=0
          @@number_of_cols=0
        end
      else
        if @para =~/¡\d+?¡(.+?)(?:¡|!)/
          @para.gsub!(/¡\d+?¡(.+?)(?:¡|!)/, "\\begin{tiny}\\1\\end{tiny}&")
          @para.gsub!(/&>\s*$/, " #@rowBreak")
        end
      end
      @para
    end
    def scopedtable
      # some features related to headers have been incorporated in longtable
      # that are not included yet here, so until synced is broken on some
      # input files, work needs to be done if is to work as before
      @endTable="\\end{tabular}"
      @rowBreak='\\\\\\\\'
      @breakPage="#@rowBreak\n#@rowBreak \n"
      if @para[/<!Th?¡\s+c(\d+);(.+?)!>/i]
        no_of_cols, cols_width=$1,$2
        @w=cols_width.split(/;\s+/)
        @colW=Array.new
        @w.each  do |x|
          col_w=((x.to_i*12)/100.00).to_s #unless x.nil?
          @colW << "p{#{col_w}cm}" if col_w
        end
        @@startTable="\\begin{tabular}{#@colW}\n"
        @para.gsub!(/<!Th?¡\s+c\d+?;.+!>/, "#{@@startTable}")
      end
      if @para =~/<!TZ!>/
        @para.gsub!(/<!TZ!>/, "#@endTable")
        @@table_pg_break_counter=1
      end
      if @para =~/<!¡/
        if @@table_pg_break_counter==28
          # taken from 34 ideal for portrait to 28 which suits landscape
          @para =
            "\n\n#@endTable \n" +
            "#@breakPage" +
            "#{@@startTable}\n"
          @@table_pg_break_counter=1
        else
          @para.gsub!(/<!¡/, "")
          @@table_pg_break_counter+=1
          tablefoot=@para[/\<!f(.+?)!\>/]
          @para.gsub!(/\<!f(.+?)!\>/, "")
        end
      end
      if @para =~/¡\d+?¡(.+?)(?:¡|!)/
      @para.gsub!(/¡\d+?¡(.+?)(?:¡|!)/, "\\begin{tiny}\\1\\end{tiny}&")
      @para.gsub!(/&>\s*$/,
        "#@rowBreak")
      end
      @para
    end
    def graphics
      dir=SiSU_Env::Info_dir.new(@md.fns)
      @para.gsub!(/<::\s+(\S+?)\s+>/i, #watch
        "\\includegraphics*[width=11pt]{#{dir.image_source_tex}/c_\\1.png}")
    end
    def image
      dir=SiSU_Env::Info_dir.new(@md.fns)
      width="100"
      width=@para[/<:image.+?width=``(\d+)''.+?>/im, 1]
      width=width.to_i*0.4
      @para.gsub!(/<:image\s+((?:https?|ftp)\S+)\s+(\S+)\s+.+\s+?>/i,
        "\\href{\\1}{\\includegraphics*[width=#{width}pt]{#{dir.image_source_tex}/\\2}}")
      @para.gsub!(/<:image\s+(\S+)\s+.+\s+?>/i,
        "\\includegraphics*[width=#{width}pt]{#{dir.image_source_tex}/\\1}")
    end
    def png
      # very messy clean up ! - work area, testing
      z=@para[/\\\{(.+?)\}(?:image|png)/, 1] # match operator for z \\ fragile !
      image, w, x, y=z.scan(/\S+/)
      image.gsub!(/\\/, '')
      @para.gsub!(/\\\{\S+\.(png|jpg).+?\}(image|png)/, "<image #{image} not available>")  # fragile match operator\\ fragile ! 
    end
    def http
      # very messy clean up ! - work area, testing
      z=@para[/\\\{(.+?)\}(?:https?|ftp):\/\//,  1] # match operator for z \\ fragile !
      url=@para[/((?:https?|ftp):\S+)/im, 1]
      if @para =~/\.(png|jpg)/
        image, w, x, y=z.scan(/\S+/)
        image.gsub!(/\\/, '')
        width=200
        width=z[/w=(\d+)/im, 1] if z =~/w=(\d+)/ 
        width=width.to_i*0.8
        width=400 if width > 400
        c=z[/``(.+?)''/im, 1]
        caption="{\\\\\\\ \n\\begin{scriptsize}#{c}\\end{scriptsize}&}" if c
      end
      if image
        dir=SiSU_Env::Info_dir.new(@md.fns)
        @para.gsub!(/\{\S+\.(png|jpg).+?\}(?:https?|ftp):\/\/\S+/, # fragile match operator\\ fragile ! 
          "\n\\href{#{url}}{\\includegraphics*[width=#{width}pt]{#{dir.image_source_tex}/#{image}}}#{caption}")
      else
        link=z[/(.+?)\\/im, 1]
        @para.gsub!(/\{.+?\}(?:https?|ftp):\/\/\S+/, "\n\\noindent\\href{#{url}}{#{link}}")  # fragile match operator\\ fragile ! 
      end
    end
  end
end
__END__

