"%% SiSU Vim syntax file
" Markup:       SiSU
" Maintainer:   Ralph Amissah
" Originally based on Ruby Vim by Mirko Nasato
" For version 5.x: Clear all syntax items
" For version 6.x: Quit when a syntax file was already loaded
if version < 600
  syntax clear
elseif exists("b:current_syntax")
"  :colorscheme green
  finish
else
endif
"% 13 Errors?
syn match SiSU_error contains=SiSU_contain,SiSU_Control,SiSU_markpara,SiSU_mark,SiSU_content_alt "<![^ei]\S\+!>"
"% 12 Expression Substitution: and Backslash Notation
" Expression Substitution: and Backslash Notation
""syn match   SiSU_exprSubst  "\\\\\|\(\(\\M-\\C-\|\\c\|\\C-\|\\M-\)\w\)\|\(\\\o\{3}\|\\x\x\{2}\|\\[tnrfbaes]\)" contained
""syn match   SiSU_exprSubst      "#[$@]\w\+" contained
"% 11 Markers: Endnote Identifiers, Pagebreaks etc.: 
" Markers: 
if !exists("SiSU_no_identifiers")
  syn match   SiSU_mark_endnote   "\~^"
  syn match   SiSU_contain        "</\?sub>"
  syn match   SiSU_mark           "<p>\|</p>\|<p />"
  syn match   SiSU_mark           "<br>\|<br />\|<:p[bn]>"
  syn match   SiSU_html           "<center>\|</center>"
  syn match   SiSU_markpara       "^_\([12]\*\?\|\*\)\s\+"
  syn match   SiSU_markpara       "#[ 1]\|_# "
  syn match   SiSU_marktail       "[~-]#"
  syn match   SiSU_html           "<td>\|<td \|<tr>\|</td>\|</tr>\|<table>\|<table \|</table>"
  syn match   SiSU_control        "\""
  syn match   SiSU_control        "\(\(^\| \)!_ \|<:b>\).*"
  "metaverse specific
  syn match   SiSU_ocn            "<\~\d\+;\w\d\+;\w\d\+>"
  syn match   SiSU_md5            "<[0-9a-f]\{32\}:[0-9a-f]\{32\}>\|<[0-9a-f]\{32\}>"
  syn match   SiSU_marktail       "<\~#>"
  syn match   SiSU_markpara       "<:i[12]>"
  syn match   SiSU_link           " \*\~\S\+"
  syn match   SiSU_action         "^<<.\+"
  syn match   SiSU_action         "^<:insert\d\+>"
  syn match   SiSU_contain        "<:e>"
  "syn match   SiSU_contain       "<e\d\+>"
endif
"% 10 URLs Numbers: and ASCII Codes
syn match   SiSU_number           "\<\(0x\x\+\|0b[01]\+\|0\o\+\|0\.\d\+\|0\|[1-9][\.0-9_]*\)\>"
syn match   SiSU_link             "http://\S\+"
"syn match   SiSU_link            "http://\(\w\|\.\|/\)\+"
"syn match   SiSU_string          "<a href=\".*</a>"
syn match   SiSU_comment          "\.\./\S\+"
"syn match   SiSU_comment         "\.\./\S\+\.\(html\|png\)"
syn match   SiSU_number           "?\(\\M-\\C-\|\\c\|\\C-\|\\M-\)\=\(\\\o\{3}\|\\x\x\{2}\|\\\=\w\)"
"% 9 Tuned Error - is error if not already matched
syn match SiSU_error              "[\~/\*!_]{\|}[\~/\*!_]" contains=SiSU_Terror
syn match SiSU_error              "<a href\|</a>]" contains=SiSU_Terror
"% 8 Simple Enclosed Markup:
" Simple Markup:
"%   headings
syn region SiSU_heading contains=SiSU_marktail,SiSU_strikeout,SiSU_number,SiSU_control,SiSU_identifier,SiSU_ocn,SiSU_md5,SiSU_error,SiSU_spellErrors matchgroup=SiSU_heading start="[1-8]\~[^-]" end="\n\n"
"%   tables
syn region SiSU_content_alt contains=SiSU_strikeout,SiSU_number,SiSU_control,SiSU_identifier,SiSU_error,SiSU_spellErrors matchgroup=SiSU_contain start="table{.\+" end="}table"
syn region SiSU_content_alt contains=SiSU_mark_endnote,SiSU_content_endnote,SiSU_link,SiSU_mark,SiSU_strikeout,SiSU_number,SiSU_control,SiSU_identifier,SiSU_error,SiSU_spellErrors matchgroup=SiSU_contain start="^\(alt\|group\|poem\){" end="^}\(alt\|group\|poem\)"
syn region SiSU_content_alt contains=SiSU_error matchgroup=SiSU_contain start="^code{" end="^}code"
"%   endnotes
syn region SiSU_content_endnote contains=SiSU_md5,SiSU_link,SiSU_strikeout,SiSU_number,SiSU_control,SiSU_identifier,SiSU_error,SiSU_spellErrors,SiSU_mark,SiSU_exception matchgroup=SiSU_mark_endnote start="\~{" end="}\~" skip="\n"
syn region SiSU_content_endnote contains=SiSU_strikeout,SiSU_number,SiSU_control,SiSU_link,SiSU_identifier,SiSU_error,SiSU_spellErrors,SiSU_mark,SiSU_exception matchgroup=SiSU_mark_endnote start="\^\~" end="\n\n"
"syn region SiSU_content_alt contains=SiSU_strikeout,SiSU_number,SiSU_control,SiSU_identifier,SiSU_error,SiSU_spellErrors,SiSU_mark,SiSU_exception matchgroup=SiSU_contain start="\~{[^{]" end="}\~" skip="\\\\\|\\'\|\n"
"%   images
syn region SiSU_content_alt contains=SiSU_brace,SiSU_strikeout,SiSU_number,SiSU_control,SiSU_identifier,SiSU_error,SiSU_spellErrors matchgroup=SiSU_link start="{" end="}\(http\S\+\|image\)" oneline
"%   font face curly brackets
syn region SiSU_control contains=SiSU_strikeout,SiSU_number,SiSU_control,SiSU_identifier,SiSU_error,SiSU_spellErrors matchgroup=SiSU_fontface start="\*{" end="}\*"
syn region SiSU_control contains=SiSU_strikeout,SiSU_number,SiSU_control,SiSU_identifier,SiSU_error,SiSU_spellErrors matchgroup=SiSU_fontface start="!{" end="}!"
syn region SiSU_identifier contains=SiSU_strikeout,SiSU_number,SiSU_control,SiSU_identifier,SiSU_error,SiSU_spellErrors matchgroup=SiSU_fontface start="_{" end="}_"
syn region SiSU_identifier contains=SiSU_strikeout,SiSU_number,SiSU_control,SiSU_identifier,SiSU_error,SiSU_spellErrors matchgroup=SiSU_fontface start="/{" end="}/"
syn region SiSU_identifier contains=SiSU_strikeout,SiSU_number,SiSU_control,SiSU_identifier,SiSU_error,SiSU_spellErrors matchgroup=SiSU_fontface start="+{" end="}+"
syn region SiSU_identifier contains=SiSU_strikeout,SiSU_number,SiSU_control,SiSU_identifier,SiSU_error,SiSU_spellErrors matchgroup=SiSU_fontface start="\^{" end="}\^"
syn region SiSU_identifier contains=SiSU_strikeout,SiSU_number,SiSU_control,SiSU_identifier,SiSU_error,SiSU_spellErrors matchgroup=SiSU_fontface start=",{" end="}," 
syn region SiSU_strikeout contains=SiSU_error matchgroup=SiSU_fontface start="-{" end="}-" 
syn region SiSU_control contains=SiSU_error matchgroup=SiSU_fontface start=" b{" end="}b" oneline
syn region SiSU_control contains=SiSU_error matchgroup=SiSU_fontface_alt start=" e{" end="}e" oneline
syn region SiSU_identifier contains=SiSU_error matchgroup=SiSU_fontface start=" u{" end="}u" oneline
syn region SiSU_identifier contains=SiSU_error matchgroup=SiSU_fontface start=" i{" end="}i" oneline
syn region SiSU_identifier contains=SiSU_error matchgroup=SiSU_fontface start=" v{" end="}v" oneline
syn region SiSU_strikeout contains=SiSU_error matchgroup=SiSU_fontface start=" x{" end="}x" oneline
syn region SiSU_control contains=SiSU_error matchgroup=SiSU_content_alt start="<b>" end="</b>" oneline
syn region SiSU_control contains=SiSU_error matchgroup=SiSU_content_alt start="<em>" end="</em>" oneline
syn region SiSU_identifier contains=SiSU_error matchgroup=SiSU_content_alt start="<u>" end="</u>" oneline
syn region SiSU_identifier contains=SiSU_error matchgroup=SiSU_content_alt start="<i>" end="</i>" oneline
syn region SiSU_identifier contains=SiSU_error matchgroup=SiSU_content_alt start="<ins>" end="</ins>" skip="\\\\\|\\'" oneline
syn region SiSU_identifier contains=SiSU_error matchgroup=SiSU_content_alt start="<del>" end="</del>" oneline
syn region SiSU_string contains=SiSU_error contains=SiSU_strikeout matchgroup=SiSU_contain start="<a href=\".\{-}\">" end="</a>" oneline
"%   single words bold italicise etc. "workon
syn region SiSU_control contains=SiSU_error matchgroup=SiSU_control start="\([ (]\|^\)\*[^\|{\n\~\\]"hs=e-1 end="\*"he=e-0 skip="[a-zA-Z0-9']\+" oneline
syn region SiSU_identifier contains=SiSU_error matchgroup=SiSU_content_alt start="\([ ]\|^\)/[^{ \|\n\\]" end="/\[ \.\]" skip="[a-zA-Z0-9']\+" oneline
""syn region SiSU_identifier contains=SiSU_error matchgroup=SiSU_identifier start="\([ (]\|^\)/[^\|{\n\\]"hs=e-1 end="/"he=e-0 skip="[a-zA-Z0-9']\+" oneline
syn region SiSU_identifier contains=SiSU_error matchgroup=SiSU_identifier start="\([ (]\|^\)_[^\|{\n\\\|\*\|[12]\|\s]"hs=e-1 end="_"he=e-0 skip="[a-zA-Z0-9']\+" oneline
"%   html
syn region SiSU_number contains=SiSU_strikeout,SiSU_number,SiSU_control,SiSU_identifier,SiSU_error,SiSU_spellErrors,SiSU_mark,SiSU_exception matchgroup=SiSU_contain start="<b>" end="</b>" skip="\n"
syn region SiSU_content_alt contains=SiSU_strikeout,SiSU_number,SiSU_control,SiSU_identifier,SiSU_error,SiSU_spellErrors,SiSU_mark,SiSU_exception matchgroup=SiSU_contain start="<i>" end="</i>" skip="\n"
syn region SiSU_content_alt contains=SiSU_strikeout,SiSU_number,SiSU_control,SiSU_identifier,SiSU_error,SiSU_spellErrors,SiSU_mark,SiSU_exception matchgroup=SiSU_contain start="<u>" end="</u>" skip="\n"
"%   misc
syn region SiSU_identifier contains=SiSU_error matchgroup=SiSU_content_alt start="\^[^{\|\n\\]"    end="\^[ ,.;:'})\\\n]" skip="[a-zA-Z0-9']\+" oneline
"% metaverse
syn region SiSU_content_alt contains=SiSU_strikeout,SiSU_number,SiSU_control,SiSU_identifier,SiSU_error,SiSU_spellErrors matchgroup=SiSU_contain start="<:Table.\{-}>" end="<:Table[-_]end>"
syn region SiSU_content_alt contains=SiSU_error matchgroup=SiSU_contain start="<:code>" end="<:code[-_]end>"
syn region SiSU_content_alt contains=SiSU_mark_endnote,SiSU_content_endnote,SiSU_link,SiSU_mark,SiSU_strikeout,SiSU_number,SiSU_control,SiSU_identifier,SiSU_error,SiSU_spellErrors matchgroup=SiSU_contain start="<:alt>" end="<:alt[-_]end>"
syn region SiSU_content_alt contains=SiSU_mark_endnote,SiSU_content_endnote,SiSU_link,SiSU_mark,SiSU_strikeout,SiSU_number,SiSU_control,SiSU_identifier,SiSU_error,SiSU_spellErrors matchgroup=SiSU_contain start="<:poem>" end="<:poem[-_]end>"
"% 7 Expensive Mode
" Expensive Mode: colorize *end* according to opening statement
if !exists("SiSU_no_expensive")
  "syn region  SiSU_content_alt  matchgroup=SiSU_define start="^\s*def\s" matchgroup=NONE end="[?!]\|\>" skip="\.\|\(::\)" oneline
  "if !exists("SiSU_minlines")
  "  let SiSU_minlines = 50
  "endif
  "exec "syn sync minlines=" . SiSU_minlines
else " not Expensive
  syn region  SiSU_content_alt  matchgroup=SiSU_control start="^\s*def\s" matchgroup=NONE end="[?!]\|\>" skip="\.\|\(::\)" oneline
endif " Expensive?
"% 6 Keywords
" Keywords:
"% 5 Headers: and Headings (Document Instructions)
" Headers: & Headings (Document Instructions)
syn match   SiSU_header contains=SiSU_error,SiSU_mark "0\~.*"
syn match   SiSU_comment contains=SiSU_error "^% .*\|^%% .*"
"syn match   SiSU_comment contains=SiSU_error "^{{\s*$"
syn match   SiSU_control contains=SiSU_error "4\~! \S\+"
syn region  SiSU_markpara contains=SiSU_error start="^=begin" end="^=end.*$"
"% single bold word
"syn match   SiSU_control  "[ (]\*\S\+\*[,.!) ]"
"syn match   SiSU_control  "!\S\+!"
"syn region  SiSU_error contains=SiSU_control start="[\~/\*!_]{" end="\n\n" contains=SiSU_control
""skip="}[\~/\*!_]"
"% 4 Errors?
syn match SiSU_error contains=SiSU_Terror  "^\s\+"
""syn match SiSU_error contains=SiSU_Terror  "\Shttp\|http://\S\{-}<br>"
""syn match SiSU_error contains=SiSU_Terror  "\(<br>\|\~{\)http:\S\+"
""syn match SiSU_error contains=SiSU_Terror  "\(<br>\|<br\s\+/>\|\~{\)http:\S\+"
syn match SiSU_error contains=SiSU_Terror  "[^ (}]http:\S\+"
syn match SiSU_error contains=SiSU_Terror  "http:\S\+[}><]"
syn match SiSU_error contains=SiSU_Terror  " \s*$"
syn match SiSU_error contains=SiSU_Terror  "\([!*/_\+,^]\){\([^(\}\1)]\)\{-}\n\n"
syn match SiSU_error contains=SiSU_Terror  "^[\-\~]{[^{]\{-}\n\n"
syn match SiSU_error contains=SiSU_Terror  "\s\+.{{"
""syn match SiSU_erro contains=SiSU_Terrorr  "^{..\+$"
syn match SiSU_error contains=SiSU_Terror  "^[0-9]\~\s*$"
" need a substitute for the following -->
"syn match SiSU_error contains=SiSU_Terror  "^[0-9]\~[^\S ]"
syn match SiSU_error contains=SiSU_Terror  "^[0-9]\~\s*$"
syn match SiSU_error contains=SiSU_Terror  "^\~\s*$"
syn match SiSU_error contains=SiSU_Terror  "^[0-9]\~\s*$"
syn match SiSU_error contains=SiSU_Terror  "^[0-9]\~\S\+\s*$"
"following error match used previously removed with change in
"markup for: table,alt,group,poem,code
"syn match SiSU_error contains=SiSU_Terror  "^\([9a-zA-Z]\)\+{.*"
syn match SiSU_error contains=SiSU_Terror  "[^{]\~\^[^ \)]"
syn match SiSU_error contains=SiSU_Terror  "\~\^\s\+\.\s*"
syn match SiSU_error contains=SiSU_Terror  "[_/\*!^]{[ .,:;?><]*}[_/\*!^]"
syn match SiSU_error contains=SiSU_Terror  "[^ (\"'(\[][_/\*!]{\|}[_/\*!][a-zA-Z0-9)\]\"']"
syn match SiSU_error contains=SiSU_Terror  "<dir>"

syn match SiSU_error contains=SiSU_Terror,SiSU_match,SiSU_strikeout,SiSU_contain,SiSU_content_alt,SiSU_mark,SiSU_number "<[a-zA-Z\/]\+>"
syn match SiSU_error  "/\?<\([biu]\)>[^(</\1>)]\{-}\n\n"
"% 3 Error Exceptions?
syn match   SiSU_string  "\n\n" "contains=ALL
""syn match   SiSU_mark  "<\(br\|p\)\( /\)\?>" "contains=SiSU_Terror
syn match   SiSU_mark   " //"
syn match SiSU_error  "%{"
syn match SiSU_error "<br>http:\S\+\|http:\S\+<br>"
syn match SiSU_error "[><]http:\S\+\|http:\S\+[><]"
"% 2 Definitions
" Define the default highlighting.
if version >= 508 || !exists("did_SiSU_syntax_inits")
  if version < 508
    let did_SiSU_syntax_inits = 1
    command -nargs=+ HiLink hi link <args>
  else
    command -nargs=+ HiLink hi def link <args>
  endif
"% 1 Defined
  HiLink SiSU_header          Comment
  HiLink SiSU_heading         Statement
  HiLink SiSU_brace           Include
  HiLink SiSU_contain         Include
  HiLink SiSU_mark_endnote    Include
  HiLink SiSU_link            Comment
  HiLink SiSU_define          Define
  HiLink SiSU_fontface        Include
  HiLink SiSU_strikeout       Number
  HiLink SiSU_content_alt     Function
  HiLink SiSU_content_endnote Function
  HiLink SiSU_control         Statement
  HiLink SiSU_ocn             Include
  HiLink SiSU_md5             Include
  HiLink SiSU_number          Number
  HiLink SiSU_boolean         Boolean
  HiLink SiSU_exception       Exception
  HiLink SiSU_classOrModule   Type
  HiLink SiSU_identifier      Special
  HiLink SiSU_sharpBang       PreProc
  HiLink SiSU_string          String
  HiLink SiSU_stringDelimit   Delimiter
  HiLink SiSU_exprSubst       Special
  HiLink SiSU_markpara        Include
  HiLink SiSU_marktail        Include
  HiLink SiSU_mark            Exception
  HiLink SiSU_html            Number
  HiLink SiSU_action          Exception
  HiLink SiSU_comment         Todo
  HiLink SiSU_spellErrors     SpellErrors "line does nothing
  "HiLink SiSU_spell           Spell
  HiLink SiSU_error           Error
  delcommand HiLink
endif
let b:current_syntax = "SiSU"

