#ifndef STACKING_H_
#define STACKING_H_

enum {
	AVERAGE_STACKING,
	MEDIAN_STACKING
};	// it would be better to do like the registration of registration methods


/* the dynamic image selection, based on various possible criteria */
typedef int (*stack_filter)(sequence *seq, int nb_img, double param);

struct stacking_args {
	stack_filter filtering_criterion;
	double filtering_parameter;
	int nb_images_to_stack; // calculated from the above, for display purposes
	char description[100];
};

/* TYPE OF SIGMA CLIPPING */
typedef enum {
	NONE,
	PERCENTILE,
	NORMAL,
	MEDIAN,
	WINSORIZED,
	LINEARFIT,
} rejection;

/* the stacking method */
typedef int (*stack_method)(sequence *seq, struct stacking_args *args);


int	stack_summing(sequence *seq, struct stacking_args *args);
int	stack_median(sequence *seq, struct stacking_args *args);
int	stack_mean_with_rejection(sequence *seq, struct stacking_args *args);
int	addmax_stacking(sequence *seq, struct stacking_args *args);
int compute_normalisation(sequence *seq, struct stacking_args *args,
									int nb_frames, double *offset, double *mul, double *scale, int mode);

void start_stacking();
void update_stack_interface();

#endif
