# SingularityCE Support

SingularityCE is a community focused open source project. We maintain
documentation, which everyone is welcome and encourage to contribute to. We have
a number of spaces in which questions can be asked, and problems reported.

## Documentation

If you haven't already, read our [documentation](https://www.sylabs.io/docs/).
These docs cover common use cases, and are often helpful to browse before
submitting an issue or asking a question to the community.

The documentation is under an open source license, and we encourage everyone to
contribute via the GitHub repositories.

- [singularity-admindocs](https://github.com/sylabs/singularity-admindocs) and
- [singularity-userdocs](https://github.com/sylabs/singularity-userdocs)
  repositories.

## Github

For bugs, feature requests, and other technical issues we recommend opening a
new issue on the Github issues boards.

- [SingularityCE Issues](https://github.com/sylabs/singularity/issues): is
  recommended for most issues with the SingularityiCE software itself.
- [User Documentation](https://github.com/sylabs/singularity-userdocs/issues)
  questions, feedback, and suggestions should go here.
- [Admin Documentation](https://github.com/sylabs/singularity-admindocs/issues)
  questions, feedback, and suggestions should go here.

Note that usage questions, or problems related to running a specific piece of
software in a container, are best asked on the Google Group, or Slack channel.
Questions in these venues will be seen by a greater number of users, who may
already know the answer!

### How should I create an issue?

After you identify a bug, or have an idea for a new feature, you should search
the issue board for similar problems reported by other users. Another user may
be facing the same issue, and you can add a +1 (in message or icon) to indicate
to the maintainers that the issue is pressing for you as well. The squeaky wheel
gets the grease!

### How is time allocated to addressing issues?

Like many open source projects, the majority of development work on
SingularityCE is carried out by maintainers and a small number of key
contributors. While we wish we could address every issue, there are only so many
hours in the day. We rank issues based on the following questions:

1. How many users are affected?
1. Is there a proposed work-around?
1. In how many instances does the proposed work-around fail?

With these simple questions, we can ensure that work is directed and has the
maximum impact! However, if your issue doesn't seem to be getting attention you
can still move it along using some of the strategies discussed below.

### What if my issue goes stale?

Issues can go stale for a number of reasons. In the bullets below, we will
review some of these reasons, along with strategies for managing them:

1. *The issue needs a gentle reminder*. Try targeting a few people with a
   "`ping @username any thoughts about this?`" in the case that it was
   forgotten.
1. *Was your issue properly explained*? You are much more likely to get help
   when you give clear instructions for reproducing the issue, and show effort
   on your part to think about what the problem might be. If possible, try to
   come up with a way to reproduce the issue that does not involve a special
   environment or exotic hardware.
1. *Is there broad need*? It could be that your issue isn't having a big enough
   impact for other users to warrant the time for the small development team. In
   this case, you might try implementing a suggested fix, and then asking for
   help with the details.
1. *Is your issue scattered?* When many issues pile up on boards, it sometimes
   is the case that issues are duplicated. It's important to find these
   duplicates and merge them into one, because in finding the duplicate you find
   another user to talk to about the issue.
1. *Does your issue need to have scope?* The idea of scoping an issue means
   framing it with respect to other components of the software. For example, if
   you have a feature request to see metadata about an object, you might frame
   that in the context of container introspection, and suggest an addition to
   the software that fits with the "inspect" command. This kind of contribution
   is much more powerful than simply asking for something.
1. *Consider contributing code* If you are able, opening a PR, even if it is
   imperfect or incomplete, can often provided the momentum needed to get a fix
   or enhancement rolling.

## Google Group

You can reach the community quickly by way of joining our
[Google Group](https://groups.google.com/g/singularity-ce).

## Slack

For real time conversation with the community, you can join our Slack at
[https://singularityce.slack.com/](https://singularityce.slack.com/). Ping the
Google Group or one of the admins here to request to be added.

Is there something missing here you'd like to see? Please
[let us know](https://github.com/sylabs/singularity/issues).
