# 
# Copyright (c) 2017-2018, SyLabs, Inc. All rights reserved.
# Copyright (c) 2017, SingularityWare, LLC. All rights reserved.
#
# Copyright (c) 2015-2017, Gregory M. Kurtzer. All rights reserved.
# 
# Copyright (c) 2016, The Regents of the University of California, through
# Lawrence Berkeley National Laboratory (subject to receipt of any required
# approvals from the U.S. Dept. of Energy).  All rights reserved.
# 
# This software is licensed under a customized 3-clause BSD license.  Please
# consult LICENSE file distributed with the sources of this project regarding
# your rights to use or distribute this software.
# 
# NOTICE.  This Software was developed under funding from the U.S. Department of
# Energy and the U.S. Government consequently retains certain rights. As such,
# the U.S. Government has been granted for itself and others acting on its
# behalf a paid-up, nonexclusive, irrevocable, worldwide license in the Software
# to reproduce, distribute copies to the public, prepare derivative works, and
# perform publicly and display publicly, and to permit other to do so. 
# 
# 

%define singgopath src/github.com/sylabs/singularity

# Disable debugsource packages; otherwise it ends up with an empty %files
#   file in debugsourcefiles.list on Fedora
%undefine _debugsource_packages

Summary: Application and environment virtualization
Name: singularity
Version: 3.1.1
Release: 1%{?dist}
# https://spdx.org/licenses/BSD-3-Clause-LBNL.html
License: BSD-3-Clause-LBNL
URL: https://www.sylabs.io/singularity/
Source: %{name}-%{version}.tar.gz
ExclusiveOS: linux
%if "%{_target_vendor}" == "suse"
%if "%{sles_version}" != "11"
BuildRequires: go
%endif
%else
BuildRequires: golang
%endif
BuildRequires: git
BuildRequires: gcc
BuildRequires: make
BuildRequires: libuuid-devel
BuildRequires: openssl-devel
%if ! 0%{?el6}
%if "%{sles_version}" != "11"
BuildRequires: libseccomp-devel
%endif
%endif
%if "%{_target_vendor}" == "suse"
Requires: squashfs
%else
Requires: squashfs-tools
%endif

# there's no golang for ppc64, just ppc64le
ExcludeArch: ppc64

Provides: %{name}-runtime
Obsoletes: %{name}-runtime

%description
Singularity provides functionality to make portable
containers that can be used across host environments.

%debug_package

%prep
# Create our build root
rm -rf %{name}-%{version}
mkdir %{name}-%{version}

%build
cd %{name}-%{version}

mkdir -p gopath/%{singgopath}
tar -C "gopath/src/github.com/sylabs/" -xf "%SOURCE0"

export GOPATH=$PWD/gopath
export PATH=$GOPATH/bin:$PATH
cd $GOPATH/%{singgopath}

# Not all of these parameters currently have an effect, but they might be
#  used someday.  They are the same parameters as in the configure macro.
./mconfig -V %{version}-%{release} \
        --prefix=%{_prefix} \
        --exec-prefix=%{_exec_prefix} \
        --bindir=%{_bindir} \
        --sbindir=%{_sbindir} \
        --sysconfdir=%{_sysconfdir} \
        --datadir=%{_datadir} \
        --includedir=%{_includedir} \
        --libdir=%{_libdir} \
        --libexecdir=%{_libexecdir} \
        --localstatedir=%{_localstatedir} \
        --sharedstatedir=%{_sharedstatedir} \
        --mandir=%{_mandir} \
        --infodir=%{_infodir}

cd builddir
make old_config=

%install
cd %{name}-%{version}

export GOPATH=$PWD/gopath
export PATH=$GOPATH/bin:$PATH
cd $GOPATH/%{singgopath}/builddir

mkdir -p $RPM_BUILD_ROOT%{_mandir}/man1
make DESTDIR=$RPM_BUILD_ROOT install man
chmod 644 $RPM_BUILD_ROOT%{_sysconfdir}/singularity/actions/*

%files
%attr(4755, root, root) %{_libexecdir}/singularity/bin/starter-suid
%{_bindir}/*
%dir %{_libexecdir}/singularity
%{_libexecdir}/singularity/bin/starter
%{_libexecdir}/singularity/cni/*
%dir %{_sysconfdir}/singularity
%config(noreplace) %{_sysconfdir}/singularity/*
%attr(755, root, root) %{_sysconfdir}/singularity/actions/exec
%attr(755, root, root) %{_sysconfdir}/singularity/actions/run
%attr(755, root, root) %{_sysconfdir}/singularity/actions/shell
%attr(755, root, root) %{_sysconfdir}/singularity/actions/start
%attr(755, root, root) %{_sysconfdir}/singularity/actions/test
%dir %{_sysconfdir}/bash_completion.d
%{_sysconfdir}/bash_completion.d/*
%dir %{_localstatedir}/singularity
%dir %{_localstatedir}/singularity/mnt
%dir %{_localstatedir}/singularity/mnt/session
# XXX: Not great since we can't control this location...
%{_mandir}/man1/*


%changelog

