#ifndef _udpmessageclient_h
#define _udpmessageclient_h


#include <asio.hpp>
#include <list>
#include "messageclient.h"


class UDPMessageClient : public MessageClient
{
private:
  asio::io_service & ioservice;

  asio::ip::udp::resolver resolver;
  asio::ip::udp::endpoint remoteEndpoint;
  void handleResolve(const asio::error_code& err, asio::ip::udp::resolver::iterator endpointIterator);


  asio::ip::udp::socket socket;
  char data[maxMessageIOSize];
  void handleReceiveFrom(const asio::error_code& err, size_t length);

  std::list<Message>  sendQueue;
  bool sendQueueCurrentlySending;
  void handleSendTo(const asio::error_code& err, size_t length);
  void startNewTransmission();

public:
  UDPMessageClient(asio::io_service& io_service, const char * host, const char * port);
  ~UDPMessageClient();

  void queueAndSendMessageSlot(Message & message);
};


#endif
