#ifndef _tcpmessageclient_h
#define _tcpmessageclient_h


#include <asio.hpp>
#include <boost/signal.hpp>
#include "messageclient.h"


class TCPMessageClient : public MessageClient
{
private:
  asio::io_service & ioservice;

  asio::ip::tcp::resolver resolver;
  asio::ip::tcp::socket socket;


  unsigned long messageSize;
  char data[maxMessageIOSize];

  void handleResolve(const asio::error_code& err, asio::ip::tcp::resolver::iterator endpoint_iterator);
  void handleConnect(const asio::error_code& err, asio::ip::tcp::resolver::iterator endpoint_iterator);

  void handleReadMessageSize(const asio::error_code& err, size_t length);
  void handleReadMessage(const asio::error_code& err, size_t length);

  std::list<Message>  sendQueue;
  bool sendQueueCurrentlySending;
  void startNewTransmission();
  void handleWriteMessage(const asio::error_code& err);

public:
  TCPMessageClient(asio::io_service& io_service, const char * host, const char * port);
  ~TCPMessageClient();

  void queueAndSendMessageSlot(Message & message);
};


#endif

