#!/bin/sh -e
# Repackaging script to be called by Uscan

echo "Repackaging ..."
TMP="../simutrans-$2/"
PKG="`dpkg-parsechangelog|sed 's/^Source: //p;d'`_$2+repack.orig"


echo "Extracting tarball ..."
mkdir "$TMP"
tar xzf "$3" -C "$TMP"

echo "Removing unwanted stuff ..."
# source is skins.src/*, only removed to make sure we rebuild it.
rm -rf ${TMP}simutrans/skin/menu.WindowSkin.pak

# freeware, cf. http://www.packetizer.com/security/sha1/ [2011-02-15]
rm -rf ${TMP}utils/sha1.cc ${TMP}utils/sha1.h


echo "Creating repack tarball ..."
tar -caf "../simutrans_$2+repack.orig.tar.xz" ${TMP}*


echo "Clean tmp dir ..."
rm -rf ${TMP}
#rmdir --ignore-fail-on-non-empty $TMP

echo "Clean uscan files ..."
rm -rf ../simutrans-src-$2.zip
rm -rf ../simutrans_$2.orig.tar.gz

echo "Repackaged tarball created"
