#ifndef INCLUDED_INCIDENCE_
#define INCLUDED_INCIDENCE_

//  Either Male, Female, or Breast plus the BRCA specs.
//
// Tumor:
//     Incidence:
//         Male:
//             #                   value   spread  distr.
//             lifetimeRisk:         .22   .005    Normal
//             meanAge:            72.48  1.08     Normal
//             stdDev:              9.28  1.62     Normal
//
//         Female:
//             #                   value   spread  distr.
//             lifetimeRisk:         .20   .004    Normal
//             meanAge:            69.62  1.49     Normal
//             stdDev:              9.73  1.83     Normal
//
//         Breast:
//             probability:    1
//             #                   value   spread  distr.
//             lifetimeRisk:         .226  .0053   Normal
//             meanAge:            72.9    .552    Normal
//             stdDev:             21.1
//
//         BRCA1:
//             probability:    0
//             #                   value   spread  distr.
//             lifetimeRisk:         .96
//             meanAge:            53.9
//             stdDev:             16.51
//
//          BRCA2:
//             probability:    0
//             #                   value   spread  distr.
//             lifetimeRisk:         .96
//             meanAge:            53.9
//             stdDev:             16.51

//  as in the original sources: with 0 probabilities the specified values
//  are set to 0


#include <vector>
#include <string>

#include "../vsd/vsd.h"

struct Incidence
{
    class Params
    {
        friend class Incidence;

        unsigned d_idx;                                 // see setIncidence

        double   d_prob = 1;

        VSD     d_vsd[3] = { VSD{ VARY_PROB },          // lifetimeRisk
                             VSD{ VARY_NONNEG },        // meanAge
                             VSD{ VARY_NONNEG } };      // stdDev
        public:
            Params(unsigned idx);                                       // .f
            void vary(std::ostream &out);                               // 1

            double   prob() const;                                      // .f
            VSD const &risk() const;           // lifeTimeRisk          // .f
            VSD const &mean() const;                                    // .f

            VSD const &stdDev() const;                                  // .f
    };

    private:
        std::vector<Params> d_params;
        DoubleVect d_cumProb;
        DoubleVect2 d_tumorRisk;

        static StringVect s_incidence;

    public:
        Incidence();

        void vary(std::ostream &out);            // vary d_vsd's values     2

        std::vector<Params> const &params() const;                      // .f

                                        // was: carrier() MODIFY for LC
        uint16_t index() const;         // randomly selected carrier index

        DoubleVect2 const &tumorRisk() const;                           // .f
        DoubleVect const &tumorRisk(size_t idx) const;                  // .f

        void writeParameters(std::ostream &out) const;

    private:
        void cptTumorRisk();            // assign values to d_tumorRisk    1
        void cptTumorRisk(DoubleVect &ageValues,                        // 2
                          Params const &params);

        static bool lifetimeRisk(StringVect &base, VSD &vsd);
        static bool meanAge(StringVect &base, VSD &vsd);

                                    // 'incidence' originally named 'carrier'
        void setIncidence();        // sets d_params                    // 1
        void setIncidence(StringVect &base, size_t idx,                 // 2
                          bool setProbability);

        static bool stdDev(StringVect &base, double &sd);

        static bool valid(double sumProb);                              // .ih

        double sumProbs();

        static void writeCarrier(std::ostream &out, size_t idx,
                                 char type, double value);

        // OBS: bool incidenceProb(StringVect const &base, Params &params);
};

#include "incidence.f"

#endif
