//#define XERR
#include "tumor.ih"

extern size_t g_caseIdx;
extern size_t g_err;

//  (ORG: calculateSize)
void Tumor::characteristics(double age)
{
    //if (g_caseIdx >= g_err) xerr("AGE: " << age << ",
    //                                  detectable age: " << d_detectableAge);

    check("size");

    if ((d_present = (d_detectableAge <= age)))            // there is a tumor
    {
        d_diameter =
            diameter(
                d_volume = d_startVolume *          // exp. growth of volume
                           pow(2, (age - d_detectableAge) / d_doublingYears)
            );
        g_log << "      tumor::characteristics:\n"
                 "        diameter: " << d_diameter << "\n"
                 "        volume: " << d_volume     << "\n"
                 "        tumor lifetime: " << age  << '\n';
    }
    else
    {
        d_volume = 0;
        d_diameter = 0;
        g_log << "      tumor::characteristics: no tumor\n";
    }

    d_rowCol = d_survival.setVSD(d_diameter);

//if (g_caseIdx >= g_err) xerr(" diameter = " << d_diameter);

}
