#define XERR
#include "probgroup.ih"

// see README.probgroup

extern size_t g_caseIdx;
extern size_t g_err;

// with Survival::cptVSDrow 'value' is the tumor diameter
// then, the group is determined from the diameter, and in the selected
// group the column index of that row of S3 is omputed as 'idx'

// static
RowCol ProbGroup::probIndexOf(Vector const &vect,
                                         double value, double prob)
{
//if (g_caseIdx >= g_err){
//xerr("PROB INDEX FOR " << prob << " value " << value);
//for (ProbGroup const &group: vect)
//cerr << group.begin() << '-' << group.end() << "; ";
//cerr<<'\n';
//}

    size_t rowIdx = 0;

    for (ProbGroup const &group: vect)
    {
        if (group.contains(value))
        {
            uint16_t idx = group.indexOf(prob);

//            if (g_caseIdx >= g_err) xerr("INDEX " << idx);

// xerr("Case  " << g_caseIdx << ", row: " << rowIdx <<
// ", col: " << idx);

            return RowCol{ rowIdx, idx };
        }
        ++rowIdx;
    }

//if (g_caseIdx >= g_err) xerr("NO INDEX FOUND ");
    return RowCol{ static_cast<uint16_t>(string::npos), 0 };
}
