#define XERR
#include "loop.ih"

void Loop::caseInit()
{
    g_log << "\nLoop::caseInit\n";

    d_caseCost = 0;                         // org: womenCosts
    d_deathAge = 0;                         // org: tumorDeathAge
    d_roundDetected = 0;                    // org: roundDetected
    d_selfDetected = false;                 // org: selfDetected
    d_roundInfo.assign(d_nRounds, '0');     // attendance info per round per
                                            // case at [idx] the info of round
                                            // idx is stored
    //xerr("cptIndices");
                                // BC simulation: bi-rad column indices or
    d_indices = cptIndices();   // LC simulation: 0-vector

    //xerr("cumTotalRisk");
    d_tumorInfo.cumTotalRisk(
                    d_screening.radiationRisk(
                            d_modalities,
                            d_indices,
                            d_tumorInfo.beir7().beta(),
                            d_tumorInfo.beir7().eta()
                    )
                );

        // naturalDeathAged is called to standardize the Random::uniformCase
        // calls
    d_options.fixedNaturalDeathAge(d_naturalDeathAge = naturalDeathAge());
    d_status = PRESENT;

    d_tumor.reset();

    g_log << "\n"
        "case init:\n"
        "   Natural death age: " << d_naturalDeathAge << '\n' <<
        d_tumor << '\n';
}
