//#define XERR
#include "survival.ih"

Survival::Survival(Scenario const &scenario)
:
    d_vsd(4)
{
    string types;

    auto range = scenario.lines(s_id);

    bool ok = true;
    for (auto iter = range.pair.first; iter != range.pair.second; ++iter)
    {
        istringstream in{ (*iter)->tail() };

        VSD vsd;
        char type;

        in >> type >> vsd;

        if (not in or type < 'a' or type > 'd')         
        {
            ok = false;
            scenario.error(range.src, (*iter)->lineNr(),      // filler (
                                            SPECIFICATION) << s_id << "')\n";
        }
        else if (types.find(type) == string::npos)
        {
            d_vsd[type - 'a'] = vsd;
            types += type;
        }
    }

    if (ok and types.size() != 4)
        scenario.error(range.src, 0, TUMORSURVIVAL_TYPES);
}
