//#define XERR
#include "screening.ih"

void Screening::set(Distribution *dest, Scenario const &scenario, 
                    char const *id)
{
    auto ret = scenario.find(id);           // find the 'id' specification

    if (ret.iter == scenario.end())         // not found
    {
        scenario.error(ret.src, 0,          // filler: ( 
                   SPECIFICATION) << s_errorID << "')\n";
        return;
    }

    if (not set(dest, ret.iter))
        scenario.error(ret.src, ret.iter->lineNr(),    // filler:   (
                                          SPECIFICATION) << id << "')\n";
}
