#ifndef INCLUDED_SCREENING_
#define INCLUDED_SCREENING_


// # screening         value   distribution:
// systematicError:    0       Normal  
// attendanceRate:     0.8     Normal  

// # screeningRound :  age mammo tomo 
// #   e.g.:
// # screeningRound:   50  1     1
// # screeningRound:   52  1     1

#include <iosfwd>

#include "../typedefs/typedefs.h"
#include "../distribution/distribution.h"
#include "../scenario/scenario.h"
#include "../round/round.h"

class Modalities;

class Screening
{
    Distribution d_sysErr;
    Distribution d_rate;

    double const *d_beir7dose;      // set from Screening using 
                                    // beir7dose() 

    RoundVect d_rounds;
    StringSet d_modalities;         // specified modalities

    static char const s_errorID[];
    static char const s_attendanceID[];
    static char const s_roundID[];

    public:
        Screening(Scenario const &scenario);

        Distribution const &error() const;
        Distribution const &rate() const;

        DoubleVect radiationRisk(
                            Modalities const &modalities,
                            Uint16Vect const &indices,
                            double beta, double eta);     // beir7 values

        void beir7dose(double const *dose);                         //  .h

        void writeParameters(std::ostream &out) const;

        uint16_t nRounds() const;


        RoundVect const &rounds() const;
        DoubleVect ages() const;      // vector of ages for the rounds

                                        // roundIdx is, e.g. Loop::d_round
        Round const &round(size_t roundIdx) const;  // individual values
        double age(size_t idx) const;   

        StringSet const &modalities() const;

    private:
        void set(Distribution *dest,                    // 1
                 Scenario const &scenario, char const *id);

        void setSystematicError(Scenario const &scenario);
        void setAttendanceRate(Scenario const &scenario);

                                                        // 2
        static bool set(Distribution *dest, 
                         Scenario::const_iterator const &iter);

        void setRounds(Scenario const &scenario);
        bool addRound(Scenario::const_iterator const &info);   // true: added

        static double beir7Err(Round const &round, uint16_t idx, double beta, 
                               double eta, Modalities const &modalities);
};


inline StringSet const &Screening::modalities() const
{
    return d_modalities;
}

inline RoundVect const &Screening::rounds() const
{
    return d_rounds;
}

inline Round const &Screening::round(size_t idx) const
{
    return d_rounds[idx];
}

inline double Screening::age(size_t idx) const
{
    return d_rounds[idx].age();
}

inline uint16_t Screening::nRounds() const
{
    return d_rounds.size();
}

inline Distribution const &Screening::error() const
{
    return d_sysErr;
}

inline Distribution const &Screening::rate() const
{
    return d_rate;
}

inline void Screening::beir7dose(double const *dose)
{
    d_beir7dose = dose;
}

// inline double Screening::Distribution::value() const
// {
//     return d_value;
// }

#endif

