#ifndef INCLUDED_OPTIONS_
#define INCLUDED_OPTIONS_

#include <iosfwd>
#include <string>
#include <unordered_map>

#include "../enums/enums.h"

namespace FBB
{
    class Arg;
}

class Options
{
    FBB::Arg const &d_arg;

    std::string d_specified;            // options specified in this run
    bool d_specificAges = false;
    size_t d_lastCase = 0;              // compute until d_lastCase, report
                                        // d_lastCase's results

    std::string d_home;                 // current 'HOME' directory
    std::string d_base;                 // guaranteed to end in '/'
    std::string d_config;
    std::string d_parametersFile;
    std::string d_dataFile;
    std::string d_roundsFile;
    std::string d_sensitivityFile;

    double d_naturalDeathAge;           // single run, subject age
    double d_tumorAge;                  // single run, tumor self-detect age

    static char const s_base[];
    static char const s_config[];
    static std::unordered_map<int, char const *> s_fileName;

    static Options *s_options;

    public:
        static Options &instance();

        Options(Options const &other) = delete;

        std::string const &base() const;                // .h
        std::string const &configFile() const;          // .h

        std::string const &parametersFile() const;                // .h
        std::string const &dataFile() const;                    // .h
        std::string const &roundsFile() const;                  // .h
        std::string const &sensitivityFile() const;             // .h
        bool specificAges() const;                              // .h

        void naturalDeathAge(double &deathAge) const; 
        void tumorAge(double &tumorAge) const;
        size_t lastCase() const;                                // .h

                                                // try to change this option's
                                                // value in this analysis
        void alter(int optChar, std::string const &value);
        void inspect() const;

    private:
        Options();

        void replaceHome(std::string &path);
        void setBase();                                         // 1
        void setBase(std::string const &value);                 // 2
        void setConfig();

        void setFile(std::string &dest, int option);            // .ih
        void setFile(std::string &dest, int option, bool specified);

        void deathAge(std::string const &value);
        void setTumorAge(std::string const &value);
        void lastCase(std::string const &value);

        void replacePlus(std::string &fname);
};

inline std::string const &Options::base() const
{
    return d_base;
}

inline std::string const &Options::configFile() const
{
    return d_config;
}

inline std::string const &Options::parametersFile() const
{
    return d_parametersFile;
}

inline std::string const &Options::dataFile() const
{
    return d_dataFile;
}

inline std::string const &Options::roundsFile() const
{
    return d_roundsFile;
}

inline std::string const &Options::sensitivityFile() const
{
    return d_sensitivityFile;
}

inline bool Options::specificAges() const
{
    return d_specificAges;
}

inline size_t Options::lastCase() const
{
    return d_lastCase;
}

#endif

