//#define XERR
#include "options.ih"

void Options::alter(int optChar, std::string const &value)
{
                                            // if a command-line option was
                                            // specified, then do not alter
                                            // options in 'analysis:;
                                            // specifications 

    if (d_specified.find(optChar) != string::npos)  // specified option
        return;

    switch (optChar)
    {
        case 'a':
            deathAge(value);
        break;

        case 'B':
            setBase(value);
        break;

        case 'C':
            d_specified += 'C';
            replaceHome(d_config = value);
        break;

        case 'D':
            setFile(d_dataFile = value, 'D', true);
        break;

        case 'n':
            lastCase(value);
        break;

        case 'o':
            throw Exception{} << 
                "`one-scenario' cannot be used in scenario specifications";
        break;

        case 'P':
            setFile(d_parametersFile = value, 'P', true);
        break;

        case 'R':
            setFile(d_roundsFile = value, 'R', true);
        break;

        case 'S':
            setFile(d_sensitivityFile = value, 'S', true);
        break;

//        case 'T':
//            setFile(d_cumTotalriskFile = value, 'T', true);
//        break;

        case 't':
            setTumorAge(value);
        break;            

        case 'V':
            d_specified += 'V';
            imsg.on();    
        break;
    }
}

