//#define XERR
#include "modbase.ih"

Err ModBase::specificities(SpecVect *dest, istream &in)
{
    while (true)
    {
        Specificity spec;                   // specificity params. to read
    
        in >> spec.d_beginAge;              // get the begin age
    
        if (not in)                         // if that fails but there's 
            break;

        char ch;                            // skips the dash and the '*'
                                            // or the 1st age digit
        in >> ch >> ch;                     // e.g. 40 - *: 0.965
                                            //      40 - 100: 0.965

        if (ch == '*')
            spec.d_endAge = END_AGE;
        else                                // no * -> read the age
        {
            in.unget();
            in >> spec.d_endAge;
        }

        in >> ch >> spec.d_value;           // skip :, read d_value

        if (not in)                         // Specificity format error
            return SPECIFICATION;
 
        if 
        (
            dest->size() != 0               // there is a previous age range
            and                             // then: age ranges must connect
            not Globals::equal(spec.d_beginAge, dest->back().d_endAge)
        )
            return NOT_CONSECUTIVE;

        dest->push_back(spec);              // all OK: add the Specificity
    }

                                            // need at least 1 age range
    return dest->size() == 0   ? SPECIFICATION      :
           setBit(SPECIFICITY) ? NO_ERROR           : 
                                 MULTIPLY_SPECIFIED;
}

