//#define XERR
#include "modbase.ih"

uint16_t ModBase::addConfigLine(HandlerMap const &handlers, ConfigSrc src, 
                             char const *id, 
                             Scenario::LineIter const &lineIter,
                             SpecVect const *specPtr)
{
    istringstream in{ lineIter->tail() };    // make the spec. available
    uint16_t lineNr = lineIter->lineNr();

    string key;
    in >> key;                              // extract the key
    auto handler = handlers.find(key);      // find the key
    
    if 
    (   Err err = SPECIFICATION;
            handler == handlers.end()                   // key not found
            or                                          // or specification
            (err = (handler->second)(this, in)) !=      //    error
                NO_ERROR
    )
        Error::msg(
            err, src, lineNr, id, 
            specPtr and specPtr->size() ? specPtr->back().d_endAge : 0
        );

    return lineNr;
}

