//#define XERR
#include "mammotomo.ih"

void MammoTomo::readSpecifications(char const *sID, uint16_t lineNr, 
                                   ConfigSrc src, string const &id,
                                   istream &in)
try
{
    while (true)
    {
        Specificity spec;
        char sep;
    
        in >> spec.d_beginAge;              // get the begin age
    
        if (not in)                         // if that fails but there's 
        {                                   // >= 1 specification, then OK.
            if (d_spec.size() == 0)
                throw false;

            return;
        }
    
        in >> sep;                          // e.g. 40-*: 0.965
                                            //      40-100: 0.965

        if (in.peek() != '*')               
            in >> spec.d_endAge;            // not *, so read the value
        else
        {
            in.ignore();                    // or ignore * and use END_AGE
            spec.d_endAge = END_AGE;
        }

        in >> sep >> spec.d_value;          // skip :, read d_value

        if (not in)                          // Specificity format
            throw false;                     // incorrect

        if 
        (
            not d_spec.empty()
            and                                     // age ranges must connect
            not Globals::equal(spec.d_beginAge, d_spec.back().d_endAge)
        )
        {
            Error::instance()(src, lineNr, NOT_CONSECUTIVE) << 
                    sID << ' ' << id << ": " << spec.d_beginAge << " - ...\n";
            return;
        }

        d_spec.push_back(spec);              // OK: add the Specificity
    }
}
catch (...)
{
    Error::instance()(src, lineNr,                  // (
                      SPECIFICATION) << sID << "')\n";
}    

