//#define XERR
#include "mammo.ih"

// Mammo cost: 64   
// 
// #     bi-rad cat:   a       b       c       d             
// Mammo dose:         3       3       3       3  
// 
// #                   agegroup
// Mammo specificity:  0 - 40:  0.961     40 - *: 0.965
// 
// #           1            2           3            4            m
// Mammo beta: -4.38 Normal 0.49 Normal -1.34 Normal -7.18 Normal 0.136 Normal

Mammo::Mammo(Tumor const &tumor, Scenario::Range &range)
:
    ModBase(s_ID),
    d_tumor(tumor)
{
    uint16_t lineNr = configure(s_handlers, range, s_ID, &d_spec);

    if (configured() != (COST | SPECIFICITY | BETA | DOSE))
        Error::msg(INCOMPLETE_SPEC, range.src, lineNr, s_ID);
}





