//#define XERR
#include "loop.ih"

// -> ORG/womanloop.cpp

void Loop::womenLoop(size_t iter)
{
    ofstream data = headerData(iter);           

    auto const &options = Options::instance();

    bool showAll = not options.specificAges() and options.lastCase() == 0;

                                        // perform 'nCases' simulations
    for (size_t idx = 0, end = nCases(); idx != end; ++idx)
    {
        initialize(idx);

        preScreen();        // no action unless screening rounds are specified
        screening();        // same
        postScreen();

        d_sumDeathAge += d_deathAge;
        d_totalCost += d_caseCost;

        if (showAll or idx + 1 == end)
            writeData(data, idx);
    }
}

// In the original womanloop function a test is performed whether the
// woman has died or not. This test is superfluous because if the woman enters
// postScreen with status PRESENT then in postScreen the status either changes
// to LEFT_POST or TUMOR_POST.

