#ifndef INCLUDED_INCIDENCE_
#define INCLUDED_INCIDENCE_

// #                            lifeTimeRisk      same: meanAge  stdandardDev
// #               carier       ---------------------   
// #               name    prob value  spread   dist.     
// tumorIncidence: Normal  1    0.226  0.0053   Normal    
// tumorIncidence: BRCA1   0    0.96   -        -         
// tumorIncidence: BRCA2   0    0.96   -        -         
// 
//  conform the original sources: with 0 probabilities the specified values
//  are set to 0


#include <vector>
#include <string>

#include "../typedefs/typedefs.h"
#include "../vsd/vsd.h"
#include "../scenario/scenario.h"

struct Incidence: public Spread
{
    Scenario const &d_scenario;

    class Params
    {
        friend class Incidence;

        uint16_t d_idx;
        double   d_prob;

        VSD     d_risk;           // lifeTimeRisk
        VSD     d_mean;
        VSD     d_stdDev;

        public:
            uint16_t idx() const;
            double   prob() const;
    
            VSD const &risk() const;           // lifeTimeRisk
            VSD const &mean() const;
            VSD const &stdDev() const;
    };

    private:
        std::vector<Params> d_params;

        double d_cumProb[END_CARRIERS];

        DoubleVect2 d_tumorRisk;

        static Map s_carrier;    
        static char const s_id[];

    public:
        Incidence(Scenario const &scenario);
        void refresh();

        std::vector<Params> const &params() const;  
        uint16_t carrier() const;               // randomly selected carrier
                                                // index

        DoubleVect2 const &tumorRisk() const;
        DoubleVect const &tumorRisk(size_t idx) const;

        void writeParameters(std::ostream &out) const;

    private:
        void set();

        bool addProbabilities(double *sumProb, Scenario::Range const &range);

                                                // negative return value:
                                                // specification error
        double add(Scenario::const_iterator const &info);

        void setTumorRisk();            // assign values to d_tumorRisk    1
        void setTumorRisk(DoubleVect &ageValues,                        // 2
                          Params const &params);

        static void writeCarrier(std::ostream &out, size_t idx, 
                                 char type, double value);

        static bool valid(double sumProb);
};
        
inline std::vector<Incidence::Params> const &Incidence::params() const
{
    return d_params;
}

inline uint16_t Incidence::Params::idx() const
{
    return d_idx;
}

inline double Incidence::Params::prob() const
{
    return d_prob;
}

inline VSD  const &Incidence::Params::risk() const
{
    return d_risk;
}

inline VSD const &Incidence::Params::mean() const
{
    return d_mean;
}

inline VSD const &Incidence::Params::stdDev() const
{
    return d_stdDev;
}

inline DoubleVect2 const &Incidence::tumorRisk() const
{
    return d_tumorRisk;
}

inline DoubleVect const &Incidence::tumorRisk(size_t idx) const
{
    return d_tumorRisk[idx];
}

#endif
