//#define XERR
#include "growth.ih"

void Growth::writeParameters(ostream &out) const
{
    out << "      growth:\n";

    writeDiameter(out, "            start diameter", d_start.value());
    writeDiameter(out, "   self-detect diameter Mu", d_selfMu.value());
    writeDiameter(out, "self-detect diameter Sigma", d_selfSigma.value());

    out.put('\n');

    size_t idx = 0;
    for (auto const &group: d_ageGroups)
    {
        writeDT(out, "  mean", idx, group.mean().value());
        writeDT(out, "stdDev", idx, group.stdDev().value());
        ++idx;
        out.put('\n');
    }
}
