//#define XERR
#include "growth.ih"

    // true: no errors encountered

bool Growth::parse(ConfigSrc src, Scenario::const_iterator const &iter)
try
{
    d_in.clear();                       // prepare for the nex extraction
    d_in.str(iter->tail());

    uint16_t lineNr = iter->lineNr();

    int nr;
    string marker;
    d_in >> nr >> marker;                // either a number or an x-y range

    if (not d_in)
        throw lineNr;

    if (marker.front() == '-')          // agegroup
        return ageGroup(src, lineNr, d_in);

    d_in.seekg(0);                      // std. tumorgrowth info

    d_in >> d_start >> d_selfMu >> d_selfSigma;

    if (not d_in)
        throw lineNr;

    return true;
}
catch (uint16_t lineNr)
{
    Error::instance()(src, lineNr, SPECIFICATION) << s_id << "')\n";
    return false;
}




