#ifndef INCLUDED_GLOBALS_
#define INCLUDED_GLOBALS_

#include <unordered_map>
#include <ostream>
#include <iomanip>

#include "../typedefs/typedefs.h"

struct Globals
{
    typedef std::unordered_map<std::string, uint16_t> Map;

    static constexpr double TOLERANCE = 1e-8;
    static constexpr double WEAK_TOLERANCE = 1e-3; 
    static constexpr double NO_TUMOR = -1;          // tumor/

    static double const s_sqrt2PI;

    private:
        static Map s_xlatDist;
    
    public:
        static uint16_t xlat(Map const &map, std::string const &key);
        static uint16_t xlatDist(std::string const &key);

                                                    // distIdx must be valid
                                                    // (unchecked)
        static std::string const &distName(uint16_t distIdx);

        static double findAge(DoubleVect const &cumProb, double prob);

        static double checkStarAge(std::string const &endAge);
        static bool equal(double value1, double value2);
        static bool isZero(double value);
        static bool isNonNegZero(double value);
        static int weakCompare(double lhs, double rhs); // uses WEAK_TOLERANCE

        static std::ostream &setPrecision(std::ostream &out, 
                                          uint16_t nDigits);
};

// static
inline bool Globals::isNonNegZero(double value)
{
    return 0 <= value and value <= TOLERANCE;
}

#endif
