#define XERR
#include "globals.ih"

// static
std::string const &Globals::distName(uint16_t distIdx)
{
    auto iter = find_if(s_xlatDist.begin(), s_xlatDist.end(), 
                [&](Map::value_type const &value)
                {
                    return value.second == distIdx;
                });

    if (iter == s_xlatDist.end())
        throw Exception{} << "internal error: no distribution name for " <<
                            distIdx;

    return iter->first;

//    return find_if(s_xlatDist.begin(), s_xlatDist.end(), 
//                [&](Map::value_type const &value)
//                {
//                    return value.second == distIdx;
//                }
//            )->first;
}
