#ifndef INCLUDED_ENUMS_
#define INCLUDED_ENUMS_


enum ConfigSrc         
{
    CONFIG,
    ANALYSIS,
    NO_SRC,
};

enum Err
{
    NO_ERROR,
    COSTS_SIZE,
    CUMPROB,
    INCOMPLETE_SPEC,
    INVALID_PROBSUM,
    MISSING_NR,
    MULTIPLY_SPECIFIED,
    N_CARRIERS,
    NOT_CONSECUTIVE,
    SPECIFICATION,
    TUMORGROWTH_STARTDIAM,
    TUMORGROWTH_AGEGROUPS,
    TUMORINCIDENCE_SIZE,
    TUMORSURVIVAL_TYPES,
};

enum Constants
{
    NORMAL,         // distribution name 
    LOGNORMAL,
    UNIFORM,
    EXPONENTIAL,
    NO_DIST,        // no distribution specified

    N_BIRADS = 4,   // 4 bi-rad categories (cf. tech man. section Densities)

// -> Modalities
//    N_DOSES = 4,    // # doses of Modalities
//    N_SENS = 4,     // # Modalities sensitivity specs.

    END_CARRIERS = 4,
    END_AGE         = 101,
    MAX_AGE         = END_AGE - 1,

    END_RANDOMPOOL = 55,    // pool of random numbers (womanloop) (MAX_SCR)
//    N_MODALITIES    = 2,    // Number of techniques used in the screening
                            // (costs.h, randompool.h)
//    MAMMOGRAPHY     = 0,
//    TOMOSYNTHESIS   = 1,
//
//    XRAY            = 0,    // used in Modalities
//    MAMMO           = 0, 
//    TOMO            = 1, 

//    N_TREATMENTCOSTS = 3,   // #treatment costs (costs.h)

    N_YEARDAYS = 365,

    BEIR_5  = 5,    // TumorInfo()
    BEIR_7  = 7,

    SEED = 1,       // default reset seed for Random
};

enum SeedType
{
    FIXED_SEED,
    INCREASING_SEED,
    RANDOM_SEED,
};
        
#endif
