#ifndef INCLUDED_DISTRIBUTION_
#define INCLUDED_DISTRIBUTION_

#include <iosfwd>
#include <cstdint>

class Distribution
{
    friend bool operator>>(std::istream &in, Distribution &dist);
    friend std::ostream &operator<<(std::ostream &out, 
                                             Distribution const &dist);

    double    d_value;
    uint16_t  d_dist;

    public:
        double   value() const;
        uint16_t dist() const;

    private:
        bool extract(std::istream &in);
        bool set(std::string const &dist);
};
        
inline bool operator>>(std::istream &in, Distribution &dist)
{
    return dist.extract(in);
}

inline double Distribution::value() const
{
    return d_value;
}

inline uint16_t Distribution::dist() const
{
    return d_dist;
}

#endif
